/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemValueGroup;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VSystemValueList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SystemValueList systemValueList_;
    private VNode parent_;
    private transient VNode[] children_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private static String description_;
    private static Icon icon16_;
    private static Icon icon32_;
    private static TableColumnModel detailsColumnModel_;
    private static String nameColumnHeader_;
    private static String descriptionColumnHeader_;
    private static final String groupName_;
    private static final String groupDescription_;
    private static final int groupCount_;

    public VSystemValueList() {
        this.systemValueList_ = new SystemValueList();
        this.initializeTransient();
    }

    public VSystemValueList(AS400 system) {
        this.systemValueList_ = new SystemValueList(system);
        this.initializeTransient();
    }

    public VSystemValueList(VNode parentNode, AS400 system) {
        if (parentNode == null) {
            throw new NullPointerException("parent");
        }
        this.systemValueList_ = new SystemValueList(system);
        this.parent_ = parentNode;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return this.children_[index];
    }

    public int getChildCount() {
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int index) {
        if (index < 0 || index >= this.children_.length) {
            return null;
        }
        return this.children_[index];
    }

    public int getDetailsChildCount() {
        return this.children_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject detailsChild) {
        for (int i = 0; i < groupCount_; ++i) {
            if (this.children_[i] != detailsChild) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int size, boolean open) {
        if (size != 32) {
            return icon16_;
        }
        return icon32_;
    }

    public int getIndex(TreeNode child) {
        for (int index = 0; index < groupCount_; ++index) {
            if (this.children_[index] != child) continue;
            return index;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return null;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.systemValueList_.getSystem();
    }

    public SystemValueList getSystemValueList() {
        return this.systemValueList_;
    }

    public String getText() {
        return description_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.children_ = new VSystemValueGroup[groupCount_];
        for (int i = 0; i < groupCount_; ++i) {
            this.children_[i] = new VSystemValueGroup(this, i);
            this.children_[i].addErrorListener(this.errorEventSupport_);
            this.children_[i].addVObjectListener(this.objectEventSupport_);
            this.children_[i].addWorkingListener(this.workingEventSupport_);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isSortable() {
        return false;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.systemValueList_.getSystem().connectService(2);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 oldValue = this.systemValueList_.getSystem();
        AS400 newValue = system;
        this.vetoableChangeSupport_.fireVetoableChange("system", oldValue, newValue);
        if (oldValue != newValue) {
            this.systemValueList_.setSystem(newValue);
        }
        this.propertyChangeSupport_.firePropertyChange("system", oldValue, newValue);
    }

    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
    }

    public String toString() {
        return description_;
    }

    static {
        groupCount_ = SystemValueList.getGroupCount();
        description_ = ResourceLoader.getText("SYSTEM_VALUE_LIST_DESCRIPTION");
        groupName_ = ResourceLoader.getText("COLUMN_GROUP");
        groupDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION");
        icon16_ = ResourceLoader.getIcon("VSystemValueList16.gif", description_);
        icon32_ = ResourceLoader.getIcon("VSystemValueList32.gif", description_);
        nameColumnHeader_ = groupName_;
        descriptionColumnHeader_ = groupDescription_;
        detailsColumnModel_ = new DefaultTableColumnModel();
        int i = 0;
        VTableColumn vTable1 = new VTableColumn(i++, NAME_PROPERTY);
        vTable1.setCellRenderer(new VObjectCellRenderer());
        vTable1.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable1.setHeaderValue(nameColumnHeader_);
        vTable1.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTable1);
        VTableColumn vTable2 = new VTableColumn(i++, DESCRIPTION_PROPERTY);
        vTable2.setCellRenderer(new VObjectCellRenderer());
        vTable2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable2.setHeaderValue(descriptionColumnHeader_);
        vTable2.setPreferredCharWidth(40);
        detailsColumnModel_.addColumn(vTable2);
    }
}

