/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.access.UserList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.UserListPropertiesPane;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUser;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VUserList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String genericDescription_ = ResourceLoader.getText("USER_LIST_DESCRIPTION");
    private String description_ = genericDescription_;
    private static Icon icon16_ = ResourceLoader.getIcon("VUserList16.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private static Icon icon32_ = ResourceLoader.getIcon("VUserList32.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private static String nameColumnHeader_ = ResourceLoader.getText("USER_USER_NAME");
    private static String descriptionColumnHeader_ = ResourceLoader.getText("USER_DESCRIPTION_PROMPT");
    private static final String allUsersText_ = ResourceLoader.getText("USER_ALL_USERS").trim();
    private static final String allUsersDescription_ = ResourceLoader.getText("USER_ALL_USERS_DES").trim();
    private static final String usersNotInGroupsText_ = ResourceLoader.getText("USER_USERS_NOT_IN_GROUPS").trim();
    private static final String usersNotInGroupsDescription_ = ResourceLoader.getText("USER_USERS_NOT_IN_GROUPS_DES").trim();
    private static final String groupsText_ = ResourceLoader.getText("USER_GROUPS").trim();
    private static final String groupsDescription_ = ResourceLoader.getText("USER_GROUPS_DES").trim();
    private UserList userList_ = null;
    VNode parent_ = null;
    private boolean isLoaded_ = false;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VObject[] detailsChildren_;
    private transient Enumeration enum_;
    private transient int loaded_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VUserList() {
        this.userList_ = new UserList();
        this.initializeTransient();
    }

    public VUserList(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.userList_ = new UserList(system);
        this.initializeTransient();
    }

    public VUserList(UserList userList, String listName) {
        this.description_ = listName;
        this.userList_ = userList;
        this.initializeTransient();
    }

    public VUserList(VNode parent, AS400 system) {
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.parent_ = parent;
        this.userList_ = new UserList(system);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int index) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    private String getDescription(UserList userList) {
        String userInfo = userList.getUserInfo();
        String groupInfo = userList.getGroupInfo();
        if (userInfo.toLowerCase().equals("*all") && groupInfo.toLowerCase().equals("*none")) {
            return allUsersDescription_;
        }
        if (userInfo.toLowerCase().equals("*member") && groupInfo.toLowerCase().equals("*nogroup")) {
            return usersNotInGroupsDescription_;
        }
        if (userInfo.toLowerCase().equals("*group") && groupInfo.toLowerCase().equals("*none")) {
            return groupsDescription_;
        }
        Trace.log(2, "userInfo or groupInfo's value is invalid");
        Trace.log(3, "userInfo : " + userInfo);
        Trace.log(3, "groupInfo : " + groupInfo);
        return "";
    }

    public VObject getDetailsChildAt(int index) {
        if (index < 0 || index >= this.detailsChildren_.length) {
            return null;
        }
        this.loadMore(index);
        return this.detailsChildren_[index];
    }

    public int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject detailsChild) {
        for (int i = 0; i < this.loaded_; ++i) {
            if (!this.detailsChildren_[i].equals(detailsChild)) continue;
            return i;
        }
        return -1;
    }

    public String getGroupInfo() {
        return this.userList_.getGroupInfo();
    }

    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode child) {
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return this.getDescription(this.userList_);
        }
        return null;
    }

    public AS400 getSystem() {
        return this.userList_.getSystem();
    }

    public String getText() {
        return this.description_;
    }

    public String getUserInfo() {
        return this.userList_.getUserInfo();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.userList_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.userList_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.detailsChildren_ = new VObject[0];
        this.enum_ = null;
        this.loaded_ = -1;
        this.propertiesPane_ = new UserListPropertiesPane(this, this.userList_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Loading users for user list.");
        }
        this.workingEventSupport_.fireStartWorking();
        Exception error = null;
        try {
            this.enum_ = this.userList_.getUsers();
        }
        catch (Exception e) {
            error = e;
        }
        VUserList vUserList = this;
        synchronized (vUserList) {
            for (int i = 0; i < this.loaded_; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = 0;
            this.detailsChildren_ = error == null ? new VUser[this.userList_.getLength()] : new VUser[0];
        }
        this.isLoaded_ = true;
        if (error != null) {
            this.errorEventSupport_.fireError(error);
        }
        this.workingEventSupport_.fireStopWorking();
        this.objectEventSupport_.fireObjectChanged(this, true);
    }

    private void loadMore(int index) {
        if (index >= this.loaded_) {
            this.workingEventSupport_.fireStartWorking();
            Exception error = null;
            for (int i = this.loaded_; i <= index; ++i) {
                User user = (User)this.enum_.nextElement();
                this.detailsChildren_[i] = new VUser(user);
                this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = index + 1;
            if (error != null) {
                this.errorEventSupport_.fireError(error);
            }
            this.workingEventSupport_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setGroupInfo(String groupInfo) throws PropertyVetoException {
        if (groupInfo == null) {
            throw new NullPointerException("groupInfo");
        }
        this.userList_.setGroupInfo(groupInfo);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        AS400 oldValue = this.userList_.getSystem();
        AS400 newValue = system;
        this.vetoableChangeSupport_.fireVetoableChange("system", oldValue, newValue);
        if (oldValue != newValue) {
            try {
                this.userList_.setSystem(system);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.propertyChangeSupport_.firePropertyChange("system", oldValue, newValue);
    }

    public void setUserInfo(String userInfo) throws PropertyVetoException {
        if (userInfo == null) {
            throw new NullPointerException("userInfo");
        }
        this.userList_.setUserInfo(userInfo);
    }

    public void sortDetailsChildren(Object[] propertyIdentifiers, boolean[] orders) {
    }

    public String toString() {
        return this.description_;
    }

    static {
        detailsColumnModel_ = null;
        detailsColumnModel_ = new DefaultTableColumnModel();
        int i = 0;
        VTableColumn vTable1 = new VTableColumn(i++, NAME_PROPERTY);
        vTable1.setCellRenderer(new VObjectCellRenderer());
        vTable1.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable1.setHeaderValue(nameColumnHeader_);
        vTable1.setPreferredCharWidth(15);
        detailsColumnModel_.addColumn(vTable1);
        VTableColumn vTable2 = new VTableColumn(i++, DESCRIPTION_PROPERTY);
        vTable2.setCellRenderer(new VObjectCellRenderer());
        vTable2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTable2.setHeaderValue(descriptionColumnHeader_);
        vTable2.setPreferredCharWidth(70);
        detailsColumnModel_.addColumn(vTable2);
    }
}

