/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataFormat;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDCursor {
    private static final int OPEN_READONLY_ = 128;
    private static final int OPEN_ALL_ = 240;
    private static final int FULL_OPEN_ = 1;
    static final int REUSE_NO = 240;
    static final int REUSE_YES = 241;
    static final int REUSE_RESULT_SET = 242;
    private boolean closed_ = true;
    private AS400JDBCConnection connection_;
    private int id_;
    private boolean lazyClose_;
    private String name_;
    private int concurrency_;
    private int holdable_ = -1;
    private int scrollable_ = -1;
    private int updatable_ = -1;
    private int sensitive_ = -1;
    private int isolationLevel_ = -1;
    private boolean extendedMetaData_ = false;
    private DBReplyRequestedDS openReply = null;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_ = null;

    JDCursor(AS400JDBCConnection aS400JDBCConnection, int n, String string, int n2) throws SQLException {
        this.concurrency_ = n2;
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.name_ = string;
        this.lazyClose_ = this.connection_.getProperties().getBoolean(40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(int n) throws SQLException {
        block11: {
            DBSQLRequestDS dBSQLRequestDS = null;
            boolean bl = false;
            try {
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6154, this.id_, 0, 0);
                    dBSQLRequestDS.setReuseIndicator(n);
                    if (this.lazyClose_) {
                        bl = true;
                        this.connection_.sendAndHold(dBSQLRequestDS, this.id_);
                    } else {
                        this.connection_.send(dBSQLRequestDS, this.id_);
                    }
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException("HY000", dBDataStreamException);
                    Object var6_5 = null;
                    if (dBSQLRequestDS != null && !bl) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    break block11;
                }
                Object var6_4 = null;
                if (dBSQLRequestDS == null || bl) break block11;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (dBSQLRequestDS != null && !bl) {
                    dBSQLRequestDS.returnToPool();
                    dBSQLRequestDS = null;
                }
                throw throwable;
            }
            dBSQLRequestDS.returnToPool();
            dBSQLRequestDS = null;
        }
        if (this.openReply != null) {
            this.openReply.returnToPool();
            this.openReply = null;
        }
        this.closed_ = true;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Closing with reuse flag = " + n);
            JDTrace.logClose(this);
        }
    }

    String getName() {
        return this.name_;
    }

    int getOpenAttributes(JDSQLStatement jDSQLStatement, String string) throws SQLException {
        int n = 240;
        if (jDSQLStatement == null) {
            n = 128;
        } else if (jDSQLStatement.isProcedureCall()) {
            n = 128;
        } else if (jDSQLStatement.isSelect() && !string.equalsIgnoreCase("0") && (this.connection_.isReadOnly() || !jDSQLStatement.isForUpdate() && this.concurrency_ != 1008)) {
            n = 128;
        }
        if (this.connection_.getProperties().getBoolean(45) && this.connection_.getServerFunctionalLevel() >= 9) {
            n |= 1;
        }
        return n;
    }

    int getConcurrency() {
        return this.concurrency_;
    }

    boolean isClosed() {
        return this.closed_;
    }

    void setExtendedColumnDescriptorsFromReply(DBReplyRequestedDS dBReplyRequestedDS) {
        this.extendedColumnDescriptors_ = this.extendedMetaData_ ? dBReplyRequestedDS.getExtendedColumnDescriptors() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DBDataFormat openDescribe(int n, int n2) throws SQLException {
        DBDataFormat dBDataFormat;
        block11: {
            dBDataFormat = null;
            try {
                DBBaseRequestDS dBBaseRequestDS = null;
                try {
                    int n3 = -1979711488;
                    if (this.extendedMetaData_) {
                        n3 += 131072;
                    }
                    dBBaseRequestDS = DBDSPool.getDBSQLRequestDS(6148, this.id_, n3, 0);
                    ((DBSQLRequestDS)dBBaseRequestDS).setOpenAttributes(n);
                    String string = this.connection_.getProperties().getString(49);
                    if (this.connection_.getVRM() <= JDUtilities.vrm520) {
                        ((DBSQLRequestDS)dBBaseRequestDS).setScrollableCursorFlag(0);
                    } else {
                        ((DBSQLRequestDS)dBBaseRequestDS).setScrollableCursorFlag(AS400JDBCResultSet.getDBSQLRequestDSCursorType(string, n2, 1007));
                    }
                    if (this.openReply != null) {
                        this.openReply.returnToPool();
                        this.openReply = null;
                    }
                    this.openReply = this.connection_.sendAndReceive(dBBaseRequestDS, this.id_);
                    int n4 = this.openReply.getErrorClass();
                    int n5 = this.openReply.getReturnCode();
                    if (n4 != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n4, n5);
                    }
                    this.processConcurrencyOverride(n, this.openReply);
                    dBDataFormat = this.openReply.getDataFormat();
                    this.setExtendedColumnDescriptorsFromReply(this.openReply);
                    dBDataFormat.setCSRSData(true);
                    Object var10_10 = null;
                    if (dBBaseRequestDS == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    throw throwable;
                }
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
        }
        this.closed_ = false;
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, null);
        }
        return dBDataFormat;
    }

    void processConcurrencyOverride(int n, DBBaseReplyDS dBBaseReplyDS) throws DBDataStreamException {
        DBReplySQLCA dBReplySQLCA = dBBaseReplyDS.getSQLCA();
        switch (dBReplySQLCA.getWarn5()) {
            case -15: 
            case -14: {
                this.concurrency_ = 1007;
                break;
            }
            case -12: {
                this.concurrency_ = 1008;
            }
        }
    }

    void processCursorAttributes(DBBaseReplyDS dBBaseReplyDS) throws SQLException {
        this.holdable_ = dBBaseReplyDS.getCursorAttributeHoldable();
        this.scrollable_ = dBBaseReplyDS.getCursorAttributeScrollable();
        this.updatable_ = dBBaseReplyDS.getCursorAttributeUpdatable();
        this.sensitive_ = dBBaseReplyDS.getCursorAttributeSensitive();
        this.isolationLevel_ = dBBaseReplyDS.getCursorIsolationLevel();
    }

    public int getCursorAttributeHoldable() {
        return this.holdable_;
    }

    public int getCursorAttributeScrollable() {
        return this.scrollable_;
    }

    public int getCursorAttributeUpdatable() {
        return this.updatable_;
    }

    public int getCursorAttributeSensitive() {
        return this.sensitive_;
    }

    public int getCursorIsolationLevel() {
        return this.isolationLevel_;
    }

    void setExtendedMetaData(boolean bl) {
        this.extendedMetaData_ = bl;
    }

    void setName(String string) {
        this.name_ = string;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "setName", "Name", this.name_);
        }
    }

    void setState(boolean bl) {
        this.closed_ = bl;
        if (JDTrace.isTraceOn()) {
            if (this.closed_) {
                JDTrace.logClose(this);
            } else {
                JDTrace.logOpen(this, null);
            }
        }
    }

    DBExtendedColumnDescriptors getExtendedColumnDescriptors() {
        return this.extendedColumnDescriptors_;
    }

    public String toString() {
        return this.name_;
    }
}

