/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PxDSFactory;
import com.ibm.as400.access.PxDSRV;
import com.ibm.as400.access.PxRepCV;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

class PxClientReadDaemon
extends StoppableThread {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private PxDSFactory factory_ = new PxDSFactory();
    private InputStream input_;
    private InvocationTargetException invocationTargetException_ = null;
    private IOException ioException_ = null;
    private Hashtable replies_ = new Hashtable();
    private boolean running_ = false;
    private boolean started_ = false;

    public PxClientReadDaemon() {
        super("Proxy client read daemon-" + PxClientReadDaemon.newId());
        this.setDaemon(true);
    }

    public PxClientReadDaemon(InputStream inputStream) {
        super("Proxy client read daemon-" + PxClientReadDaemon.newId());
        this.setDaemon(true);
        this.input_ = inputStream;
    }

    public PxDSFactory getFactory() {
        return this.factory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PxRepCV getReply(long l) throws InvocationTargetException, IOException {
        Long l2 = new Long(l);
        while (true) {
            if (this.ioException_ != null) {
                throw this.ioException_;
            }
            if (this.invocationTargetException_ != null) {
                throw this.invocationTargetException_;
            }
            PxClientReadDaemon pxClientReadDaemon = this;
            synchronized (pxClientReadDaemon) {
                if (this.replies_.containsKey(l2)) {
                    PxRepCV pxRepCV = (PxRepCV)this.replies_.get(l2);
                    this.replies_.remove(l2);
                    return pxRepCV;
                }
                if (this.running_ || !this.started_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    if (Trace.isTraceErrorOn()) {
                        Trace.log(2, "Proxy read daemon stopped, but replies are expected.");
                    }
                    throw new InternalErrorException(4);
                }
            }
        }
    }

    public void register(PxDSRV pxDSRV) {
        this.factory_.register(pxDSRV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.started_ = true;
        this.running_ = true;
        try {
            while (this.canContinue()) {
                long l;
                PxRepCV pxRepCV = (PxRepCV)this.factory_.getNextDS(this.input_);
                if (Trace.isTraceProxyOn()) {
                    pxRepCV.dump(Trace.getPrintWriter());
                }
                if ((l = pxRepCV.getCorrelationId()) >= 0L) {
                    PxClientReadDaemon pxClientReadDaemon = this;
                    synchronized (pxClientReadDaemon) {
                        this.replies_.put(new Long(l), pxRepCV);
                        this.notifyAll();
                        continue;
                    }
                }
                pxRepCV.process();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            this.invocationTargetException_ = invocationTargetException;
        }
        catch (IOException iOException) {
            if (!this.wasStoppedSafely() && !(iOException instanceof EOFException)) {
                this.ioException_ = iOException;
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Ending read daemon", (Throwable)iOException);
                }
            }
            PxClientReadDaemon pxClientReadDaemon = this;
            synchronized (pxClientReadDaemon) {
                this.notifyAll();
            }
        }
        this.running_ = false;
    }

    public PxRepCV getReply(long l, InputStream inputStream) throws InvocationTargetException, IOException {
        PxRepCV pxRepCV;
        Long l2 = new Long(l);
        if (this.replies_.containsKey(l2)) {
            PxRepCV pxRepCV2 = (PxRepCV)this.replies_.get(l2);
            this.replies_.remove(l2);
            return pxRepCV2;
        }
        while (true) {
            long l3;
            pxRepCV = (PxRepCV)this.factory_.getNextDS(inputStream);
            if (Trace.isTraceProxyOn()) {
                pxRepCV.dump(Trace.getPrintWriter());
            }
            if ((l3 = pxRepCV.getCorrelationId()) == l) break;
            this.replies_.put(new Long(l3), pxRepCV);
        }
        pxRepCV.process();
        return pxRepCV;
    }
}

