/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLReal
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private float value_ = 0.0f;

    SQLReal(SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
    }

    public Object clone() {
        return new SQLReal(this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.value_ = BinaryConverter.byteArrayToFloat(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.floatToByteArray(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        boolean bl = false;
        double d = 0.0;
        if (object instanceof String) {
            if (this.settings_.getDecimalSeparator().equals(",")) {
                object = ((String)object).replace(',', '.');
            }
            try {
                String string = (String)object;
                d = Double.valueOf(string);
                if ((d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) && string.toUpperCase().indexOf("inf") >= 0) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Number) {
            String string;
            Number number = (Number)object;
            d = number.doubleValue();
            if ((d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) && (string = number.toString().toLowerCase()).indexOf("inf") >= 0) {
                bl = true;
            }
        } else if (object instanceof Boolean) {
            d = (Boolean)object == true ? 1.0 : 0.0;
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        if (d > 3.4028234663852886E38) {
            if (!bl) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
                this.value_ = Float.MAX_VALUE;
            }
        } else if (d < -3.4028234663852886E38) {
            if (!bl) {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
                this.value_ = -3.4028235E38f;
            }
        } else {
            this.value_ = (float)d;
        }
    }

    public int getSQLType() {
        return 24;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 13;
    }

    public String getJavaClassName() {
        return "java.lang.Float";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "REAL";
    }

    public int getMaximumPrecision() {
        return 24;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 480;
    }

    public int getPrecision() {
        return 24;
    }

    public int getRadix() {
        return 2;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 7;
    }

    public String getTypeName() {
        return "REAL";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return SQLDataFactory.getPrecision(Float.toString(this.value_));
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        BigDecimal bigDecimal = null;
        String string = Float.toString(this.value_);
        int n2 = string.indexOf("E");
        if (n2 == -1) {
            bigDecimal = new BigDecimal(string);
        } else {
            String string2 = string.substring(0, n2);
            int n3 = Integer.parseInt(string.substring(n2 + 1));
            bigDecimal = new BigDecimal(string2);
            bigDecimal = bigDecimal.movePointRight(n3);
        }
        if (n >= 0) {
            if (n >= bigDecimal.scale()) {
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return bigDecimal.setScale(n);
            }
            this.truncated_ = bigDecimal.scale() - n;
            this.outOfBounds_ = false;
            return bigDecimal.setScale(n, 4);
        }
        return bigDecimal;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_ != 0.0f;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 127.0f || this.value_ < -128.0f) {
            if (this.value_ > 32767.0f || this.value_ < -32768.0f) {
                this.truncated_ = 3;
                this.outOfBounds_ = true;
            } else {
                this.truncated_ = 1;
                this.outOfBounds_ = true;
            }
        }
        return (byte)this.value_;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 2.1474836E9f || this.value_ < -2.1474836E9f) {
            this.truncated_ = 4;
            this.outOfBounds_ = true;
        }
        return (int)this.value_;
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 9.223372E18f || this.value_ < -9.223372E18f) {
            this.truncated_ = 8;
            this.outOfBounds_ = true;
        }
        return (long)this.value_;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new Float(this.value_);
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.value_ > 32767.0f || this.value_ < -32768.0f) {
            this.truncated_ = 2;
            this.outOfBounds_ = true;
        }
        return (short)this.value_;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = Float.toString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = Float.toString(this.value_);
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = new Float(this.value_);
    }
}

