/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400AuthenticationException;
import com.ibm.as400.security.auth.AS400CredentialEvent;
import com.ibm.as400.security.auth.AS400CredentialImpl;
import com.ibm.as400.security.auth.AS400CredentialListener;
import com.ibm.as400.security.auth.AS400Principal;
import com.ibm.as400.security.auth.AS400SwappableCredential;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.RefreshAgent;
import com.ibm.as400.security.auth.ResourceBundleLoader_a;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Vector;

public abstract class AS400Credential
implements Serializable,
AS400SwappableCredential {
    static final long serialVersionUID = 4L;
    private transient PropertyChangeSupport changes_;
    private transient VetoableChangeSupport vetos_;
    private transient Vector listeners_;
    private transient AS400CredentialImpl impl_;
    private transient RefreshAgent rAgent_;
    private AS400 system_ = null;
    private AS400Principal principal_ = null;
    private Boolean renewable_ = null;
    private Boolean standalone_ = null;
    private Boolean timed_ = null;
    boolean private_ = true;
    private static int minVRM_ = 0;
    private static ResourceBundleLoader_a loader_;
    public static final int CR_AUTO_REFRESH_FAILED = 0;
    public static final int CR_AUTO_REFRESH_NOT_VALID = 1;
    public static final int CR_AUTO_REFRESH_STARTED = 2;
    public static final int CR_AUTO_REFRESH_STOPPED = 3;
    private static String permissionClassName_;
    private static Constructor permissionClassConstructor_;
    private static String permissionCheckMethodName_;
    private static Method permissionCheckMethod_;

    public AS400Credential() {
        this.initTransient();
    }

    public void addCredentialListener(AS400CredentialListener aS400CredentialListener) {
        if (aS400CredentialListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.listeners_.addElement(aS400CredentialListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    public String[] basicAuthenticationPrompt() {
        String[] stringArray = new String[2];
        stringArray[0] = ResourceBundleLoader_a.getCoreText("DLG_USER_ID_LABEL");
        stringArray[1] = ResourceBundleLoader_a.getCoreText("DLG_PASSWORD_LABEL");
        return stringArray;
    }

    void checkAuthenticationPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && permissionCheckMethod_ != null && permissionClassConstructor_ != null) {
            try {
                permissionCheckMethod_.invoke((Object)securityManager, permissionClassConstructor_.newInstance(string));
            }
            catch (InvocationTargetException invocationTargetException) {
                Trace.log(1, "Authentication permission check failed: " + string);
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SecurityException) {
                    throw (SecurityException)throwable;
                }
                AuthenticationSystem.handleUnexpectedException(throwable);
            }
            catch (Exception exception) {
                AuthenticationSystem.handleUnexpectedException(exception);
            }
        }
    }

    public void destroy() throws AS400SecurityException {
        this.checkAuthenticationPermission("destroyCredential");
        this.stopAutomaticRefresh();
        if (this.impl_ != null) {
            this.impl_.destroy();
            this.setImpl(null);
        }
        this.invalidateProperties();
        this.fireDestroyed();
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Credential destroyed >> ").append(this.toString()).toString());
        }
    }

    protected void finalize() throws Throwable {
        this.stopAutomaticRefresh();
        super.finalize();
    }

    void fireCreated() {
        Vector vector = (Vector)this.listeners_.clone();
        AS400CredentialEvent aS400CredentialEvent = new AS400CredentialEvent(this, 0);
        for (int i = 0; i < vector.size(); ++i) {
            AS400CredentialListener aS400CredentialListener = (AS400CredentialListener)vector.elementAt(i);
            aS400CredentialListener.created(aS400CredentialEvent);
        }
    }

    void fireDestroyed() {
        Vector vector = (Vector)this.listeners_.clone();
        AS400CredentialEvent aS400CredentialEvent = new AS400CredentialEvent(this, 1);
        for (int i = 0; i < vector.size(); ++i) {
            AS400CredentialListener aS400CredentialListener = (AS400CredentialListener)vector.elementAt(i);
            aS400CredentialListener.destroyed(aS400CredentialEvent);
        }
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.changes_.firePropertyChange(string, object, object2);
    }

    void fireRefreshed() {
        Vector vector = (Vector)this.listeners_.clone();
        AS400CredentialEvent aS400CredentialEvent = new AS400CredentialEvent(this, 2);
        for (int i = 0; i < vector.size(); ++i) {
            AS400CredentialListener aS400CredentialListener = (AS400CredentialListener)vector.elementAt(i);
            aS400CredentialListener.refreshed(aS400CredentialEvent);
        }
    }

    void fireSwapped() {
        Vector vector = (Vector)this.listeners_.clone();
        AS400CredentialEvent aS400CredentialEvent = new AS400CredentialEvent(this, 3);
        for (int i = 0; i < vector.size(); ++i) {
            AS400CredentialListener aS400CredentialListener = (AS400CredentialListener)vector.elementAt(i);
            aS400CredentialListener.swapped(aS400CredentialEvent);
        }
    }

    void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        this.vetos_.fireVetoableChange(string, object, object2);
    }

    public Throwable getAutomaticRefreshFailure() {
        if (this.rAgent_ != null) {
            return this.rAgent_.getFailure();
        }
        return null;
    }

    public int getAutomaticRefreshStatus() {
        if (!this.isRenewable() || this.getSystem() == null || !this.getSystem().isThreadUsed()) {
            return 1;
        }
        if (this.rAgent_ != null) {
            if (this.rAgent_.getFailure() != null) {
                return 0;
            }
            if (this.rAgent_.isAlive()) {
                return 2;
            }
        }
        return 3;
    }

    AS400CredentialImpl getImpl() throws AS400SecurityException {
        if (this.impl_ == null) {
            this.validateProperties();
            this.setImpl(this.getImplPrimitive());
        }
        return this.impl_;
    }

    AS400CredentialImpl getImplPrimitive() throws AS400SecurityException {
        this.validateVRM();
        AS400CredentialImpl aS400CredentialImpl = null;
        try {
            try {
                aS400CredentialImpl = (AS400CredentialImpl)Class.forName(this.implClassName()).newInstance();
            }
            catch (Exception exception) {
                if (this.implClassNameNative() != null && this.implClassName().equals(this.implClassNameNative())) {
                    Trace.log(1, "Load of native implementation '" + this.implClassNameNative() + "' failed, attempting to load remote implementation.");
                    aS400CredentialImpl = (AS400CredentialImpl)Class.forName(this.implClassNameRemote()).newInstance();
                }
                throw exception;
            }
            if (aS400CredentialImpl.getVersion() < this.typeMinImplVersion()) {
                if (this.implClassNameNative() != null && aS400CredentialImpl.getClass().getName().equals(this.implClassNameNative())) {
                    Trace.log(1, new StringBuffer("Native impl '").append(aS400CredentialImpl.getClass().getName()).append("' found at version ").append(aS400CredentialImpl.getVersion()).append(" not sufficient to meet required level ").append(this.typeMinImplVersion()).append(". Attempting to load remote impl instead.").toString());
                    aS400CredentialImpl = (AS400CredentialImpl)Class.forName(this.implClassNameRemote()).newInstance();
                    if (aS400CredentialImpl.getVersion() < this.typeMinImplVersion()) {
                        Trace.log(1, new StringBuffer("Remote impl '").append(aS400CredentialImpl.getClass().getName()).append("' found at version ").append(aS400CredentialImpl.getVersion()).append(" not sufficient to meet required level ").append(this.typeMinImplVersion()).toString());
                        aS400CredentialImpl = null;
                    }
                } else {
                    aS400CredentialImpl = null;
                }
                if (aS400CredentialImpl == null) {
                    Trace.log(1, "Load of implementation for " + this.getClass().getName() + " failed.");
                    throw new ExtendedIllegalStateException(11);
                }
            }
            aS400CredentialImpl.setCredential(this);
        }
        catch (Exception exception) {
            Trace.log(1, "Load of implementation " + this.implClassName() + " failed.");
            AuthenticationSystem.handleUnexpectedException(exception);
        }
        return aS400CredentialImpl;
    }

    public AS400Principal getPrincipal() {
        return this.principal_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public int getTimeToExpiration() throws AS400SecurityException {
        if (this.isTimed()) {
            return this.getImpl().getTimeToExpiration();
        }
        return 0;
    }

    String implClassName() {
        if (this.implClassNameNative() != null && AuthenticationSystem.isLocal(this.getSystem())) {
            return this.implClassNameNative();
        }
        return this.implClassNameRemote();
    }

    String implClassNameNative() {
        return null;
    }

    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.AS400CredentialImplRemote";
    }

    void initTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.vetos_ = new VetoableChangeSupport(this);
        this.listeners_ = new Vector();
        this.rAgent_ = null;
        this.setImpl(null);
    }

    void invalidateProperties() {
        this.system_ = null;
        this.principal_ = null;
        this.renewable_ = null;
        this.standalone_ = null;
        this.timed_ = null;
    }

    boolean isConnected() {
        return this.impl_ != null;
    }

    public boolean isCurrent() {
        try {
            if (!this.isDestroyed()) {
                return this.getImpl().isCurrent();
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            // empty catch block
        }
        return false;
    }

    public boolean isDestroyed() {
        if (this.impl_ == null) {
            try {
                this.validateProperties();
            }
            catch (Exception exception) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrivate() {
        return this.private_;
    }

    public boolean isRenewable() {
        if (this.renewable_ != null) {
            return this.renewable_;
        }
        return this.typeIsRenewable();
    }

    boolean isStandalone() {
        if (this.standalone_ != null) {
            return this.standalone_;
        }
        return this.typeIsStandalone();
    }

    public boolean isTimed() {
        if (this.timed_ != null) {
            return this.timed_;
        }
        return this.typeIsTimed();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initTransient();
    }

    public void refresh() throws AS400SecurityException {
        this.checkAuthenticationPermission("refreshCredential");
        if (!this.isRenewable()) {
            return;
        }
        this.getImpl().refresh();
        this.fireRefreshed();
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Credential refreshed >> ").append(this.toString()).toString());
        }
    }

    public void removeCredentialListener(AS400CredentialListener aS400CredentialListener) {
        this.listeners_.removeElement(aS400CredentialListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
    }

    void setImpl(AS400CredentialImpl aS400CredentialImpl) {
        this.impl_ = aS400CredentialImpl;
    }

    void setIsRenewable(boolean bl) {
        this.validatePropertyChange("isRenewable");
        this.renewable_ = new Boolean(bl);
    }

    void setIsStandalone(boolean bl) {
        this.validatePropertyChange("isStandalone");
        this.standalone_ = new Boolean(bl);
    }

    void setIsTimed(boolean bl) {
        this.validatePropertyChange("isTimed");
        this.timed_ = new Boolean(bl);
    }

    public void setPrincipal(AS400Principal aS400Principal) throws PropertyVetoException {
        this.validatePropertyChange("principal");
        AS400Principal aS400Principal2 = this.getPrincipal();
        this.fireVetoableChange("principal", aS400Principal2, aS400Principal);
        this.principal_ = aS400Principal;
        this.firePropertyChange("principal", aS400Principal2, aS400Principal);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        this.validatePropertyChange("system");
        AS400 aS4002 = this.getSystem();
        this.fireVetoableChange("system", aS4002, aS400);
        this.system_ = aS400;
        this.firePropertyChange("system", aS4002, aS400);
    }

    public void startAutomaticRefresh(int n, int n2) {
        int n3 = this.getAutomaticRefreshStatus();
        if (n3 == 1) {
            Trace.log(2, "Automatic refresh for " + this.toString() + " not valid.");
            throw new IllegalStateException("automaticRefreshStatus");
        }
        if (n3 == 2) {
            Trace.log(2, "Automatic refresh for " + this.toString() + " already started.");
            throw new IllegalStateException("automaticRefreshStatus");
        }
        if (n <= 0) {
            Trace.log(2, "Refresh interval " + n + " must be > 0.");
            throw new ExtendedIllegalArgumentException("refreshInterval", 4);
        }
        if (n2 < -1) {
            Trace.log(2, "Maximum number of refreshes " + n2 + " must be >= -1.");
            throw new ExtendedIllegalArgumentException("maxRefreshes", 4);
        }
        this.rAgent_ = new RefreshAgent(this, n, n2);
        this.rAgent_.start();
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Automatic refresh started >> ").append(this.toString()).toString());
        }
    }

    public void stopAutomaticRefresh() {
        if (this.rAgent_ == null || !this.rAgent_.isAlive()) {
            return;
        }
        this.rAgent_.stopRefresh();
        this.rAgent_ = null;
        if (Trace.isTraceOn()) {
            Trace.log(3, new StringBuffer("Automatic refresh stopped >> ").append(this.toString()).toString());
        }
    }

    public void swap() throws Exception {
        this.swap(false);
    }

    public AS400Credential swap(boolean bl) throws AS400SecurityException {
        this.checkAuthenticationPermission("modifyThreadIdentity");
        this.validatePrincipalCompatibility();
        AS400Credential aS400Credential = null;
        try {
            aS400Credential = this.getImpl().swap(bl);
            if (this.getSystem() != AuthenticationSystem.localHost()) {
                AuthenticationSystem.resetLocalHost();
            }
            this.getSystem().resetAllServices();
            this.getSystem().setUserId("*CURRENT");
            this.getSystem().setPassword("*CURRENT");
            this.getSystem().getServicePort(7);
            this.fireSwapped();
            if (Trace.isTraceOn()) {
                Trace.log(3, new StringBuffer("Credential swapped >> ").append(this.toString()).toString());
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
        return aS400Credential;
    }

    boolean typeIsRenewable() {
        return false;
    }

    boolean typeIsStandalone() {
        return false;
    }

    boolean typeIsTimed() {
        return false;
    }

    int typeMinImplVersion() {
        return 1;
    }

    int typeMinVRM() {
        if (minVRM_ == 0) {
            minVRM_ = AS400.generateVRM(4, 5, 0);
        }
        return minVRM_;
    }

    void validatePrincipalCompatibility() {
        if (this.isStandalone() || this.getPrincipal() == null || this.getPrincipal().getSystem() == null) {
            return;
        }
        if (this.getPrincipal().getSystem().equals(this.getSystem())) {
            Trace.log(2, "Incompatible credential and principal systems.");
            throw new IllegalStateException("system");
        }
    }

    void validateProperties() {
        this.validatePropertySet("system", this.getSystem());
        if (!this.isStandalone()) {
            this.validatePropertySet("principal", this.getPrincipal());
        }
    }

    void validatePropertyChange(String string) {
        if (this.isConnected()) {
            Trace.log(2, "Property '" + string + "' not changed (connected=true).");
            throw new ExtendedIllegalStateException(string, 5);
        }
    }

    void validatePropertySet(String string, Object object) {
        if (object == null) {
            Trace.log(2, "Required property '" + string + "' not set.");
            throw new ExtendedIllegalStateException(4);
        }
    }

    void validateVRM() throws AS400SecurityException {
        try {
            if (this.getSystem().getVRM() < this.typeMinVRM()) {
                Trace.log(2, "VRM<" + this.typeMinVRM());
                throw new AS400AuthenticationException(38);
            }
        }
        catch (Exception exception) {
            AuthenticationSystem.handleUnexpectedException(exception);
        }
    }

    static {
        permissionClassName_ = "javax.security.auth.AuthPermission";
        permissionClassConstructor_ = null;
        permissionCheckMethodName_ = "checkPermission";
        permissionCheckMethod_ = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                Class<?> clazz = Class.forName(permissionClassName_);
                permissionClassConstructor_ = clazz.getConstructor(String.class);
                permissionCheckMethod_ = securityManager.getClass().getMethod(permissionCheckMethodName_, Class.forName("java.security.Permission"));
            }
            catch (AccessControlException accessControlException) {
                Trace.log(4, "Access to permission class is denied by SecurityManager, JAAS permissions will not be checked.", (Throwable)accessControlException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.log(4, "Unable to resolve permission class, JAAS permissions will not be checked.", (Throwable)classNotFoundException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Trace.log(4, "Unable to resolve permission class, JAAS permissions will not be checked.", (Throwable)noClassDefFoundError);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Trace.log(4, "Security manager does not implement method '" + permissionCheckMethodName_ + "'. JAAS permissions will not be checked.", (Throwable)noSuchMethodException);
            }
        }
    }
}

