/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AS400DetailsModel;
import com.ibm.as400.vaccess.DoubleClickAdapter;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PopupMenuAdapter;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AS400DetailsPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    boolean allowActions_ = true;
    boolean confirm_ = true;
    transient JTable table_ = null;
    AS400DetailsModel model_ = new AS400DetailsModel();
    private transient VActionContext actionContext_;
    private transient DoubleClickAdapter doubleClickAdapter_;
    private transient PopupMenuAdapter popupMenuAdapter_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public AS400DetailsPane() {
        this.initializeTransient();
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table_);
        this.add("Center", jScrollPane);
    }

    public AS400DetailsPane(VNode vNode) {
        this();
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        try {
            this.model_.setRoot(vNode);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionEventSupport_.addListSelectionListener(listSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public VActionContext getActionContext() {
        return this.actionContext_;
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public boolean getConfirm() {
        return this.confirm_;
    }

    public TableModel getModel() {
        return this.model_;
    }

    public VNode getRoot() {
        return this.model_.getRoot();
    }

    public boolean getRowSelectionAllowed() {
        return this.table_.getRowSelectionAllowed();
    }

    public VObject getSelectedObject() {
        VObject vObject = null;
        int[] nArray = this.table_.getSelectedRows();
        if (nArray.length > 0) {
            vObject = this.model_.getObjectAt(nArray[0]);
        }
        return vObject;
    }

    public VObject[] getSelectedObjects() {
        int[] nArray = this.table_.getSelectedRows();
        VObject[] vObjectArray = new VObject[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vObjectArray[i] = this.model_.getObjectAt(nArray[i]);
        }
        return vObjectArray;
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    private void initializeTransient() {
        this.addFocusListener(new SerializationListener(this));
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.table_ = new JTable(this.model_);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setAutoResizeMode(0);
        this.table_.setColumnSelectionAllowed(false);
        this.table_.setRowSelectionAllowed(true);
        this.table_.setShowGrid(false);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.model_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.table_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.actionContext_ = new VActionContext_();
        this.model_.addPropertyChangeListener(new ColumnAdapter_());
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.table_));
        VPane_ vPane_ = new VPane_();
        this.doubleClickAdapter_ = new DoubleClickAdapter(vPane_, this.actionContext_);
        this.popupMenuAdapter_ = new PopupMenuAdapter(vPane_, this.actionContext_);
        if (this.allowActions_) {
            this.table_.addMouseListener(this.popupMenuAdapter_);
            this.table_.addMouseListener(this.doubleClickAdapter_);
        }
    }

    public boolean isSelected(VObject vObject) {
        if (vObject == null) {
            throw new NullPointerException("object");
        }
        int[] nArray = this.table_.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.model_.getObjectAt(nArray[i]).equals(vObject)) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.table_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listSelectionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.removeVetoableChangeListener(vetoableChangeListener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setAllowActions(boolean bl) {
        if (this.allowActions_ != bl) {
            this.allowActions_ = bl;
            if (this.allowActions_) {
                this.table_.addMouseListener(this.popupMenuAdapter_);
                this.table_.addMouseListener(this.doubleClickAdapter_);
            } else {
                this.table_.removeMouseListener(this.popupMenuAdapter_);
                this.table_.removeMouseListener(this.doubleClickAdapter_);
            }
        }
    }

    public void setConfirm(boolean bl) {
        this.confirm_ = bl;
    }

    public void setRoot(VNode vNode) throws PropertyVetoException {
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        this.table_.clearSelection();
        this.model_.setRoot(vNode);
    }

    public void setRowSelectionAllowed(boolean bl) {
        this.table_.setRowSelectionAllowed(bl);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.table_.getSelectionModel();
        if (listSelectionModel2 != null) {
            listSelectionModel2.removeListSelectionListener(this.listSelectionEventSupport_);
        }
        this.table_.setSelectionModel(listSelectionModel);
        if (listSelectionModel != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionEventSupport_);
        }
    }

    void sizeColumns() {
        int n = 0;
        if (this.table_.getFont() != null) {
            n = this.table_.getFontMetrics(this.table_.getFont()).charWidth('M');
        }
        if (n > 0) {
            TableColumnModel tableColumnModel = this.table_.getColumnModel();
            int n2 = tableColumnModel.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                if (!(tableColumn instanceof VTableColumn)) continue;
                VTableColumn vTableColumn = (VTableColumn)tableColumn;
                tableColumn.setPreferredWidth(vTableColumn.getPreferredCharWidth() * n + 10);
            }
        }
    }

    public void sort(Object[] objectArray, boolean[] blArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (blArray == null) {
            throw new NullPointerException("orders");
        }
        this.model_.sort(objectArray, blArray);
    }

    private class VPane_
    implements VPane,
    Serializable {
        private VPane_() {
        }

        public VNode getRoot() {
            return AS400DetailsPane.this.getRoot();
        }

        public VObject getObjectAt(Point point) {
            VObject vObject = null;
            int n = AS400DetailsPane.this.table_.rowAtPoint(point);
            if (n != -1) {
                vObject = AS400DetailsPane.this.model_.getObjectAt(n);
            }
            return vObject;
        }

        public void setRoot(VNode vNode) throws PropertyVetoException {
            AS400DetailsPane.this.setRoot(vNode);
        }
    }

    private class VActionContext_
    implements VActionContext,
    Serializable {
        private VActionContext_() {
        }

        public boolean getConfirm() {
            return AS400DetailsPane.this.confirm_;
        }

        public Frame getFrame() {
            return VUtilities.getFrame(AS400DetailsPane.this);
        }

        public CellEditor startEditing(VObject vObject, Object object) {
            if (vObject == null) {
                throw new NullPointerException("object");
            }
            if (object == null) {
                throw new NullPointerException("propertyIdentifier");
            }
            if (!AS400DetailsPane.this.allowActions_) {
                return null;
            }
            int n = AS400DetailsPane.this.model_.getRoot().getDetailsIndex(vObject);
            if (n < 0) {
                return null;
            }
            TableColumn tableColumn = null;
            try {
                tableColumn = AS400DetailsPane.this.table_.getColumn(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            int n2 = tableColumn.getModelIndex();
            AS400DetailsPane.this.table_.editCellAt(n, n2);
            return tableColumn.getCellEditor();
        }
    }

    private class ColumnAdapter_
    implements PropertyChangeListener {
        private ColumnAdapter_() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "root") {
                Object object;
                TableColumnModel tableColumnModel = AS400DetailsPane.this.table_.getColumnModel();
                Vector<TableColumn> vector = new Vector<TableColumn>();
                Object object2 = tableColumnModel.getColumns();
                while (object2.hasMoreElements()) {
                    vector.addElement(object2.nextElement());
                }
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    tableColumnModel.removeColumn((TableColumn)object);
                }
                object2 = AS400DetailsPane.this.model_.getRoot().getDetailsColumnModel();
                if (object2 != null) {
                    object = object2.getColumns();
                    while (object.hasMoreElements()) {
                        TableColumn tableColumn = (TableColumn)object.nextElement();
                        tableColumnModel.addColumn(tableColumn);
                    }
                }
                AS400DetailsPane.this.sizeColumns();
            }
        }
    }
}

