/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceMetaData;
import java.awt.Component;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

class ResourceCellRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static Border emptyBorder_ = new EmptyBorder(1, 2, 1, 2);
    private ResourceMetaData metaData_ = null;

    public ResourceCellRenderer(ResourceMetaData resourceMetaData) {
        this.metaData_ = resourceMetaData;
        this.setOpaque(true);
        if (resourceMetaData != null) {
            if (Number.class.isAssignableFrom(resourceMetaData.getType())) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        } else {
            this.setHorizontalAlignment(2);
        }
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setTextAndIcon(object);
        if (bl) {
            this.setForeground(jList.getSelectionForeground());
            this.setBackground(jList.getSelectionBackground());
        } else {
            this.setForeground(jList.getForeground());
            this.setBackground(jList.getBackground());
        }
        if (bl2) {
            this.setBorder(new LineBorder(jList.getForeground()));
        } else {
            this.setBorder(emptyBorder_);
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setTextAndIcon(object);
        if (bl) {
            this.setForeground(jTable.getSelectionForeground());
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.setBorder(new LineBorder(jTable.getForeground()));
        } else {
            this.setBorder(emptyBorder_);
        }
        return this;
    }

    private void setTextAndIcon(Object object) {
        if (object != null) {
            Serializable serializable;
            Presentation presentation;
            if (object instanceof Resource && (presentation = (serializable = (Resource)object).getPresentation()) != null) {
                this.setTextAndIcon(presentation);
                return;
            }
            if (this.metaData_ != null && (serializable = this.metaData_.getPossibleValuePresentation(object)) != null) {
                this.setTextAndIcon((Presentation)serializable);
                return;
            }
            this.setText(object.toString());
            this.setIcon(null);
        }
    }

    private void setTextAndIcon(Presentation presentation) {
        this.setText(presentation.getName());
        Image image = (Image)presentation.getValue("16");
        if (image != null) {
            this.setIcon(new ImageIcon(image));
        } else {
            this.setIcon(null);
        }
    }
}

