/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnectionPoolDataSource;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.ConnectionPool;
import com.ibm.as400.access.ConnectionPoolEvent;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.PoolConnectionEventListener;
import com.ibm.as400.access.PoolMaintenance;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class AS400JDBCConnectionPool
extends ConnectionPool
implements Serializable {
    static final long serialVersionUID = 4L;
    private boolean closed_;
    private AS400JDBCConnectionPoolDataSource dataSource_;
    transient long lastSingleThreadRun_;
    transient Vector activePool_;
    transient Vector availablePool_;
    transient Vector deadPool_;
    private transient PoolConnectionEventListener eventListener_;

    public AS400JDBCConnectionPool() {
        this.initializeTransient();
    }

    public AS400JDBCConnectionPool(AS400JDBCConnectionPoolDataSource aS400JDBCConnectionPoolDataSource) {
        this();
        try {
            this.setDataSource(aS400JDBCConnectionPoolDataSource);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupConnections() {
        Object object;
        Object object2;
        boolean bl = JDTrace.isTraceOn();
        if (bl) {
            JDTrace.logInformation(this, "ConnectionPool cleanup...");
            JDTrace.logInformation(this, "   MaxLifeTime: " + this.getMaxLifetime());
            JDTrace.logInformation(this, "   MaxUseTime: " + this.getMaxUseTime());
            JDTrace.logInformation(this, "   MaxInactivity: " + this.getMaxInactivity());
            JDTrace.logInformation(this, "   PretestConnections: " + this.isPretestConnections());
            JDTrace.logInformation(this, "Idle Connections: " + this.availablePool_.size());
            JDTrace.logInformation(this, "Active Connections: " + this.activePool_.size());
            JDTrace.logInformation(this, "Dead Connections: " + this.deadPool_.size());
        }
        Serializable serializable = this.availablePool_;
        synchronized (serializable) {
            object2 = this.activePool_;
            synchronized (object2) {
                object = new Iterator[]{this.availablePool_.iterator(), this.activePool_.iterator()};
                for (int i = 0; i < ((Iterator[])object).length; ++i) {
                    while (object[i].hasNext()) {
                        Serializable serializable2;
                        AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)object[i].next();
                        if (bl) {
                            JDTrace.logInformation(this, aS400JDBCPooledConnection.toString());
                        }
                        if (!aS400JDBCPooledConnection.isInUse() && this.getMaxLifetime() != -1L && aS400JDBCPooledConnection.getLifeSpan() > this.getMaxLifetime() || !aS400JDBCPooledConnection.isInUse() && this.getMaxInactivity() != -1L && aS400JDBCPooledConnection.getInactivityTime() > this.getMaxInactivity()) {
                            if (bl) {
                                JDTrace.logInformation(this, "Removing expired connection from the pool.");
                            }
                            object[i].remove();
                            serializable2 = this.deadPool_;
                            synchronized (serializable2) {
                                this.deadPool_.addElement(aS400JDBCPooledConnection);
                            }
                            if (this.poolListeners_ == null) continue;
                            serializable2 = new ConnectionPoolEvent(aS400JDBCPooledConnection, 4);
                            this.poolListeners_.fireConnectionExpiredEvent((ConnectionPoolEvent)serializable2);
                            continue;
                        }
                        if (this.getMaxUseTime() <= 0L || aS400JDBCPooledConnection.getInUseTime() <= this.getMaxUseTime()) continue;
                        if (bl) {
                            JDTrace.logInformation(this, "Returning active connection to the pool.");
                        }
                        aS400JDBCPooledConnection.returned();
                        this.availablePool_.add(aS400JDBCPooledConnection);
                        object[i].remove();
                        if (this.poolListeners_ == null) continue;
                        serializable2 = new ConnectionPoolEvent(aS400JDBCPooledConnection, 4);
                        this.poolListeners_.fireConnectionExpiredEvent((ConnectionPoolEvent)serializable2);
                    }
                }
            }
        }
        serializable = this.deadPool_;
        synchronized (serializable) {
            object2 = this.deadPool_.iterator();
            while (object2.hasNext()) {
                object = (AS400JDBCPooledConnection)object2.next();
                if (bl) {
                    JDTrace.logInformation(this, object.toString());
                }
                if (bl) {
                    JDTrace.logInformation(this, "Removing dead connection from the pool.");
                }
                this.closePooledConnection((AS400JDBCPooledConnection)object);
                object2.remove();
            }
        }
        if (this.poolListeners_ != null) {
            serializable = new ConnectionPoolEvent(this, 5);
            this.poolListeners_.fireMaintenanceThreadRun((ConnectionPoolEvent)serializable);
        }
        serializable = this.availablePool_;
        synchronized (serializable) {
            object2 = this.activePool_;
            synchronized (object2) {
                if (this.activePool_.isEmpty() && this.availablePool_.isEmpty()) {
                    if (this.maintenance_ != null) {
                        this.maintenance_.setRunning(false);
                    }
                    this.setInUse(false);
                }
            }
        }
        if (!this.isThreadUsed()) {
            this.lastSingleThreadRun_ = System.currentTimeMillis();
        }
        if (bl) {
            JDTrace.logInformation(this, "ConnectionPool cleanup finished.");
            JDTrace.logInformation(this, "   Idle Connections: " + this.availablePool_.size());
            JDTrace.logInformation(this, "   Active Connections: " + this.activePool_.size());
            JDTrace.logInformation(this, "   Dead Connections: " + this.deadPool_.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Closing the JDBC connection pool.");
            JDTrace.logInformation(this, "Available: " + this.availablePool_.size());
            JDTrace.logInformation(this, "Active: " + this.activePool_.size());
        }
        Serializable serializable = this.availablePool_;
        synchronized (serializable) {
            Vector vector = this.activePool_;
            synchronized (vector) {
                Vector vector2 = this.deadPool_;
                synchronized (vector2) {
                    Iterator[] iteratorArray = new Iterator[]{this.availablePool_.iterator(), this.activePool_.iterator(), this.deadPool_.iterator()};
                    for (int i = 0; i < iteratorArray.length; ++i) {
                        while (iteratorArray[i].hasNext()) {
                            AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)iteratorArray[i].next();
                            this.closePooledConnection(aS400JDBCPooledConnection);
                            iteratorArray[i].remove();
                        }
                    }
                }
            }
        }
        if (this.maintenance_ != null && this.maintenance_.isAlive()) {
            this.maintenance_.shutdown();
        }
        serializable = this;
        synchronized (serializable) {
            if (this.isInUse()) {
                this.setInUse(false);
            }
        }
        if (this.poolListeners_ != null) {
            serializable = new ConnectionPoolEvent(this, 0);
            this.poolListeners_.fireClosedEvent((ConnectionPoolEvent)serializable);
        }
        this.closed_ = true;
    }

    void closePooledConnection(AS400JDBCPooledConnection aS400JDBCPooledConnection) {
        try {
            aS400JDBCPooledConnection.close();
        }
        catch (SQLException sQLException) {
            JDTrace.logInformation(this, sQLException.getMessage());
        }
    }

    private AS400JDBCPooledConnection createPooledConnection() throws SQLException {
        if (this.dataSource_ == null) {
            throw new ExtendedIllegalStateException("dataSource", 4);
        }
        AS400JDBCPooledConnection aS400JDBCPooledConnection = new AS400JDBCPooledConnection(this.dataSource_.getConnection());
        aS400JDBCPooledConnection.addConnectionEventListener(this.eventListener_);
        this.dataSource_.log("PooledConnection created");
        return aS400JDBCPooledConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(int n) throws ConnectionPoolException {
        Serializable serializable;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Filling the pool with " + n + " connections.");
        }
        if (n < 1) {
            throw new ExtendedIllegalArgumentException("numberOfConnections", 4);
        }
        int n2 = this.getMaxConnections();
        if (n2 != -1 && n + this.getActiveConnectionCount() + this.getAvailableConnectionCount() > n2) {
            throw new ConnectionPoolException(1);
        }
        try {
            serializable = this.availablePool_;
            synchronized (serializable) {
                for (int i = 0; i < n; ++i) {
                    AS400JDBCPooledConnection aS400JDBCPooledConnection = this.createPooledConnection();
                    this.availablePool_.addElement(aS400JDBCPooledConnection);
                    if (this.poolListeners_ == null) continue;
                    ConnectionPoolEvent connectionPoolEvent = new ConnectionPoolEvent(aS400JDBCPooledConnection, 1);
                    this.poolListeners_.fireConnectionCreatedEvent(connectionPoolEvent);
                }
            }
        }
        catch (SQLException sQLException) {
            if (this.isRunMaintenance() && this.maintenance_ != null) {
                this.cleanupConnections();
            }
            throw new ConnectionPoolException(sQLException);
        }
        serializable = this;
        synchronized (serializable) {
            if (!this.isInUse()) {
                this.setInUse(true);
                if (this.isClosed()) {
                    this.closed_ = false;
                }
            }
        }
        if (this.isRunMaintenance() && this.isThreadUsed()) {
            if (this.maintenance_ == null) {
                serializable = this;
                synchronized (serializable) {
                    if (this.maintenance_ == null) {
                        this.maintenance_ = new PoolMaintenance(this);
                        this.maintenance_.start();
                    }
                }
            }
            if (!this.maintenance_.isRunning()) {
                this.maintenance_.setRunning(true);
            }
        } else if (this.isRunMaintenance() && !this.isThreadUsed()) {
            this.lastSingleThreadRun_ = System.currentTimeMillis();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    public int getActiveConnectionCount() {
        return this.activePool_.size();
    }

    public int getAvailableConnectionCount() {
        return this.availablePool_.size();
    }

    public Connection getConnection() throws ConnectionPoolException {
        AS400JDBCPooledConnection aS400JDBCPooledConnection = this.getPooledConnection();
        Connection connection = null;
        try {
            connection = aS400JDBCPooledConnection.getConnection();
        }
        catch (SQLException sQLException) {
            throw new ConnectionPoolException(sQLException);
        }
        return connection;
    }

    public AS400JDBCConnectionPoolDataSource getDataSource() {
        return this.dataSource_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AS400JDBCPooledConnection getPooledConnection() throws ConnectionPoolException {
        Serializable serializable;
        AS400JDBCPooledConnection aS400JDBCPooledConnection = null;
        int n = Math.max(this.getMaxConnections(), 1 + this.availablePool_.size());
        int n2 = 0;
        while (aS400JDBCPooledConnection == null && ++n2 <= n) {
            block16: {
                serializable = this.availablePool_;
                synchronized (serializable) {
                    if (this.availablePool_.isEmpty()) {
                        this.fill(1);
                    }
                    aS400JDBCPooledConnection = (AS400JDBCPooledConnection)this.availablePool_.lastElement();
                    this.availablePool_.removeElement(aS400JDBCPooledConnection);
                }
                try {
                    if (!this.isPretestConnections() || aS400JDBCPooledConnection.isConnectionAlive()) break block16;
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Connection failed a pretest.");
                    }
                    serializable = this.deadPool_;
                    synchronized (serializable) {
                        this.deadPool_.addElement(aS400JDBCPooledConnection);
                    }
                    aS400JDBCPooledConnection = null;
                }
                catch (SQLException sQLException) {
                    throw new ConnectionPoolException(sQLException);
                }
            }
            if (aS400JDBCPooledConnection == null) continue;
            serializable = this.activePool_;
            synchronized (serializable) {
                this.activePool_.addElement(aS400JDBCPooledConnection);
            }
        }
        if (aS400JDBCPooledConnection == null) {
            JDTrace.logInformation(this, "Exceeded maximum attempts to get a valid connection: " + n2);
            throw new ConnectionPoolException(2);
        }
        if (this.poolListeners_ != null) {
            serializable = new ConnectionPoolEvent(aS400JDBCPooledConnection, 2);
            this.poolListeners_.fireConnectionReleasedEvent((ConnectionPoolEvent)serializable);
        }
        return aS400JDBCPooledConnection;
    }

    private void initializeTransient() {
        this.eventListener_ = new PoolConnectionEventListener(this);
        this.activePool_ = new Vector();
        this.availablePool_ = new Vector();
        this.deadPool_ = new Vector();
        this.closed_ = true;
    }

    public boolean isClosed() {
        return this.closed_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduceConnectionCount() {
        Object object;
        Vector vector = this.availablePool_;
        synchronized (vector) {
            object = this.activePool_;
            synchronized (object) {
                int n = this.availablePool_.size() + this.activePool_.size();
                int n2 = this.getMaxConnections();
                if (n > n2) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Reducing number of connections... Current: " + n + "(" + this.availablePool_.size() + ") " + " Max: " + n2);
                    }
                    int n3 = n - n2;
                    for (int i = 0; i < n3 && this.availablePool_.size() != 0; ++i) {
                        AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)this.availablePool_.remove(0);
                        Vector vector2 = this.deadPool_;
                        synchronized (vector2) {
                            this.deadPool_.addElement(aS400JDBCPooledConnection);
                            continue;
                        }
                    }
                }
            }
        }
        vector = this.deadPool_;
        synchronized (vector) {
            object = this.deadPool_.iterator();
            while (object.hasNext()) {
                AS400JDBCPooledConnection aS400JDBCPooledConnection = (AS400JDBCPooledConnection)object.next();
                this.closePooledConnection(aS400JDBCPooledConnection);
                object.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runMaintenance(boolean bl) {
        if (this.maintenance_ != null && this.maintenance_.isRunning()) {
            PoolMaintenance poolMaintenance = this.maintenance_;
            synchronized (poolMaintenance) {
                if (bl) {
                    this.reduceConnectionCount();
                }
                this.maintenance_.notify();
            }
        }
    }

    public void setDataSource(AS400JDBCConnectionPoolDataSource aS400JDBCConnectionPoolDataSource) throws PropertyVetoException {
        String string = "dataSource";
        if (aS400JDBCConnectionPoolDataSource == null) {
            throw new NullPointerException(string);
        }
        if (this.isInUse()) {
            JDTrace.logInformation(this, "Connection pool data source is already in use.");
            throw new ExtendedIllegalStateException(string, 5);
        }
        AS400JDBCConnectionPoolDataSource aS400JDBCConnectionPoolDataSource2 = this.dataSource_;
        this.dataSource_ = aS400JDBCConnectionPoolDataSource;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, aS400JDBCConnectionPoolDataSource2, aS400JDBCConnectionPoolDataSource);
        }
    }
}

