/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConvTableDoubleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private char[] toUnicode_ = null;
    protected char[] fromUnicode_ = null;
    char[][] toUnicodeSurrogate_ = null;
    char[][] toUnicodeTriple_ = null;
    char[][] toUnicodeQuad_ = null;
    public static final int LEADING_SURROGATE_BASE = 55296;
    public static final int TRAILING_SURROGATE_BASE = 56320;
    public static final int FROM_UNICODE_SURROGATE_DIMENSION_LENGTH = 1024;
    char[][] fromUnicodeSurrogate_ = null;
    char[][][] fromUnicodeTriple_ = null;
    int firstTripleMin_;
    int secondTripleMin_;
    int thirdTripleMin_;
    char[][][][] fromUnicodeQuad_ = null;
    int firstQuadMin_;
    int secondQuadMin_;
    int thirdQuadMin_;
    int fourthQuadMin_;
    char[] combiningCharacters_;
    char[][] combiningCombinations_;

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2, char[][] cArray3, char[][] cArray4) {
        this(n, cArray, cArray2, cArray3, cArray4, null);
    }

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2, char[][] cArray3, char[][] cArray4, char[][] cArray5) {
        this(n, cArray, cArray2);
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        char c;
        int n7;
        this.toUnicodeSurrogate_ = new char[65535][];
        this.fromUnicodeSurrogate_ = new char[1024][];
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        Hashtable<Integer, char[]> hashtable = new Hashtable<Integer, char[]>();
        for (n7 = 0; n7 < cArray3.length; ++n7) {
            char[] cArray6;
            c = cArray3[n7][0];
            char c2 = cArray3[n7][1];
            char c3 = cArray3[n7][2];
            char[] cArray7 = new char[]{c2, c3};
            this.toUnicodeSurrogate_[0xFFFF & c] = cArray7;
            n6 = c2 - 55296;
            n5 = c3 - 56320;
            if (n6 >= 0 && n6 < 1024) {
                if (this.fromUnicodeSurrogate_[n6] == null) {
                    this.fromUnicodeSurrogate_[n6] = new char[1024];
                }
                cArray6 = this.fromUnicodeSurrogate_[n6];
                if (n5 < 0 || n5 >= 1024) continue;
                cArray6[n5] = c;
                continue;
            }
            cArray6 = new char[]{c2, c3, c};
            arrayList.add(cArray6);
            hashtable.put(new Integer(c3), cArray7);
        }
        n7 = hashtable.size();
        this.combiningCharacters_ = new char[n7];
        c = '\u0000';
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n8 = (Integer)enumeration.nextElement();
            this.combiningCharacters_[c] = (char)n8.intValue();
            ++c;
        }
        int n9 = arrayList.size();
        this.combiningCombinations_ = new char[n9][];
        for (c = '\u0000'; c < n9; ++c) {
            this.combiningCombinations_[c] = (char[])arrayList.get(c);
        }
        if (cArray4 != null) {
            int n10;
            char[] cArray8;
            int n11;
            this.firstTripleMin_ = 65535;
            this.secondTripleMin_ = 65535;
            this.thirdTripleMin_ = 65535;
            int n12 = 0;
            n6 = 0;
            n5 = 0;
            for (n11 = 0; n11 < cArray4.length; ++n11) {
                cArray8 = cArray4[n11];
                n10 = 0xFFFF & cArray8[1];
                n4 = 0xFFFF & cArray8[2];
                n3 = 0xFFFF & cArray8[3];
                if (n10 < this.firstTripleMin_) {
                    this.firstTripleMin_ = n10;
                }
                if (n10 > n12) {
                    n12 = n10;
                }
                if (n4 < this.secondTripleMin_) {
                    this.secondTripleMin_ = n4;
                }
                if (n4 > n6) {
                    n6 = n4;
                }
                if (n3 < this.thirdTripleMin_) {
                    this.thirdTripleMin_ = n3;
                }
                if (n3 <= n5) continue;
                n5 = n3;
            }
            this.fromUnicodeTriple_ = new char[n12 - this.firstTripleMin_ + 1][][];
            this.toUnicodeTriple_ = new char[65535][];
            for (n11 = 0; n11 < cArray4.length; ++n11) {
                char[] cArray9;
                cArray8 = cArray4[n11];
                n10 = 0xFFFF & cArray8[0];
                n4 = (0xFFFF & cArray8[1]) - this.firstTripleMin_;
                n3 = (0xFFFF & cArray8[2]) - this.secondTripleMin_;
                n2 = (0xFFFF & cArray8[3]) - this.thirdTripleMin_;
                this.toUnicodeTriple_[n10] = new char[3];
                this.toUnicodeTriple_[n10][0] = cArray8[1];
                this.toUnicodeTriple_[n10][1] = cArray8[2];
                this.toUnicodeTriple_[n10][2] = cArray8[3];
                Object object = this.fromUnicodeTriple_[n4];
                if (object == null) {
                    object = new char[n6 - this.secondTripleMin_ + 1][];
                    this.fromUnicodeTriple_[n4] = object;
                }
                if ((cArray9 = object[n3]) == null) {
                    cArray9 = new char[n5 - this.thirdTripleMin_ + 1];
                    object[n3] = cArray9;
                }
                cArray9[n2] = (char)n10;
            }
        }
        if (cArray5 != null) {
            int n13;
            this.firstQuadMin_ = 65535;
            this.secondQuadMin_ = 65535;
            this.thirdQuadMin_ = 65535;
            this.fourthQuadMin_ = 65535;
            int n14 = 0;
            n6 = 0;
            n5 = 0;
            int n15 = 0;
            for (n13 = 0; n13 < cArray5.length; ++n13) {
                char[] cArray10 = cArray5[n13];
                n4 = 0xFFFF & cArray10[1];
                n3 = 0xFFFF & cArray10[2];
                n2 = 0xFFFF & cArray10[3];
                int n16 = 0xFFFF & cArray10[4];
                if (n4 < this.firstQuadMin_) {
                    this.firstQuadMin_ = n4;
                }
                if (n4 > n14) {
                    n14 = n4;
                }
                if (n3 < this.secondQuadMin_) {
                    this.secondQuadMin_ = n3;
                }
                if (n3 > n6) {
                    n6 = n3;
                }
                if (n2 < this.thirdQuadMin_) {
                    this.thirdQuadMin_ = n2;
                }
                if (n2 > n5) {
                    n5 = n2;
                }
                if (n16 < this.fourthQuadMin_) {
                    this.fourthQuadMin_ = n16;
                }
                if (n16 <= n15) continue;
                n15 = n16;
            }
            this.fromUnicodeQuad_ = new char[n14 - this.firstQuadMin_ + 1][][][];
            this.toUnicodeQuad_ = new char[65535][];
            for (n13 = 0; n13 < cArray5.length; ++n13) {
                char[] cArray11;
                Object object;
                char[] cArray12 = cArray5[n13];
                n4 = 0xFFFF & cArray12[0];
                n3 = (0xFFFF & cArray12[1]) - this.firstQuadMin_;
                n2 = (0xFFFF & cArray12[2]) - this.secondQuadMin_;
                int n17 = (0xFFFF & cArray12[3]) - this.thirdQuadMin_;
                int n18 = (0xFFFF & cArray12[4]) - this.fourthQuadMin_;
                this.toUnicodeQuad_[n4] = new char[4];
                this.toUnicodeQuad_[n4][0] = cArray12[1];
                this.toUnicodeQuad_[n4][1] = cArray12[2];
                this.toUnicodeQuad_[n4][2] = cArray12[3];
                this.toUnicodeQuad_[n4][3] = cArray12[4];
                Object object2 = this.fromUnicodeQuad_[n3];
                if (object2 == null) {
                    object2 = new char[n6 - this.secondQuadMin_ + 1][][];
                    this.fromUnicodeQuad_[n3] = object2;
                }
                if ((object = object2[n2]) == null) {
                    object = new char[n5 - this.thirdQuadMin_ + 1][];
                    object2[n2] = object;
                }
                if ((cArray11 = object[n17]) == null) {
                    cArray11 = new char[n15 - this.fourthQuadMin_ + 1];
                    object[n17] = cArray11;
                }
                cArray11[n18] = (char)n4;
            }
        }
    }

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.toUnicode_ = this.decompress(cArray);
        this.fromUnicode_ = this.decompress(cArray2);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded double-byte map for ccsid: " + this.ccsid_);
        }
    }

    ConvTableDoubleMap(ConvTableDoubleMap convTableDoubleMap) {
        super(convTableDoubleMap.ccsid_);
        this.toUnicode_ = convTableDoubleMap.toUnicode_;
        this.fromUnicode_ = convTableDoubleMap.fromUnicode_;
        this.toUnicodeSurrogate_ = convTableDoubleMap.toUnicodeSurrogate_;
        this.fromUnicodeSurrogate_ = convTableDoubleMap.fromUnicodeSurrogate_;
        this.combiningCharacters_ = convTableDoubleMap.combiningCharacters_;
        this.combiningCombinations_ = convTableDoubleMap.combiningCombinations_;
    }

    char[] decompress(char[] cArray) {
        return ConvTableDoubleMap.decompress(cArray, this.ccsid_);
    }

    static char[] decompress(char[] cArray, int n) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing double-byte conversion table for ccsid: " + n, cArray.length);
        }
        char[] cArray2 = new char[65536];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n3;
            int n4;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                long l = (0xFFFF & cArray[i + 1]) + (0xFFFF & n2);
                n4 = cArray[i + 2];
                while ((long)n2 < l) {
                    cArray2[n2++] = n4;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                int n5 = 0xFFFF & cArray[i + 2];
                n3 = 0xFFFF & cArray[i + 1];
                for (n4 = n5; n4 < n3 + n5; ++n4) {
                    cArray2[n2++] = (char)n4;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                int n6 = 0xFFFF & cArray[++i];
                n3 = cArray[++i];
                n4 = (char)(0xFF00 & n3);
                cArray2[n2++] = n3;
                ++i;
                for (int j = 0; j < n6; ++j) {
                    char c = cArray[i + j];
                    cArray2[n2++] = (char)(n4 + ((0xFF00 & c) >>> 8));
                    cArray2[n2++] = (char)(n4 + (0xFF & c));
                }
                i = i + n6 - 1;
                continue;
            }
            cArray2[n2++] = cArray[i];
        }
        return cArray2;
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            try {
                int n4 = ((0xFF & byArray[i * 2 + n]) << 8) + (0xFF & byArray[i * 2 + 1 + n]);
                int n5 = this.toUnicode(cArray, n3, n4);
                n3 += n5;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw arrayIndexOutOfBoundsException;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public int toUnicode(char[] cArray, int n, int n2) {
        int n3 = 0;
        cArray[n] = this.toUnicode_[n2];
        if (cArray[n] == '\ud800') {
            if (this.toUnicodeSurrogate_ != null) {
                char[] cArray2 = this.toUnicodeSurrogate_[n2];
                if (cArray2 != null) {
                    cArray[n] = cArray2[0];
                    ++n3;
                    cArray[++n] = cArray2[1];
                    ++n;
                    ++n3;
                } else {
                    cArray[n] = 65533;
                    ++n;
                    ++n3;
                }
            } else {
                cArray[n] = 65533;
                ++n;
                ++n3;
            }
        } else if (cArray[n] == '\ud801') {
            if (this.toUnicodeTriple_ != null) {
                char[] cArray3 = this.toUnicodeTriple_[n2];
                if (cArray3 != null) {
                    cArray[n] = cArray3[0];
                    ++n3;
                    cArray[++n] = cArray3[1];
                    ++n3;
                    cArray[++n] = cArray3[2];
                    ++n;
                    ++n3;
                } else if (this.ccsid_ != 61952) {
                    cArray[n] = 65533;
                    ++n;
                    ++n3;
                }
            } else {
                cArray[n] = 65533;
                ++n;
                ++n3;
            }
        } else if (cArray[n] == '\ud802') {
            if (this.toUnicodeQuad_ != null) {
                char[] cArray4 = this.toUnicodeQuad_[n2];
                if (cArray4 != null) {
                    cArray[n] = cArray4[0];
                    ++n3;
                    cArray[++n] = cArray4[1];
                    ++n3;
                    cArray[++n] = cArray4[2];
                    ++n3;
                    cArray[++n] = cArray4[3];
                    ++n;
                    ++n3;
                } else {
                    cArray[n] = 65533;
                    ++n;
                    ++n3;
                }
            } else {
                cArray[n] = 65533;
                ++n;
                ++n3;
            }
        } else {
            ++n;
            ++n3;
        }
        return n3;
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int[] nArray = new int[1];
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = this.fromUnicode(cArray, n2, nArray);
            byArray[n * 2] = (byte)(c >>> 8);
            byArray[n * 2 + 1] = (byte)(0xFF & c);
            if (nArray[0] > 1) {
                ++n2;
            }
            ++n2;
            ++n;
        }
        if (n * 2 != byArray.length) {
            byte[] byArray2 = new byte[n * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n * 2);
            byArray = byArray2;
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }

    public char fromUnicode(char[] cArray, int n, int[] nArray) {
        int n2;
        char c;
        int n3;
        Object object;
        int n4;
        int n5 = 1;
        int n6 = 0;
        char c2 = cArray[n];
        boolean bl = false;
        if (this.fromUnicodeQuad_ != null && n + 3 < cArray.length && (n4 = (0xFFFF & cArray[n]) - this.firstQuadMin_) >= 0 && n4 < this.fromUnicodeQuad_.length && (object = (Object)this.fromUnicodeQuad_[n4]) != null && (n3 = (0xFFFF & cArray[n + 1]) - this.secondQuadMin_) >= 0 && n3 < ((char[])object).length) {
            c = object[n3];
            n2 = (0xFFFF & cArray[n + 2]) - this.thirdQuadMin_;
            if (n2 >= 0 && n2 < ((char)c).length) {
                void var13_15 = c[n2];
                int n7 = (0xFFFF & cArray[n + 3]) - this.fourthQuadMin_;
                if (n7 >= 0 && n7 < ((void)var13_15).length && (n6 = var13_15[n7]) != 0) {
                    bl = true;
                    n5 += 3;
                }
            }
        }
        if (!bl && this.fromUnicodeTriple_ != null && n + 2 < cArray.length && (n4 = (0xFFFF & cArray[n]) - this.firstTripleMin_) >= 0 && n4 < this.fromUnicodeTriple_.length && (object = (Object)this.fromUnicodeTriple_[n4]) != null && (n3 = (0xFFFF & cArray[n + 1]) - this.secondTripleMin_) >= 0 && n3 < ((char[])object).length) {
            c = object[n3];
            n2 = (0xFFFF & cArray[n + 2]) - this.thirdTripleMin_;
            if (n2 >= 0 && n2 < ((char)c).length && (n6 = c[n2]) != 0) {
                bl = true;
                n5 += 2;
            }
        }
        if (!bl) {
            if (c2 < '\ud800' || c2 >= '\udc00') {
                n4 = n + 1;
                if (this.combiningCharacters_ != null && n4 < cArray.length) {
                    char c3 = cArray[n4];
                    for (n3 = 0; !bl && n3 < this.combiningCharacters_.length; ++n3) {
                        if (c3 != this.combiningCharacters_[n3]) continue;
                        for (int i = 0; !bl && i < this.combiningCombinations_.length; ++i) {
                            if (c2 != this.combiningCombinations_[i][0] || c3 != this.combiningCombinations_[i][1]) continue;
                            bl = true;
                            n6 = this.combiningCombinations_[i][2];
                            ++n;
                            ++n5;
                        }
                    }
                }
                if (!bl) {
                    n6 = this.fromUnicode_[cArray[n]];
                }
            } else {
                n4 = cArray[n] - 55296;
                ++n5;
                n6 = this.fromUnicodeSurrogate_ != null ? ((object = this.fromUnicodeSurrogate_[n4]) != null ? ((n3 = cArray[++n] - 56320) >= 0 && n3 < 1024 && object[n3] != '\u0000' ? object[n3] : 65278) : 65278) : 65278;
            }
        }
        nArray[0] = n5;
        return (char)n6;
    }

    public char[] getFromUnicode() {
        return this.fromUnicode_;
    }

    void setFromUnicode(char[] cArray) {
        this.fromUnicode_ = cArray;
    }

    public char[] getToUnicode() {
        return this.toUnicode_;
    }

    void setToUnicode(char[] cArray) {
        this.toUnicode_ = cArray;
    }
}

