/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.UserPermission;

public class DLOPermission
extends UserPermission {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;

    public DLOPermission(String string) {
        super(string);
        this.dataAuthority_ = "*EXCLUDE";
    }

    public String getDataAuthority() {
        if (this.isFromAuthorizationList()) {
            return "*AUTL";
        }
        this.parseBasic();
        switch (this.objectAuthority_) {
            case 0: {
                return "*ALL";
            }
            case 1: {
                return "*EXCLUDE";
            }
            case 2: {
                return "*USE";
            }
            case 3: {
                return "*CHANGE";
            }
            case -1: {
                return "USER DEFINED";
            }
        }
        return "USER DEFINED";
    }

    private synchronized void parseBasic() {
        for (int i = 0; i < 4; ++i) {
            boolean bl = true;
            for (int j = 0; j < 10; ++j) {
                if (this.authorities_[j] == basicAutMapping[i][j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.objectAuthority_ = i;
            return;
        }
        this.objectAuthority_ = -1;
    }

    synchronized void setAdd(boolean bl) {
        this.changeAuthority();
        this.authorities_[6] = bl;
    }

    synchronized void setAlter(boolean bl) {
        this.changeAuthority();
        this.authorities_[3] = bl;
    }

    public synchronized void setDataAuthority(String string) {
        if (string == null) {
            throw new NullPointerException("authority");
        }
        String string2 = string.trim().toUpperCase();
        this.changeAuthority();
        if (this.getDataAuthority().equals(string2)) {
            return;
        }
        if (string2.equals("*ALL")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[0][i];
            }
            this.objectAuthority_ = 0;
        } else if (string2.equals("*EXCLUDE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[1][i];
            }
            this.objectAuthority_ = 1;
        } else if (string2.equals("*USE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[2][i];
            }
            this.objectAuthority_ = 2;
        } else if (string2.equals("*CHANGE")) {
            for (int i = 0; i < 10; ++i) {
                this.authorities_[i] = basicAutMapping[3][i];
            }
            this.objectAuthority_ = 3;
        } else if (string2.equals("*AUTL")) {
            this.setFromAuthorizationList(true);
        }
    }

    synchronized void setDelete(boolean bl) {
        this.changeAuthority();
        this.authorities_[8] = bl;
    }

    synchronized void setExecute(boolean bl) {
        this.changeAuthority();
        this.authorities_[9] = bl;
    }

    synchronized void setExistence(boolean bl) {
        this.changeAuthority();
        this.authorities_[2] = bl;
    }

    synchronized void setManagement(boolean bl) {
        this.changeAuthority();
        this.authorities_[1] = bl;
    }

    synchronized void setOperational(boolean bl) {
        this.changeAuthority();
        this.authorities_[0] = bl;
    }

    synchronized void setRead(boolean bl) {
        this.changeAuthority();
        this.authorities_[5] = bl;
    }

    synchronized void setReference(boolean bl) {
        this.changeAuthority();
        this.authorities_[4] = bl;
    }

    synchronized void setUpdate(boolean bl) {
        this.changeAuthority();
        this.authorities_[7] = bl;
    }
}

