/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.IFSDataStream;
import com.ibm.as400.access.IFSObjAttrs1;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

class IFSListAttrsRep
extends IFSDataStream {
    private static final boolean DEBUG = false;
    static final int FILE = 1;
    static final int DIRECTORY = 2;
    static final int SYMBOLIC_LINK = 3;
    static final int AS400_OBJECT = 4;
    static final int DEVICE_FIFO = 5;
    static final int DEVICE_CHAR = 6;
    static final int DEVICE_BLOCK = 7;
    static final int SOCKET = 8;
    static final int FA_READONLY = 1;
    static final int FA_HIDDEN = 2;
    static final int FA_SYSTEM = 4;
    static final int FA_DIRECTORY = 16;
    static final int FA_ARCHIVE = 32;
    static final int OA_NONE = 0;
    static final int OA1 = 1;
    static final int OA2 = 2;
    private static final int TEMPLATE_LENGTH_OFFSET = 16;
    private static final int HEADER_LENGTH = 20;
    private static final int LLCP_LENGTH = 6;
    private static final int CREATE_DATE_OFFSET = 22;
    private static final int MODIFY_DATE_OFFSET = 30;
    private static final int ACCESS_DATE_OFFSET = 38;
    private static final int FILE_SIZE_OFFSET = 46;
    private static final int FIXED_ATTRS_OFFSET = 50;
    private static final int OBJECT_TYPE_OFFSET = 54;
    private static final int NUM_EXT_ATTRS_OFFSET = 56;
    private static final int BYTES_EA_NAMES_OFFSET = 58;
    private static final int BYTES_EA_VALUES_OFFSET = 62;
    private static final int VERSION_NUMBER_OFFSET = 66;
    private static final int AMOUNT_ACCESSED_OFFSET = 70;
    private static final int ACCESS_HISTORY_OFFSET = 72;
    private static final int NAME_CCSID_OFFSET = 73;
    private static final int CHECKOUT_CCSID_OFFSET = 75;
    private static final int RESTART_ID_OFFSET = 77;
    private static final int LARGE_FILE_SIZE_OFFSET = 81;
    private static final int SYMBOLIC_LINK_OFFSET = 91;
    private static final int FILE_SYSTEM_TYPE_OFFSET = 89;
    private static final int UNINITIALIZED = -1;

    IFSListAttrsRep() {
    }

    public Object getNewDataStream() {
        return new IFSListAttrsRep();
    }

    long getAccessDate() {
        return this.getDate(38);
    }

    int getCCSID(int n) {
        return this.getObjAttrs2().getCCSID(n);
    }

    long getCreationDate() {
        return this.getDate(22);
    }

    Hashtable getExtendedAttributeValues() {
        int n;
        Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
        int n2 = n = 20 + this.get16bit(16);
        int n3 = this.get32bit(n2);
        int n4 = this.get16bit(n2 + 4);
        while (n4 != 9 && n2 + n3 + 6 <= this.data_.length) {
            n3 = this.get32bit(n2 += n3);
            n4 = this.get16bit(n2 + 4);
        }
        if (n4 != 9) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "No Extended Attributes were returned.");
            }
            return hashtable;
        }
        int n5 = n2;
        byte[] byArray = null;
        int n6 = this.get16bit(n5 + 6);
        int n7 = n5 + 8;
        for (int i = 0; i < n6; ++i) {
            int n8 = this.get16bit(n7);
            int n9 = this.get16bit(n7 + 2);
            int n10 = this.get32bit(n7 + 6);
            byte[] byArray2 = new byte[n9];
            System.arraycopy(this.data_, n7 + 10, byArray2, 0, n9);
            if (n10 > 4) {
                byArray = new byte[n10 - 4];
                System.arraycopy(this.data_, n7 + 10 + n9 + 4, byArray, 0, n10 - 4);
                try {
                    String string = CharConverter.byteArrayToString(n8, byArray2);
                    hashtable.put(string, byArray);
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Extended Attribute returned: " + string, byArray);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Trace.log(2, unsupportedEncodingException);
                }
            }
            n7 += 10 + n9 + n10;
        }
        return hashtable;
    }

    int getFixedAttributes() {
        return this.get32bit(50);
    }

    long getModificationDate() {
        return this.getDate(30);
    }

    byte[] getName() {
        int n = 20 + this.get16bit(16);
        int n2 = this.get32bit(n) - 6;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data_, 6 + n, byArray, 0, n2);
        return byArray;
    }

    IFSObjAttrs1 getObjAttrs1() {
        return new IFSObjAttrs1(this.getObjAttrBytes(1));
    }

    IFSObjAttrs2 getObjAttrs2() {
        return new IFSObjAttrs2(this.getObjAttrBytes(2));
    }

    private final byte[] getObjAttrBytes(int n) {
        if (n == 0) {
            return null;
        }
        int n2 = 20 + this.get16bit(16);
        short s = n == 1 ? (short)16 : 15;
        byte[] byArray = null;
        while (byArray == null && n2 < this.data_.length) {
            int n3 = this.get32bit(n2);
            short s2 = (short)this.get16bit(n2 + 4);
            if (s2 == s) {
                int n4 = n3 - 6;
                byArray = new byte[n4];
                System.arraycopy(this.data_, n2 + 6, byArray, 0, n4);
                continue;
            }
            n2 += n3;
        }
        if (byArray == null) {
            Trace.log(2, "The reply does not contain an OA" + n + " structure.");
            throw new InternalErrorException(6);
        }
        return byArray;
    }

    int getObjectType() {
        return this.get16bit(54);
    }

    String getOwnerName(int n) throws UnsupportedEncodingException {
        return this.getObjAttrs1().getOwnerName(n);
    }

    int getASP() throws UnsupportedEncodingException {
        return this.getObjAttrs1().getASP();
    }

    long getOwnerUID() {
        return this.getObjAttrs2().getOwnerUID();
    }

    byte[] getRestartID() {
        byte[] byArray = new byte[4];
        System.arraycopy(this.data_, 77, byArray, 0, byArray.length);
        return byArray;
    }

    long getSize(int n) {
        if (n < 8 || n == 62708) {
            int n2 = this.get32bit(46);
            return (long)n2 & 0xFFFFFFFFL;
        }
        return this.get64bit(81);
    }

    long getSize8Bytes() {
        int n;
        long l = 0L;
        int n2 = n = 20 + this.get16bit(16);
        int n3 = this.get32bit(n2);
        int n4 = this.get16bit(n2 + 4);
        while (n4 != 20 && n2 + n3 + 6 <= this.data_.length) {
            n3 = this.get32bit(n2 += n3);
            n4 = this.get16bit(n2 + 4);
        }
        if (n4 != 20) {
            Trace.log(2, "Error getting 8-byte file size: Optional field was not returned.");
            throw new InternalErrorException(6);
        }
        l = this.get64bit(n2 + 6);
        return l;
    }

    boolean isSymbolicLink(int n) {
        boolean bl = false;
        if (n < 8 || n == 62708) {
            Trace.log(4, "Could not determine whether file is a symbolic link.");
        } else {
            byte by = this.data_[91];
            switch (by) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                default: {
                    Trace.log(2, "Internal error, unexpected value in symbolic link field: ", by);
                }
            }
        }
        return bl;
    }

    public int hashCode() {
        return 32773;
    }

    int getFileSystemType(int n) {
        int n2 = -1;
        if (n < 8 || n == 62708) {
            Trace.log(4, "Could not determine the file system type, This field is only returned for data stream levels 8 and later.");
        } else {
            n2 = this.get16bit(89);
        }
        return n2;
    }
}

