/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.access.QueuedMessageEnumeration;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class JobLog
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final int maxMessageLength_ = 511;
    private static final int maxMessageHelpLength_ = 3000;
    private static final int qgygtleHeaderLength_ = 81;
    private AS400 system_;
    private String name_ = "*";
    private String user_ = "";
    private String number_ = "";
    private int length_;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private boolean listDirection_ = true;
    private byte[] startingMessageKey_;
    private Vector numberOfFieldIdentifiers_ = new Vector();
    public static final int ALERT_OPTION = 101;
    public static final int REPLACEMENT_DATA = 201;
    public static final int MESSAGE = 301;
    public static final int MESSAGE_WITH_REPLACEMENT_DATA = 302;
    public static final int MESSAGE_HELP = 401;
    public static final int MESSAGE_HELP_WITH_REPLACEMENT_DATA = 402;
    public static final int MESSAGE_HELP_WITH_FORMATTING_CHARACTERS = 403;
    public static final int MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS = 404;
    public static final int DEFAULT_REPLY = 501;
    public static final int SENDER_TYPE = 602;
    public static final int SENDING_PROGRAM_NAME = 603;
    public static final int SENDING_MODULE_NAME = 604;
    public static final int SENDING_PROCEDURE_NAME = 605;
    public static final int SENDING_STATEMENT_NUMBERS = 606;
    public static final int SENDING_USER_PROFILE = 607;
    public static final int RECEIVING_TYPE = 702;
    public static final int RECEIVING_PROGRAM_NAME = 703;
    public static final int RECEIVING_MODULE_NAME = 704;
    public static final int RECEIVING_PROCEDURE_NAME = 705;
    public static final int RECEIVING_STATEMENT_NUMBERS = 706;
    public static final int MESSAGE_FILE_LIBRARY_USED = 801;
    public static final int REPLY_STATUS = 1001;
    public static final int REQUEST_STATUS = 1101;
    public static final int REQUEST_LEVEL = 1201;
    public static final int CCSID_FOR_TEXT = 1301;
    public static final int CCSID_CONVERSION_STATUS_TEXT = 1302;
    public static final int CCSID_FOR_DATA = 1303;
    public static final int CCSID_CONVERSION_STATUS_DATA = 1304;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;
    private static final byte[] typeCompletion_ = new byte[]{92, -61, -42, -44, -41, 64, 64, 64, 64, 64};
    private static final byte[] typeDiagnostic_ = new byte[]{92, -60, -55, -63, -57, 64, 64, 64, 64, 64};
    private static final byte[] typeEscape_ = new byte[]{92, -59, -30, -61, -63, -41, -59, 64, 64, 64};
    private static final byte[] typeInformational_ = new byte[]{92, -55, -43, -58, -42, 64, 64, 64, 64, 64};
    private static final byte[] callStackEntry_ = new byte[]{92, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    public JobLog() {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding default list information: REPLY_STATUS, SENDING_PROGRAM_NAME, DEFAULT_REPLY, MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS, MESSAGE_WITH_REPLACEMENT_DATA, ALERT_OPTION ");
        }
        this.addDefaultListInformation();
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobLog object.");
        }
    }

    public JobLog(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobLog object, system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Adding default list information: REPLY_STATUS, SENDING_PROGRAM_NAME, DEFAULT_REPLY, MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS, MESSAGE_WITH_REPLACEMENT_DATA, ALERT_OPTION ");
        }
        this.addDefaultListInformation();
        this.system_ = aS400;
    }

    public JobLog(AS400 aS400, String string, String string2, String string3) {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing JobLog object, system: " + aS400 + ", name: " + string + ", user: " + string2 + ", number: " + string3);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (string3 == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Adding default list information: REPLY_STATUS, SENDING_PROGRAM_NAME, DEFAULT_REPLY, MESSAGE_HELP_WITH_REPLACEMENT_DATA_AND_FORMATTING_CHARACTERS, MESSAGE_WITH_REPLACEMENT_DATA, ALERT_OPTION ");
        }
        this.addDefaultListInformation();
        this.system_ = aS400;
        this.name_ = string;
        this.user_ = string2;
        this.number_ = string3;
    }

    public void addAttributeToRetrieve(int n) throws IOException {
        if (!this.numberOfFieldIdentifiers_.contains(new Integer(n))) {
            switch (n) {
                case 1001: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1001));
                    break;
                }
                case 603: {
                    this.numberOfFieldIdentifiers_.add(new Integer(603));
                    break;
                }
                case 501: {
                    this.numberOfFieldIdentifiers_.add(new Integer(501));
                    break;
                }
                case 404: {
                    this.numberOfFieldIdentifiers_.add(new Integer(404));
                    break;
                }
                case 302: {
                    this.numberOfFieldIdentifiers_.add(new Integer(302));
                    break;
                }
                case 101: {
                    this.numberOfFieldIdentifiers_.add(new Integer(101));
                    break;
                }
                case 201: {
                    this.numberOfFieldIdentifiers_.add(new Integer(201));
                    break;
                }
                case 301: {
                    this.numberOfFieldIdentifiers_.add(new Integer(301));
                    break;
                }
                case 401: {
                    this.numberOfFieldIdentifiers_.add(new Integer(401));
                    break;
                }
                case 402: {
                    this.numberOfFieldIdentifiers_.add(new Integer(402));
                    break;
                }
                case 403: {
                    this.numberOfFieldIdentifiers_.add(new Integer(403));
                    break;
                }
                case 602: {
                    this.numberOfFieldIdentifiers_.add(new Integer(602));
                    break;
                }
                case 604: {
                    this.numberOfFieldIdentifiers_.add(new Integer(604));
                    break;
                }
                case 605: {
                    this.numberOfFieldIdentifiers_.add(new Integer(605));
                    break;
                }
                case 606: {
                    this.numberOfFieldIdentifiers_.add(new Integer(606));
                    break;
                }
                case 607: {
                    this.numberOfFieldIdentifiers_.add(new Integer(607));
                    break;
                }
                case 702: {
                    this.numberOfFieldIdentifiers_.add(new Integer(702));
                    break;
                }
                case 703: {
                    this.numberOfFieldIdentifiers_.add(new Integer(703));
                    break;
                }
                case 704: {
                    this.numberOfFieldIdentifiers_.add(new Integer(704));
                    break;
                }
                case 705: {
                    this.numberOfFieldIdentifiers_.add(new Integer(705));
                    break;
                }
                case 706: {
                    this.numberOfFieldIdentifiers_.add(new Integer(706));
                    break;
                }
                case 801: {
                    this.numberOfFieldIdentifiers_.add(new Integer(801));
                    break;
                }
                case 1101: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1101));
                    break;
                }
                case 1201: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1201));
                    break;
                }
                case 1301: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1301));
                    break;
                }
                case 1302: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1302));
                    break;
                }
                case 1303: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1303));
                    break;
                }
                case 1304: {
                    this.numberOfFieldIdentifiers_.add(new Integer(1304));
                    break;
                }
                default: {
                    Trace.log(2, "Value of parameter 'attribute' is not valid: " + n);
                    throw new ExtendedIllegalArgumentException("attribute", 2);
                }
            }
        }
    }

    public void clearAttributesToRetrieve() {
        this.numberOfFieldIdentifiers_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Closing job log message list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    public int getLength() {
        block5: {
            if (Trace.traceOn_) {
                Trace.log(1, "Getting job log list length.");
            }
            try {
                if (this.handle_ == null || this.closeHandle_) {
                    this.load();
                }
            }
            catch (Exception exception) {
                Trace.log(2, "Exception caught getting length of job log list:", (Throwable)exception);
                if (!(exception instanceof ExtendedIllegalStateException)) break block5;
                throw (ExtendedIllegalStateException)exception;
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public boolean getListDirection() {
        return this.listDirection_;
    }

    public Enumeration getMessages() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job log message list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        return new QueuedMessageEnumeration(this, this.length_);
    }

    public QueuedMessage[] getMessages(int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Retrieving job log message list, list offset: " + n + ", number:", n2);
        }
        if (n < -1) {
            throw new ExtendedIllegalArgumentException("listOffset (" + n + ")", 4);
        }
        if (n2 < 0 && n != -1) {
            throw new ExtendedIllegalArgumentException("number (" + n2 + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.load();
        }
        if (this.length_ == 0 || n2 == 0 && n != -1) {
            return new QueuedMessage[0];
        }
        if (n == -1) {
            n2 = this.length_;
            n = 0;
        } else {
            if (n >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", n + " (list length: " + this.length_ + ")");
                }
                return new QueuedMessage[0];
            }
            if (n + n2 > this.length_) {
                n2 = this.length_ - n;
            }
        }
        int n3 = 1024 * n2;
        byte[] byArray = ListUtilities.retrieveListEntries(this.system_, this.handle_, n3, n2, n, null);
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        QueuedMessage[] queuedMessageArray = new QueuedMessage[n2];
        int n4 = 0;
        for (int i = 0; i < queuedMessageArray.length; ++i) {
            int n5 = BinaryConverter.byteArrayToInt(byArray, n4);
            int n6 = BinaryConverter.byteArrayToInt(byArray, n4 + 4);
            int n7 = BinaryConverter.byteArrayToInt(byArray, n4 + 8);
            int n8 = BinaryConverter.byteArrayToInt(byArray, n4 + 12);
            String string = converter.byteArrayToString(byArray, n4 + 16, 7).trim();
            int n9 = (byArray[n4 + 23] & 0xF) * 10 + (byArray[n4 + 24] & 0xF);
            if (n9 == 0) {
                n9 = -1;
            }
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, n4 + 25, byArray2, 0, 4);
            String string2 = converter.byteArrayToString(byArray, n4 + 29, 10).trim();
            String string3 = converter.byteArrayToString(byArray, n4 + 39, 10).trim();
            String string4 = converter.byteArrayToString(byArray, n4 + 49, 7);
            String string5 = converter.byteArrayToString(byArray, n4 + 56, 6);
            queuedMessageArray[i] = new QueuedMessage(this.system_, n8, string, n9, byArray2, string2, string3, string4, string5);
            for (int j = 0; j < n7; ++j) {
                int n10 = BinaryConverter.byteArrayToInt(byArray, n6);
                int n11 = BinaryConverter.byteArrayToInt(byArray, n6 + 8);
                byte by = byArray[n6 + 12];
                int n12 = BinaryConverter.byteArrayToInt(byArray, n6 + 28);
                if (by == -61) {
                    if (n11 == 201) {
                        byte[] byArray3 = new byte[n12];
                        System.arraycopy(byArray, n6 + 32, byArray3, 0, n12);
                        queuedMessageArray[i].setValueInternal(n11, byArray3);
                    } else {
                        queuedMessageArray[i].setValueInternal(n11, converter.byteArrayToString(byArray, n6 + 32, n12));
                    }
                } else if (by == -62) {
                    if (n12 > 4) {
                        queuedMessageArray[i].setAsLong(n11, BinaryConverter.byteArrayToLong(byArray, n6 + 32));
                    } else {
                        queuedMessageArray[i].setAsInt(n11, BinaryConverter.byteArrayToInt(byArray, n6 + 32));
                    }
                } else {
                    int n13 = BinaryConverter.byteArrayToInt(byArray, n6 + 32);
                    String[] stringArray = new String[n13];
                    for (int k = 0; k < n13; ++k) {
                        stringArray[k] = converter.byteArrayToString(byArray, n6 + 36 + k * 10, 10);
                    }
                    queuedMessageArray[i].setValueInternal(n11, stringArray);
                }
                n6 = n10;
            }
            n4 = n5;
        }
        return queuedMessageArray;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting name: " + this.name_);
        }
        return this.name_;
    }

    public String getNumber() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting number: " + this.number_);
        }
        return this.number_;
    }

    public byte[] getStartingMessageKey() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting starting message key:", this.startingMessageKey_);
        }
        return this.startingMessageKey_;
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String getUser() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting user: " + this.user_);
        }
        return this.user_;
    }

    public synchronized void load() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Loading job log message list.");
        }
        if (this.system_ == null) {
            Trace.log(2, "Cannot connect to server before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (!this.name_.equals("*")) {
            if (this.user_.equals("")) {
                Trace.log(2, "Cannot connect to server before setting user.");
                throw new ExtendedIllegalStateException("user", 4);
            }
            if (this.number_.equals("")) {
                Trace.log(2, "Cannot connect to server before setting number.");
                throw new ExtendedIllegalStateException("number", 4);
            }
        }
        if (this.closeHandle_) {
            this.close();
        }
        byte[] byArray = this.listInformationArray();
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(0), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(80), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ProgramParameter(byArray), new ProgramParameter(BinaryConverter.intToByteArray(byArray.length)), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QGY.LIB/QGYOLJBL.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray2 = programParameterArray[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(byArray2, 8, this.handle_, 0, 4);
        byArray2 = ListUtilities.waitForListToComplete(this.system_, this.handle_, byArray2);
        this.length_ = BinaryConverter.byteArrayToInt(byArray2, 0);
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded job log message list, length: " + this.length_ + ", handle: ", this.handle_);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListDirection(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting list direction: " + bl);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.listDirection_ = bl;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting name: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobLog jobLog = this;
            synchronized (jobLog) {
                this.name_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.name_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("name", string2, string3);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.name_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("name", string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumber(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting number: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'number' is null.");
            throw new NullPointerException("number");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobLog jobLog = this;
            synchronized (jobLog) {
                this.number_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.number_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("number", string2, string3);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.number_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("number", string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartingMessageKey(byte[] byArray) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting starting message key:", byArray);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.startingMessageKey_ = byArray;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.handle_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002 = this.system_;
            AS400 aS4003 = aS400;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("system", aS4002, aS4003);
            }
            this.system_ = aS400;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS4003);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting user: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'user' is null.");
            throw new NullPointerException("user");
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            JobLog jobLog = this;
            synchronized (jobLog) {
                this.user_ = string;
                if (this.handle_ != null) {
                    this.closeHandle_ = true;
                }
            }
        }
        String string2 = this.user_;
        String string3 = string;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("user", string2, string3);
        }
        JobLog jobLog = this;
        synchronized (jobLog) {
            this.user_ = string;
            if (this.handle_ != null) {
                this.closeHandle_ = true;
            }
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("user", string2, string3);
        }
    }

    public static void writeMessage(AS400 aS400, String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing message to job log, system: " + aS400 + ", message ID: " + string + ", message type:", n);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("messageType (" + n + ")", 2);
            }
        }
        JobLog.sendProgramMessage(aS400, string, "/QSYS.LIB/QCPFMSG.MSGF", null, n, false);
    }

    public static void writeMessage(AS400 aS400, String string, int n, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Writing message to job log, system: " + aS400 + ", message ID: " + string + ", message type: " + n + ", substitution data:", byArray);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("messageType (" + n + ")", 2);
            }
        }
        JobLog.sendProgramMessage(aS400, string, "/QSYS.LIB/QCPFMSG.MSGF", byArray, n, false);
    }

    public static void writeMessage(AS400 aS400, String string, int n, String string2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("messageType (" + n + ")", 2);
            }
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        QSYSObjectPathName.validatePath(string2, "MSGF");
        JobLog.sendProgramMessage(aS400, string, string2, null, n, false);
    }

    public static void writeMessage(AS400 aS400, String string, int n, String string2, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("messageType (" + n + ")", 2);
            }
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        QSYSObjectPathName.validatePath(string2, "MSGF");
        JobLog.sendProgramMessage(aS400, string, string2, byArray, n, false);
    }

    public static void writeMessage(AS400 aS400, String string, int n, String string2, byte[] byArray, boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'messageID' is null.");
            throw new NullPointerException("messageID");
        }
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 15: {
                break;
            }
            default: {
                Trace.log(2, "Value of parameter 'messageType' is not valid: " + n);
                throw new ExtendedIllegalArgumentException("messageType (" + n + ")", 2);
            }
        }
        if (string2 == null) {
            Trace.log(2, "Parameter 'messageFile' is null.");
            throw new NullPointerException("messageFile");
        }
        QSYSObjectPathName.validatePath(string2, "MSGF");
        JobLog.sendProgramMessage(aS400, string, string2, byArray, n, bl);
    }

    private void addDefaultListInformation() {
        this.numberOfFieldIdentifiers_.add(new Integer(1001));
        this.numberOfFieldIdentifiers_.add(new Integer(603));
        this.numberOfFieldIdentifiers_.add(new Integer(501));
        this.numberOfFieldIdentifiers_.add(new Integer(404));
        this.numberOfFieldIdentifiers_.add(new Integer(302));
        this.numberOfFieldIdentifiers_.add(new Integer(101));
    }

    private byte[] listInformationArray() throws IOException {
        byte[] byArray = new byte[81 + this.numberOfFieldIdentifiers_.size() * 4];
        Converter converter = new Converter(this.system_.getCcsid(), this.system_);
        if (this.listDirection_) {
            System.arraycopy(new byte[]{92, -43, -59, -25, -29}, 0, byArray, 0, 5);
        } else {
            System.arraycopy(new byte[]{92, -41, -39, -27, 64}, 0, byArray, 0, 5);
        }
        for (int i = 5; i < 52; ++i) {
            byArray[i] = 64;
        }
        converter.stringToByteArray(this.name_.toUpperCase().trim(), byArray, 10);
        converter.stringToByteArray(this.user_.toUpperCase().trim(), byArray, 20);
        converter.stringToByteArray(this.number_, byArray, 30);
        byte[] byArray2 = this.startingMessageKey_ != null ? this.startingMessageKey_ : (this.listDirection_ ? MessageQueue.OLDEST : MessageQueue.NEWEST);
        System.arraycopy(byArray2, 0, byArray, 52, 4);
        BinaryConverter.intToByteArray(511, byArray, 56);
        BinaryConverter.intToByteArray(3000, byArray, 60);
        BinaryConverter.intToByteArray(80, byArray, 64);
        BinaryConverter.intToByteArray(this.numberOfFieldIdentifiers_.size(), byArray, 68);
        BinaryConverter.intToByteArray(81 + this.numberOfFieldIdentifiers_.size() * 4 - 1, byArray, 72);
        BinaryConverter.intToByteArray(1, byArray, 76);
        Enumeration enumeration = this.numberOfFieldIdentifiers_.elements();
        int n = 80;
        while (enumeration.hasMoreElements()) {
            BinaryConverter.intToByteArray((Integer)enumeration.nextElement(), byArray, n);
            n += 4;
        }
        byArray[80 + this.numberOfFieldIdentifiers_.size() * 4] = 92;
        return byArray;
    }

    private static void sendProgramMessage(AS400 aS400, String string, String string2, byte[] byArray, int n, boolean bl) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Converter converter = new Converter(aS400.getCcsid(), aS400);
        byte[] byArray2 = new byte[]{64, 64, 64, 64, 64, 64, 64};
        converter.stringToByteArray(string, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string2);
        converter.stringToByteArray(qSYSObjectPathName.getObjectName(), byArray3, 0, 10);
        converter.stringToByteArray(qSYSObjectPathName.getLibraryName(), byArray3, 10, 10);
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] byArray4 = null;
        switch (n) {
            case 1: {
                byArray4 = typeCompletion_;
                break;
            }
            case 2: {
                byArray4 = typeDiagnostic_;
                break;
            }
            case 15: {
                byArray4 = typeEscape_;
                break;
            }
            case 4: {
                byArray4 = typeInformational_;
                break;
            }
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray2), new ProgramParameter(byArray3), new ProgramParameter(byArray), new ProgramParameter(BinaryConverter.intToByteArray(byArray.length)), new ProgramParameter(byArray4), new ProgramParameter(callStackEntry_), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(4), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QMHSNDPM.PGM", programParameterArray);
        if (bl) {
            programCall.setThreadSafe(true);
        }
        if (!programCall.run()) {
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            if (aS400MessageArray.length == 1 && aS400MessageArray[0].getID().equals(string) && aS400MessageArray[0].getType() == n) {
                if (Trace.traceOn_) {
                    Trace.log(3, "The expected escape message is ignored.");
                }
                return;
            }
            throw new AS400Exception(aS400MessageArray);
        }
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for job log invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

