/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400File;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.ServerStartupException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.UnknownHostException;

public class KeyedFile
extends AS400File
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int KEY_EQ = 0;
    public static final int KEY_GT = 1;
    public static final int KEY_GE = 2;
    public static final int KEY_LT = 3;
    public static final int KEY_LE = 4;
    protected static final int[] TYPE_TABLE = new int[]{11, 13, 12, 9, 10};

    public KeyedFile() {
    }

    public KeyedFile(AS400 aS400, String string) {
        super(aS400, string);
    }

    public void setLongRecordNumber(boolean bl) {
        this.longRecordNumber = bl;
    }

    public void deleteRecord(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        this.impl_.doIt("positionCursorToKey", new Class[]{Object[].class, Integer.TYPE}, new Object[]{objectArray, new Integer(TYPE_TABLE[0])});
        this.deleteCurrentRecord();
    }

    public void deleteRecord(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorToKeyLong", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(TYPE_TABLE[0]), new Integer(n)});
        } else {
            this.impl_.doIt("positionCursorToKey", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(TYPE_TABLE[0]), new Integer(n)});
        }
        this.deleteCurrentRecord();
    }

    public void positionCursor(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(objectArray, 0);
    }

    public void positionCursor(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursor(byArray, 0, n);
    }

    public void positionCursor(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorLong", new Class[]{Object[].class, Integer.TYPE}, new Object[]{objectArray, new Integer(TYPE_TABLE[n])});
        } else {
            this.impl_.doIt("positionCursor", new Class[]{Object[].class, Integer.TYPE}, new Object[]{objectArray, new Integer(TYPE_TABLE[n])});
        }
    }

    public void positionCursor(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n2);
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorLong", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(TYPE_TABLE[n]), new Integer(n2)});
        } else {
            this.impl_.doIt("positionCursor", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(TYPE_TABLE[n]), new Integer(n2)});
        }
    }

    public void positionCursorAfter(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorAfterLong", new Class[]{Object[].class}, new Object[]{objectArray});
        } else {
            this.impl_.doIt("positionCursorAfter", new Class[]{Object[].class}, new Object[]{objectArray});
        }
    }

    public void positionCursorAfter(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorAfterLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)});
        } else {
            this.impl_.doIt("positionCursorAfter", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)});
        }
    }

    public void positionCursorBefore(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorBeforeLong", new Class[]{Object[].class}, new Object[]{objectArray});
        } else {
            this.impl_.doIt("positionCursorBefore", new Class[]{Object[].class}, new Object[]{objectArray});
        }
    }

    public void positionCursorBefore(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            this.impl_.doIt("positionCursorBeforeLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)});
        } else {
            this.impl_.doIt("positionCursorBefore", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)});
        }
    }

    public Record read(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        return this.read(objectArray, 0);
    }

    public Record read(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        return this.read(byArray, 0, n);
    }

    public Record read(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readLong", new Class[]{Object[].class, Integer.TYPE}, new Object[]{objectArray, new Integer(TYPE_TABLE[n])}));
        }
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[]{Object[].class, Integer.TYPE}, new Object[]{objectArray, new Integer(TYPE_TABLE[n])}));
    }

    public Record read(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n2);
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("searchType", 2);
        }
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readLong", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(TYPE_TABLE[n]), new Integer(n2)}));
        }
        return this.fillInRecord(this.impl_.doItRecord("read", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{byArray, new Integer(TYPE_TABLE[n]), new Integer(n2)}));
    }

    public Record readAfter(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readAfterLong", new Class[]{Object[].class}, new Object[]{objectArray}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readAfter", new Class[]{Object[].class}, new Object[]{objectArray}));
    }

    public Record readAfter(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readAfterLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readAfter", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
    }

    public Record[] readAll() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, InterruptedException, IOException, ServerStartupException, UnknownHostException {
        if (this.isOpen_) {
            throw new ExtendedIllegalStateException(2);
        }
        if (this.recordFormat_ == null) {
            throw new ExtendedIllegalStateException("recordFormat", 4);
        }
        this.chooseImpl();
        this.recordFormat_.initializeTextObjects(this.system_);
        int n = 2048 / (this.recordFormat_.getNewRecord().getRecordLength() + 16);
        if (n <= 1) {
            n = 100;
        }
        Record[] recordArray = null;
        recordArray = this.longRecordNumber ? this.impl_.doItRecordArray("readAllLong", new Class[]{String.class, Integer.TYPE}, new Object[]{"key", new Integer(n)}) : this.impl_.doItRecordArray("readAll", new Class[]{String.class, Integer.TYPE}, new Object[]{"key", new Integer(n)});
        if (recordArray != null) {
            for (int i = 0; i < recordArray.length; ++i) {
                recordArray[i] = this.fillInRecord(recordArray[i]);
            }
        }
        return recordArray;
    }

    public Record readBefore(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readBeforeLong", new Class[]{Object[].class}, new Object[]{objectArray}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readBefore", new Class[]{Object[].class}, new Object[]{objectArray}));
    }

    public Record readBefore(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readBeforeLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readBefore", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
    }

    public Record readNextEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextEqualLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNextEqual", new Class[0], new Object[0]));
    }

    public Record readNextEqual(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextEqualLong", new Class[]{Object[].class}, new Object[]{objectArray}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNextEqual", new Class[]{Object[].class}, new Object[]{objectArray}));
    }

    public Record readNextEqual(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readNextEqualLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readNextEqual", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public Record readPreviousEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkOpen();
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousEqualLong", new Class[0], new Object[0]));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPreviousEqual", new Class[0], new Object[0]));
    }

    public Record readPreviousEqual(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameter(objectArray);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousEqualLong", new Class[]{Object[].class}, new Object[]{objectArray}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPreviousEqual", new Class[]{Object[].class}, new Object[]{objectArray}));
    }

    public Record readPreviousEqual(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.checkParameters(byArray, n);
        if (this.longRecordNumber) {
            return this.fillInRecord(this.impl_.doItRecord("readPreviousEqualLong", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
        }
        return this.fillInRecord(this.impl_.doItRecord("readPreviousEqual", new Class[]{byte[].class, Integer.TYPE}, new Object[]{byArray, new Integer(n)}));
    }

    public void update(Object[] objectArray, Record record) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(objectArray);
        this.update(record);
    }

    public void update(byte[] byArray, Record record, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(byArray, n);
        this.update(record);
    }

    public void update(Object[] objectArray, Record record, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(objectArray, n);
        this.update(record);
    }

    public void update(byte[] byArray, Record record, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (record == null) {
            throw new NullPointerException("record");
        }
        this.positionCursor(byArray, n, n2);
        this.update(record);
    }

    private void checkParameter(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("key");
        }
        if (objectArray.length == 0) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        if (objectArray.length > this.recordFormat_.getNumberOfKeyFields()) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new ExtendedIllegalArgumentException("key", 2);
        }
        this.checkOpen();
    }

    private void checkParameters(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("key");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("key", 1);
        }
        if (n < 1 || n > this.recordFormat_.getNumberOfKeyFields()) {
            throw new ExtendedIllegalArgumentException("numberOfKeyFields", 2);
        }
        this.checkOpen();
    }
}

