/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class ListUtilities {
    private static final int DEFAULT_MAX_WAIT_TIME = 60;
    static final int LIST_INFO_LENGTH = 80;
    static final char INFORMATION_COMPLETE = 'C';
    static final char INFORMATION_INTERRUPTED = 'I';
    static final char INFORMATION_PARTIAL = 'P';
    static final char LIST_PENDING = '0';
    static final char LIST_BEING_BUILT = '1';
    static final char LIST_COMPLETE = '2';
    static final char LIST_ERROR = '3';
    static final char LIST_PRIMED = '4';
    static final char LIST_TOO_MUCH_DATA = '5';

    ListUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char checkListStatus(byte[] byArray) throws ErrorCompletingRequestException {
        char c;
        char c2;
        Object object;
        try {
            object = new byte[]{byArray[16]};
            c2 = new CharConverter(37).byteArrayToString((byte[])object, 0, 1).charAt(0);
            object[0] = byArray[30];
            c = new CharConverter(37).byteArrayToString((byte[])object, 0, 1).charAt(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalErrorException(10, (Throwable)unsupportedEncodingException);
        }
        switch (c) {
            case '2': {
                break;
            }
            case '0': 
            case '1': {
                if (!Trace.traceOn_) break;
                Trace.log(1, "List status indicator:", c);
                break;
            }
            default: {
                object = new StringBuffer("Unable to synchronously build object list on server.");
                try {
                    ((StringBuffer)object).append("\n  List status indicator: " + c);
                    ((StringBuffer)object).append("\n  Info complete indicator: " + c2);
                    ((StringBuffer)object).append("\n  Total records:    " + BinaryConverter.byteArrayToInt(byArray, 0));
                    ((StringBuffer)object).append("\n  Records returned: " + BinaryConverter.byteArrayToInt(byArray, 4));
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    Trace.log(2, ((StringBuffer)object).toString());
                    throw throwable;
                }
            }
        }
        if (c2 == 'I') {
            Trace.log(2, "Info complete indicator: " + c2);
            throw new ErrorCompletingRequestException(1);
        }
        return c;
    }

    static void closeList(AS400 aS400, byte[] byArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (byArray == null || !aS400.isConnected()) {
            return;
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QGY.LIB/QGYCLST.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }

    private static byte[] refreshListInformation(byte[] byArray, ProgramCall programCall) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (programCall.getParameterList().length == 0) {
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(8), new ProgramParameter(BinaryConverter.intToByteArray(8)), new ProgramParameter(byArray), new ProgramParameter(80), new ProgramParameter(new byte[]{0, 0, 0, 0}), new ProgramParameter(new byte[]{-1, -1, -1, -1}), new ErrorCodeParameter()};
            try {
                programCall.setProgram("/QSYS.LIB/QGY.LIB/QGYGTLE.PGM", programParameterArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        return programCall.getParameterList()[3].getOutputData();
    }

    static byte[] waitForListToComplete(AS400 aS400, byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall programCall = null;
        int n = 0;
        int n2 = ListUtilities.getMaxWaitTime();
        char c = ListUtilities.checkListStatus(byArray2);
        while (c != '2' && n < n2) {
            try {
                Thread.sleep(1000L);
                ++n;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Calling QGYGTLE.PGM to wait for list to be completely built.");
            }
            if (programCall == null) {
                programCall = new ProgramCall(aS400);
            }
            byArray2 = ListUtilities.refreshListInformation(byArray, programCall);
            c = ListUtilities.checkListStatus(byArray2);
        }
        if (c != '2') {
            Trace.log(2, "The building of the list did not complete within the specified time limit of " + n2 + " seconds.");
            throw new ErrorCompletingRequestException(1);
        }
        return byArray2;
    }

    static byte[] retrieveListEntries(AS400 aS400, byte[] byArray, int n, int n2, int n3, Object[] objectArray) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray2;
        int n4;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n), new ProgramParameter(BinaryConverter.intToByteArray(n)), new ProgramParameter(byArray), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray(n2)), new ProgramParameter(BinaryConverter.intToByteArray(n3 == -1 ? -1 : n3 + 1)), new ErrorCodeParameter()};
        ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM", programParameterArray);
        do {
            if (programCall.run()) {
                byArray2 = programParameterArray[3].getOutputData();
                ListUtilities.checkListStatus(byArray2);
                n4 = BinaryConverter.byteArrayToInt(byArray2, 4);
            } else {
                byArray2 = null;
                n4 = 0;
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                if (!aS400MessageArray[0].getID().equals("GUI0002")) {
                    throw new AS400Exception(aS400MessageArray);
                }
            }
            if (n4 >= n2) continue;
            if (byArray2 != null) {
                int n5 = BinaryConverter.byteArrayToInt(byArray2, 0);
                int n6 = BinaryConverter.byteArrayToInt(byArray2, 36);
                if (n6 + n4 > n5) break;
            }
            if (Trace.traceOn_) {
                Trace.log(1, "Retrieved messages, records returned: " + n4 + ", number:", n2);
            }
            if (n4 < 0) {
                throw new InternalErrorException(6, "Records returned: " + n4, null);
            }
            n *= 1 + n2 / (n4 + 1);
            if (Trace.traceOn_) {
                Trace.log(1, "Updated length: ", n);
            }
            programParameterArray[0] = new ProgramParameter(n);
            programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n));
        } while (n4 < n2);
        if (objectArray != null && byArray2 != null) {
            objectArray[0] = byArray2;
        }
        return programParameterArray[0].getOutputData();
    }

    private static int getMaxWaitTime() {
        int n;
        block4: {
            n = 60;
            String string = SystemProperties.getProperty("com.ibm.as400.access.ListUtilities.listWaitTimeout");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n == 0) {
                        n = Integer.MAX_VALUE;
                    }
                }
                catch (Exception exception) {
                    if (!Trace.traceOn_) break block4;
                    Trace.log(4, "Error retrieving listWaitTimeout property value:", (Throwable)exception);
                }
            }
        }
        return n;
    }
}

