/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLBinary
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int maxLength_;
    private AS400ByteArray typeConverter_;
    private byte[] value_;

    SQLBinary(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.maxLength_ = n;
        this.typeConverter_ = new AS400ByteArray(n);
        this.value_ = new byte[n];
    }

    public Object clone() {
        return new SQLBinary(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.value_ = (byte[])this.typeConverter_.toObject(byArray, n);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.typeConverter_.toBytes(this.value_, byArray, n);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            InputStream inputStream;
            int n2 = n;
            if (n2 >= 0) {
                inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n3 = n2 < 1000000 ? n2 : 1000000;
                byte[] byArray = new byte[n3];
                try {
                    int n4 = 0;
                    int n5 = inputStream.read(byArray, 0, n3);
                    while (n5 > -1 && n4 < n2) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                        int n6 = n2 - (n4 += n5);
                        if (n6 < n3) {
                            n3 = n6;
                        }
                        n5 = inputStream.read(byArray, 0, n3);
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
                this.value_ = byteArrayOutputStream.toByteArray();
                if (this.value_.length < n2) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (n2 == -2 || n2 == -1) {
                inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n7 = 1000000;
                byte[] byArray = new byte[n7];
                try {
                    int n8 = 0;
                    int n9 = inputStream.read(byArray, 0, n7);
                    while (n9 > -1) {
                        byteArrayOutputStream.write(byArray, 0, n9);
                        n8 += n9;
                        n9 = inputStream.read(byArray, 0, n7);
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
                this.value_ = byteArrayOutputStream.toByteArray();
            } else {
                if (JDTrace.isTraceOn()) {
                    if (object == null) {
                        JDTrace.logInformation(this, "Unable to assign null object");
                    } else {
                        JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                    }
                }
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Reader) {
            int n10 = n;
            if (n10 >= 0) {
                try {
                    int n11 = n10 < 1000000 ? n10 : 1000000;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray = new byte[n11];
                    int n12 = 0;
                    int n13 = hexReaderInputStream.read(byArray, 0, n11);
                    while (n13 > -1 && n12 < n10) {
                        byteArrayOutputStream.write(byArray, 0, n13);
                        int n14 = n10 - (n12 += n13);
                        if (n14 < n11) {
                            n11 = n14;
                        }
                        n13 = hexReaderInputStream.read(byArray, 0, n11);
                    }
                    this.value_ = byteArrayOutputStream.toByteArray();
                    if (this.value_.length < n10) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    hexReaderInputStream.close();
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else if (n10 == -2 || n10 == -1) {
                try {
                    int n15 = 1000000;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray = new byte[n15];
                    int n16 = 0;
                    int n17 = hexReaderInputStream.read(byArray, 0, n15);
                    while (n17 > -1) {
                        byteArrayOutputStream.write(byArray, 0, n17);
                        n16 += n17;
                        n17 = hexReaderInputStream.read(byArray, 0, n15);
                    }
                    this.value_ = byteArrayOutputStream.toByteArray();
                    hexReaderInputStream.close();
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n18 = this.value_.length;
        if (n18 < this.maxLength_) {
            byte[] byArray = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, byArray, 0, n18);
            this.value_ = byArray;
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (n18 > this.maxLength_) {
            byte[] byArray = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
            this.value_ = byArray;
            this.truncated_ = n18 - this.maxLength_;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
    }

    public int getSQLType() {
        return 2;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getLiteralPrefix() {
        return "BINARY(X'";
    }

    public String getLiteralSuffix() {
        return "')";
    }

    public String getLocalName() {
        return "BINARY";
    }

    public int getMaximumPrecision() {
        return 32765;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 912;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -2;
    }

    public String getTypeName() {
        return "BINARY";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public String getJavaClassName() {
        return "[B";
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public Blob getBlob() throws SQLException {
        return new AS400JDBCBlob(this.getBytes(), this.maxLength_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() {
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length > n && n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value_, 0, byArray, 0, n);
            return byArray;
        }
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        return new AS400JDBCClob(BinaryConverter.bytesToHexString(this.getBytes()), this.maxLength_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToHexString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public NClob getNClob() throws SQLException {
        return new AS400JDBCNClob(BinaryConverter.bytesToHexString(this.getBytes()), this.maxLength_);
    }

    public String getNString() throws SQLException {
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

