/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RoutingDataEntry;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SubsystemEntryList {
    private static final QSYSObjectPathName USERSPACE_PATH = new QSYSObjectPathName("QTEMP", "JT4QLSBSE", "USRSPC");
    private static final String SBSE_FORMAT_100 = "SBSE0100";
    private static final String SBSE_FORMAT_200 = "SBSE0200";
    private static final String SBSE_FORMAT_300 = "SBSE0300";
    private static final String SBSE_FORMAT_400 = "SBSE0400";
    private static final String SBSE_FORMAT_500 = "SBSE0500";
    private static final String SBSE_FORMAT_600 = "SBSE0600";
    private static final String SBSE_FORMAT_700 = "SBSE0700";
    public static final int ROUTING_ENTRY = 1;
    public static final int COMMUNICATION_ENTRY = 2;
    public static final int REMOTE_LOCATION_ENTRY = 3;
    public static final int AUTOSTART_JOB_ENTRY = 4;
    public static final int PRESTART_JOB_ENTRY = 5;
    public static final int WORKSTATION_NAME_ENTRY = 6;
    public static final int WORKSTATION_TYPE_ENTRY = 7;
    private AS400 system_;
    private String name_;
    private String library_;
    private int listType_;
    private QSYSObjectPathName path_;
    private final Map routingDataDescription_ = new HashMap();

    public SubsystemEntryList(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("Subsystem library");
        }
        if (string2 == null) {
            throw new NullPointerException("Subsystem name");
        }
        this.system_ = aS400;
        this.name_ = string2;
        this.library_ = string;
        this.path_ = new QSYSObjectPathName(this.library_, this.name_, "SBSD");
    }

    public SubsystemEntryList(AS400 aS400, QSYSObjectPathName qSYSObjectPathName) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (qSYSObjectPathName == null) {
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.path_ = qSYSObjectPathName;
    }

    private String lookupFormat(int n) {
        String string;
        switch (n) {
            case 1: {
                string = SBSE_FORMAT_100;
                break;
            }
            case 2: {
                string = SBSE_FORMAT_200;
                break;
            }
            case 3: {
                string = SBSE_FORMAT_300;
                break;
            }
            case 4: {
                string = SBSE_FORMAT_400;
                break;
            }
            case 5: {
                string = SBSE_FORMAT_500;
                break;
            }
            case 6: {
                string = SBSE_FORMAT_600;
                break;
            }
            case 7: {
                string = SBSE_FORMAT_700;
                break;
            }
            default: {
                if (Trace.traceOn_) {
                    Trace.log(4, "Unrecognized list type:", n);
                }
                string = SBSE_FORMAT_100;
            }
        }
        return string;
    }

    public void refresh() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.clear();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QWDLSBSE.PGM", this.buildProgramParameters(this.getFormat()));
        boolean bl = programCall.isStayOnThread();
        Serializable serializable = bl ? USERSPACE_PATH : this.system_;
        Serializable serializable2 = serializable;
        synchronized (serializable2) {
            UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH.getPath());
            userSpace.setMustUseProgramCall(true);
            if (!bl) {
                userSpace.setMustUseSockets(true);
            }
            try {
                userSpace.create(65535, true, "JT400", (byte)0, "Userspace for loading members", "*ALL");
                if (!programCall.run()) {
                    throw new AS400Exception(programCall.getMessageList());
                }
                byte[] byArray = new byte[65535];
                int n = userSpace.read(byArray, 0, 0, 144);
                if (n < 144) {
                    Trace.log(2, "Failed to read the generic header.  Number of bytes read: " + n);
                    throw new InternalErrorException(6, n);
                }
                int n2 = BinaryConverter.byteArrayToInt(byArray, 116);
                int n3 = BinaryConverter.byteArrayToInt(byArray, 120);
                int n4 = BinaryConverter.byteArrayToInt(byArray, 124);
                int n5 = BinaryConverter.byteArrayToInt(byArray, 128);
                int n6 = BinaryConverter.byteArrayToInt(byArray, 132);
                int n7 = BinaryConverter.byteArrayToInt(byArray, 136);
                int n8 = BinaryConverter.byteArrayToInt(byArray, 140);
                if (n8 == 0) {
                    n8 = this.system_.getCcsid();
                }
                CharConverter charConverter = new CharConverter(n8);
                n = userSpace.read(byArray, n2, 0, n3);
                if (n < n3) {
                    Trace.log(2, "Failed to read the header section.  Number of bytes read: " + n);
                    throw new InternalErrorException(6, n);
                }
                if (n5 > byArray.length) {
                    byArray = new byte[n5 + 1];
                }
                if ((n = userSpace.read(byArray, n4, 0, n5)) < n5) {
                    Trace.log(2, "Failed to read the list data section.  Number of bytes read: " + n);
                    throw new InternalErrorException(6, n);
                }
                String string = this.getFormat();
                for (int i = 0; i < n6; ++i) {
                    byte[] byArray2 = new byte[n7];
                    System.arraycopy(byArray, i * n7, byArray2, 0, n7);
                    if (!string.equals(SBSE_FORMAT_100)) continue;
                    this.readRoutingDataEntries(byArray2, string, charConverter);
                }
                Object var20_19 = null;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                try {
                    userSpace.delete();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
                throw throwable;
            }
            try {
                userSpace.delete();
            }
            catch (Exception exception) {
                Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
            }
        }
    }

    private String getFormat() {
        String string = SBSE_FORMAT_100;
        String string2 = this.lookupFormat(this.listType_);
        if (string.compareTo(string2) < 0) {
            string = string2;
        }
        return string;
    }

    public void setListType(int n) {
        this.listType_ = n;
    }

    private ProgramParameter[] buildProgramParameters(String string) throws UnsupportedEncodingException {
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(CharConverter.stringToByteArray(this.system_, USERSPACE_PATH.toQualifiedObjectName())), new ProgramParameter(CharConverter.stringToByteArray(this.system_, string)), new ProgramParameter(CharConverter.stringToByteArray(this.system_, this.path_.toQualifiedObjectName())), new ErrorCodeParameter()};
        return programParameterArray;
    }

    private void readRoutingDataEntries(byte[] byArray, String string, CharConverter charConverter) {
        String string2 = charConverter.byteArrayToString(byArray, 56, 10).trim();
        RoutingDataEntry routingDataEntry = (RoutingDataEntry)this.routingDataDescription_.get(string2);
        if (routingDataEntry == null) {
            routingDataEntry = new RoutingDataEntry();
        }
        int n = 0;
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        String string3 = charConverter.byteArrayToString(byArray, 4, 10).trim();
        String string4 = charConverter.byteArrayToString(byArray, 14, 10).trim();
        String string5 = charConverter.byteArrayToString(byArray, 24, 10).trim();
        String string6 = charConverter.byteArrayToString(byArray, 24, 10).trim();
        int n3 = BinaryConverter.byteArrayToInt(byArray, 44);
        int n4 = BinaryConverter.byteArrayToInt(byArray, 48);
        int n5 = BinaryConverter.byteArrayToInt(byArray, 52);
        String string7 = charConverter.byteArrayToString(byArray, 136, 10).trim();
        String string8 = charConverter.byteArrayToString(byArray, 146, 10).trim();
        String string9 = charConverter.byteArrayToString(byArray, 156, 10).trim();
        routingDataEntry.setcompareValue(string2);
        routingDataEntry.setroutingEntrySequenceNum(n2);
        routingDataEntry.setroutingEntryProgramName(string3);
        routingDataEntry.setroutingEntryProgramLibrary(string4);
        routingDataEntry.setroutingEntryClassName(string5);
        routingDataEntry.setroutingEntryClassLibrary(string6);
        routingDataEntry.setmaxActiveRoutingStep(n3);
        routingDataEntry.setroutingEntryPoolIden(n4);
        routingDataEntry.setcompareStartPosition(n5);
        routingDataEntry.setroutingEntryThreadResourcesAffinityGroup(string7);
        routingDataEntry.setroutingEntryThreadResourcesAffinityLevel(string8);
        routingDataEntry.setroutingEntryResourcesAffinityGroup(string9);
        this.routingDataDescription_.put(string2, routingDataEntry);
    }

    public RoutingDataEntry getRoutingDataEntry(String string) {
        return (RoutingDataEntry)this.routingDataDescription_.get(string);
    }

    public RoutingDataEntry[] getRoutingDataEntry() {
        return this.routingDataDescription_.values().toArray(new RoutingDataEntry[this.routingDataDescription_.size()]);
    }

    public void clear() {
        this.routingDataDescription_.clear();
    }
}

