/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.PresentationLoader;
import com.ibm.as400.resource.RIFSFile;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaDataTable;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;

public class RIFSFileList
extends ResourceList {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String PRESENTATION_KEY_ = "IFSFILE_LIST";
    private static final String ICON_BASE_NAME_ = "RIFSFileList";
    private static PresentationLoader presentationLoader_ = new PresentationLoader("com.ibm.as400.resource.ResourceMRI");
    private static ResourceMetaDataTable selections_ = new ResourceMetaDataTable(presentationLoader_, "IFSFILE_LIST");
    public static final String FILTER = "FILTER";
    public static final String PATTERN = "PATTERN";
    private Vector cache_;
    private Enumeration enum_;
    private IFSFile file_ = new IFSFile();
    private String path_ = null;

    public RIFSFileList() {
        super(presentationLoader_.getPresentationWithIcon(PRESENTATION_KEY_, ICON_BASE_NAME_), RIFSFile.attributes_, selections_, null);
    }

    public RIFSFileList(AS400 aS400, String string) {
        this();
        try {
            this.setSystem(aS400);
            this.setPath(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public RIFSFileList(RIFSFile rIFSFile) {
        this();
        try {
            this.setSystem(rIFSFile.getSystem());
            this.setPath(rIFSFile.getPath());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void establishConnection() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        super.establishConnection();
        try {
            this.file_.setSystem(this.getSystem());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void freezeProperties() throws ResourceException {
        if (this.file_.getPath() == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        Presentation presentation = this.getPresentation();
        presentation.setName(this.file_.getName());
        presentation.setFullName(this.file_.getPath());
        super.freezeProperties();
    }

    public String getPath() {
        return this.path_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws ResourceException {
        if (this.isOpen()) {
            return;
        }
        super.open();
        this.fireBusy();
        try {
            RIFSFileList rIFSFileList = this;
            synchronized (rIFSFileList) {
                if (!this.isConnectionEstablished()) {
                    this.establishConnection();
                }
                try {
                    String string = (String)this.getSelectionValue(PATTERN);
                    this.enum_ = string == null ? this.file_.enumerateFiles((IFSFileFilter)this.getSelectionValue(FILTER)) : this.file_.enumerateFiles((IFSFileFilter)this.getSelectionValue(FILTER), string);
                    this.cache_ = new Vector();
                    if (!this.enum_.hasMoreElements()) {
                        this.fireListCompleted();
                    }
                }
                catch (Exception exception) {
                    throw new ResourceException(exception);
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fireIdle();
            throw throwable;
        }
        this.fireIdle();
    }

    public void refreshContents() throws ResourceException {
        if (this.isOpen()) {
            this.close();
        }
        super.refreshContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource resourceAt(long l) throws ResourceException {
        RIFSFileList rIFSFileList = this;
        synchronized (rIFSFileList) {
            Resource resource = super.resourceAt(l);
            if (resource == null) {
                Vector vector = this.cache_;
                synchronized (vector) {
                    if (l < (long)this.cache_.size()) {
                        return (Resource)this.cache_.elementAt((int)l);
                    }
                    int n = this.cache_.size();
                    while ((long)n <= l) {
                        resource = new RIFSFile((IFSFile)this.enum_.nextElement());
                        this.cache_.addElement(resource);
                        resource.freezeProperties();
                        this.fireResourceAdded(resource, n);
                        this.fireLengthChanged(n + 1);
                        if (!this.enum_.hasMoreElements()) {
                            this.fireListCompleted();
                            break;
                        }
                        ++n;
                    }
                }
            }
            return resource;
        }
    }

    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        if (this.arePropertiesFrozen()) {
            throw new ExtendedIllegalStateException("propertiesFrozen", 5);
        }
        String string2 = this.file_.getPath();
        try {
            this.path_ = string;
            String string3 = string.replace(IFSJavaFile.separatorChar, '/');
            this.file_.setPath(string3);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.firePropertyChange("path", string2, string);
    }

    public void waitForComplete() throws ResourceException {
        super.waitForComplete();
        int n = 0;
        while (!this.isComplete()) {
            this.resourceAt(n++);
        }
    }

    public void waitForResource(long l) throws ResourceException {
        super.waitForResource(l);
        int n = 0;
        while (!this.isComplete() && (long)n <= l) {
            this.resourceAt(n++);
        }
    }

    static {
        selections_.add((Object)FILTER, IFSFileFilter.class, false);
        selections_.add((Object)PATTERN, String.class, false);
    }
}

