/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.Resource;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceListEvent;
import com.ibm.as400.resource.ResourceListListener;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.TableModelEventSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ResourceListDetailsModel
implements TableModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String RESOURCE_COLUMN_NAME_ = ResourceLoader.getText("RESOURCE_COLUMN_NAME");
    private static final int COLUMN_SOURCE_NOT_KNOWN_ = 0;
    private static final int COLUMN_SOURCE_RESOURCE_ = 1;
    private static final int COLUMN_SOURCE_RESOURCE_ATTRIBUTE_ = 2;
    private static final int COLUMN_SOURCE_NOT_VALID_ = 99;
    private boolean exceptionOccured_ = false;
    private transient boolean loaded_ = false;
    private ResourceList resourceList_ = null;
    private Object[] columnAttributeIDs_ = null;
    private int[] columnSources_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient ResourceListListener resourceListListener_;
    transient TableModelEventSupport tableModelEventSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public ResourceListDetailsModel() {
        this.initializeTransient();
    }

    public ResourceListDetailsModel(ResourceList resourceList, Object[] objectArray) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        if (objectArray == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        this.initializeTransient();
        this.setResourceList(resourceList);
        this.setColumnAttributeIDs(objectArray);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModelEventSupport_.addTableModelListener(tableModelListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Object[] getColumnAttributeIDs() {
        return this.columnAttributeIDs_;
    }

    public Class getColumnClass(int n) {
        switch (this.getColumnSource(n)) {
            case 1: {
                return Resource.class;
            }
            case 2: {
                return this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[n]).getType();
            }
        }
        return null;
    }

    public int getColumnCount() {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null) {
            return 0;
        }
        return this.columnAttributeIDs_.length;
    }

    public String getColumnName(int n) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null) {
            return null;
        }
        switch (this.getColumnSource(n)) {
            case 1: {
                return RESOURCE_COLUMN_NAME_;
            }
            case 2: {
                return this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[n]).getPresentation().getName();
            }
        }
        if (n < 0 || n >= this.columnAttributeIDs_.length) {
            return null;
        }
        return this.columnAttributeIDs_[n].toString();
    }

    private int getColumnSource(int n) {
        if (this.columnAttributeIDs_ == null) {
            return 99;
        }
        if (n < 0 || n >= this.columnAttributeIDs_.length) {
            return 99;
        }
        if (this.columnSources_[n] == 0) {
            if (this.columnAttributeIDs_[n] == null) {
                this.columnSources_[n] = 1;
            } else {
                try {
                    ResourceMetaData resourceMetaData = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[n]);
                    this.columnSources_[n] = 2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.columnSources_[n] = 99;
                }
            }
        }
        return this.columnSources_[n];
    }

    public int getColumnWidth(int n) {
        int n2;
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null) {
            return 20;
        }
        switch (this.getColumnSource(n)) {
            default: {
                return 20;
            }
            case 2: 
        }
        int n3 = 20;
        ResourceMetaData resourceMetaData = this.resourceList_.getAttributeMetaData(this.columnAttributeIDs_[n]);
        Class clazz = resourceMetaData.getType();
        Presentation[] presentationArray = resourceMetaData.getPossibleValuePresentations();
        if (Number.class.isAssignableFrom(clazz)) {
            n3 = 10;
        } else if (presentationArray.length > 0) {
            n3 = 1;
            for (n2 = 0; n2 < presentationArray.length; ++n2) {
                int n4 = presentationArray[n2].getName().toString().length();
                if (n4 <= n3) continue;
                n3 = n4;
            }
        }
        n2 = resourceMetaData.getPresentation().getName().toString().length();
        if (n2 > n3) {
            n3 = n2;
        }
        return n3;
    }

    public Resource getResourceAt(int n) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null || !this.loaded_ || this.exceptionOccured_) {
            return null;
        }
        try {
            if (n < 0 || this.resourceList_.isComplete() && (long)n > this.resourceList_.getListLength()) {
                return null;
            }
            return this.resourceList_.resourceAt(n);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            this.exceptionOccured_ = true;
            return null;
        }
    }

    public ResourceList getResourceList() {
        return this.resourceList_;
    }

    public int getRowCount() {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null || !this.loaded_ || this.exceptionOccured_) {
            return 0;
        }
        try {
            if (!this.resourceList_.isComplete()) {
                this.resourceList_.refreshStatus();
            }
            long l = this.resourceList_.getListLength();
            return (int)l;
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
            this.exceptionOccured_ = true;
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        if (this.resourceList_ == null || this.columnAttributeIDs_ == null || !this.loaded_ || this.exceptionOccured_) {
            return null;
        }
        Resource resource = this.getResourceAt(n);
        if (resource == null) {
            return null;
        }
        switch (this.getColumnSource(n2)) {
            case 1: {
                return resource;
            }
            case 2: {
                resource.addActiveStatusListener(this.workingEventSupport_);
                try {
                    Object object = resource.getAttributeValue(this.columnAttributeIDs_[n2]);
                    Object var7_6 = null;
                    resource.removeActiveStatusListener(this.workingEventSupport_);
                    return object;
                }
                catch (Exception exception) {
                    try {
                        this.errorEventSupport_.fireError(exception);
                        this.exceptionOccured_ = true;
                        Object var5_9 = null;
                        Object var7_7 = null;
                        resource.removeActiveStatusListener(this.workingEventSupport_);
                        return var5_9;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        resource.removeActiveStatusListener(this.workingEventSupport_);
                        throw throwable;
                    }
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.resourceListListener_ = new ResourceListListener_();
        this.tableModelEventSupport_ = new TableModelEventSupport(this, this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.resourceList_ != null) {
            this.resourceList_.addActiveStatusListener(this.workingEventSupport_);
            this.resourceList_.addResourceListListener(this.resourceListListener_);
        }
    }

    public void load() {
        if (this.loaded_ && this.resourceList_ != null && !this.exceptionOccured_) {
            try {
                this.resourceList_.refreshContents();
            }
            catch (Exception exception) {
                this.errorEventSupport_.fireError(exception);
                this.exceptionOccured_ = true;
            }
        } else {
            this.loaded_ = true;
        }
        this.tableModelEventSupport_.fireTableChanged(-1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableModelEventSupport_.removeTableModelListener(tableModelListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setColumnAttributeIDs(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("columnAttributeIDs");
        }
        Object[] objectArray2 = this.columnAttributeIDs_;
        if (objectArray2 != objectArray) {
            this.columnAttributeIDs_ = objectArray;
            this.columnSources_ = new int[this.columnAttributeIDs_.length];
            this.tableModelEventSupport_.fireTableChanged(-1);
        }
        this.propertyChangeSupport_.firePropertyChange("columnAttributeIDs", objectArray2, this.columnAttributeIDs_);
    }

    public void setResourceList(ResourceList resourceList) {
        if (resourceList == null) {
            throw new NullPointerException("resourceList");
        }
        ResourceList resourceList2 = this.resourceList_;
        if (resourceList2 != resourceList) {
            if (resourceList2 != null) {
                resourceList2.removeActiveStatusListener(this.workingEventSupport_);
                resourceList2.removeResourceListListener(this.resourceListListener_);
            }
            resourceList.addActiveStatusListener(this.workingEventSupport_);
            resourceList.addResourceListListener(this.resourceListListener_);
            this.resourceList_ = resourceList;
            this.exceptionOccured_ = false;
            if (this.columnAttributeIDs_ != null) {
                this.columnSources_ = new int[this.columnAttributeIDs_.length];
            }
            this.tableModelEventSupport_.fireTableChanged(-1);
        }
        this.propertyChangeSupport_.firePropertyChange("resourceList", resourceList2, this.resourceList_);
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    private class ResourceListListener_
    implements ResourceListListener {
        private long length_ = 0L;

        private ResourceListListener_() {
        }

        public void lengthChanged(ResourceListEvent resourceListEvent) {
            long l = resourceListEvent.getLength();
            ResourceListDetailsModel.this.tableModelEventSupport_.fireTableChanged((int)this.length_, (int)l, -1, 1);
            this.length_ = l;
        }

        public void listClosed(ResourceListEvent resourceListEvent) {
        }

        public void listCompleted(ResourceListEvent resourceListEvent) {
        }

        public void listInError(ResourceListEvent resourceListEvent) {
        }

        public void listOpened(ResourceListEvent resourceListEvent) {
        }

        public void resourceAdded(ResourceListEvent resourceListEvent) {
        }
    }
}

