/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.resource.RJob;
import com.ibm.as400.resource.RJobList;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VJob;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VResourceListPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VJobList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("JOB_LIST_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VJobList16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VJobList32.gif", description_);
    private static String cpuUsedColumnHeader_ = ResourceLoader.getText("JOB_CPU_USED");
    private static String dateColumnHeader_ = ResourceLoader.getText("JOB_DATE");
    private static String functionColumnHeader_ = ResourceLoader.getText("JOB_FUNCTION");
    private static String nameColumnHeader_ = ResourceLoader.getText("JOB_NAME");
    private static String numberColumnHeader_ = ResourceLoader.getText("JOB_NUMBER");
    private static String statusColumnHeader_ = ResourceLoader.getText("JOB_STATUS");
    private static String subsystemColumnHeader_ = ResourceLoader.getText("JOB_SUBSYSTEM");
    private static String subtypeColumnHeader_ = ResourceLoader.getText("JOB_SUBTYPE");
    private static String typeColumnHeader_ = ResourceLoader.getText("JOB_TYPE");
    private static String userColumnHeader_ = ResourceLoader.getText("JOB_USER");
    private RJobList jobList_ = null;
    private String name_ = null;
    private String number_ = null;
    private VNode parent_ = null;
    private String user_ = null;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VNode[] children_;
    private transient Object childrenLock_;
    private transient boolean loaded_ = false;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VJobList() {
        this.jobList_ = new RJobList();
        try {
            this.jobList_.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
            this.jobList_.setSortValue(new Object[]{"JOB_NAME", "USER_NAME", "JOB_NUMBER"});
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.initializeTransient();
    }

    public VJobList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.jobList_ = new RJobList(aS400);
        try {
            this.jobList_.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
            this.jobList_.setSortValue(new Object[]{"JOB_NAME", "USER_NAME", "JOB_NUMBER"});
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.initializeTransient();
    }

    public VJobList(VNode vNode, AS400 aS400) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.parent_ = vNode;
        this.jobList_ = new RJobList(aS400);
        try {
            this.jobList_.setSelectionValue("PRIMARY_JOB_STATUSES", new String[]{"*ACTIVE"});
            this.jobList_.setSortValue(new Object[]{"JOB_NAME", "USER_NAME", "JOB_NUMBER"});
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        if (!this.loaded_) {
            return null;
        }
        if (this.children_ == null) {
            this.loadFirst();
        }
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        if (this.children_[n] == null) {
            this.loadSingle(n);
        }
        return this.children_[n];
    }

    public int getChildCount() {
        if (!this.loaded_) {
            return 0;
        }
        if (this.children_ == null) {
            this.loadFirst();
        }
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        return (VObject)((Object)this.getChildAt(n));
    }

    public int getDetailsChildCount() {
        return this.getChildCount();
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject vObject) {
        if (vObject instanceof TreeNode) {
            return this.getIndex((TreeNode)((Object)vObject));
        }
        return -1;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode treeNode) {
        if (!this.loaded_) {
            return -1;
        }
        if (treeNode == null) {
            return -1;
        }
        if (this.children_ == null) {
            this.loadFirst();
        }
        for (int i = 0; i < this.children_.length; ++i) {
            if (this.children_[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        if (this.name_ == null) {
            return "*ALL";
        }
        return this.name_;
    }

    public String getNumber() {
        if (this.number_ == null) {
            return "*ALL";
        }
        return this.number_;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == NAME_PROPERTY) {
            return this;
        }
        if (object == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.jobList_.getSystem();
    }

    public String getText() {
        return description_;
    }

    public String getUser() {
        if (this.user_ == null) {
            return "*ALL";
        }
        return this.user_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.jobList_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.jobList_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.children_ = new VNode[0];
        this.childrenLock_ = new Object();
        this.propertiesPane_ = new VResourceListPropertiesPane(this, this.jobList_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.childrenLock_;
        synchronized (object) {
            if (this.children_ != null) {
                for (int i = 0; i < this.children_.length; ++i) {
                    if (this.children_[i] == null) continue;
                    this.children_[i].removeErrorListener(this.errorEventSupport_);
                    this.children_[i].removeVObjectListener(this.objectEventSupport_);
                    this.children_[i].removeWorkingListener(this.workingEventSupport_);
                }
            }
            this.children_ = null;
            this.loaded_ = true;
        }
        this.objectEventSupport_.fireObjectChanged(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFirst() {
        this.workingEventSupport_.fireStartWorking();
        Exception exception = null;
        Object object = this.childrenLock_;
        synchronized (object) {
            if (this.children_ == null) {
                try {
                    this.jobList_.refreshContents();
                    this.jobList_.waitForComplete();
                    this.children_ = new VJob[(int)this.jobList_.getListLength()];
                }
                catch (Exception exception2) {
                    exception = exception2;
                    this.children_ = new VJob[0];
                }
            }
        }
        if (exception != null) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSingle(int n) {
        this.workingEventSupport_.fireStartWorking();
        Exception exception = null;
        Object object = this.childrenLock_;
        synchronized (object) {
            if (this.children_[n] == null) {
                try {
                    RJob rJob = (RJob)this.jobList_.resourceAt(n);
                    this.children_[n] = new VJob((VNode)this, this.jobList_.getSystem(), rJob);
                    this.children_[n].addErrorListener(this.errorEventSupport_);
                    this.children_[n].addVObjectListener(this.objectEventSupport_);
                    this.children_[n].addWorkingListener(this.workingEventSupport_);
                    this.children_[n].load();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    this.children_ = new VJob[0];
                }
            }
        }
        if (exception != null) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        this.vetoableChangeSupport_.fireVetoableChange("name", string2, string);
        this.name_ = string;
        try {
            this.jobList_.setSelectionValue("JOB_NAME", this.name_);
        }
        catch (ResourceException resourceException) {
            this.errorEventSupport_.fireError(resourceException);
        }
        this.propertyChangeSupport_.firePropertyChange("name", string2, string);
    }

    public void setNumber(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("number");
        }
        String string2 = this.number_;
        this.vetoableChangeSupport_.fireVetoableChange("number", string2, string);
        this.number_ = string;
        try {
            this.jobList_.setSelectionValue("JOB_NUMBER", this.number_);
        }
        catch (ResourceException resourceException) {
            this.errorEventSupport_.fireError(resourceException);
        }
        this.propertyChangeSupport_.firePropertyChange("number", string2, string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.jobList_.getSystem();
        this.vetoableChangeSupport_.fireVetoableChange("system", aS4002, aS400);
        this.jobList_.setSystem(aS400);
        this.propertyChangeSupport_.firePropertyChange("system", aS4002, aS400);
    }

    public void setUser(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("user");
        }
        String string2 = this.user_;
        this.vetoableChangeSupport_.fireVetoableChange("user", string2, string);
        this.user_ = string;
        try {
            this.jobList_.setSelectionValue("USER_NAME", this.user_);
        }
        catch (ResourceException resourceException) {
            this.errorEventSupport_.fireError(resourceException);
        }
        this.propertyChangeSupport_.firePropertyChange("user", string2, string);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (blArray == null) {
            throw new NullPointerException("orders");
        }
    }

    public String toString() {
        return description_;
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VJob.NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VJob.USER_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(userColumnHeader_);
        vTableColumn2.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn2);
        VTableColumn vTableColumn3 = new VTableColumn(n++, VJob.TYPE_PROPERTY);
        vTableColumn3.setCellRenderer(new VObjectCellRenderer());
        vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn3.setHeaderValue(typeColumnHeader_);
        vTableColumn3.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn3);
        VTableColumn vTableColumn4 = new VTableColumn(n++, VJob.STATUS_PROPERTY);
        vTableColumn4.setCellRenderer(new VObjectCellRenderer());
        vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn4.setHeaderValue(statusColumnHeader_);
        vTableColumn4.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn4);
        VTableColumn vTableColumn5 = new VTableColumn(n++, VJob.NUMBER_PROPERTY);
        vTableColumn5.setCellRenderer(new VObjectCellRenderer());
        vTableColumn5.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn5.setHeaderValue(numberColumnHeader_);
        vTableColumn5.setPreferredCharWidth(6);
        detailsColumnModel_.addColumn(vTableColumn5);
    }
}

