/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEvent;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.SystemPoolPropertiesPane;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemPoolModifyAction;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.Icon;

public class VSystemPool
implements VObject,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final Icon icon16_ = ResourceLoader.getIcon("VSystemPool16.gif");
    private static final Icon icon32_ = ResourceLoader.getIcon("VSystemPool32.gif");
    public static String IDENTIFIER_PROPERTY = "System pool";
    public static String POOL_SIZE_PROPERTY = "Pool size";
    public static String RESERVED_SIZE_PROPERTY = "Reserved size";
    private SystemPool systemPool_ = null;
    private transient VAction[] actions_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private boolean allowModify_ = false;

    public VSystemPool() {
        this.systemPool_ = null;
        this.initializeTransient();
    }

    public VSystemPool(SystemPool systemPool) {
        if (systemPool == null) {
            throw new NullPointerException("systemPool");
        }
        this.systemPool_ = systemPool;
        this.systemPool_.setCaching(true);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public void errorOccurred(ErrorEvent errorEvent) {
        this.errorEventSupport_.errorOccurred(errorEvent);
    }

    public VAction[] getActions() {
        return this.actions_;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        try {
            if (object == NAME_PROPERTY) {
                return this;
            }
            if (object == DESCRIPTION_PROPERTY) {
                return this.systemPool_.getDescription();
            }
            if (object == IDENTIFIER_PROPERTY) {
                return Integer.toString(this.systemPool_.getPoolIdentifier());
            }
            if (object == POOL_SIZE_PROPERTY) {
                return Integer.toString(this.systemPool_.getPoolSize());
            }
            if (object == RESERVED_SIZE_PROPERTY) {
                return Integer.toString(this.systemPool_.getReservedSize());
            }
            return null;
        }
        catch (Exception exception) {
            Trace.log(2, "Unable to getPropertyValue for VSystemPool.", (Throwable)exception);
            this.errorEventSupport_.fireError(exception);
            return null;
        }
    }

    public AS400 getSystem() {
        return this.systemPool_.getSystem();
    }

    public SystemPool getSystemPool() {
        return this.systemPool_;
    }

    public String getText() {
        if (this.systemPool_ != null) {
            return this.systemPool_.getPoolName();
        }
        return "";
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.propertiesPane_ = new SystemPoolPropertiesPane(this, this.systemPool_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
        this.actions_ = new VAction[1];
        this.actions_[0] = new VSystemPoolModifyAction(this, this.systemPool_);
        this.actions_[0].addErrorListener(this.errorEventSupport_);
        this.actions_[0].addWorkingListener(this.workingEventSupport_);
    }

    public boolean isAllowModify() {
        return this.allowModify_;
    }

    public void load() {
        if (this.systemPool_ != null) {
            this.systemPool_.refreshCache();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setAllowModify(boolean bl) {
        this.allowModify_ = bl;
        for (int i = 0; i < this.actions_.length; ++i) {
            if (this.actions_[i] == null) continue;
            ((VSystemPoolModifyAction)this.actions_[i]).setEnabled(bl);
        }
    }

    public void setSystemPool(SystemPool systemPool) throws PropertyVetoException {
        if (systemPool == null) {
            throw new NullPointerException("systemPool");
        }
        if (this.systemPool_ != systemPool) {
            SystemPool systemPool2 = this.systemPool_;
            SystemPool systemPool3 = systemPool;
            this.vetoableChangeSupport_.fireVetoableChange("systemPool", systemPool2, systemPool3);
            this.systemPool_ = systemPool;
            this.systemPool_.setCaching(true);
            this.propertyChangeSupport_.firePropertyChange("systemPool", systemPool2, systemPool3);
            this.objectEventSupport_.fireObjectChanged(this);
        }
    }

    public String toString() {
        return this.getText();
    }
}

