/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.SystemStatus;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemPool;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VSystemStatus
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static TableColumnModel detailsColumnModel_ = null;
    private static String description_ = ResourceLoader.getText("SYSTEM_STATUS_SYSTEM_STATUS");
    private static final Icon icon16_ = ResourceLoader.getIcon("VSystemStatus16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VSystemStatus32.gif", description_);
    private static String nameColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_POOL_NAME");
    private static String descriptionColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_POOL_DESCRIPTION");
    private static String identifierColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_IDENTIFIER");
    private static String poolSizeColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_POOL_SIZE");
    private static String reservedSizeColumnHeader_ = ResourceLoader.getText("SYSTEM_POOL_RESERVED_SIZE");
    private SystemStatus systemStatus_ = null;
    private VNode parent_ = null;
    private boolean allowModifyAllPools_ = false;
    private transient VObject[] detailsChildren_;
    private transient Enumeration enum_;
    private transient int loaded_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VSystemStatus() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        this.systemStatus_ = new SystemStatus();
        this.initializeTransient();
    }

    public VSystemStatus(AS400 aS400) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.systemStatus_ = new SystemStatus(aS400);
        this.initializeTransient();
    }

    public VSystemStatus(SystemStatus systemStatus) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        this.systemStatus_ = systemStatus;
        this.initializeTransient();
    }

    public VSystemStatus(VNode vNode, AS400 aS400) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException, UnsupportedEncodingException, PropertyVetoException {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.parent_ = vNode;
        this.systemStatus_ = new SystemStatus(aS400);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        if (vObjectListener == null) {
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        if (n < 0 || n >= this.detailsChildren_.length) {
            return null;
        }
        this.loadMore(n);
        return this.detailsChildren_[n];
    }

    public int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject vObject) {
        for (int i = 0; i < this.loaded_; ++i) {
            if (this.detailsChildren_[i] != vObject) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        return null;
    }

    public AS400 getSystem() {
        return this.systemStatus_.getSystem();
    }

    public String getText() {
        return description_;
    }

    private synchronized void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.systemStatus_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.systemStatus_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.detailsChildren_ = new VObject[0];
        this.enum_ = null;
        this.loaded_ = -1;
    }

    public boolean isAllowModifyAllPools() {
        return this.allowModifyAllPools_;
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (Trace.isTraceOn() && Trace.isTraceInformationOn()) {
            Trace.log(3, "VSystemStatus: loading");
        }
        this.workingEventSupport_.fireStartWorking();
        Exception exception = null;
        VSystemStatus vSystemStatus = this;
        synchronized (vSystemStatus) {
            for (int i = 0; i < this.loaded_; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = 0;
            try {
                this.systemStatus_.refreshCache();
                this.enum_ = this.systemStatus_.getSystemPools();
                this.detailsChildren_ = new VSystemPool[this.systemStatus_.getPoolsNumber()];
            }
            catch (Exception exception2) {
                exception = exception2;
                this.detailsChildren_ = new VSystemPool[0];
            }
        }
        if (exception != null) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMore(int n) {
        if (n >= this.loaded_) {
            this.workingEventSupport_.fireStartWorking();
            Exception exception = null;
            VSystemStatus vSystemStatus = this;
            synchronized (vSystemStatus) {
                for (int i = this.loaded_; i <= n; ++i) {
                    SystemPool systemPool = (SystemPool)this.enum_.nextElement();
                    VSystemPool vSystemPool = new VSystemPool(systemPool);
                    vSystemPool.setAllowModify(this.allowModifyAllPools_);
                    this.detailsChildren_[i] = vSystemPool;
                    this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                    this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                    this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
                }
            }
            this.loaded_ = n + 1;
            if (exception != null) {
                this.errorEventSupport_.fireError(exception);
            }
            this.workingEventSupport_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        if (vObjectListener == null) {
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        this.systemStatus_.setSystem(aS400);
    }

    public void setAllowModifyAllPools(boolean bl) {
        this.allowModifyAllPools_ = bl;
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return description_;
    }

    static {
        detailsColumnModel_ = null;
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VSystemPool.IDENTIFIER_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(identifierColumnHeader_);
        vTableColumn.setPreferredCharWidth(5);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VSystemPool.POOL_SIZE_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(poolSizeColumnHeader_);
        vTableColumn2.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTableColumn2);
        VTableColumn vTableColumn3 = new VTableColumn(n++, VSystemPool.RESERVED_SIZE_PROPERTY);
        vTableColumn3.setCellRenderer(new VObjectCellRenderer());
        vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn3.setHeaderValue(reservedSizeColumnHeader_);
        vTableColumn3.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTableColumn3);
        VTableColumn vTableColumn4 = new VTableColumn(n++, NAME_PROPERTY);
        vTableColumn4.setCellRenderer(new VObjectCellRenderer());
        vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn4.setHeaderValue(nameColumnHeader_);
        vTableColumn4.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn4);
        VTableColumn vTableColumn5 = new VTableColumn(n++, DESCRIPTION_PROPERTY);
        vTableColumn5.setCellRenderer(new VObjectCellRenderer());
        vTableColumn5.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn5.setHeaderValue(descriptionColumnHeader_);
        vTableColumn5.setPreferredCharWidth(50);
        detailsColumnModel_.addColumn(vTableColumn5);
    }
}

