/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.User;
import com.ibm.as400.access.UserList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.UserListPropertiesPane;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUser;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VUserList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String genericDescription_ = ResourceLoader.getText("USER_LIST_DESCRIPTION");
    private String description_ = genericDescription_;
    private static Icon icon16_ = ResourceLoader.getIcon("VUserList16.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private static Icon icon32_ = ResourceLoader.getIcon("VUserList32.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private static String nameColumnHeader_ = ResourceLoader.getText("USER_USER_NAME");
    private static String descriptionColumnHeader_ = ResourceLoader.getText("USER_DESCRIPTION_PROMPT");
    private static final String allUsersText_ = ResourceLoader.getText("USER_ALL_USERS").trim();
    private static final String allUsersDescription_ = ResourceLoader.getText("USER_ALL_USERS_DES").trim();
    private static final String usersNotInGroupsText_ = ResourceLoader.getText("USER_USERS_NOT_IN_GROUPS").trim();
    private static final String usersNotInGroupsDescription_ = ResourceLoader.getText("USER_USERS_NOT_IN_GROUPS_DES").trim();
    private static final String groupsText_ = ResourceLoader.getText("USER_GROUPS").trim();
    private static final String groupsDescription_ = ResourceLoader.getText("USER_GROUPS_DES").trim();
    private UserList userList_ = null;
    VNode parent_ = null;
    private boolean isLoaded_ = false;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VObject[] detailsChildren_;
    private transient Enumeration enum_;
    private transient int loaded_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VUserList() {
        this.userList_ = new UserList();
        this.initializeTransient();
    }

    public VUserList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.userList_ = new UserList(aS400);
        this.initializeTransient();
    }

    public VUserList(UserList userList, String string) {
        this.description_ = string;
        this.userList_ = userList;
        this.initializeTransient();
    }

    public VUserList(VNode vNode, AS400 aS400) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.parent_ = vNode;
        this.userList_ = new UserList(aS400);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    private String getDescription(UserList userList) {
        String string = userList.getUserInfo();
        String string2 = userList.getGroupInfo();
        if (string.toLowerCase().equals("*all") && string2.toLowerCase().equals("*none")) {
            return allUsersDescription_;
        }
        if (string.toLowerCase().equals("*member") && string2.toLowerCase().equals("*nogroup")) {
            return usersNotInGroupsDescription_;
        }
        if (string.toLowerCase().equals("*group") && string2.toLowerCase().equals("*none")) {
            return groupsDescription_;
        }
        Trace.log(2, "userInfo or groupInfo's value is invalid");
        Trace.log(3, "userInfo : " + string);
        Trace.log(3, "groupInfo : " + string2);
        return "";
    }

    public VObject getDetailsChildAt(int n) {
        if (n < 0 || n >= this.detailsChildren_.length) {
            return null;
        }
        this.loadMore(n);
        return this.detailsChildren_[n];
    }

    public int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject vObject) {
        for (int i = 0; i < this.loaded_; ++i) {
            if (!this.detailsChildren_[i].equals(vObject)) continue;
            return i;
        }
        return -1;
    }

    public String getGroupInfo() {
        return this.userList_.getGroupInfo();
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public int getIndex(TreeNode treeNode) {
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == NAME_PROPERTY) {
            return this;
        }
        if (object == DESCRIPTION_PROPERTY) {
            return this.getDescription(this.userList_);
        }
        return null;
    }

    public AS400 getSystem() {
        return this.userList_.getSystem();
    }

    public String getText() {
        return this.description_;
    }

    public String getUserInfo() {
        return this.userList_.getUserInfo();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.userList_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.userList_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.detailsChildren_ = new VObject[0];
        this.enum_ = null;
        this.loaded_ = -1;
        this.propertiesPane_ = new UserListPropertiesPane(this, this.userList_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (Trace.isTraceOn()) {
            Trace.log(3, "Loading users for user list.");
        }
        this.workingEventSupport_.fireStartWorking();
        Exception exception = null;
        try {
            this.enum_ = this.userList_.getUsers();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        VUserList vUserList = this;
        synchronized (vUserList) {
            for (int i = 0; i < this.loaded_; ++i) {
                this.detailsChildren_[i].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].removeWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = 0;
            this.detailsChildren_ = exception == null ? new VUser[this.userList_.getLength()] : new VUser[0];
        }
        this.isLoaded_ = true;
        if (exception != null) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
        this.objectEventSupport_.fireObjectChanged(this, true);
    }

    private void loadMore(int n) {
        if (n >= this.loaded_) {
            this.workingEventSupport_.fireStartWorking();
            Exception exception = null;
            for (int i = this.loaded_; i <= n; ++i) {
                User user = (User)this.enum_.nextElement();
                this.detailsChildren_[i] = new VUser(user);
                this.detailsChildren_[i].addErrorListener(this.errorEventSupport_);
                this.detailsChildren_[i].addVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[i].addWorkingListener(this.workingEventSupport_);
            }
            this.loaded_ = n + 1;
            if (exception != null) {
                this.errorEventSupport_.fireError(exception);
            }
            this.workingEventSupport_.fireStopWorking();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setGroupInfo(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("groupInfo");
        }
        this.userList_.setGroupInfo(string);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.userList_.getSystem();
        AS400 aS4003 = aS400;
        this.vetoableChangeSupport_.fireVetoableChange("system", aS4002, aS4003);
        if (aS4002 != aS4003) {
            try {
                this.userList_.setSystem(aS400);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.propertyChangeSupport_.firePropertyChange("system", aS4002, aS4003);
    }

    public void setUserInfo(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("userInfo");
        }
        this.userList_.setUserInfo(string);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return this.description_;
    }

    static {
        detailsColumnModel_ = null;
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(15);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, DESCRIPTION_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(descriptionColumnHeader_);
        vTableColumn2.setPreferredCharWidth(70);
        detailsColumnModel_.addColumn(vTableColumn2);
    }
}

