/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Array
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private AS400DataType arrayType = null;
    private int arraySize = -1;
    private boolean allowChanges = true;

    public AS400Array() {
    }

    public AS400Array(AS400DataType aS400DataType, int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("size (" + String.valueOf(n) + ")", 1);
        }
        this.allowChanges = false;
        this.arrayType = (AS400DataType)aS400DataType.clone();
        this.arraySize = n;
    }

    public Object clone() {
        try {
            AS400Array aS400Array = (AS400Array)super.clone();
            aS400Array.arrayType = this.arrayType == null ? null : (AS400DataType)this.arrayType.clone();
            return aS400Array;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6, (Throwable)cloneNotSupportedException);
        }
    }

    public int getByteLength() {
        AS400DataType aS400DataType = this.arrayType;
        int n = this.arraySize;
        if (aS400DataType == null) {
            throw new ExtendedIllegalStateException("Type", 4);
        }
        if (n == -1) {
            throw new ExtendedIllegalStateException("NumberOfElements", 4);
        }
        this.allowChanges = false;
        return this.arraySize * this.arrayType.getByteLength();
    }

    public Object getDefaultValue() {
        int n = this.arraySize == -1 ? 0 : this.arraySize;
        Object[] objectArray = new Object[n];
        Object object = this.arrayType == null ? null : this.arrayType.getDefaultValue();
        for (int i = 0; i < n; ++i) {
            objectArray[i] = object;
        }
        return objectArray;
    }

    public int getInstanceType() {
        return 0;
    }

    public Class getJavaType() {
        return Object[].class;
    }

    public int getNumberOfElements() {
        return this.arraySize;
    }

    public AS400DataType getType() {
        return this.arrayType == null ? null : (AS400DataType)this.arrayType.clone();
    }

    public void setNumberOfElements(int n) {
        if (!this.allowChanges) {
            throw new ExtendedIllegalStateException("NumberOfElements", 5);
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("size (" + String.valueOf(n) + ")", 1);
        }
        this.arraySize = n;
    }

    public void setType(AS400DataType aS400DataType) {
        if (!this.allowChanges) {
            throw new ExtendedIllegalStateException("Type", 5);
        }
        this.arrayType = (AS400DataType)aS400DataType.clone();
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.getByteLength()];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        AS400DataType aS400DataType = this.arrayType;
        int n2 = this.arraySize;
        if (aS400DataType == null) {
            throw new ExtendedIllegalStateException("Type", 4);
        }
        if (n2 == -1) {
            throw new ExtendedIllegalStateException("NumberOfElements", 4);
        }
        this.allowChanges = false;
        Object[] objectArray = (Object[])object;
        if (objectArray.length != n2) {
            throw new ExtendedIllegalArgumentException("javaValue (" + object.toString() + ")", 1);
        }
        for (int i = 0; i < n2; ++i) {
            n += aS400DataType.toBytes(objectArray[i], byArray, n);
        }
        return aS400DataType.getByteLength() * n2;
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        AS400DataType aS400DataType = this.arrayType;
        int n2 = this.arraySize;
        if (aS400DataType == null) {
            throw new ExtendedIllegalStateException("Type", 4);
        }
        if (n2 == -1) {
            throw new ExtendedIllegalStateException("NumberOfElements", 4);
        }
        this.allowChanges = false;
        int n3 = aS400DataType.getByteLength();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = aS400DataType.toObject(byArray, n);
            n += n3;
        }
        return objectArray;
    }
}

