/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Bin8
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 8;
    private static final long defaultValue = 0L;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6, (Throwable)cloneNotSupportedException);
        }
    }

    public int getByteLength() {
        return 8;
    }

    public Object getDefaultValue() {
        return new Long(0L);
    }

    public int getInstanceType() {
        return 3;
    }

    public Class getJavaType() {
        return Long.class;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[8];
        BinaryConverter.longToByteArray((Long)object, byArray, 0);
        return byArray;
    }

    public byte[] toBytes(long l) {
        byte[] byArray = new byte[8];
        BinaryConverter.longToByteArray(l, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        BinaryConverter.longToByteArray((Long)object, byArray, 0);
        return 8;
    }

    public int toBytes(long l, byte[] byArray) {
        BinaryConverter.longToByteArray(l, byArray, 0);
        return 8;
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        BinaryConverter.longToByteArray((Long)object, byArray, n);
        return 8;
    }

    public int toBytes(long l, byte[] byArray, int n) {
        BinaryConverter.longToByteArray(l, byArray, n);
        return 8;
    }

    public long toLong(byte[] byArray) {
        return BinaryConverter.byteArrayToLong(byArray, 0);
    }

    public long toLong(byte[] byArray, int n) {
        return BinaryConverter.byteArrayToLong(byArray, n);
    }

    public Object toObject(byte[] byArray) {
        return new Long(BinaryConverter.byteArrayToLong(byArray, 0));
    }

    public Object toObject(byte[] byArray, int n) {
        return new Long(BinaryConverter.byteArrayToLong(byArray, n));
    }
}

