/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400ByteArray
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int length;
    private static final int defaultValue = 0;

    public AS400ByteArray(int n) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("length (" + String.valueOf(n) + ")", 1);
        }
        this.length = n;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6, (Throwable)cloneNotSupportedException);
        }
    }

    public int getByteLength() {
        return this.length;
    }

    public Object getDefaultValue() {
        return new byte[0];
    }

    public int getInstanceType() {
        return 4;
    }

    public Class getJavaType() {
        return byte[].class;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[this.length];
        this.toBytes(object, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        return this.toBytes(object, byArray, 0);
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        int n2 = this.length;
        byte[] byArray2 = (byte[])object;
        int n3 = n2 < byArray2.length ? n2 : byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n, n3);
        for (int i = byArray2.length; i < n2; ++i) {
            byArray[n + i] = 0;
        }
        return n2;
    }

    public Object toObject(byte[] byArray) {
        return this.toObject(byArray, 0);
    }

    public Object toObject(byte[] byArray, int n) {
        int n2 = this.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }
}

