/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Float8
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 8;
    private static final double defaultValue = 0.0;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.log(2, "Unexpected cloning error", (Throwable)cloneNotSupportedException);
            throw new InternalErrorException(6, (Throwable)cloneNotSupportedException);
        }
    }

    public int getByteLength() {
        return 8;
    }

    public Object getDefaultValue() {
        return new Double(0.0);
    }

    public int getInstanceType() {
        return 6;
    }

    public Class getJavaType() {
        return Double.class;
    }

    public byte[] toBytes(Object object) {
        byte[] byArray = new byte[8];
        BinaryConverter.doubleToByteArray((Double)object, byArray, 0);
        return byArray;
    }

    public byte[] toBytes(double d) {
        byte[] byArray = new byte[8];
        BinaryConverter.doubleToByteArray(d, byArray, 0);
        return byArray;
    }

    public int toBytes(Object object, byte[] byArray) {
        BinaryConverter.doubleToByteArray((Double)object, byArray, 0);
        return 8;
    }

    public int toBytes(double d, byte[] byArray) {
        BinaryConverter.doubleToByteArray(d, byArray, 0);
        return 8;
    }

    public int toBytes(Object object, byte[] byArray, int n) {
        BinaryConverter.doubleToByteArray((Double)object, byArray, n);
        return 8;
    }

    public int toBytes(double d, byte[] byArray, int n) {
        BinaryConverter.doubleToByteArray(d, byArray, n);
        return 8;
    }

    public double toDouble(byte[] byArray) {
        return BinaryConverter.byteArrayToDouble(byArray, 0);
    }

    public double toDouble(byte[] byArray, int n) {
        return BinaryConverter.byteArrayToDouble(byArray, n);
    }

    public Object toObject(byte[] byArray) {
        return new Double(BinaryConverter.byteArrayToDouble(byArray, 0));
    }

    public Object toObject(byte[] byArray, int n) {
        return new Double(BinaryConverter.byteArrayToDouble(byArray, n));
    }
}

