/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCPooledConnection;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ToolboxWrapper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.ConnectionEvent;

public class AS400JDBCConnectionHandle
extends ToolboxWrapper
implements Connection {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCPooledConnection pooledConnection_ = null;
    private AS400JDBCConnection connection_ = null;

    AS400JDBCConnectionHandle(AS400JDBCPooledConnection aS400JDBCPooledConnection, AS400JDBCConnection aS400JDBCConnection) {
        if (aS400JDBCPooledConnection == null) {
            throw new NullPointerException("pooledConnection");
        }
        this.pooledConnection_ = aS400JDBCPooledConnection;
        if (aS400JDBCConnection == null) {
            throw new NullPointerException("connection");
        }
        this.connection_ = aS400JDBCConnection;
    }

    void invalidate() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "invalidate()");
        }
        this.connection_ = null;
        this.pooledConnection_ = null;
    }

    void checkAccess(JDSQLStatement jDSQLStatement) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.checkAccess(jDSQLStatement);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    void checkOpen() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.checkOpen();
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public void clearWarnings() throws SQLException {
        this.validateConnection();
        this.connection_.clearWarnings();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "close()");
        }
        if (this.connection_ == null) {
            if (!JDTrace.isTraceOn()) return;
            JDTrace.logInformation(this, "close() returning because connection_ is null");
            return;
        }
        try {
            try {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "close() calling connection_.pseudoClosed " + this.connection_.getServerJobIdentifier());
                }
                this.connection_.pseudoClose();
            }
            catch (SQLException sQLException) {
                if (JDTrace.isTraceOn()) {
                    JDTrace.logInformation(this, "close() calling fireEventIfErrorFatal");
                }
                this.fireEventIfErrorFatal(sQLException);
                throw sQLException;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "close() calling pooledConnection_.fireConnectionCloseEvent ");
            }
            this.pooledConnection_.fireConnectionCloseEvent(new ConnectionEvent(this.pooledConnection_));
            this.connection_ = null;
            this.pooledConnection_ = null;
            throw throwable;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "close() calling pooledConnection_.fireConnectionCloseEvent ");
        }
        this.pooledConnection_.fireConnectionCloseEvent(new ConnectionEvent(this.pooledConnection_));
        this.connection_ = null;
        this.pooledConnection_ = null;
    }

    public void commit() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.commit();
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement() throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement(n, n2);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.validateConnection();
        return this.connection_.createStatement(n, n2, n3);
    }

    protected void finalize() throws Throwable {
        block2: {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                if (!JDTrace.isTraceOn()) break block2;
                JDTrace.logInformation(this, "Finalize on a connection handle threw exception: " + sQLException.getMessage());
            }
        }
    }

    private final void fireEventIfErrorFatal(SQLException sQLException) {
        String string = sQLException.getSQLState();
        if (string.equals("42505") || string.equals("08003") || string.equals("08004") || string.equals("08001") || string.equals("08S01") || string.equals("HY000") || string.equals("HY001") || string.equals("42705")) {
            this.pooledConnection_.fatalConnectionErrorOccurred_ = true;
            this.pooledConnection_.fireConnectionErrorEvent(new ConnectionEvent(this.pooledConnection_, sQLException));
        }
    }

    AS400Impl getAS400() throws SQLException {
        this.validateConnection();
        return this.connection_.getAS400();
    }

    public boolean getAutoCommit() throws SQLException {
        this.validateConnection();
        return this.connection_.getAutoCommit();
    }

    public int getConcurrentAccessResolution() throws SQLException {
        this.validateConnection();
        return this.connection_.getConcurrentAccessResolution();
    }

    public String getCatalog() throws SQLException {
        this.validateConnection();
        return this.connection_.getCatalog();
    }

    ConvTable getConverter() throws SQLException {
        this.validateConnection();
        return this.connection_.getConverter();
    }

    ConvTable getConverter(int n) throws SQLException {
        this.validateConnection();
        return this.connection_.getConverter(n);
    }

    String getDefaultSchema() throws SQLException {
        this.validateConnection();
        return this.connection_.getDefaultSchema();
    }

    public int getHoldability() throws SQLException {
        this.validateConnection();
        return this.connection_.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateConnection();
        return this.connection_.getMetaData();
    }

    JDProperties getProperties() throws SQLException {
        this.validateConnection();
        return this.connection_.getProperties();
    }

    public String getServerJobIdentifier() throws SQLException {
        this.validateConnection();
        return this.connection_.getServerJobIdentifier();
    }

    public AS400 getSystem() {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Warning: returning pooled connection's AS400 object directly to user.");
        }
        return this.connection_.getSystem();
    }

    public int getTransactionIsolation() throws SQLException {
        this.validateConnection();
        return this.connection_.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.validateConnection();
        return this.connection_.getTypeMap();
    }

    String getURL() throws SQLException {
        this.validateConnection();
        return this.connection_.getURL();
    }

    String getUserName() throws SQLException {
        this.validateConnection();
        return this.connection_.getUserName();
    }

    int getVRM() throws SQLException {
        this.validateConnection();
        return this.connection_.getVRM();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateConnection();
        return this.connection_.getWarnings();
    }

    boolean isCursorNameUsed(String string) throws SQLException {
        this.validateConnection();
        return this.connection_.isCursorNameUsed(string);
    }

    public boolean isClosed() throws SQLException {
        return this.connection_ == null;
    }

    public boolean isReadOnly() throws SQLException {
        this.validateConnection();
        return this.connection_.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        this.validateConnection();
        return this.connection_.nativeSQL(string);
    }

    void notifyClose(AS400JDBCStatement aS400JDBCStatement, int n) throws SQLException {
        this.validateConnection();
        this.connection_.notifyClose(aS400JDBCStatement, n);
    }

    void postWarning(SQLWarning sQLWarning) throws SQLException {
        this.validateConnection();
        this.connection_.postWarning(sQLWarning);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.validateConnection();
        return this.connection_.prepareStatement(string, stringArray);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public void rollback() throws SQLException {
        this.validateConnection();
        try {
            this.connection_.rollback();
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    void send(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(dBBaseRequestDS);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    void send(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(dBBaseRequestDS, n);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    void send(DBBaseRequestDS dBBaseRequestDS, int n, boolean bl) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.send(dBBaseRequestDS, n, bl);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        this.validateConnection();
        try {
            return this.connection_.sendAndReceive(dBBaseRequestDS);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        this.validateConnection();
        try {
            return this.connection_.sendAndReceive(dBBaseRequestDS, n);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public void setConcurrentAccessResolution(int n) throws SQLException {
        this.validateConnection();
        this.connection_.setConcurrentAccessResolution(n);
    }

    public void setDB2eWLMCorrelator(byte[] byArray) throws SQLException {
        this.validateConnection();
        this.connection_.setDB2eWLMCorrelator(byArray);
    }

    public void setCatalog(String string) throws SQLException {
        this.validateConnection();
        this.connection_.setCatalog(string);
    }

    void setDRDA(boolean bl) throws SQLException {
        this.validateConnection();
        this.connection_.setDRDA(bl);
    }

    public void setHoldability(int n) throws SQLException {
        this.validateConnection();
        this.connection_.setHoldability(n);
    }

    void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400 aS400, Properties properties) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setProperties(jDDataSourceURL, jDProperties, aS400, properties);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400Impl aS400Impl) throws SQLException {
        this.validateConnection();
        try {
            this.connection_.setProperties(jDDataSourceURL, jDProperties, aS400Impl);
        }
        catch (SQLException sQLException) {
            this.fireEventIfErrorFatal(sQLException);
            throw sQLException;
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.validateConnection();
        this.connection_.setReadOnly(bl);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.validateConnection();
        return this.connection_.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.validateConnection();
        return this.connection_.setSavepoint(string);
    }

    void setSystem(AS400 aS400) throws SQLException {
        this.validateConnection();
        this.connection_.setSystem(aS400);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.validateConnection();
        this.connection_.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validateConnection();
        this.connection_.setTypeMap(map);
    }

    public String toString() {
        if (this.connection_ != null) {
            return this.connection_.toString();
        }
        return super.toString();
    }

    boolean useExtendedFormats() throws SQLException {
        this.validateConnection();
        return this.connection_.useExtendedFormats();
    }

    private void validateConnection() throws SQLException {
        if (this.connection_ == null) {
            JDTrace.logInformation(this, "The connection is closed.");
            JDError.throwSQLException("08003");
        }
    }

    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.Connection"};
    }

    public boolean isValid(int n) throws SQLException {
        this.validateConnection();
        return this.connection_.isValid(n);
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.validateConnection();
        }
        catch (SQLException sQLException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), null);
            throw sQLClientInfoException;
        }
        this.connection_.setClientInfo(properties);
    }

    public String getClientInfo(String string) throws SQLException {
        this.validateConnection();
        return this.connection_.getClientInfo(string);
    }

    public Properties getClientInfo() throws SQLException {
        this.validateConnection();
        return this.connection_.getClientInfo();
    }

    public Clob createClob() throws SQLException {
        this.validateConnection();
        return this.connection_.createClob();
    }

    public Blob createBlob() throws SQLException {
        this.validateConnection();
        return this.connection_.createBlob();
    }

    public NClob createNClob() throws SQLException {
        this.validateConnection();
        return this.connection_.createNClob();
    }

    public SQLXML createSQLXML() throws SQLException {
        this.validateConnection();
        return this.connection_.createSQLXML();
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.validateConnection();
        return this.connection_.createArrayOf(string, objectArray);
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.validateConnection();
        return this.connection_.createStruct(string, objectArray);
    }

    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.validateConnection();
        }
        catch (SQLException sQLException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), null);
            throw sQLClientInfoException;
        }
        this.connection_.setClientInfo(string, string2);
    }

    public void setDBHostServerTrace(boolean bl) throws SQLException {
        try {
            this.validateConnection();
        }
        catch (SQLException sQLException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), null);
            throw sQLClientInfoException;
        }
        this.connection_.setDBHostServerTrace(bl);
    }

    public void abort(Executor executor) throws SQLException {
        this.validateConnection();
        this.connection_.abort(executor);
    }

    public int getNetworkTimeout() throws SQLException {
        this.validateConnection();
        return this.connection_.getNetworkTimeout();
    }

    public String getSchema() throws SQLException {
        this.validateConnection();
        return this.connection_.getSchema();
    }

    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.validateConnection();
        this.connection_.setNetworkTimeout(executor, n);
    }

    public void setSchema(String string) throws SQLException {
        this.validateConnection();
        this.connection_.setSchema(string);
    }
}

