/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DDMACCSECReplyDataStream;
import com.ibm.as400.access.DDMACCSECRequestDataStream;
import com.ibm.as400.access.DDMASPReplyDataStream;
import com.ibm.as400.access.DDMASPRequestDataStream;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.DDMEXCSATReplyDataStream;
import com.ibm.as400.access.DDMEXCSATRequestDataStream;
import com.ibm.as400.access.DDMSECCHKReplyDataStream;
import com.ibm.as400.access.DDMSECCHKRequestDataStream;
import com.ibm.as400.access.DDMTerm;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.util.Hashtable;

public class ClassDecoupler {
    public static boolean forceENCUSRPWD = false;
    public static boolean forceAES = false;

    static void freeDBReplyStream(DataStream dataStream) {
        if (dataStream instanceof DBReplyRequestedDS) {
            ((DBReplyRequestedDS)dataStream).returnToPool();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object[] connectDDMPhase1(OutputStream outputStream, InputStream inputStream, boolean bl, int n, int n2) throws ServerStartupException, IOException {
        int n3;
        KeyPair keyPair = null;
        String string = null;
        DDMEXCSATRequestDataStream dDMEXCSATRequestDataStream = new DDMEXCSATRequestDataStream();
        if (Trace.traceOn_) {
            dDMEXCSATRequestDataStream.setConnectionID(n2);
        }
        dDMEXCSATRequestDataStream.write(outputStream);
        DDMEXCSATReplyDataStream dDMEXCSATReplyDataStream = new DDMEXCSATReplyDataStream();
        if (Trace.traceOn_) {
            dDMEXCSATReplyDataStream.setConnectionID(n2);
        }
        dDMEXCSATReplyDataStream.read(inputStream);
        if (!dDMEXCSATReplyDataStream.checkReply()) {
            throw new ServerStartupException(1);
        }
        byte[] byArray = dDMEXCSATReplyDataStream.getEXTNAM();
        if (Trace.traceOn_) {
            Trace.log(1, "DDM EXCSAT successful.");
        }
        if (forceENCUSRPWD) {
            n3 = 4;
            string = "TRUE";
            try {
                if (!forceAES) {
                    try {
                        keyPair = DDMTerm.getDESKeyPair();
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        if (Trace.traceOn_) {
                            Trace.log(1, "ClassDecoupler: Upgrading to AES due to InvalidAlgorithmParameterException ", (Throwable)invalidAlgorithmParameterException);
                        }
                        forceAES = true;
                        keyPair = DDMTerm.getAESKeyPair();
                    }
                }
                keyPair = DDMTerm.getAESKeyPair();
            }
            catch (GeneralSecurityException generalSecurityException) {
                ServerStartupException serverStartupException = new ServerStartupException(1);
                serverStartupException.initCause(generalSecurityException);
                throw serverStartupException;
            }
        } else {
            n3 = n;
        }
        DDMACCSECRequestDataStream dDMACCSECRequestDataStream = new DDMACCSECRequestDataStream(bl, n3, null, keyPair, forceAES);
        if (Trace.traceOn_) {
            dDMACCSECRequestDataStream.setConnectionID(n2);
        }
        dDMACCSECRequestDataStream.write(outputStream);
        DDMACCSECReplyDataStream dDMACCSECReplyDataStream = new DDMACCSECReplyDataStream();
        if (Trace.traceOn_) {
            dDMACCSECReplyDataStream.setConnectionID(n2);
        }
        dDMACCSECReplyDataStream.read(inputStream);
        if (!dDMACCSECReplyDataStream.checkReply(n3)) {
            n3 = 4;
            if (!dDMACCSECReplyDataStream.checkReplyForEUSRIDPWD(n)) throw new ServerStartupException(1);
            try {
                if (!forceAES) {
                    try {
                        keyPair = DDMTerm.getDESKeyPair();
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        if (Trace.traceOn_) {
                            Trace.log(1, "ClassDecoupler: Upgrading to AES due to InvalidAlgorithmParameterException ", (Throwable)invalidAlgorithmParameterException);
                        }
                        forceAES = true;
                        keyPair = DDMTerm.getAESKeyPair();
                    }
                } else {
                    keyPair = DDMTerm.getAESKeyPair();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                ServerStartupException serverStartupException = new ServerStartupException(1);
                serverStartupException.initCause(generalSecurityException);
                throw serverStartupException;
            }
            dDMACCSECRequestDataStream = new DDMACCSECRequestDataStream(bl, n3, null, keyPair, forceAES);
            if (Trace.traceOn_) {
                dDMACCSECRequestDataStream.setConnectionID(n2);
            }
            dDMACCSECRequestDataStream.write(outputStream);
            dDMACCSECReplyDataStream = new DDMACCSECReplyDataStream();
            if (Trace.traceOn_) {
                dDMACCSECReplyDataStream.setConnectionID(n2);
            }
            dDMACCSECReplyDataStream.read(inputStream);
            if (dDMACCSECReplyDataStream.aesUpgrade()) {
                try {
                    if (Trace.traceOn_) {
                        Trace.log(1, "ClassDecoupler: Upgrading to AES due to server negotiation");
                    }
                    keyPair = DDMTerm.getAESKeyPair();
                    forceAES = true;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    ServerStartupException serverStartupException = new ServerStartupException(1);
                    serverStartupException.initCause(generalSecurityException);
                    throw serverStartupException;
                }
                dDMACCSECRequestDataStream = new DDMACCSECRequestDataStream(bl, n3, null, keyPair, forceAES);
                if (Trace.traceOn_) {
                    dDMACCSECRequestDataStream.setConnectionID(n2);
                }
                dDMACCSECRequestDataStream.write(outputStream);
                dDMACCSECReplyDataStream = new DDMACCSECReplyDataStream();
                if (Trace.traceOn_) {
                    dDMACCSECReplyDataStream.setConnectionID(n2);
                }
                dDMACCSECReplyDataStream.read(inputStream);
            }
            if (!dDMACCSECReplyDataStream.checkReplyForEUSRIDPWD(n)) {
                throw new ServerStartupException(1);
            }
            string = "TRUE";
        } else if (dDMACCSECReplyDataStream.aesUpgrade()) {
            try {
                if (Trace.traceOn_) {
                    Trace.log(1, "ClassDecoupler: Upgrading to AES due to server negotiation");
                }
                keyPair = DDMTerm.getAESKeyPair();
                forceAES = true;
            }
            catch (GeneralSecurityException generalSecurityException) {
                ServerStartupException serverStartupException = new ServerStartupException(1);
                serverStartupException.initCause(generalSecurityException);
                throw serverStartupException;
            }
            dDMACCSECRequestDataStream = new DDMACCSECRequestDataStream(bl, n3, null, keyPair, forceAES);
            if (Trace.traceOn_) {
                dDMACCSECRequestDataStream.setConnectionID(n2);
            }
            dDMACCSECRequestDataStream.write(outputStream);
            dDMACCSECReplyDataStream = new DDMACCSECReplyDataStream();
            if (Trace.traceOn_) {
                dDMACCSECReplyDataStream.setConnectionID(n2);
            }
            dDMACCSECReplyDataStream.read(inputStream);
            if (!dDMACCSECReplyDataStream.checkReplyForEUSRIDPWD(n)) {
                throw new ServerStartupException(1);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM ACCSEC successful.");
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (string != null) {
            byArray3 = dDMACCSECReplyDataStream.getServerSeed();
            return new Object[]{byArray2, byArray3, byArray, string, keyPair};
        } else {
            if (n != 0 && n3 != 4) return new Object[]{byArray2, byArray3, byArray, string, keyPair};
            byArray2 = dDMACCSECRequestDataStream.getClientSeed();
            byArray3 = dDMACCSECReplyDataStream.getServerSeed();
        }
        return new Object[]{byArray2, byArray3, byArray, string, keyPair};
    }

    static void connectDDMPhase2(OutputStream outputStream, InputStream inputStream, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, String string, String string2, int n2) throws ServerStartupException, IOException, AS400SecurityException {
        DDMSECCHKRequestDataStream dDMSECCHKRequestDataStream = new DDMSECCHKRequestDataStream(byArray, byArray2, byArray3, n);
        if (Trace.traceOn_) {
            dDMSECCHKRequestDataStream.setConnectionID(n2);
        }
        dDMSECCHKRequestDataStream.write(outputStream);
        DDMSECCHKReplyDataStream dDMSECCHKReplyDataStream = new DDMSECCHKReplyDataStream();
        if (Trace.traceOn_) {
            dDMSECCHKReplyDataStream.setConnectionID(n2);
        }
        dDMSECCHKReplyDataStream.read(inputStream);
        if (!dDMSECCHKReplyDataStream.checkReply()) {
            int n3 = dDMSECCHKReplyDataStream.getErrorCode();
            switch (n3) {
                case 14: {
                    throw new AS400SecurityException(7);
                }
                case 15: {
                    throw new AS400SecurityException(8);
                }
                case 16: {
                    throw new AS400SecurityException(22);
                }
                case 19: {
                    throw new AS400SecurityException(32);
                }
                case 18: {
                    throw new AS400SecurityException(30);
                }
                case 20: {
                    throw new AS400SecurityException(31);
                }
                case 21: {
                    throw new AS400SecurityException(13);
                }
                case 9: {
                    throw new AS400SecurityException(24);
                }
                case 10: {
                    throw new AS400SecurityException(24);
                }
            }
            throw new ServerStartupException(1);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "DDM SECCHK successful.");
        }
        if (byArray3 != null) {
            DDMASPRequestDataStream dDMASPRequestDataStream = new DDMASPRequestDataStream(byArray3);
            if (Trace.traceOn_) {
                dDMASPRequestDataStream.setConnectionID(n2);
            }
            dDMASPRequestDataStream.write(outputStream);
            DDMASPReplyDataStream dDMASPReplyDataStream = new DDMASPReplyDataStream();
            if (Trace.traceOn_) {
                dDMASPReplyDataStream.setConnectionID(n2);
            }
            dDMASPReplyDataStream.read(inputStream);
            if (!dDMASPReplyDataStream.checkReply()) {
                if (Trace.traceOn_) {
                    Trace.log(2, "RDB name '" + string + "' is not a valid IASP name on system '" + string2 + "'.");
                }
                throw new ServerStartupException(1);
            }
            if (Trace.traceOn_) {
                Trace.log(1, "DDM RDB name '" + string + "' verified.");
            }
        }
    }

    static DataStream constructDDMDataStream(InputStream inputStream, Hashtable hashtable, AS400ImplRemote aS400ImplRemote, int n) throws IOException {
        return DDMDataStream.construct(inputStream, hashtable, aS400ImplRemote, n);
    }

    static {
        String string = System.getProperty("com.ibm.as400.access.DDMPWDRQD");
        if (string != null && (string = string.toUpperCase()).equals("ENCUSRPWD")) {
            forceENCUSRPWD = true;
        }
        if ((string = System.getProperty("com.ibm.as400.access.DDMENCALC")) != null && (string = string.toUpperCase()).equals("AES")) {
            forceAES = true;
        }
    }
}

