/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Copyright;
import com.ibm.as400.access.NLSTableDownload;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class GenerateConverterTable {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    private static final int MAX_SURROGATE_LENGTH = 2000;
    private static final int MAX_TO_EBCDIC_LENGTH = 20000;
    static AS400 sys = null;
    static Connection connection_ = null;
    static boolean compress_ = true;
    static boolean codePointPerLine_ = false;
    static boolean ascii_ = false;
    static boolean bidi_ = false;
    static boolean showOffsets_ = false;
    static boolean useJdbc_ = false;
    private static final char repSig = '\uffff';
    private static final char cic_ = '\uffff';
    private static final char rampSig = '\ufffe';
    private static final char ric_ = '\ufffe';
    private static final char hbSig = '\u0000';
    private static final char pad = '\u0000';
    static int numRepeats;
    static int numRamps;
    static int hbRepeats;
    static int charRepeats;

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: java com.ibm.as400.access.GenerateConverterTable system uid pwd [-nocompress] [-ascii] [-bidi] [-showOffsets] [-codePointPerLine] [-useJdbc] ccsid [ccsid2] [ccsid3] [ccsid4] ...");
            System.exit(0);
        }
        try {
            sys = new AS400(stringArray[0], stringArray[1], stringArray[2]);
            sys.connectService(6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        int n = 3;
        if (stringArray[n].equals("-nocompress")) {
            compress_ = false;
            ++n;
        }
        if (stringArray[n].equals("-ascii")) {
            ascii_ = true;
            ++n;
        }
        if (stringArray[n].equals("-bidi")) {
            bidi_ = true;
            ++n;
        }
        if (stringArray[n].equals("-showOffsets")) {
            showOffsets_ = true;
            ++n;
        }
        if (stringArray[n].equals("-codePointPerLine")) {
            codePointPerLine_ = true;
            ++n;
        }
        if (stringArray[n].equals("-useJdbc")) {
            useJdbc_ = true;
            try {
                Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                connection_ = DriverManager.getConnection("jdbc:as400:" + stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
            ++n;
        }
        for (int i = n; i < stringArray.length; ++i) {
            GenerateConverterTable.go(new Integer(stringArray[i]));
        }
    }

    static String formattedChar(char c) {
        int n = 0xFFFF & c;
        String string = "\\u";
        if (n < 16) {
            string = string + "0";
        }
        if (n < 256) {
            string = string + "0";
        }
        if (n < 4096) {
            string = string + "0";
        }
        string = string + Integer.toHexString(n).toUpperCase();
        return string;
    }

    static void go(int n) {
        Object object;
        char[] cArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object2 = new char[]{};
        char[] cArray2 = new char[]{};
        char[] cArray3 = new char[]{};
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        boolean bl = false;
        int n7 = 2;
        int n8 = n;
        try {
            Object object6;
            block131: {
                if (useJdbc_) {
                    if (ConvTable.isMixedCCSID(n8)) {
                        GenerateConverterTable.go(1000000 + n);
                        GenerateConverterTable.go(2000000 + n);
                        return;
                    }
                    Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                    try {
                        bl = n > 2000000 ? true : (n > 1000000 ? false : GenerateConverterTable.jdbcIsDBCS(connection_, n));
                        if (bl) {
                            cArray2 = GenerateConverterTable.jdbcToUnicodeSpacesDBCS(connection_, n);
                            cArray3 = GenerateConverterTable.jdbcToEbcdicDBCS(connection_, n);
                            break block131;
                        }
                        object2 = GenerateConverterTable.jdbcToUnicode(connection_, n);
                        cArray3 = GenerateConverterTable.jdbcToEbcdic(connection_, n);
                    }
                    catch (Exception exception) {
                        System.out.println("Error downloading table using JDBC ");
                        exception.printStackTrace(System.out);
                        System.exit(1);
                    }
                } else {
                    AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)sys.getImpl();
                    NLSTableDownload nLSTableDownload = new NLSTableDownload(aS400ImplRemote);
                    nLSTableDownload.connect();
                    if (n == 1089) {
                        System.out.println("Special case for ccsid 1089.");
                        System.out.println("Retrieving " + n + "->61952 table...");
                        object2 = nLSTableDownload.download(n, 61952, 1);
                    } else if (n == 1376) {
                        object2 = null;
                    } else if (n == 1371) {
                        object2 = null;
                        n7 = 3;
                    } else {
                        System.out.println("Retrieving " + n + "->13488 table...");
                        object2 = nLSTableDownload.download(n, 13488, 1);
                    }
                    if (object2 == null || ((char[])object2).length == 0) {
                        object6 = "";
                        object6 = object2 == null ? "tableToUnicode is null" : "tableToUnicode.length is 0";
                        if (n == 1175) {
                            System.out.println("Aborting since CCSD 1175 failed to download");
                            throw new Exception("Aborting since CCSD 1175 failed to download");
                        }
                        System.out.println(n + " must be double-byte because download failed (" + (String)object6 + "). Performing secondary retrieve of " + n + "->1200 table...");
                        bl = true;
                        nLSTableDownload.disconnect();
                        nLSTableDownload.connect();
                        object2 = nLSTableDownload.download(n, 1200, n7);
                    }
                    nLSTableDownload.disconnect();
                    nLSTableDownload.connect();
                    if (n == 1089) {
                        System.out.println("Special case for ccsid 1089.");
                        System.out.println("Retrieving 61952->" + n + " table...");
                        cArray3 = nLSTableDownload.download(61952, n, 2);
                    } else {
                        System.out.println("Retrieving 1200->" + n + " table...");
                        cArray3 = nLSTableDownload.download(1200, n, 2);
                    }
                }
            }
            System.out.println("  Size: " + ((char[])object2).length + " or " + cArray2.length);
            if (((char[])object2).length > 65536 || cArray2.length > 131072) {
                int n9;
                int n10;
                System.out.println("Size is > 65536 or 131072.  Fixing table");
                int n11 = 0;
                object6 = new char[65536];
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = ((char[])object2).length;
                if (n3 > 0) {
                    for (n10 = 0; n11 < n3 && n10 < 65536; ++n10) {
                        n2 = 0xFFFF & object2[n11];
                        while (n2 >= 65024 && n2 <= 65039) {
                            n2 = 0xFFFF & object2[++n11];
                        }
                        if (n10 > 60586 && n10 <= 60624) {
                            System.out.println("Next=0x" + Integer.toHexString(n10) + " to=" + Integer.toHexString(n2));
                        }
                        n9 = 0;
                        if (n11 + 1 < ((char[])object2).length) {
                            n9 = 0xFFFF & object2[n11 + 1];
                        }
                        if (n2 >= 55296 && n2 <= 57343 || n9 >= 65024 && n9 <= 65039 || n9 == 12442 && n2 != 12441 || n2 != 65533 && n9 == 768 || n2 != 4093 && n2 != 768 && n9 == 769 || n2 == 741 && n9 == 745 || n2 == 745 && n9 == 741) {
                            object6[n10] = 55296;
                            n6 = n10;
                            n5 = 55296;
                            if (object3 == null) {
                                object3 = new char[65536][];
                            }
                            cArray = new char[2];
                            object3[n10] = cArray;
                            cArray[0] = (char)(0xFFFF & object2[n11]);
                            cArray[1] = (char)(0xFFFF & object2[n11 + 1]);
                            n11 += 2;
                            continue;
                        }
                        object6[n10] = (char)n2;
                        if (n2 != 65533) {
                            n6 = n10;
                            n5 = n2;
                        }
                        ++n11;
                    }
                } else {
                    n3 = cArray2.length;
                    while (n11 < n3 && n10 < 65536) {
                        char[] cArray4;
                        n2 = 0;
                        n9 = 0;
                        int n12 = 0;
                        int n13 = 0;
                        int n14 = 0;
                        int n15 = 0;
                        n2 = 0xFFFF & cArray2[n11];
                        if (n != 2001371) {
                            while (n2 >= 65024 && n2 <= 65039) {
                                n2 = 0xFFFF & cArray2[++n11];
                            }
                        }
                        if ((n9 = 0xFFFF & cArray2[n11 + 1]) == 12288) {
                            n15 = 1;
                        } else {
                            n12 = 0xFFFF & cArray2[n11 + 2];
                            if (n12 == 12288) {
                                n15 = 2;
                            } else {
                                n13 = 0xFFFF & cArray2[n11 + 3];
                                if (n13 == 12288) {
                                    n15 = 3;
                                } else {
                                    n14 = 0xFFFF & cArray2[n11 + 4];
                                    if (n14 == 12288) {
                                        n15 = 4;
                                    } else {
                                        throw new Exception("Character count is too large for from=0x" + Integer.toHexString(n11));
                                    }
                                }
                            }
                        }
                        if (n15 == 1) {
                            object6[n10] = (char)n2;
                            n11 += 2;
                        } else if (n15 == 2) {
                            object6[n10] = 55296;
                            if (object3 == null) {
                                object3 = new char[65536][];
                            }
                            cArray4 = new char[2];
                            object3[n10] = cArray4;
                            cArray4[0] = (char)(0xFFFF & n2);
                            cArray4[1] = (char)(0xFFFF & n9);
                            n11 += 3;
                        } else if (n15 == 3) {
                            object6[n10] = 55297;
                            if (object4 == null) {
                                object4 = new char[65536][];
                            }
                            cArray4 = new char[3];
                            object4[n10] = cArray4;
                            cArray4[0] = (char)(0xFFFF & n2);
                            cArray4[1] = (char)(0xFFFF & n9);
                            cArray4[2] = (char)(0xFFFF & n12);
                            n11 += 4;
                        } else if (n15 == 4) {
                            object6[n10] = 55298;
                            if (object5 == null) {
                                object5 = new char[65536][];
                            }
                            cArray4 = new char[4];
                            object5[n10] = cArray4;
                            cArray4[0] = (char)(0xFFFF & n2);
                            cArray4[1] = (char)(0xFFFF & n9);
                            cArray4[2] = (char)(0xFFFF & n12);
                            cArray4[3] = (char)(0xFFFF & n13);
                            n11 += 5;
                        } else {
                            throw new Exception("Character count is invalid " + n15);
                        }
                        ++n10;
                    }
                    while (n10 < 65536) {
                        object6[n10] = 65533;
                        ++n10;
                    }
                }
                object2 = object6;
            } else if (((char[])object2).length == 0) {
                int n16 = cArray2.length / 2;
                object2 = new char[n16];
                for (int i = 0; i < n16; ++i) {
                    object2[i] = cArray2[i * 2];
                }
            }
            System.out.println("  Size: " + cArray3.length);
            if (n7 == 3) {
                int n17;
                char[] cArray5 = new char[65536];
                byte[] byArray = new byte[cArray3.length * 2];
                for (n17 = 0; n17 < cArray3.length; ++n17) {
                    byArray[2 * n17] = (byte)(0xFF & cArray3[n17] >> 8);
                    byArray[2 * n17 + 1] = (byte)(cArray3[n17] & 0xFF);
                }
                n17 = 1;
                n6 = 0;
                for (n5 = 0; n5 < byArray.length; ++n5) {
                    n4 = 0xFF & byArray[n5];
                    while (n5 > 15 && n5 < byArray.length && (n4 == 14 || n4 == 15)) {
                        if (n4 == 14) {
                            n17 = 0;
                            ++n5;
                        } else {
                            n17 = 1;
                            ++n5;
                        }
                        if (n5 >= byArray.length) continue;
                        n4 = 0xFF & byArray[n5];
                    }
                    if (n5 >= byArray.length) continue;
                    if (n17 != 0) {
                        if (n6 >= cArray5.length) continue;
                        cArray5[n6] = (char)n4;
                        ++n6;
                        continue;
                    }
                    if (++n5 >= byArray.length) continue;
                    n3 = 0xFF & byArray[n5];
                    if (n6 >= cArray5.length) continue;
                    if (n6 == 1073) {
                        cArray5[n6] = (char)((n4 << 8) + n3);
                        ++n6;
                        continue;
                    }
                    cArray5[n6] = (char)((n4 << 8) + n3);
                    ++n6;
                }
                while (n6 < cArray5.length) {
                    cArray5[n6] = 65278;
                    ++n6;
                }
                cArray3 = cArray5;
            }
            sys.disconnectAllServices();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        if (n == 290) {
            object2[225] = 8364;
            char c = cArray3[4182];
            cArray3[4182] = c = (char)(0xE100 | c & 0xFF);
        }
        GenerateConverterTable.verifyRoundTrip(object2, cArray3, bl, n, object3, object4, object5);
        System.out.println("****************************************");
        System.out.println("Verify round 2 ");
        System.out.println("****************************************");
        GenerateConverterTable.verifyRoundTrip(object2, cArray3, bl, n, object3, object4, object5);
        if (bl && compress_) {
            System.out.println("Compressing " + n + "->13488 conversion table...");
            char[] cArray6 = GenerateConverterTable.compress(object2);
            System.out.println("Old compression length: " + cArray6.length + " characters.");
            char[] cArray7 = GenerateConverterTable.compressBetter(object2);
            System.out.println("New compression length: " + cArray7.length + " characters.");
            if (cArray7.length > cArray6.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            cArray6 = GenerateConverterTable.decompressBetter(cArray7);
            if (cArray6.length != ((char[])object2).length) {
                int n18;
                System.out.println("Verification failed, lengths not equal: " + cArray6.length + " != " + ((char[])object2).length);
                for (n18 = 0; n18 < cArray6.length && cArray6[n18] == object2[n18]; ++n18) {
                }
                System.out.println("First mismatch at index " + n18 + ": " + cArray6[n18] + " != " + object2[n18]);
            } else {
                boolean bl2 = false;
                for (n6 = 0; n6 < cArray6.length; ++n6) {
                    if (cArray6[n6] == object2[n6]) continue;
                    bl2 = true;
                    System.out.println(n6 + ": " + Integer.toHexString(cArray6[n6]) + " != " + Integer.toHexString(object2[n6]));
                }
                if (bl2) {
                    System.out.println("Mismatches found in table.");
                } else {
                    object2 = cArray7;
                    System.out.println("Table verified.");
                }
            }
        }
        int n19 = n;
        if (n7 == 3) {
            n19 = n + 1100000;
            System.out.println("Create file using " + n19 + " since MIXED CCSID ");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = "ConvTable" + n19 + ".java";
            FileWriter fileWriter = new FileWriter((String)object);
            GenerateConverterTable.writeHeader(fileWriter, n19, sys.getSystemName());
            if (ascii_) {
                fileWriter.write("class ConvTable" + n19 + " extends ConvTableAsciiMap\n{\n");
            } else if (bidi_) {
                fileWriter.write("class ConvTable" + n19 + " extends ConvTableBidiMap\n{\n");
            } else if (bl) {
                fileWriter.write("class ConvTable" + n19 + " extends ConvTableDoubleMap\n{\n");
            } else {
                fileWriter.write("class ConvTable" + n19 + " extends ConvTableSingleMap\n{\n");
            }
            fileWriter.write("  private static char[] toUnicodeArray_;  \n");
            fileWriter.write("  private static final String copyright = \"Copyright (C) 1997-2016 International Business Machines Corporation and others.\";\n");
            fileWriter.write("  // toUnicode_ length is " + ((char[])object2).length + "\n");
            fileWriter.write("  private static final String toUnicode_ = \n");
            System.out.print("Writing table for conversion from " + n + " to 13488... to " + (String)object + "\n");
            GenerateConverterTable.writeTable(fileWriter, object2, 0, ((char[])object2).length);
            fileWriter.write("\n");
            fileWriter.write("\n");
            n5 = 0;
            if (object3 != null) {
                fileWriter.write("\n");
                for (n4 = 0; n4 < ((char[][])object3).length; ++n4) {
                    char[] cArray8 = object3[n4];
                    if (cArray8 == null) continue;
                    ++n5;
                }
                n4 = 0;
                char[][] cArrayArray = new char[n5][];
                for (n2 = 0; n2 < ((char[][])object3).length; ++n2) {
                    char[] cArray9 = object3[n2];
                    if (cArray9 == null) continue;
                    cArray = new char[]{(char)n2, cArray9[0], cArray9[1]};
                    cArrayArray[n4] = cArray;
                    ++n4;
                }
                fileWriter.write("  // Number of surrogateMappings is " + n5 + "\n");
                if (n5 < 2000) {
                    fileWriter.write("  private static final char[][] toUnicodeSurrogateMappings = { \n");
                    System.out.print("Writing surrogate table for conversion from " + n + " to 1200... to " + (String)object + "\n");
                    for (n2 = 0; n2 < cArrayArray.length; ++n2) {
                        char[] cArray10 = cArrayArray[n2];
                        if (cArray10 == null) continue;
                        fileWriter.write("{'" + GenerateConverterTable.formattedChar(cArray10[0]) + "','" + GenerateConverterTable.formattedChar(cArray10[1]) + "','" + GenerateConverterTable.formattedChar(cArray10[2]) + "'},\n");
                    }
                    fileWriter.write("};\n");
                    fileWriter.write("\n");
                    fileWriter.write("\n");
                } else {
                    fileWriter.write("  private static char[][] toUnicodeSurrogateMappings = new char[" + n5 + "][];\n");
                    for (n2 = 0; n2 < n5; n2 += 2000) {
                        fileWriter.write("  private static void initToUnicodeSurrogateMappings" + n2 + "() { \n");
                        fileWriter.write("  char[][] toUnicodeSurrogateMappingsPiece = {\n");
                        for (int i = 0; i < 2000 && i + n2 < n5; ++i) {
                            cArray = cArrayArray[n2 + i];
                            if (cArray == null) continue;
                            fileWriter.write("    {'" + GenerateConverterTable.formattedChar(cArray[0]) + "','" + GenerateConverterTable.formattedChar(cArray[1]) + "','" + GenerateConverterTable.formattedChar(cArray[2]) + "'},\n");
                        }
                        fileWriter.write("  };\n");
                        fileWriter.write("    for (int j = 0; j < toUnicodeSurrogateMappingsPiece.length ; j++) {\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n2 + "+j]= new char[3];\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n2 + "+j][0] = toUnicodeSurrogateMappingsPiece[j][0];\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n2 + "+j][1] = toUnicodeSurrogateMappingsPiece[j][1];\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n2 + "+j][2] = toUnicodeSurrogateMappingsPiece[j][2];\n");
                        fileWriter.write("    }\n");
                        fileWriter.write("  }\n");
                        fileWriter.write("\n");
                        stringBuffer.append("   initToUnicodeSurrogateMappings" + n2 + "();\n");
                    }
                }
            }
            n4 = 0;
            if (object4 != null) {
                int n20;
                int n21;
                fileWriter.write("\n");
                for (n21 = 0; n21 < ((char[][])object4).length; ++n21) {
                    char[] cArray11 = object4[n21];
                    if (cArray11 == null) continue;
                    ++n4;
                }
                n21 = 0;
                char[][] cArrayArray = new char[n4][];
                for (n20 = 0; n20 < ((char[][])object4).length; ++n20) {
                    cArray = object4[n20];
                    if (cArray == null) continue;
                    char[] cArray12 = new char[]{(char)n20, cArray[0], cArray[1], cArray[2]};
                    cArrayArray[n21] = cArray12;
                    ++n21;
                }
                fileWriter.write("  // Number of tripletMappings is " + n4 + "\n");
                if (n4 < 2000) {
                    fileWriter.write("  private static final char[][] toUnicodeTripletMappings = { \n");
                    System.out.print("Writing triplet table for conversion from " + n + " to 13488... to " + (String)object + "\n");
                    for (n20 = 0; n20 < cArrayArray.length; ++n20) {
                        cArray = cArrayArray[n20];
                        if (cArray == null) continue;
                        fileWriter.write("{'" + GenerateConverterTable.formattedChar(cArray[0]) + "','" + GenerateConverterTable.formattedChar(cArray[1]) + "','" + GenerateConverterTable.formattedChar(cArray[2]) + "','" + GenerateConverterTable.formattedChar(cArray[3]) + "'},\n");
                    }
                    fileWriter.write("};\n");
                    fileWriter.write("\n");
                    fileWriter.write("\n");
                } else {
                    fileWriter.write("  private static char[][] toUnicodeTripletMappings = new char[" + n4 + "][];\n");
                    for (n20 = 0; n20 < n4; n20 += 2000) {
                        fileWriter.write("  private static void initToUnicodeTripletMappings" + n20 + "() { \n");
                        fileWriter.write("  char[][] toUnicodeTripletMappingsPiece = {\n");
                        for (int i = 0; i < 2000 && i + n20 < n4; ++i) {
                            char[] cArray13 = cArrayArray[n20 + i];
                            if (cArray13 == null) continue;
                            fileWriter.write("    {'" + GenerateConverterTable.formattedChar(cArray13[0]) + "','" + GenerateConverterTable.formattedChar(cArray13[1]) + "','" + GenerateConverterTable.formattedChar(cArray13[2]) + "','" + GenerateConverterTable.formattedChar(cArray13[3]) + "'},\n");
                        }
                        fileWriter.write("  };\n");
                        fileWriter.write("    for (int j = 0; j < toUnicodeTripletMappingsPiece.length ; j++) {\n");
                        fileWriter.write("      toUnicodeTripletMappings[" + n20 + "+j]= new char[3];\n");
                        fileWriter.write("      toUnicodeTripletMappings[" + n20 + "+j][0] = toUnicodeTripletMappingsPiece[j][0];\n");
                        fileWriter.write("      toUnicodeTripletMappings[" + n20 + "+j][1] = toUnicodeTripletMappingsPiece[j][1];\n");
                        fileWriter.write("      toUnicodeTripletMappings[" + n20 + "+j][2] = toUnicodeTripletMappingsPiece[j][2];\n");
                        fileWriter.write("    }\n");
                        fileWriter.write("  }\n");
                        fileWriter.write("\n");
                        stringBuffer.append("   initToUnicodeTripletMappings" + n20 + "();\n");
                    }
                }
            }
            n3 = 0;
            if (object5 != null) {
                int n22;
                int n23;
                fileWriter.write("\n");
                for (n23 = 0; n23 < ((char[][])object5).length; ++n23) {
                    char[] cArray14 = object5[n23];
                    if (cArray14 == null) continue;
                    ++n3;
                }
                n23 = 0;
                char[][] cArrayArray = new char[n3][];
                for (n22 = 0; n22 < ((char[][])object5).length; ++n22) {
                    char[] cArray15 = object5[n22];
                    if (cArray15 == null) continue;
                    char[] cArray16 = new char[]{(char)n22, cArray15[0], cArray15[1], cArray15[2], cArray15[3]};
                    cArrayArray[n23] = cArray16;
                    ++n23;
                }
                fileWriter.write("  // Number of quadMappings is " + n3 + "\n");
                if (n3 < 2000) {
                    fileWriter.write("  private static final char[][] toUnicodeQuadMappings = { \n");
                    System.out.print("Writing quad table for conversion from " + n + " to 1200... to " + (String)object + "\n");
                    for (n22 = 0; n22 < cArrayArray.length; ++n22) {
                        char[] cArray17 = cArrayArray[n22];
                        if (cArray17 == null) continue;
                        fileWriter.write("{'" + GenerateConverterTable.formattedChar(cArray17[0]) + "','" + GenerateConverterTable.formattedChar(cArray17[1]) + "','" + GenerateConverterTable.formattedChar(cArray17[2]) + "','" + GenerateConverterTable.formattedChar(cArray17[3]) + "','" + GenerateConverterTable.formattedChar(cArray17[4]) + "'},\n");
                    }
                    fileWriter.write("};\n");
                    fileWriter.write("\n");
                    fileWriter.write("\n");
                } else {
                    fileWriter.write("  private static char[][] toUnicodeQuadMappings = new char[" + n3 + "][];\n");
                    for (n22 = 0; n22 < n3; n22 += 2000) {
                        fileWriter.write("  private static void initToUnicodeQuadMappings" + n22 + "() { \n");
                        fileWriter.write("  char[][] toUnicodeQuadMappingsPiece = {\n");
                        for (int i = 0; i < 2000 && i + n22 < n3; ++i) {
                            char[] cArray18 = cArrayArray[n22 + i];
                            if (cArray18 == null) continue;
                            fileWriter.write("    {'" + GenerateConverterTable.formattedChar(cArray18[0]) + "','" + GenerateConverterTable.formattedChar(cArray18[1]) + "','" + GenerateConverterTable.formattedChar(cArray18[2]) + "','" + GenerateConverterTable.formattedChar(cArray18[3]) + "','" + GenerateConverterTable.formattedChar(cArray18[4]) + "'},\n");
                        }
                        fileWriter.write("  };\n");
                        fileWriter.write("    for (int j = 0; j < toUnicodeQuadMappingsPiece.length ; j++) {\n");
                        fileWriter.write("      toUnicodeQuadMappings[" + n22 + "+j]= new char[3];\n");
                        fileWriter.write("      toUnicodeQuadMappings[" + n22 + "+j][0] = toUnicodeQuadMappingsPiece[j][0];\n");
                        fileWriter.write("      toUnicodeQuadMappings[" + n22 + "+j][1] = toUnicodeQuadMappingsPiece[j][1];\n");
                        fileWriter.write("      toUnicodeQuadMappings[" + n22 + "+j][2] = toUnicodeQuadMappingsPiece[j][2];\n");
                        fileWriter.write("      toUnicodeQuadMappings[" + n22 + "+j][3] = toUnicodeQuadMappingsPiece[j][3];\n");
                        fileWriter.write("    }\n");
                        fileWriter.write("  }\n");
                        fileWriter.write("\n");
                        stringBuffer.append("   initToUnicodeQuadMappings" + n22 + "();\n");
                    }
                }
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (compress_) {
            System.out.println("Compressing 13488->" + n + " conversion table...");
            object = GenerateConverterTable.compress(cArray3);
            System.out.println("Old compression length: " + ((Object)object).length + " characters.");
            char[] cArray19 = GenerateConverterTable.compressBetter(cArray3);
            System.out.println("New compression length: " + cArray19.length + " characters.");
            if (cArray19.length > ((Object)object).length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            object = GenerateConverterTable.decompressBetter(cArray19);
            if (((Object)object).length != cArray3.length) {
                System.out.println("Verification failed, lengths not equal: " + ((Object)object).length + " != " + cArray3.length);
                for (n5 = 0; n5 < ((Object)object).length && object[n5] == cArray3[n5]; ++n5) {
                }
                System.out.println("First mismatch at index " + n5 + ": " + (int)object[n5] + " != " + cArray3[n5]);
                cArray3 = cArray19;
            } else {
                n5 = 0;
                for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                    if (object[n4] == cArray3[n4]) continue;
                    n5 = 1;
                    System.out.println(n4 + ": " + Integer.toHexString((int)object[n4]) + " != " + Integer.toHexString(cArray3[n4]));
                }
                if (n5 != 0) {
                    System.out.println("Mismatches found in table.");
                } else {
                    cArray3 = cArray19;
                    System.out.println("Table verified.");
                }
            }
        }
        try {
            object = "ConvTable" + n19 + ".java";
            FileWriter fileWriter = new FileWriter((String)object, true);
            System.out.print("Writing table for conversion from 13488 to " + n + "... to " + (String)object + "\n");
            fileWriter.write("  private static char[] fromUnicodeArray_; \n");
            fileWriter.write("  // fromUnicode length = " + cArray3.length + "\n");
            if (cArray3.length < 20000) {
                fileWriter.write("  private static final String fromUnicode_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray3, 0, cArray3.length);
                fileWriter.write("\n");
            } else {
                n5 = cArray3.length / 4;
                fileWriter.write("  private static final String fromUnicode0_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray3, 0, n5);
                fileWriter.write("\n");
                fileWriter.write("  private static final String fromUnicode1_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray3, n5, n5);
                fileWriter.write("\n");
                fileWriter.write("  private static final String fromUnicode2_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray3, 2 * n5, n5);
                fileWriter.write("\n");
                fileWriter.write("  private static final String fromUnicode3_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray3, 3 * n5, cArray3.length - 3 * n5);
                fileWriter.write("\n");
            }
            fileWriter.write("  static {\n");
            fileWriter.write("    toUnicodeArray_ = toUnicode_.toCharArray();\n");
            if (cArray3.length < 20000) {
                fileWriter.write("    fromUnicodeArray_ = fromUnicode_.toCharArray();\n");
            } else {
                fileWriter.write("    StringBuffer sb = new StringBuffer(); \n");
                fileWriter.write("    sb.append(fromUnicode0_); \n");
                fileWriter.write("    sb.append(fromUnicode1_); \n");
                fileWriter.write("    sb.append(fromUnicode2_); \n");
                fileWriter.write("    sb.append(fromUnicode3_); \n");
                fileWriter.write("    fromUnicodeArray_ = sb.toString().toCharArray();\n");
            }
            fileWriter.write(stringBuffer.toString());
            fileWriter.write("  }\n");
            fileWriter.write("\n  ConvTable" + n19 + "()\n  {\n");
            fileWriter.write("    super(" + n19 + ", ");
            fileWriter.write("toUnicodeArray_, ");
            if (object3 != null) {
                fileWriter.write("fromUnicodeArray_,");
                if (object5 != null) {
                    fileWriter.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings,toUnicodeQuadMappings);\n");
                } else if (object4 != null) {
                    fileWriter.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings);\n");
                } else {
                    fileWriter.write("toUnicodeSurrogateMappings,null);\n");
                }
            } else {
                fileWriter.write("fromUnicodeArray_);\n");
            }
            fileWriter.write("  }\n\n");
            fileWriter.write("\n  ConvTable" + n19 + "(int ccsid)\n  {\n");
            fileWriter.write("    super(ccsid, ");
            fileWriter.write("toUnicodeArray_, ");
            if (object3 != null) {
                fileWriter.write("fromUnicodeArray_,");
                if (object5 != null) {
                    fileWriter.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings,toUnicodeQuadMappings);\n");
                } else if (object4 != null) {
                    fileWriter.write("toUnicodeSurrogateMappings,toUnicodeTripletMappings);\n");
                } else {
                    fileWriter.write("toUnicodeSurrogateMappings,null);\n");
                }
            } else {
                fileWriter.write("fromUnicodeArray_);\n");
            }
            fileWriter.write("  }\n}\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.print("Done.\n");
    }

    private static void writeTable(FileWriter fileWriter, char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; i += 16) {
            if (showOffsets_) {
                fileWriter.write("/* " + Integer.toHexString(i) + " */ \"");
            } else {
                fileWriter.write("    \"");
            }
            for (int j = 0; j < 16 && i + j < n + n2; ++j) {
                char c = cArray[i + j];
                if (c == '\b') {
                    fileWriter.write("\\b");
                } else if (c == '\t') {
                    fileWriter.write("\\t");
                } else if (c == '\n') {
                    fileWriter.write("\\n");
                } else if (c == '\f') {
                    fileWriter.write("\\f");
                } else if (c == '\r') {
                    fileWriter.write("\\r");
                } else if (c == '\"') {
                    fileWriter.write("\\\"");
                } else if (c == '\'') {
                    fileWriter.write("\\'");
                } else if (c == '\\') {
                    fileWriter.write("\\\\");
                } else {
                    String string = "\\u";
                    if (c < '\u0010') {
                        string = string + "0";
                    }
                    if (c < '\u0100') {
                        string = string + "0";
                    }
                    if (c < '\u1000') {
                        string = string + "0";
                    }
                    string = string + Integer.toHexString(c).toUpperCase();
                    fileWriter.write(string);
                }
                if (!codePointPerLine_ || j >= 15) continue;
                if (showOffsets_) {
                    fileWriter.write("\" +\n/* " + Integer.toHexString(i + j + 1) + " */ \"");
                    continue;
                }
                fileWriter.write("\" +\n    \"");
            }
            if (i + 16 < n + n2) {
                fileWriter.write("\" +\n");
                continue;
            }
            fileWriter.write("\";\n");
        }
    }

    private static boolean verifyRoundTrip(char[] cArray, char[] cArray2, boolean bl, int n, char[][] cArray3, char[][] cArray4, char[][] cArray5) {
        int n2;
        int n3;
        char[] cArray6;
        int n4;
        int n5;
        String string = "X";
        if (bl) {
            string = "GX";
        }
        if (!bl && (n5 = 0xFFFF & cArray2[13]) >> 8 != 63) {
            System.out.println("Fixing sub char in tableToEbcdic == sub was 0x" + Integer.toHexString(n5 >> 8));
            n5 = 0x3F00 | 0xFF & n5;
            cArray2[13] = (char)n5;
        }
        System.out.println("Checking round trip from EBCDIC for CCSID " + n);
        n5 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        char[] cArray7 = new char[1];
        char[] cArray8 = new char[1];
        for (n4 = 0; n4 < cArray.length; ++n4) {
            int n6;
            char[] cArray9;
            int n7;
            cArray7[0] = cArray[n4];
            cArray6 = cArray7[0] == '\ud800' && cArray3 != null ? cArray3[n4] : (cArray7[0] == '\ud801' && cArray4 != null ? cArray4[n4] : (cArray7[0] == '\ud802' && cArray5 != null ? cArray5[n4] : cArray7));
            if (cArray6[0] == '\ufffd') continue;
            n3 = 0;
            if (bl) {
                if (cArray6.length == 1) {
                    n3 = 0xFFFF & cArray2[cArray6[0]];
                } else if (cArray6.length == 2) {
                    n3 = GenerateConverterTable.findEbcdicSurrogate(cArray3, cArray6);
                } else if (cArray6.length == 3) {
                    n3 = GenerateConverterTable.findEbcdicTriplet(cArray4, cArray6);
                } else if (cArray6.length == 4) {
                    n3 = GenerateConverterTable.findEbcdicQuad(cArray5, cArray6);
                }
            } else {
                n7 = 0xFFFF & cArray2[cArray6[0] / 2];
                n3 = cArray6[0] % 2 == 0 ? n7 >> 8 : n7 & 0xFF;
            }
            if (n4 == n3) continue;
            if (cArray6[0] != '\u001a' && cArray6[0] != '\ud800' && cArray6[0] != '\ud801' && (n3 == 65278 || n3 == 63)) {
                stringBuffer.append("Fixing up EBCDIC RoundTrip Failure " + string + "'" + Integer.toHexString(n4) + "' -> UX'" + Integer.toHexString(cArray6[0]) + "' -> " + string + "'" + Integer.toHexString(n3) + "'\n");
                if (bl) {
                    cArray2[cArray6[0]] = (char)n4;
                } else {
                    n7 = 0xFFFF & cArray2[cArray6[0] / 2];
                    n7 = cArray6[0] % 2 == 0 ? n4 << 8 | n7 & 0xFF : n7 & 0xFF00 | n4;
                    cArray2[cArray6[0] / 2] = (char)n7;
                }
                n5 = 0;
                continue;
            }
            try {
                cArray8[0] = cArray[n3];
                cArray9 = cArray8[0] == '\ud800' ? cArray3[n3] : (cArray8[0] == '\ud801' ? cArray4[n3] : cArray8);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("ERROR.. ArrayIndexOutOfBounds");
                System.out.println("ebcdicChar=0x" + Integer.toHexString(n3));
                System.out.println("i=" + n4);
                System.out.println("unicodeChar=0x" + Integer.toHexString(cArray6[0]));
                throw arrayIndexOutOfBoundsException;
            }
            n2 = 1;
            if (cArray9.length != cArray6.length) {
                n2 = 0;
            } else {
                for (n6 = 0; n6 < cArray6.length; ++n6) {
                    if (cArray6[n6] == cArray9[n6]) continue;
                    n2 = 0;
                }
            }
            if (n2 != 0) {
                stringBuffer2.append("Secondary EBCDIC mapping " + string + "'" + Integer.toHexString(n4) + "' -> UX'");
                for (n6 = 0; n6 < cArray6.length; ++n6) {
                    stringBuffer2.append(Integer.toHexString(cArray6[n6]) + ".");
                }
                stringBuffer2.append("' -> " + string + "'" + Integer.toHexString(n3) + "' -> UX'");
                for (n6 = 0; n6 < cArray9.length; ++n6) {
                    stringBuffer2.append(Integer.toHexString(cArray9[n6]) + ".");
                }
                stringBuffer2.append("'\n");
                continue;
            }
            stringBuffer3.append("EBCDIC RoundTrip Failure 2 " + string + "'" + Integer.toHexString(n4) + "' -> UX'");
            for (n6 = 0; n6 < cArray6.length; ++n6) {
                stringBuffer3.append(Integer.toHexString(cArray6[n6]) + ".");
            }
            stringBuffer3.append("' -> " + string + "'" + Integer.toHexString(n3) + "' -> UX'");
            for (n6 = 0; n6 < cArray9.length; ++n6) {
                stringBuffer3.append(Integer.toHexString(cArray9[n6]) + ".");
            }
            stringBuffer3.append("'\n");
            n5 = 0;
        }
        System.out.println(stringBuffer2);
        System.out.println(stringBuffer);
        System.out.println(stringBuffer3);
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        stringBuffer3.setLength(0);
        for (n4 = 0; n4 < cArray2.length; ++n4) {
            int n8;
            if (bl) {
                n3 = 0xFFFF & cArray2[n4];
            } else {
                n8 = 0xFFFF & cArray2[n4 / 2];
                n3 = n4 % 2 == 0 ? n8 >> 8 : n8 & 0xFF;
            }
            if (n3 == 65278 || n3 == 63) continue;
            cArray7[0] = cArray[n3];
            cArray6 = cArray7[0] == '\ud800' ? cArray3[n3] : (cArray7[0] == '\ud801' ? cArray4[n3] : cArray7);
            if (n4 == cArray6[0]) continue;
            if (cArray6[0] == '\ufffd') {
                stringBuffer.append("Unicode RoundTrip Failure UX'" + Integer.toHexString(n4) + "' -> " + string + "'" + Integer.toHexString(n3) + "' -> UX'");
                for (n8 = 0; n8 < cArray6.length; ++n8) {
                    stringBuffer.append(Integer.toHexString(cArray6[n8]) + ".");
                }
                stringBuffer.append("'\n");
                if (cArray[n3] == '\ufffd') {
                    cArray[n3] = (char)n4;
                    cArray7[0] = cArray[n3];
                    cArray6 = cArray7;
                    stringBuffer.append("Fixed up ................ UX'" + Integer.toHexString(n4) + "' -> " + string + "'" + Integer.toHexString(n3) + "' -> UX'");
                    for (n8 = 0; n8 < cArray6.length; ++n8) {
                        stringBuffer.append(Integer.toHexString(cArray6[n8]) + ".");
                    }
                    stringBuffer.append("'\n");
                }
                n5 = 0;
                continue;
            }
            n8 = 0;
            if (bl) {
                if (cArray6.length == 1) {
                    n8 = 0xFFFF & cArray2[cArray6[0]];
                } else if (cArray6.length == 2) {
                    n8 = GenerateConverterTable.findEbcdicSurrogate(cArray3, cArray6);
                } else if (cArray6.length == 3) {
                    n8 = GenerateConverterTable.findEbcdicTriplet(cArray4, cArray6);
                }
            } else {
                n2 = 0xFFFF & cArray2[cArray6[0] / 2];
                n8 = cArray6[0] % 2 == 0 ? n2 >> 8 : n2 & 0xFF;
            }
            if (n8 == n3) {
                stringBuffer2.append("Secondary Unicode mapping UX'" + Integer.toHexString(n4) + "' -> " + string + "'" + Integer.toHexString(n3) + "' -> UX'");
                for (n2 = 0; n2 < cArray6.length; ++n2) {
                    stringBuffer2.append(Integer.toHexString(cArray6[n2]) + ".");
                }
                stringBuffer2.append("' -> " + string + "'" + Integer.toHexString(n8) + "'\n");
                continue;
            }
            stringBuffer3.append("Unicode RoundTrip Failure 2 UX'" + Integer.toHexString(n4) + "' -> " + string + "'" + Integer.toHexString(n3) + "' -> UX'");
            for (n2 = 0; n2 < cArray6.length; ++n2) {
                stringBuffer3.append(Integer.toHexString(cArray6[n2]) + ".");
            }
            stringBuffer3.append("' -> " + string + "'" + Integer.toHexString(n8) + "'\n");
            n5 = 0;
        }
        System.out.println(stringBuffer2);
        System.out.println(stringBuffer);
        System.out.println(stringBuffer3);
        return n5 != 0;
    }

    private static int findEbcdicQuad(char[][] cArray, char[] cArray2) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == null || cArray[i][0] != cArray2[0] || cArray[i][1] != cArray2[1] || cArray[i][2] != cArray2[2] || cArray[i][3] != cArray2[3]) continue;
            return i;
        }
        return 0;
    }

    private static int findEbcdicTriplet(char[][] cArray, char[] cArray2) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == null || cArray[i][0] != cArray2[0] || cArray[i][1] != cArray2[1] || cArray[i][2] != cArray2[2]) continue;
            return i;
        }
        return 0;
    }

    private static int findEbcdicSurrogate(char[][] cArray, char[] cArray2) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == null || cArray[i][0] != cArray2[0] || cArray[i][1] != cArray2[1]) continue;
            return i;
        }
        return 0;
    }

    static int repeatCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] == cArray[n2 - 1]; ++n2) {
        }
        return n2 - n;
    }

    static final int rampCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] == cArray[n2 - 1] + '\u0001'; ++n2) {
        }
        return n2 - n;
    }

    static int hbCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length; ++n2) {
            if (GenerateConverterTable.repeatCheck(cArray, n2) > 6) {
                return n2 - n;
            }
            if (GenerateConverterTable.rampCheck(cArray, n2) > 6) {
                return n2 - n;
            }
            if ((cArray[n2] & 0xFF00) == (cArray[n2 - 1] & 0xFF00)) continue;
            return n2 - n;
        }
        return n2 - n;
    }

    static char[] compressBetter(char[] cArray) {
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n = GenerateConverterTable.repeatCheck(cArray, i);
            if (n > 3) {
                ++numRepeats;
                stringBuffer.append('\uffff');
                stringBuffer.append((char)n);
                stringBuffer.append(cArray[i]);
                i += n - 1;
                continue;
            }
            int n2 = GenerateConverterTable.rampCheck(cArray, i);
            if (n2 > 3) {
                ++numRamps;
                stringBuffer.append('\ufffe');
                stringBuffer.append((char)n2);
                stringBuffer.append(cArray[i]);
                i += n2 - 1;
                continue;
            }
            int n3 = GenerateConverterTable.hbCheck(cArray, i);
            if (--n3 >= 6) {
                ++hbRepeats;
                stringBuffer.append('\u0000');
                if ((0xFFFFFFFFL & (long)n3) % 2L == 1L) {
                    --n3;
                }
                stringBuffer.append((char)(n3 / 2));
                stringBuffer.append(cArray[i++]);
                for (int j = 0; j < n3 / 2; ++j) {
                    char c = (char)((0xFF & cArray[i + j * 2]) * 256 + (0xFF & cArray[i + j * 2 + 1]));
                    stringBuffer.append(c);
                }
                i = i + n3 - 1;
                continue;
            }
            stringBuffer.append(cArray[i]);
            ++charRepeats;
            if (cArray[i] != '\uffff' && cArray[i] != '\ufffe' && cArray[i] != '\u0000') continue;
            stringBuffer.append('\u0000');
        }
        System.out.println("Compression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return stringBuffer.toString().toCharArray();
    }

    static char[] decompressBetter(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            char c;
            int n2;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\uffff');
                    ++i;
                    continue;
                }
                ++numRepeats;
                n2 = cArray[i + 1];
                c = cArray[i + 2];
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(c);
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\ufffe');
                    ++i;
                    continue;
                }
                ++numRamps;
                n2 = cArray[i + 1];
                c = cArray[i + 2];
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append((char)(n + c));
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\u0000');
                    ++i;
                    continue;
                }
                ++hbRepeats;
                n2 = 0xFFFF & cArray[++i];
                c = cArray[++i];
                n = (char)(0xFF00 & c);
                stringBuffer.append(c);
                ++i;
                for (int j = 0; j < n2; ++j) {
                    char c2 = cArray[i + j];
                    char c3 = (char)(n + ((0xFF00 & c2) >>> 8));
                    char c4 = (char)(n + (0xFF & c2));
                    stringBuffer.append(c3);
                    stringBuffer.append(c4);
                }
                i = i + n2 - 1;
                continue;
            }
            stringBuffer.append(cArray[i]);
            ++charRepeats;
        }
        System.out.println("Decompression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return stringBuffer.toString().toCharArray();
    }

    static char[] compress(char[] cArray) {
        int n;
        if (cArray.length < 3) {
            return cArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = cArray[0];
        char c2 = cArray[1];
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 2; n < cArray.length; ++n) {
            if (!bl && !bl2) {
                if (cArray[n] == c2 && cArray[n] == c) {
                    bl = true;
                    stringBuffer.append('\uffff');
                    stringBuffer.append(c);
                    n2 = 3;
                } else if (cArray[n] == c2 + '\u0001' && cArray[n] == c + 2) {
                    bl2 = true;
                    stringBuffer.append('\ufffe');
                    stringBuffer.append(c);
                } else if (c == '\uffff') {
                    stringBuffer.append('\uffff');
                } else if (c == '\ufffe') {
                    stringBuffer.append('\ufffe');
                } else {
                    stringBuffer.append(c);
                }
                c = c2;
                c2 = cArray[n];
                continue;
            }
            if (bl) {
                if (cArray[n] == c2 && cArray[n] == c) {
                    ++n2;
                    c = c2;
                    c2 = cArray[n];
                    continue;
                }
                bl = false;
                int n3 = n2;
                if (n2 == 8) {
                    n3 = 8;
                } else if (n2 == 9) {
                    n3 = 9;
                } else if (n2 == 10) {
                    n3 = 10;
                } else if (n2 == 12) {
                    n3 = 12;
                } else if (n2 == 13) {
                    n3 = 13;
                } else if (n2 == 34) {
                    n3 = 34;
                } else if (n2 == 39) {
                    n3 = 39;
                } else if (n2 == 92) {
                    n3 = 92;
                }
                stringBuffer.append((char)n3);
                c = cArray[n++];
                if (n < cArray.length) {
                    c2 = cArray[n];
                    continue;
                }
                c2 = '\u0000';
                continue;
            }
            if (cArray[n] == c2 + '\u0001' && cArray[n] == c + 2) {
                c = c2;
                c2 = cArray[n];
                continue;
            }
            bl2 = false;
            stringBuffer.append(c2);
            c = cArray[n++];
            c2 = cArray[n];
        }
        if (bl) {
            n = (char)n2;
            if (n2 == 8) {
                n = 8;
            } else if (n2 == 9) {
                n = 9;
            } else if (n2 == 10) {
                n = 10;
            } else if (n2 == 12) {
                n = 12;
            } else if (n2 == 13) {
                n = 13;
            } else if (n2 == 34) {
                n = 34;
            } else if (n2 == 39) {
                n = 39;
            } else if (n2 == 92) {
                n = 92;
            }
            stringBuffer.append((char)n);
        }
        if (bl2) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString().toCharArray();
    }

    static void writeHeader(FileWriter fileWriter, int n, String string) throws Exception {
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        Date date = new Date();
        Class<Copyright> clazz = Copyright.class;
        Field field = clazz.getField("version");
        String string2 = (String)field.get(null);
        fileWriter.write("///////////////////////////////////////////////////////////////////////////////\n");
        fileWriter.write("//\n");
        fileWriter.write("// JTOpen (IBM Toolbox for Java - OSS version)\n");
        fileWriter.write("//\n");
        fileWriter.write("// Filename:  ConvTable" + n + ".java\n");
        fileWriter.write("//\n");
        fileWriter.write("// The source code contained herein is licensed under the IBM Public License\n");
        fileWriter.write("// Version 1.0, which has been approved by the Open Source Initiative.\n");
        fileWriter.write("// Copyright (C) 1997-2016 International Business Machines Corporation and\n");
        fileWriter.write("// others.  All rights reserved.\n");
        fileWriter.write("//\n");
        fileWriter.write("// Generated " + date + " from " + string + "\n");
        StringBuffer stringBuffer = new StringBuffer();
        if (!compress_) {
            stringBuffer.append(" -nocompress");
        }
        if (ascii_) {
            stringBuffer.append(" -ascii");
        }
        if (bidi_) {
            stringBuffer.append(" -bidi");
        }
        if (showOffsets_) {
            stringBuffer.append(" -showOffsets");
        }
        if (codePointPerLine_) {
            stringBuffer.append(" -codePointPerLine");
        }
        if (useJdbc_) {
            stringBuffer.append(" -useJdbc");
        }
        if (stringBuffer.length() > 0) {
            fileWriter.write("// Generation Options:" + stringBuffer.toString() + "\n");
        }
        fileWriter.write("// Using " + string2 + "\n");
        fileWriter.write("///////////////////////////////////////////////////////////////////////////////\n\n");
        fileWriter.write("package com.ibm.as400.access;\n\n");
    }

    static boolean jdbcIsDBCS(Connection connection, int n) throws SQLException {
        boolean bl;
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("CREATE TABLE QTEMP.GENERATE" + n + "(C1 VARCHAR(80) CCSID " + n + ")");
            bl = false;
        }
        catch (SQLException sQLException) {
            int n2 = sQLException.getErrorCode();
            if (n2 == -189) {
                statement.executeUpdate("CREATE TABLE QTEMP.GENERATE" + n + "(C1 VARGRAPHIC(80) CCSID " + n + ")");
                bl = true;
            }
            throw sQLException;
        }
        statement.close();
        return bl;
    }

    private static char[] jdbcToEbcdic(Connection connection, int n) throws Exception {
        int n2;
        if (n > 1000000) {
            n -= 1000000;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS CLOB(1M) CCSID " + n + ") as BLOB(1M)) from sysibm.sysdummy1");
        char[] cArray = new char[65536];
        for (n2 = 0; n2 < 55296; ++n2) {
            cArray[n2] = (char)n2;
        }
        for (n2 = 55296; n2 < 63744; ++n2) {
            cArray[n2] = 26;
        }
        for (n2 = 63744; n2 < 65536; ++n2) {
            cArray[n2] = (char)n2;
        }
        Clob clob = ((AS400JDBCConnection)connection).createClob();
        clob.setString(1L, new String(cArray));
        preparedStatement.setClob(1, clob);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        byte[] byArray = resultSet.getBytes(1);
        if (byArray.length != 65536) {
            byArray = GenerateConverterTable.removeDoubleByteEbcdic(byArray);
        }
        resultSet.close();
        preparedStatement.close();
        char[] cArray2 = new char[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            cArray2[i / 2] = (char)(byArray[i] << 8 | 0xFF & byArray[i + 1]);
        }
        return cArray2;
    }

    private static byte[] removeDoubleByteEbcdic(byte[] byArray) throws Exception {
        int n;
        byte[] byArray2 = new byte[65536];
        for (n = 0; n < 32; ++n) {
            byArray2[n] = byArray[n];
        }
        n = 32;
        boolean bl = true;
        for (int i = 32; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl) {
                if (by == 14) {
                    bl = false;
                    continue;
                }
                if (by == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                if (n >= byArray2.length) {
                    throw new Exception("ERROR:  toIndexInvalid");
                }
                byArray2[n] = by;
                ++n;
                continue;
            }
            if (by == 15) {
                bl = true;
                continue;
            }
            if (by == 14) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            if (n >= byArray2.length) {
                throw new Exception("ERROR:  toIndexInvalid");
            }
            byArray2[n] = 63;
            ++n;
            ++i;
        }
        if (n != 65536) {
            throw new Exception("To index is " + n + " should be 65536");
        }
        return byArray2;
    }

    private static char[] removeSingleByteEbcdic(byte[] byArray, boolean bl) throws Exception {
        char[] cArray = new char[65536];
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl2) {
                if (by == 14) {
                    bl2 = false;
                    continue;
                }
                if (by == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                cArray[n] = 65278;
                ++n;
                continue;
            }
            if (by == 15 && bl) {
                bl2 = true;
                continue;
            }
            if (by == 14 && bl) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            cArray[n] = (char)(by << 8 | 0xFF & byArray[i + 1]);
            ++n;
            ++i;
        }
        if (n != 65536) {
            throw new Exception("To index is " + n + " should be 65536");
        }
        return cArray;
    }

    private static char[] removeSingleByteEbcdicAndSpaces(byte[] byArray, boolean bl) throws Exception {
        char[] cArray = new char[65536];
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl2) {
                if (by == 14) {
                    bl2 = false;
                    continue;
                }
                if (by == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                cArray[n] = 65278;
                ++n;
                if (byArray[i + 1] != 64) continue;
                ++i;
                continue;
            }
            if (by == 15 && bl) {
                bl2 = true;
                if (byArray[i + 1] != 64) continue;
                ++i;
                continue;
            }
            if (by == 14 && bl) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            cArray[n] = (char)(by << 8 | 0xFF & byArray[i + 1]);
            ++n;
            ++i;
        }
        if (n != 65536) {
            throw new Exception("To index is " + n + " should be 65536");
        }
        return cArray;
    }

    private static char[] jdbcToUnicode(Connection connection, int n) throws SQLException {
        if (n > 1000000) {
            n -= 1000000;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS VARCHAR(256) FOR BIT DATA) AS VARCHAR(256) CCSID " + n + ") as VARGRAPHIC(256) CCSID 1200) from sysibm.sysdummy1");
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = i == 14 ? 63 : (i == 15 ? 63 : (byte)i);
        }
        preparedStatement.setBytes(1, byArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        preparedStatement.close();
        char[] cArray = string.toCharArray();
        cArray[14] = 14;
        cArray[15] = 15;
        return cArray;
    }

    private static char[] jdbcToEbcdicDBCS(Connection connection, int n) throws Exception {
        char[] cArray;
        Object object;
        PreparedStatement preparedStatement;
        boolean bl = false;
        if (n > 2000000) {
            n -= 2000000;
            bl = true;
        }
        try {
            preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS DBCLOB(1M) CCSID " + n + ") as BLOB(1M)) from sysibm.sysdummy1");
        }
        catch (SQLException sQLException) {
            object = sQLException.toString();
            if (((String)object).indexOf("SQL0189") >= 0) {
                preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS CLOB(1M) CCSID " + n + ") as BLOB(1M)) from sysibm.sysdummy1");
            }
            throw sQLException;
        }
        if (n != 1399) {
            int n2;
            object = new char[65536];
            for (n2 = 0; n2 < 55296; ++n2) {
                object[n2] = n2 <= 128 ? (Object)26 : (Object)((char)n2);
            }
            for (n2 = 55296; n2 < 57344; ++n2) {
                object[n2] = 65533;
            }
            for (n2 = 57344; n2 < 65536; ++n2) {
                object[n2] = n2 >= 65024 && n2 <= 65295 ? (Object)65533 : (Object)((char)n2);
            }
            Clob clob = ((AS400JDBCConnection)connection).createClob();
            clob.setString(1L, new String((char[])object));
            preparedStatement.setClob(1, clob);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            byte[] byArray = resultSet.getBytes(1);
            resultSet.close();
            preparedStatement.close();
            if (byArray.length != 131072) {
                cArray = GenerateConverterTable.removeSingleByteEbcdic(byArray, bl);
            } else {
                cArray = new char[byArray.length / 2];
                for (int i = 0; i < byArray.length; i += 2) {
                    cArray[i / 2] = (char)(byArray[i] << 8 | 0xFF & byArray[i + 1]);
                }
            }
        } else {
            int n3;
            object = new char[131072];
            for (n3 = 0; n3 < 55296; ++n3) {
                object[2 * n3] = n3 <= 128 ? (Object)26 : (Object)((char)n3);
                object[2 * n3 + 1] = 32;
            }
            for (n3 = 55296; n3 < 57344; ++n3) {
                object[2 * n3] = 65533;
                object[2 * n3 + 1] = 32;
            }
            for (n3 = 57344; n3 < 65536; ++n3) {
                object[2 * n3] = n3 >= 65024 && n3 <= 65295 ? (Object)65533 : (Object)((char)n3);
                object[2 * n3 + 1] = 32;
            }
            Clob clob = ((AS400JDBCConnection)connection).createClob();
            clob.setString(1L, new String((char[])object));
            preparedStatement.setClob(1, clob);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            byte[] byArray = resultSet.getBytes(1);
            resultSet.close();
            preparedStatement.close();
            cArray = GenerateConverterTable.removeSingleByteEbcdicAndSpaces(byArray, bl);
        }
        return cArray;
    }

    private static char[] jdbcToUnicodeSpacesDBCS(Connection connection, int n) throws SQLException {
        boolean bl = false;
        int n2 = 1024;
        String string = "select cast(INTERPRET(CAST(? AS CHAR(" + n2 * 4 + ") FOR BIT DATA) AS GRAPHIC(" + n2 * 2 + ") CCSID " + n + ") as VARGRAPHIC(8200) CCSID 1200) from sysibm.sysdummy1";
        if (n > 2000000) {
            bl = true;
            string = "select cast(CAST(CAST(? AS VARCHAR(16390) FOR BIT DATA) AS VARCHAR(16390) CCSID " + (n -= 2000000) + ") as VARGRAPHIC(8200) CCSID 1200) from sysibm.sysdummy1";
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        int n3 = 65536 / n2;
        byte[] byArray = bl ? new byte[n2 * 4 + 2] : new byte[n2 * 4];
        int n4 = 0;
        if (bl) {
            byArray[0] = 14;
            byArray[n2 * 4 + 1] = 15;
            n4 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = i * n2 + j;
                if (bl && (n5 < 256 || n5 / 256 == 14 || n5 / 256 == 15 || n5 % 256 == 14 || n5 % 256 == 15)) {
                    n5 = 65278;
                }
                byArray[n4 + 4 * j] = (byte)(n5 / 256);
                byArray[n4 + 4 * j + 1] = (byte)n5;
                byArray[n4 + 4 * j + 2] = 64;
                byArray[n4 + 4 * j + 3] = 64;
            }
            if (n4 == 1) {
                byArray[n2 * 4 + 1] = 15;
            }
            preparedStatement.setBytes(1, byArray);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string2 = resultSet.getString(1);
            if (string2 == null) {
                System.out.println("ERROR: got null processing block " + i + " of size " + n2);
                System.out.println("INPUT BYTES: = " + GenerateConverterTable.dumpBytes(" ", byArray));
            } else if (string2.length() != n2) {
                // empty if block
            }
            stringBuffer.append(string2);
            resultSet.close();
        }
        preparedStatement.close();
        return stringBuffer.toString().toCharArray();
    }

    private static String dumpUnicodeString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string2.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(string);
            int n = 0xFFFF & cArray[i];
            if (n < 16) {
                stringBuffer.append("0");
            }
            if (n < 256) {
                stringBuffer.append("0");
            }
            if (n < 4096) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    private static String dumpBytes(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(string);
            int n = 0xFF & byArray[i];
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }
}

