/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCConnectionRedirect;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.DriverManager;

final class JDTrace {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    private JDTrace() {
    }

    static boolean isTraceOn() {
        if (Trace.traceOn_ && Trace.traceJDBC_) {
            return true;
        }
        return DriverManager.getLogWriter() != null;
    }

    static void logDataEvenIfTracingIsOff(Object object, String string) {
        JDTrace.logInformation(object, string);
    }

    static void logInformation(String string) {
        if (JDTrace.isTraceOn()) {
            String string2 = "as400: " + string;
            JDTrace.log(string2);
        }
    }

    static void logException(Object object, String string, Exception exception) {
        if (JDTrace.isTraceOn()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.write("as400: ");
            if (object != null) {
                printWriter.write(JDTrace.objectToString(object));
            } else {
                printWriter.write("static method");
            }
            printWriter.write(": ");
            printWriter.write(string);
            printWriter.write(".");
            exception.printStackTrace(printWriter);
            JDTrace.log(stringWriter.toString());
        }
    }

    static void logException(Object object, Object object2, String string, Exception exception) {
        if (JDTrace.isTraceOn()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.write("as400: ");
            if (object != null) {
                printWriter.write(JDTrace.objectToString(object));
            } else {
                printWriter.write("static method ");
            }
            if (object2 != null) {
                printWriter.write(JDTrace.objectToString(object2));
            }
            printWriter.write(": ");
            printWriter.write(string);
            printWriter.write(".");
            exception.printStackTrace(printWriter);
            JDTrace.log(stringWriter.toString());
        }
    }

    static void logInformation(Object object, String string) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(": ");
            stringBuffer.append(string);
            stringBuffer.append(".");
            JDTrace.log(stringBuffer.toString());
        }
    }

    static void logProperty(Object object, String string, String string2, String string3) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400@");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(": ");
            stringBuffer.append(string2);
            stringBuffer.append(" = \"");
            stringBuffer.append(string3);
            stringBuffer.append("\".");
            JDTrace.log(stringBuffer.toString());
        }
    }

    static void logProperty(Object object, String string, String string2, boolean bl) {
        if (JDTrace.isTraceOn()) {
            Boolean bl2 = new Boolean(bl);
            JDTrace.logProperty(object, string, string2, bl2.toString());
        }
    }

    static void logProperty(Object object, String string, String string2, int n) {
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty(object, string, string2, Integer.toString(n));
        }
    }

    static void logOpen(Object object, Object object2) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(" open.");
            if (object2 != null) {
                stringBuffer.append(" Parent: ");
                stringBuffer.append(JDTrace.objectToString(object2));
                stringBuffer.append(".");
            }
            JDTrace.log(stringBuffer.toString());
        }
    }

    private static void log(String string) {
        PrintWriter printWriter;
        PrintWriter printWriter2 = DriverManager.getLogWriter();
        if (printWriter2 != null) {
            printWriter2.println(string);
        }
        if ((printWriter = DriverManager.getLogWriter()) != null) {
            try {
                ((Writer)printWriter).write(string + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Trace.log(8, string);
    }

    static void logClose(Object object) {
        if (JDTrace.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("as400: ");
            stringBuffer.append(JDTrace.objectToString(object));
            stringBuffer.append(" closed.");
            JDTrace.log(stringBuffer.toString());
        }
    }

    static String objectToString(Object object) {
        AS400JDBCConnection aS400JDBCConnection;
        String string;
        if (object == null) {
            object = "";
        }
        String string2 = (string = object.getClass().getName()).startsWith("com.ibm.as400.access.AS400JDBC") ? string.substring(30) : (string.startsWith("com.ibm.as400.access.JD") ? string.substring(23) : (string.startsWith("java.lang.Class") ? "" : "Unknown"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(object.toString());
        if (object instanceof AS400JDBCConnectionImpl) {
            aS400JDBCConnection = (AS400JDBCConnectionImpl)object;
            if (aS400JDBCConnection.dataSourceUrl_ != null) {
                stringBuffer.append(":");
                stringBuffer.append(aS400JDBCConnection.dataSourceUrl_.getServerName());
            }
        }
        if (object instanceof AS400JDBCConnectionRedirect) {
            aS400JDBCConnection = (AS400JDBCConnectionRedirect)object;
            if (((AS400JDBCConnectionRedirect)aS400JDBCConnection).currentUrl_ != null) {
                stringBuffer.append(":");
                stringBuffer.append(((AS400JDBCConnectionRedirect)aS400JDBCConnection).currentUrl_.getServerName());
            }
        }
        stringBuffer.append(" (");
        stringBuffer.append(object.hashCode());
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    static void setTraceOn(boolean bl) {
        Trace.setTraceJDBCOn(bl);
        if (bl) {
            Trace.setTraceOn(bl);
        }
    }
}

