/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PSConfig;
import com.ibm.as400.access.PSController;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.PSServerSocketContainer;
import com.ibm.as400.access.PxPeerConnection;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.StoppableThread;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyServer {
    private static final PrintStream errors_ = System.err;
    private PSConfig configuration_;
    private PSLoad load_ = new PSLoad();
    private PSLoadBalancer loadBalancer_ = new PSLoadBalancer(this.load_);
    private int port_ = 3470;
    private int securePort_ = 3471;
    private Vector threadGroup_ = null;

    public ProxyServer() {
        this.configuration_ = new PSConfig(this.load_, this.loadBalancer_);
    }

    public int getActiveConnections() {
        return this.load_.getActiveConnections();
    }

    public int getBalanceThreshold() {
        return this.load_.getBalanceThreshold();
    }

    public String getConfiguration() {
        return this.configuration_.getName();
    }

    public int getMaxConnections() {
        return this.load_.getMaxConnections();
    }

    public String[] getPeers() {
        return this.loadBalancer_.getPeers();
    }

    public int getPort() {
        return this.port_;
    }

    public int getSecurePort() {
        return this.securePort_;
    }

    public boolean isStarted() {
        return this.threadGroup_ != null;
    }

    public boolean isVerbose() {
        return Verbose.isVerbose();
    }

    public static void main(String[] stringArray) {
        ProxyServer proxyServer = new ProxyServer();
        if (proxyServer.parseArgs(stringArray)) {
            Verbose.forcePrintln(ResourceBundleLoader.getText("PROXY_SERVER_STARTED"));
            proxyServer.start();
        } else {
            PSConfig.usage(System.err);
        }
    }

    private boolean parseArgs(String[] stringArray) {
        String string;
        String string2;
        CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, PSConfig.expectedOptions_, PSConfig.shortcuts_);
        if (commandLineArguments.getOptionValue("-help") != null) {
            return false;
        }
        try {
            this.configuration_.apply(commandLineArguments);
        }
        catch (Exception exception) {
            errors_.println(exception.getMessage());
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Exception while parsing command line arguments", (Throwable)exception);
            }
            return false;
        }
        String string3 = commandLineArguments.getOptionValue("-port");
        if (string3 != null && string3.length() > 0) {
            this.setPort(Integer.parseInt(string3));
        }
        if ((string2 = commandLineArguments.getOptionValue("-securePort")) != null && string2.length() > 0) {
            this.setSecurePort(Integer.parseInt(string2));
        }
        Enumeration enumeration = commandLineArguments.getExtraOptions();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            errors_.println(ResourceBundleLoader.getText("PROXY_OPTION_NOT_VALID", string));
        }
        string = commandLineArguments.getOptionValue("-");
        if (string != null && string.length() > 0) {
            errors_.println(ResourceBundleLoader.getText("PROXY_VALUE_NO_OPTION", string));
        }
        return true;
    }

    public void setBalanceThreshold(int n) {
        this.load_.setBalanceThreshold(n);
    }

    public void setConfiguration(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("configuration");
        }
        if (string.length() == 0) {
            throw new ExtendedIllegalArgumentException("configuration", 2);
        }
        this.configuration_.setName(string);
        this.configuration_.load();
    }

    public void setMaxConnections(int n) {
        this.load_.setMaxConnections(n);
    }

    public void setPeers(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("peers");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new NullPointerException("peers[" + i + "]");
            }
            if (stringArray[i].length() != 0) continue;
            throw new ExtendedIllegalArgumentException("peers[" + i + "]", 2);
        }
        this.loadBalancer_.setPeers(stringArray);
    }

    public void setPort(int n) {
        if (this.isStarted()) {
            throw new ExtendedIllegalStateException("port", 5);
        }
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("port", 4);
        }
        this.port_ = n;
    }

    public void setSecurePort(int n) {
        if (this.isStarted()) {
            throw new ExtendedIllegalStateException("securePort", 5);
        }
        if (n < 0 || n > 65535) {
            throw new ExtendedIllegalArgumentException("securePort", 4);
        }
        this.securePort_ = n;
    }

    public void setVerbose(boolean bl) {
        Verbose.setVerbose(bl);
    }

    public void start() {
        if (this.threadGroup_ != null) {
            throw new ExtendedIllegalStateException(7);
        }
        this.threadGroup_ = new Vector();
        try {
            String string = System.getProperty("javax.net.ssl.keyStore");
            PSServerSocketContainer pSServerSocketContainer = string == null ? new PSServerSocketContainer(this.port_) : new PSServerSocketContainer(this.securePort_, true);
            this.port_ = pSServerSocketContainer.getLocalPort();
            PSController pSController = new PSController(this.threadGroup_, this, this.load_, this.loadBalancer_, this.configuration_, pSServerSocketContainer);
            pSController.start();
            this.threadGroup_.addElement(pSController);
            Verbose.println(ResourceBundleLoader.getText("PROXY_SERVER_LISTENING", pSServerSocketContainer, Integer.toString(this.port_)));
        }
        catch (BindException bindException) {
            Verbose.println(ResourceBundleLoader.getText("PROXY_ALREADY_LISTENING", Integer.toString(this.port_)));
            try {
                PxPeerConnection pxPeerConnection = new PxPeerConnection(InetAddress.getLocalHost().getHostName() + ":" + this.port_);
                pxPeerConnection.configure(this.configuration_);
                pxPeerConnection.close();
                return;
            }
            catch (UnknownHostException unknownHostException) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "Peer host is unknown.", (Throwable)bindException);
                }
                errors_.println(bindException.getMessage());
            }
        }
        catch (IOException iOException) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, "Error opening server socket.", (Throwable)iOException);
            }
            errors_.println(iOException.getMessage());
        }
    }

    public void stop() {
        if (this.threadGroup_ == null) {
            throw new ExtendedIllegalStateException(8);
        }
        this.load_.allConnectionsClosed();
        Enumeration enumeration = this.threadGroup_.elements();
        while (enumeration.hasMoreElements()) {
            ((StoppableThread)enumeration.nextElement()).stopSafely();
        }
        this.threadGroup_ = null;
    }

    static {
        SystemProperties.ignoreProperty("com.ibm.as400.access.AS400.proxyServer");
    }
}

