/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.CharConversionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class SQLDate
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    static boolean jdk14 = false;
    private int dateFormat_;
    private int year_ = 0;
    private int month_ = 0;
    private int day_ = 0;

    SQLDate(SQLConversionSettings sQLConversionSettings, int n) {
        super(sQLConversionSettings);
        this.dateFormat_ = n;
    }

    public Object clone() {
        return new SQLDate(this.settings_, this.dateFormat_);
    }

    public static Date stringToDate(String string, SQLConversionSettings sQLConversionSettings, Calendar calendar) throws SQLException {
        String string2 = string.trim();
        int n = string2.length();
        try {
            if (n == 0 || Integer.parseInt(string2) == 0) {
                return new Date(0L);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        try {
            switch (sQLConversionSettings.getDateFormat()) {
                case 4: {
                    calendar.set(1, Integer.parseInt(string.substring(6, 10)));
                    calendar.set(2, Integer.parseInt(string.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(string.substring(3, 5)));
                    break;
                }
                case 6: {
                    calendar.set(1, Integer.parseInt(string.substring(6, 10)));
                    calendar.set(2, Integer.parseInt(string.substring(3, 5)) - 1);
                    calendar.set(5, Integer.parseInt(string.substring(0, 2)));
                    break;
                }
                case 0: {
                    if (n <= 6) {
                        calendar.set(6, Integer.parseInt(string.substring(3, 6)));
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(string.substring(0, 2))));
                        break;
                    }
                    calendar.set(6, Integer.parseInt(string.substring(5, 8)));
                    calendar.set(1, Integer.parseInt(string.substring(0, 4)));
                    break;
                }
                case 1: {
                    if (n <= 8) {
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(string.substring(6, 8))));
                    } else {
                        calendar.set(1, Integer.parseInt(string.substring(6, 10)));
                    }
                    calendar.set(2, Integer.parseInt(string.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(string.substring(3, 5)));
                    break;
                }
                case 2: {
                    if (n <= 8) {
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(string.substring(6, 8))));
                    } else {
                        calendar.set(1, Integer.parseInt(string.substring(6, 10)));
                    }
                    calendar.set(2, Integer.parseInt(string.substring(3, 5)) - 1);
                    calendar.set(5, Integer.parseInt(string.substring(0, 2)));
                    break;
                }
                case 3: {
                    if (n <= 8) {
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(string.substring(0, 2))));
                        calendar.set(2, Integer.parseInt(string.substring(3, 5)) - 1);
                        calendar.set(5, Integer.parseInt(string.substring(6, 8)));
                        break;
                    }
                    calendar.set(1, Integer.parseInt(string.substring(0, 4)));
                    calendar.set(2, Integer.parseInt(string.substring(5, 7)) - 1);
                    calendar.set(5, Integer.parseInt(string.substring(8, 10)));
                    break;
                }
                case 5: 
                case 7: {
                    calendar.set(1, Integer.parseInt(string.substring(0, 4)));
                    calendar.set(2, Integer.parseInt(string.substring(5, 7)) - 1);
                    calendar.set(5, Integer.parseInt(string.substring(8, 10)));
                }
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        catch (NumberFormatException numberFormatException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing date " + string, numberFormatException);
            }
            JDError.throwSQLException("07006", string);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing date " + string, stringIndexOutOfBoundsException);
            }
            JDError.throwSQLException("07006", string);
        }
        try {
            long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
            return new Date(l);
        }
        catch (Exception exception) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing date " + string, exception);
            }
            JDError.throwSQLException("07006", string);
            return null;
        }
    }

    public static String localDateToString(LocalDate localDate, SQLConversionSettings sQLConversionSettings, Calendar calendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth());
        return SQLDate.dateToString(gregorianCalendar.getTime(), sQLConversionSettings, calendar);
    }

    public static String dateToString(java.util.Date date, SQLConversionSettings sQLConversionSettings, Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sQLConversionSettings.getDateSeparator();
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.setTime(date);
        switch (sQLConversionSettings.getDateFormat()) {
            case 4: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                stringBuffer.append('/');
                stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                stringBuffer.append('/');
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 4));
                break;
            }
            case 6: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                stringBuffer.append('.');
                stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                stringBuffer.append('.');
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 4));
                break;
            }
            case 0: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(6), 3));
                break;
            }
            case 1: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                break;
            }
            case 2: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                break;
            }
            case 3: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                stringBuffer.append(string);
                stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                break;
            }
            case 5: 
            case 7: {
                stringBuffer.append(JDUtilities.padZeros(calendar.get(1), 4));
                stringBuffer.append('-');
                stringBuffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                stringBuffer.append('-');
                stringBuffer.append(JDUtilities.padZeros(calendar.get(5), 2));
            }
        }
        return stringBuffer.toString();
    }

    private static int twoDigitYearToFour(int n) {
        return n <= 39 ? n + 2000 : n + 1900;
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = this.settings_.getDateFormat();
        switch (this.dateFormat_ != -1 && this.dateFormat_ != n2 ? this.dateFormat_ : n2) {
            case 0: {
                this.year_ = SQLDate.twoDigitYearToFour((byArray[n + 0] & 0xF) * 10 + (byArray[n + 1] & 0xF));
                Calendar calendar = AS400Calendar.getGregorianInstance();
                calendar.clear();
                calendar.set(1, this.year_);
                calendar.set(6, (byArray[n + 3] & 0xF) * 100 + (byArray[n + 4] & 0xF) * 10 + (byArray[n + 5] & 0xF));
                calendar.setTime(calendar.getTime());
                this.month_ = calendar.get(2);
                this.day_ = calendar.get(5);
                break;
            }
            case 1: {
                this.month_ = (byArray[n + 0] & 0xF) * 10 + (byArray[n + 1] & 0xF) - 1;
                this.day_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF);
                this.year_ = SQLDate.twoDigitYearToFour((byArray[n + 6] & 0xF) * 10 + (byArray[n + 7] & 0xF));
                break;
            }
            case 2: {
                this.day_ = (byArray[n + 0] & 0xF) * 10 + (byArray[n + 1] & 0xF);
                this.month_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF) - 1;
                this.year_ = SQLDate.twoDigitYearToFour((byArray[n + 6] & 0xF) * 10 + (byArray[n + 7] & 0xF));
                break;
            }
            case 3: {
                this.year_ = SQLDate.twoDigitYearToFour((byArray[n + 0] & 0xF) * 10 + (byArray[n + 1] & 0xF));
                this.month_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF) - 1;
                this.day_ = (byArray[n + 6] & 0xF) * 10 + (byArray[n + 7] & 0xF);
                break;
            }
            case 4: {
                this.month_ = (byArray[n + 0] & 0xF) * 10 + (byArray[n + 1] & 0xF) - 1;
                this.day_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF);
                this.year_ = (byArray[n + 6] & 0xF) * 1000 + (byArray[n + 7] & 0xF) * 100 + (byArray[n + 8] & 0xF) * 10 + (byArray[n + 9] & 0xF);
                break;
            }
            case 5: 
            case 7: {
                this.year_ = (byArray[n + 0] & 0xF) * 1000 + (byArray[n + 1] & 0xF) * 100 + (byArray[n + 2] & 0xF) * 10 + (byArray[n + 3] & 0xF);
                this.month_ = (byArray[n + 5] & 0xF) * 10 + (byArray[n + 6] & 0xF) - 1;
                this.day_ = (byArray[n + 8] & 0xF) * 10 + (byArray[n + 9] & 0xF);
                break;
            }
            case 6: {
                this.day_ = (byArray[n + 0] & 0xF) * 10 + (byArray[n + 1] & 0xF);
                this.month_ = (byArray[n + 3] & 0xF) * 10 + (byArray[n + 4] & 0xF) - 1;
                this.year_ = (byArray[n + 6] & 0xF) * 1000 + (byArray[n + 7] & 0xF) * 100 + (byArray[n + 8] & 0xF) * 10 + (byArray[n + 9] & 0xF);
            }
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(JDUtilities.padZeros(this.year_, 4));
        stringBuffer.append('-');
        stringBuffer.append(JDUtilities.padZeros(this.month_ + 1, 2));
        stringBuffer.append('-');
        stringBuffer.append(JDUtilities.padZeros(this.day_, 2));
        try {
            convTable.stringToByteArray(stringBuffer.toString(), byArray, n);
        }
        catch (CharConversionException charConversionException) {
            JDError.throwSQLException("HY000", charConversionException);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        if (object instanceof String) {
            SQLDate.stringToDate((String)object, this.settings_, calendar);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
        } else if (object instanceof java.util.Date) {
            calendar.setTime((java.util.Date)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            this.year_ = localDate.getYear();
            this.month_ = localDate.getMonthValue() - 1;
            this.day_ = localDate.getDayOfMonth();
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            this.year_ = localDateTime.getYear();
            this.month_ = localDateTime.getMonthValue() - 1;
            this.day_ = localDateTime.getDayOfMonth();
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            if (object != null) {
                JDError.throwSQLException((Object)this, "07006", object.getClass().getName());
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        }
    }

    public int getSQLType() {
        return 10;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 10;
    }

    public String getJavaClassName() {
        return "java.sql.Date";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "DATE";
    }

    public int getMaximumPrecision() {
        return 10;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 384;
    }

    public int getPrecision() {
        return 10;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 91;
    }

    public String getTypeName() {
        return "DATE";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        return 10;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        return new Date(l);
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getDate(null);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        Date date = new Date(l);
        return SQLDate.dateToString(date, this.settings_, calendar);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(0);
        return timestamp;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long l = jdk14 ? calendar.getTimeInMillis() : calendar.getTime().getTime();
        Date date = new Date(l);
        return SQLDate.dateToString(date, this.settings_, calendar);
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() throws SQLException {
        this.savedValue_ = this.getObject();
    }

    static {
        jdk14 = JVMInfo.isJDK14();
    }
}

