/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400CredentialImplRemote;
import com.ibm.as400.security.auth.AuthenticationSystem;
import com.ibm.as400.security.auth.DestroyFailedException;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import com.ibm.as400.security.auth.ProfileTokenImpl;
import com.ibm.as400.security.auth.RefreshFailedException;
import com.ibm.as400.security.auth.RetrieveFailedException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

class ProfileTokenImplRemote
extends AS400CredentialImplRemote
implements ProfileTokenImpl {
    ProfileTokenImplRemote() {
    }

    public void destroy() throws DestroyFailedException {
        this.removeFromSystem();
        super.destroy();
    }

    public byte[] generateToken(String string, String string2, int n, int n2) throws RetrieveFailedException {
        AS400 aS400 = this.getCredential().getSystem();
        try {
            if (aS400.getVRM() >= 328448) {
                Trace.log(2, "setToken(String,String,in,int) deprecated.Use setTokenExtended(String,String,int,int).");
                throw new ExtendedIllegalArgumentException("Method deprecated", 2);
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new RetrieveFailedException(aS400SecurityException.getReturnCode());
        }
        catch (IOException iOException) {
            AuthenticationSystem.handleUnexpectedException(iOException);
        }
        byte[] byArray = null;
        try {
            byArray = aS400.getProfileToken(string, string2, n, n2).getToken();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new RetrieveFailedException(aS400SecurityException.getReturnCode());
        }
        catch (Exception exception) {
            AuthenticationSystem.handleUnexpectedException(exception);
        }
        return byArray;
    }

    public byte[] generateToken(String string, int n, int n2, int n3) throws RetrieveFailedException {
        String string2;
        switch (n) {
            case 1: {
                string2 = "*NOPWD    ";
                break;
            }
            case 2: {
                string2 = "*NOPWDCHK ";
                break;
            }
            default: {
                Trace.log(2, "Password special value = " + n + " is not valid.");
                throw new ExtendedIllegalArgumentException("Password special value", 2);
            }
        }
        AS400 aS400 = this.getCredential().getSystem();
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        programParameterArray[0] = new ProgramParameter(32);
        programParameterArray[1] = new ProgramParameter(ProfileTokenImplRemote.stringToByteArray(string.toUpperCase()));
        try {
            programParameterArray[2] = new ProgramParameter(CharConverter.stringToByteArray(37, aS400, string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, "Unexpected UnsupportedEncodingException: ", (Throwable)unsupportedEncodingException);
            throw new RetrieveFailedException();
        }
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[4] = new ProgramParameter(CharConverter.stringToByteArray(aS400, new Integer(n2).toString()));
        programParameterArray[5] = new ProgramParameter(BinaryConverter.intToByteArray(0));
        ProgramCall programCall = new ProgramCall(aS400);
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGENPT", "PGM"), programParameterArray);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGENPT failed.");
                throw new RetrieveFailedException(programCall.getMessageList());
            }
        }
        catch (IOException iOException) {
            AuthenticationSystem.handleUnexpectedException(iOException);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
        catch (InterruptedException interruptedException) {
            AuthenticationSystem.handleUnexpectedException(interruptedException);
        }
        catch (Exception exception) {
            throw new RetrieveFailedException();
        }
        return programParameterArray[0].getOutputData();
    }

    public byte[] generateTokenExtended(String string, String string2, int n, int n2) throws RetrieveFailedException {
        byte[] byArray = null;
        try {
            byArray = this.getCredential().getSystem().getProfileToken(string, string2, n, n2).getToken();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new RetrieveFailedException(aS400SecurityException.getReturnCode());
        }
        catch (Exception exception) {
            AuthenticationSystem.handleUnexpectedException(exception);
        }
        return byArray;
    }

    public byte[] generateTokenExtended(String string, char[] cArray, int n, int n2) throws RetrieveFailedException {
        byte[] byArray = null;
        try {
            byArray = this.getCredential().getSystem().getProfileToken(string, cArray, n, n2).getToken();
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new RetrieveFailedException(aS400SecurityException.getReturnCode());
        }
        catch (Exception exception) {
            AuthenticationSystem.handleUnexpectedException(exception);
        }
        return byArray;
    }

    public int getTimeToExpiration() throws RetrieveFailedException {
        ProgramCall programCall = new ProgramCall(this.getCredential().getSystem());
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(4), new ProgramParameter(new AS400ByteArray(32).toBytes(((ProfileTokenCredential)this.getCredential()).getToken())), new ProgramParameter(new AS400Bin4().toBytes(0))};
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGETPT", "PGM"), programParameterArray);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGETPT failed.");
                throw new RetrieveFailedException();
            }
        }
        catch (IOException iOException) {
            AuthenticationSystem.handleUnexpectedException(iOException);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
        catch (InterruptedException interruptedException) {
            AuthenticationSystem.handleUnexpectedException(interruptedException);
        }
        catch (Exception exception) {
            throw new RetrieveFailedException(programCall.getMessageList());
        }
        return new AS400Bin4().toInt(programParameterArray[0].getOutputData());
    }

    public byte[] refresh(int n, int n2) throws RefreshFailedException {
        ProfileTokenCredential profileTokenCredential = (ProfileTokenCredential)this.getCredential();
        AS400 aS400 = profileTokenCredential.getSystem();
        ProgramCall programCall = new ProgramCall(profileTokenCredential.getSystem());
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(32), new ProgramParameter(new AS400ByteArray(32).toBytes(profileTokenCredential.getToken())), new ProgramParameter(new AS400Bin4().toBytes(n2)), new ProgramParameter(new AS400Text(1, aS400.getCcsid(), aS400).toBytes(new Integer(n).toString())), new ProgramParameter(new AS400Bin4().toBytes(0))};
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYGENFT", "PGM"), programParameterArray);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYGENFT failed.");
                throw new RefreshFailedException();
            }
        }
        catch (IOException iOException) {
            AuthenticationSystem.handleUnexpectedException(iOException);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
        catch (InterruptedException interruptedException) {
            AuthenticationSystem.handleUnexpectedException(interruptedException);
        }
        catch (Exception exception) {
            throw new RefreshFailedException(programCall.getMessageList());
        }
        return (byte[])new AS400ByteArray(32).toObject(programParameterArray[0].getOutputData());
    }

    void removeFromSystem() throws DestroyFailedException {
        ProfileTokenCredential profileTokenCredential = (ProfileTokenCredential)this.getCredential();
        AS400 aS400 = profileTokenCredential.getSystem();
        ProgramCall programCall = new ProgramCall(aS400);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(new AS400Text(10, aS400.getCcsid(), aS400).toBytes("*PRFTKN")), new ProgramParameter(new AS400Bin4().toBytes(0)), new ProgramParameter(new AS400ByteArray(32).toBytes(profileTokenCredential.getToken()))};
        try {
            programCall.setProgram(QSYSObjectPathName.toPath("QSYS", "QSYRMVPT", "PGM"), programParameterArray);
            programCall.suggestThreadsafe();
            if (!programCall.run()) {
                Trace.log(2, "Call to QSYRMVPT failed.");
                throw new DestroyFailedException();
            }
        }
        catch (IOException iOException) {
            AuthenticationSystem.handleUnexpectedException(iOException);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
        catch (InterruptedException interruptedException) {
            AuthenticationSystem.handleUnexpectedException(interruptedException);
        }
        catch (Exception exception) {
            throw new DestroyFailedException(programCall.getMessageList());
        }
    }

    private static byte[] stringToByteArray(String string) throws RetrieveFailedException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        block55: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '#': {
                    byArray[i] = 123;
                    continue block55;
                }
                case '$': {
                    byArray[i] = 91;
                    continue block55;
                }
                case '0': {
                    byArray[i] = -16;
                    continue block55;
                }
                case '1': {
                    byArray[i] = -15;
                    continue block55;
                }
                case '2': {
                    byArray[i] = -14;
                    continue block55;
                }
                case '3': {
                    byArray[i] = -13;
                    continue block55;
                }
                case '4': {
                    byArray[i] = -12;
                    continue block55;
                }
                case '5': {
                    byArray[i] = -11;
                    continue block55;
                }
                case '6': {
                    byArray[i] = -10;
                    continue block55;
                }
                case '7': {
                    byArray[i] = -9;
                    continue block55;
                }
                case '8': {
                    byArray[i] = -8;
                    continue block55;
                }
                case '9': {
                    byArray[i] = -7;
                    continue block55;
                }
                case '@': {
                    byArray[i] = 124;
                    continue block55;
                }
                case 'A': {
                    byArray[i] = -63;
                    continue block55;
                }
                case 'B': {
                    byArray[i] = -62;
                    continue block55;
                }
                case 'C': {
                    byArray[i] = -61;
                    continue block55;
                }
                case 'D': {
                    byArray[i] = -60;
                    continue block55;
                }
                case 'E': {
                    byArray[i] = -59;
                    continue block55;
                }
                case 'F': {
                    byArray[i] = -58;
                    continue block55;
                }
                case 'G': {
                    byArray[i] = -57;
                    continue block55;
                }
                case 'H': {
                    byArray[i] = -56;
                    continue block55;
                }
                case 'I': {
                    byArray[i] = -55;
                    continue block55;
                }
                case 'J': {
                    byArray[i] = -47;
                    continue block55;
                }
                case 'K': {
                    byArray[i] = -46;
                    continue block55;
                }
                case 'L': {
                    byArray[i] = -45;
                    continue block55;
                }
                case 'M': {
                    byArray[i] = -44;
                    continue block55;
                }
                case 'N': {
                    byArray[i] = -43;
                    continue block55;
                }
                case 'O': {
                    byArray[i] = -42;
                    continue block55;
                }
                case 'P': {
                    byArray[i] = -41;
                    continue block55;
                }
                case 'Q': {
                    byArray[i] = -40;
                    continue block55;
                }
                case 'R': {
                    byArray[i] = -39;
                    continue block55;
                }
                case 'S': {
                    byArray[i] = -30;
                    continue block55;
                }
                case 'T': {
                    byArray[i] = -29;
                    continue block55;
                }
                case 'U': {
                    byArray[i] = -28;
                    continue block55;
                }
                case 'V': {
                    byArray[i] = -27;
                    continue block55;
                }
                case 'W': {
                    byArray[i] = -26;
                    continue block55;
                }
                case 'X': {
                    byArray[i] = -25;
                    continue block55;
                }
                case 'Y': {
                    byArray[i] = -24;
                    continue block55;
                }
                case 'Z': {
                    byArray[i] = -23;
                    continue block55;
                }
                case '_': {
                    byArray[i] = 109;
                    continue block55;
                }
                case '\u00a3': {
                    byArray[i] = 123;
                    continue block55;
                }
                case '\u00a5': {
                    byArray[i] = 91;
                    continue block55;
                }
                case '\u00a7': {
                    byArray[i] = 124;
                    continue block55;
                }
                case '\u00c4': {
                    byArray[i] = 123;
                    continue block55;
                }
                case '\u00c5': {
                    byArray[i] = 91;
                    continue block55;
                }
                case '\u00c6': {
                    byArray[i] = 123;
                    continue block55;
                }
                case '\u00d0': {
                    byArray[i] = 124;
                    continue block55;
                }
                case '\u00d1': {
                    byArray[i] = 123;
                    continue block55;
                }
                case '\u00d6': {
                    byArray[i] = 124;
                    continue block55;
                }
                case '\u00d8': {
                    byArray[i] = 124;
                    continue block55;
                }
                case '\u00e0': {
                    byArray[i] = 124;
                    continue block55;
                }
                case '\u0130': {
                    byArray[i] = 91;
                    continue block55;
                }
                case '\u015e': {
                    byArray[i] = 124;
                    continue block55;
                }
                default: {
                    throw new RetrieveFailedException(63);
                }
            }
        }
        return byArray;
    }
}

