/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class UpdateACSJar {
    static final String copyright = "Copyright (C) 2018 International Business Machines Corporation and others.";

    public static void main(String[] stringArray) {
        try {
            System.out.println("Usage: java -cp jt400.jar com.ibm.as400.util.UpdateACSJar <acsbundle.jar>");
            System.out.println("       This program updates acsbundle.jar with the current jt400.jar file.");
            System.out.println("       If acsbundle.jar is not specified, the default locations of acsbundle.jar are used. ");
            System.out.println("       This is provided so that ACS Run SQL Scripts can utilize the latest features of JTOpen.");
            System.out.println("       ");
            System.out.println(" Note: Official support for ACS is not available if this tool is used since ");
            System.out.println("       official testing has not been done on the resultant combination.");
            System.out.println("       If you find ACS does not work after the update, delete acsbundle.jar and replace it ");
            System.out.println("       with the backup file that was created by this program. ");
            System.out.println("");
            System.out.println(" Please report problems with jt400.jar on the JTOpen bug forum: https://sourceforge.net/p/jt400/bugs/ ");
            System.out.println("");
            System.out.println(" This version creates an enableClientAffinitiesList jdbc configuration to use the new ");
            System.out.println(" ClientAffinities property.");
            System.out.println("");
            String string = "Open Source Software, JTOpen 11.1 codebase 5770-SS1 V7R5M0.00 built=20221028 @AI4";
            String string2 = null;
            if (stringArray.length > 0) {
                string2 = stringArray[0];
            }
            File file = UpdateACSJar.locateCurrentJt400JarFile();
            System.out.println("Updating acsbundle.jar");
            UpdateACSJar.updateAcsBundle(file, string2);
            System.out.println("Checking jdbc configuration");
            UpdateACSJar.createEnableClientAffinitiesList();
            System.out.println("Tool ended successfully with acsbundle.jar updated with the following jar.");
            System.out.println("   " + string);
            System.out.println("To verify jt400.jar version, start ACS, then RSS, then run the query");
            System.out.println("values {fn jtopeninfo()};");
            System.out.println("The returned information should match the version information above");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static File locateCurrentJt400JarFile() throws Exception {
        String string = "unknown";
        ClassLoader classLoader = UpdateACSJar.class.getClassLoader();
        if (classLoader != null) {
            String string2 = UpdateACSJar.class.getName().replace('.', '/') + ".class";
            URL uRL = classLoader.getResource(string2);
            if (uRL != null) {
                string = uRL.getPath();
                if (string.indexOf("file:") == 0) {
                    int n = (string = string.substring(5)).indexOf(33);
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    if (string.endsWith(".jar")) {
                        return new File(string);
                    }
                    throw new Exception("Resource " + string + " is not jar file ");
                }
                throw new Exception("Rosource " + string + " is not a file");
            }
            throw new Exception("Unable to find resourceUrl for " + string2);
        }
        throw new Exception("Unable to find classloader for " + UpdateACSJar.class.toString());
    }

    private static void createEnableClientAffinitiesList() throws Exception {
        File file = UpdateACSJar.getJdbcConfigFile();
        if (file.exists()) {
            System.out.println("jdbc configuration '" + file.toString() + "' already exists and was not updated.");
        } else {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("# Created by com.ibm.as400.access.util.UpdateACSJar");
            printWriter.println("naming=sql");
            printWriter.println("time\\ format=iso");
            printWriter.println("date\\ format=iso");
            printWriter.println("enableClientAffinitiesList=1");
            printWriter.println("maxRetriesForClientReroute=10");
            printWriter.println("retryIntervalForClientReroute=6");
            printWriter.close();
            System.out.println("Create jdbc configuration '" + file.toString() + "'.");
        }
    }

    private static File getJdbcConfigFile() throws Exception {
        File file;
        String string = System.getProperty("user.home") + "\\Documents\\IBM\\iAccessClient\\RunSQLScripts\\JDBC";
        if (System.getProperty("os.name").indexOf("Mac") >= 0) {
            string = System.getProperty("user.home") + "/IBM/iAccessClient/RunSQLScripts/JDBC";
        }
        if (!(file = new File(string)).exists()) {
            System.out.println("Creating JDBC configuration location at " + string);
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new Exception("JDBC configuration location '" + string + "' is not a directory.");
        }
        return new File(file + File.separator + "enableClientAffinitiesList.jdbc");
    }

    private static void updateAcsBundle(File file, String string) throws Exception {
        File[] fileArray;
        if (string == null) {
            fileArray = UpdateACSJar.findAcsBundles();
        } else {
            File file2 = new File(string);
            if (!file2.exists()) {
                throw new Exception("Error " + string + " does not exist");
            }
            fileArray = new File[]{file2};
        }
        for (int i = 0; i < fileArray.length; ++i) {
            int n;
            Object object;
            File file3 = fileArray[i];
            if (file3 == null) continue;
            System.out.println("Updating " + file3.getPath() + " with " + file.getPath());
            File file4 = UpdateACSJar.backupBundle(file3);
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file4));
            byte[] byArray = new byte[4096];
            Manifest manifest = jarInputStream.getManifest();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            manifest.write(byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray2), "UTF-8"));
            String string2 = bufferedReader.readLine();
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (string2 != null) {
                if (!bl) {
                    if (string2.indexOf("jt400.jar") >= 0) {
                        bl = true;
                    } else {
                        stringBuffer.append(string2);
                        stringBuffer.append("\n");
                    }
                } else {
                    bl = false;
                }
                string2 = bufferedReader.readLine();
            }
            String string3 = stringBuffer.toString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes("UTF-8"));
            manifest = new Manifest(byteArrayInputStream);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file3), manifest);
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                object = jarEntry.getName();
                if (!((String)object).equals("lib/jt400.jar") && ((String)object).indexOf("IBMACS.RSA") < 0 && ((String)object).indexOf("IBMACS.SF") < 0) {
                    jarOutputStream.putNextEntry(new JarEntry((String)object));
                    while ((n = jarInputStream.read(byArray)) > 0) {
                        jarOutputStream.write(byArray, 0, n);
                    }
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
            jarInputStream.close();
            object = new FileInputStream(file);
            jarOutputStream.putNextEntry(new JarEntry("lib/jt400.jar"));
            while ((n = ((InputStream)object).read(byArray)) > 0) {
                jarOutputStream.write(byArray, 0, n);
            }
            ((InputStream)object).close();
            jarOutputStream.closeEntry();
            jarOutputStream.close();
        }
    }

    private static File backupBundle(File file) throws Exception {
        boolean bl;
        String string = file.getAbsolutePath();
        File file2 = new File(string + "." + UpdateACSJar.currentDateString());
        if (file2.exists()) {
            file2.delete();
        }
        if (!(bl = file.renameTo(file2))) {
            throw new Exception("\n  Unable to rename " + string + " to " + file2 + ".\n  Have all instances of ACS and RSS been stopped?");
        }
        System.out.println(" Renamed old acsbundle.jar to " + file2);
        return file2;
    }

    private static String currentDateString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(new Date());
    }

    private static File[] findAcsBundles() throws Exception {
        int n;
        String[] stringArray = new String[]{"C:\\Users\\Public\\IBM\\ClientSolutions\\acsbundle.jar", System.getProperty("user.home") + "\\IBM\\ClientSolutions\\acsbundle.jar", "/Applications/IBM i Access Client Solutions.app/acsbundle.jar"};
        boolean bl = false;
        File[] fileArray = new File[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            File file = new File(stringArray[n]);
            if (!file.exists()) continue;
            fileArray[n] = file;
            bl = true;
        }
        if (!bl) {
            System.out.println("ERROR:  Could not find bundle file");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("..Looked for " + stringArray[n]);
            }
            throw new Exception("Could not find bundle file.");
        }
        return fileArray;
    }
}

