/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.access.QueuedMessage;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.QueuedMessagePropertiesPane;
import com.ibm.as400.vaccess.QueuedMessageRemoveAction;
import com.ibm.as400.vaccess.QueuedMessageReplyAction;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.Icon;

public class VQueuedMessage
implements VObject,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("MESSAGE_QUEUED_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VMessage16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VMessage32.gif", description_);
    private QueuedMessage message_ = null;
    private MessageQueue queue_ = null;
    private transient VAction[] actions_;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    public static final Object DATE_PROPERTY = "Date";
    public static final Object FROM_JOB_PROPERTY = "From job";
    public static final Object FROM_JOB_NUMBER_PROPERTY = "From job number";
    public static final Object FROM_PROGRAM_PROPERTY = "From program";
    public static final Object FROM_USER_PROPERTY = "From user";
    public static final Object ID_PROPERTY = "ID";
    public static final Object MESSAGE_QUEUE_PROPERTY = "Message queue";
    public static final Object SEVERITY_PROPERTY = "Severity";
    public static final Object TEXT_PROPERTY = "Text";
    public static final Object TYPE_PROPERTY = "Type";

    VQueuedMessage(QueuedMessage queuedMessage, MessageQueue messageQueue) {
        if (queuedMessage == null) {
            throw new NullPointerException("message");
        }
        if (messageQueue == null) {
            throw new NullPointerException("queue");
        }
        this.message_ = queuedMessage;
        this.queue_ = messageQueue;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public VAction[] getActions() {
        return this.actions_;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == NAME_PROPERTY) {
            return this;
        }
        if (object == DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (object == ID_PROPERTY) {
            return this.message_.getID();
        }
        if (object == TEXT_PROPERTY) {
            return this.message_.getText();
        }
        if (object == SEVERITY_PROPERTY) {
            return new Integer(this.message_.getSeverity());
        }
        if (object == TYPE_PROPERTY) {
            return MessageUtilities.getTypeText(this.message_.getType());
        }
        if (object == DATE_PROPERTY) {
            return this.message_.getDate().getTime();
        }
        if (object == FROM_JOB_PROPERTY) {
            return this.message_.getFromJobName();
        }
        if (object == FROM_USER_PROPERTY) {
            return this.message_.getUser();
        }
        if (object == FROM_JOB_NUMBER_PROPERTY) {
            return this.message_.getFromJobNumber();
        }
        if (object == FROM_PROGRAM_PROPERTY) {
            return this.message_.getFromProgram();
        }
        if (object == MESSAGE_QUEUE_PROPERTY) {
            MessageQueue messageQueue = this.message_.getQueue();
            if (messageQueue == null) {
                return "";
            }
            return messageQueue.getPath();
        }
        return null;
    }

    public String getText() {
        String string = this.message_.getID();
        if (string == null) {
            return "";
        }
        return string;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.actions_ = new VAction[]{new QueuedMessageReplyAction(this, this.message_, this.queue_), new QueuedMessageRemoveAction((VObject)this, this.message_, this.queue_)};
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new QueuedMessagePropertiesPane(this, this.message_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public void load() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public String toString() {
        String string = this.message_.getID();
        if (string == null) {
            return "";
        }
        return string;
    }
}

