/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.util.BASE64Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import utilities.JarMakerEvent;
import utilities.JarMakerListener;

public class JarMaker {
    static final boolean DEBUG = false;
    private static final boolean DEBUG_MANIFEST = false;
    private static final boolean DEBUG_CP = false;
    private static final boolean DEBUG_ZIP = false;
    private static final boolean DEBUG_REF = false;
    static final String CLASS_SUFFIX = ".class";
    private static final String MANIFEST_DIR_NAME = "META-INF/";
    private static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_NAME_KEYWORD = "Name:";
    private static final String MANIFEST_VERSION_KEYWORD = "Manifest-Version:";
    private static final String MANIFEST_REQVERS_KEYWORD = "Required-Version:";
    private static final int BUFFER_SIZE = 2048;
    private static final int SPLIT_SIZE_KBYTES = 2048;
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);
    static final File CURRENT_DIR = new File(System.getProperty("user.dir"));
    static final boolean CHECK_DUPS = true;
    static final boolean NO_CHECK_DUPS = false;
    static final int STARTS_WITH = 1;
    static final int ENDS_WITH = 2;
    static final int CONTAINS = 3;
    private static boolean noSHA_ = false;
    private static boolean noMD5_ = false;
    boolean verbose_;
    boolean requestedUsageInfo_;
    private File sourceJarFile_;
    private File destinationJarFile_;
    private Vector filesRequired_ = new Vector();
    private Vector filesExcluded_ = new Vector();
    private Vector packages_ = new Vector();
    private Vector packagesExcluded_ = new Vector();
    private Hashtable additionalFiles_ = new Hashtable();
    boolean excludeSomeDependencies_;
    Vector dependenciesToExclude_ = new Vector();
    private boolean extract_ = false;
    private File baseDirectoryForExtract_ = new File(System.getProperty("user.dir"));
    private boolean split_ = false;
    private int splitSize_ = 2048;
    private String jarEntryDefaultPrefix_;
    private String jarEntryDefaultPrefixDotted_;
    private transient Vector eventListeners_ = new Vector();
    private Arguments arguments_ = new Arguments();
    static final boolean OPTIONS_ALL = true;
    static final boolean OPTIONS_UNRECOGNIZED = false;

    public JarMaker() {
    }

    JarMaker(String string) {
        this.jarEntryDefaultPrefix_ = string;
        this.jarEntryDefaultPrefixDotted_ = string.replace('/', '.');
    }

    static boolean addElement(Vector vector, Object object) {
        if (vector.contains(object)) {
            return false;
        }
        vector.addElement(object);
        return true;
    }

    static void removeElements(Vector vector, String string, int n) {
        Object object;
        Vector<Object> vector2 = new Vector<Object>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            boolean bl = false;
            switch (n) {
                case 1: {
                    if (!((String)object).startsWith(string)) break;
                    bl = true;
                    break;
                }
                case 2: {
                    if (!((String)object).endsWith(string)) break;
                    bl = true;
                    break;
                }
                default: {
                    if (((String)object).indexOf(string) == -1) break;
                    bl = true;
                }
            }
            if (!bl) continue;
            vector2.addElement(object);
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            vector.removeElement((String)object.nextElement());
        }
    }

    public synchronized void addJarMakerListener(JarMakerListener jarMakerListener) {
        if (jarMakerListener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners_.addElement(jarMakerListener);
    }

    static void addPackageFiles(Vector vector, JarMap jarMap, Vector vector2) throws IOException {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.replace('.', '/');
            Vector vector3 = JarMaker.getEntryNamesForPackage(string2, jarMap);
            if (vector3.size() == 0) {
                System.err.println("Error: Specified package not found in source file:");
                System.err.println("       " + string);
                throw new ZipException(string);
            }
            JarMaker.copyVector(vector3, vector, true);
        }
    }

    static void removePackageFiles(Vector vector, JarMap jarMap, Vector vector2) throws IOException {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.replace('.', '/');
            Vector vector3 = JarMaker.getEntryNamesForPackage(string2, jarMap);
            if (vector3.size() == 0) {
                System.err.println("Error: Specified package not found in source file:");
                System.err.println("       " + string);
                throw new ZipException(string);
            }
            JarMaker.removeElements(vector, vector3);
        }
    }

    Vector adjustDependencies1(Vector vector, JarMap jarMap) throws IOException {
        return vector;
    }

    Vector adjustDependencies2(Vector vector, JarMap jarMap) throws IOException {
        JarMaker.removePackageFiles(vector, jarMap, this.packagesExcluded_);
        JarMaker.addPackageFiles(vector, jarMap, this.packages_);
        return vector;
    }

    void analyzeJarEntry(String string, Vector vector, Vector vector2, JarMap jarMap) throws IOException {
        this.fireAnalysisEvent(true, string);
        if (string.endsWith(CLASS_SUFFIX)) {
            if (this.excludeSomeDependencies_ && this.dependenciesToExclude_.contains(string)) {
                if (this.verbose_) {
                    System.out.println("\nExcluding entry from dependency analysis: " + string + "\n");
                }
                JarMaker.addElement(vector2, string);
            } else {
                Vector vector3 = this.getReferencedEntries(string, jarMap);
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!vector.contains(string2)) continue;
                    vector.removeElement(string2);
                    this.analyzeJarEntry(string2, vector, vector2, jarMap);
                    JarMaker.addElement(vector2, string2);
                }
            }
        }
        this.fireAnalysisEvent(false, string);
    }

    private static void constructManifestEntry(StringBuffer stringBuffer, File file, String string) throws IOException {
        String string2;
        byte[] byArray;
        MessageDigest messageDigest;
        String string3 = null;
        String string4 = null;
        byte[] byArray2 = JarMaker.getBytes(file);
        if (!noSHA_) {
            try {
                messageDigest = MessageDigest.getInstance("SHA");
                byArray = messageDigest.digest(byArray2);
                string2 = new BASE64Encoder().encodeBuffer(byArray);
                string3 = "SHA-Digest: " + string2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noSHA_ = true;
            }
        }
        if (!noMD5_) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
                byArray = messageDigest.digest(byArray2);
                string2 = new BASE64Encoder().encodeBuffer(byArray);
                string4 = "MD5-Digest: " + string2;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                noMD5_ = true;
            }
        }
        if (string3 != null || string4 != null) {
            stringBuffer.append("Name: " + string + "\n");
            stringBuffer.append("Digest-Algorithms:");
            if (string3 != null) {
                stringBuffer.append(" SHA");
            }
            if (string4 != null) {
                stringBuffer.append(" MD5");
            }
            stringBuffer.append('\n');
            if (string3 != null) {
                stringBuffer.append(string3);
                if (!string3.endsWith("\n")) {
                    stringBuffer.append('\n');
                }
            }
            if (string4 != null) {
                stringBuffer.append(string4);
                if (!string4.endsWith("\n")) {
                    stringBuffer.append('\n');
                }
            }
            stringBuffer.append('\n');
        } else {
            System.err.println("Error: Failed to construct manifest entry for file");
            System.err.println("       " + file.getAbsolutePath());
        }
    }

    static final boolean contains(int[] nArray, int n) {
        return Arrays.binarySearch(nArray, n) >= 0;
    }

    private static void copyBytes(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[2048];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while (!bl && (long)n2 < l) {
            n = inputStream.read(byArray, 0, byArray.length);
            if (n == -1) {
                bl = true;
                continue;
            }
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
    }

    /*
     * Loose catch block
     */
    static void copyFile(File file, File file2) throws IOException {
        block17: {
            FilterOutputStream filterOutputStream;
            BufferedInputStream bufferedInputStream;
            block16: {
                if (file == null) {
                    throw new NullPointerException("sourceFile");
                }
                if (file2 == null) {
                    throw new NullPointerException("destinationFile");
                }
                bufferedInputStream = null;
                filterOutputStream = null;
                String string = file2.getParent();
                if (string == null) {
                    throw new NullPointerException("parentDirectory");
                }
                File file3 = new File(string);
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new IOException(file3.getAbsolutePath() + ": Cannot create directory.");
                }
                byte[] byArray = new byte[2048];
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 2048);
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 2048);
                boolean bl = false;
                while (!bl) {
                    int n = bufferedInputStream.read(byArray);
                    if (n == -1) {
                        bl = true;
                        continue;
                    }
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                Object var10_10 = null;
                if (bufferedInputStream == null) break block16;
                try {
                    bufferedInputStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            break block17;
            {
                catch (IOException iOException) {
                    System.err.println("Error: IOException when copying file");
                    System.err.println("       " + file2.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                throw throwable;
            }
        }
    }

    static void copyVector(Vector vector, Vector vector2, boolean bl) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (bl && vector2.contains(e)) continue;
            vector2.addElement(e);
        }
    }

    static void removeElements(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.remove(enumeration.nextElement());
        }
    }

    static void copyZipEntry(ZipEntry zipEntry, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        long l;
        long l2;
        if (zipEntry == null) {
            throw new NullPointerException("inZipEntry");
        }
        if (inputStream == null) {
            throw new NullPointerException("inStream");
        }
        if (zipOutputStream == null) {
            throw new NullPointerException("zipOutStream");
        }
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setComment(zipEntry.getComment());
        long l3 = zipEntry.getCrc();
        if (l3 != -1L) {
            zipEntry2.setCrc(l3);
        }
        zipEntry2.setExtra(zipEntry.getExtra());
        int n = zipEntry.getMethod();
        if (n != -1) {
            zipEntry2.setMethod(n);
        }
        if ((l2 = zipEntry.getSize()) != -1L) {
            zipEntry2.setSize(l2);
        }
        if ((l = zipEntry.getTime()) != -1L) {
            zipEntry2.setTime(l);
        }
        zipOutputStream.putNextEntry(zipEntry2);
        byte[] byArray = new byte[2048];
        if (!zipEntry.isDirectory()) {
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            while (!bl && (long)n3 < l2) {
                n2 = inputStream.read(byArray);
                if (n2 == -1) {
                    bl = true;
                    continue;
                }
                zipOutputStream.write(byArray, 0, n2);
                n3 += n2;
            }
        }
    }

    private static int determineDirMetadataSize(Vector vector, int n) {
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n2 += string.length();
            n2 += n;
        }
        return n2;
    }

    public File extract(File file) throws FileNotFoundException, IOException, ZipException {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        File file2 = new File(System.getProperty("user.dir"));
        this.extract(file, file2);
        return file2;
    }

    /*
     * Loose catch block
     */
    public void extract(File file, File file2) throws FileNotFoundException, IOException, ZipException {
        block33: {
            Throwable throwable2222;
            JarMap jarMap;
            InputStream inputStream;
            FilterOutputStream filterOutputStream;
            block31: {
                if (file == null) {
                    throw new NullPointerException("sourceJarFile");
                }
                if (file2 == null) {
                    throw new NullPointerException("outputDirectory");
                }
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                if (this.verbose_) {
                    System.out.println("Source file is " + file.getAbsolutePath());
                    System.out.println("Extraction output directory is " + file2.getAbsolutePath());
                }
                filterOutputStream = null;
                inputStream = null;
                String string = file2.getAbsolutePath();
                jarMap = null;
                if (this.additionalFiles_.size() != 0) {
                    System.err.println("Warning: Additional files were specified.  They are ignored by extract().");
                }
                jarMap = new JarMap(file, this.verbose_);
                Vector vector = this.identifyDependencies(jarMap);
                if (jarMap.hasManifest() && !vector.contains(MANIFEST_ENTRY_NAME)) {
                    int n = vector.indexOf(MANIFEST_DIR_NAME);
                    if (n == -1) {
                        vector.insertElementAt(MANIFEST_DIR_NAME, 0);
                        n = 0;
                    }
                    vector.insertElementAt(MANIFEST_ENTRY_NAME, n + 1);
                }
                if (this.verbose_) {
                    System.out.println("Extracting files");
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string2 = (String)enumeration.nextElement();
                    String string3 = JarMaker.generateFilePath(string, string2);
                    if (this.verbose_) {
                        System.out.print(".");
                    }
                    if (string2.endsWith("/")) {
                        object = new File(string3.substring(0, string3.length() - 1));
                        if (((File)object).exists() || ((File)object).mkdirs()) continue;
                        throw new IOException(((File)object).getAbsolutePath() + ": Cannot create directory.");
                    }
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(string3), 2048);
                    object = jarMap.getEntry(string2);
                    if (object == null) {
                        throw new FileNotFoundException(string2);
                    }
                    inputStream = jarMap.getInputStream((ZipEntry)object);
                    JarMaker.copyBytes(inputStream, filterOutputStream, ((ZipEntry)object).getSize());
                    filterOutputStream.close();
                    filterOutputStream = null;
                    inputStream.close();
                    inputStream = null;
                }
                Object var13_15 = null;
                if (jarMap == null) break block31;
                try {
                    jarMap.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2222) {}
            }
            break block33;
            {
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when extracting source file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when extracting source file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable42222;
                Object var13_16 = null;
                if (jarMap != null) {
                    try {
                        jarMap.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                throw throwable3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAnalysisEvent(boolean bl, String string) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.eventListeners_.clone();
        }
        object = new JarMakerEvent(this, string);
        for (int i = 0; i < vector.size(); ++i) {
            JarMakerListener jarMakerListener = (JarMakerListener)vector.elementAt(i);
            if (bl) {
                jarMakerListener.dependencyAnalysisStarted((JarMakerEvent)object);
                continue;
            }
            jarMakerListener.dependencyAnalysisCompleted((JarMakerEvent)object);
        }
    }

    private static Vector generateDirEntries(String string, Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        String string2 = string.substring(0, string.lastIndexOf("/") + 1);
        if (string2.length() != 0) {
            int n = string2.indexOf("/");
            while (n != -1 && n < string.length() - 1) {
                String string3 = string2.substring(0, n + 1);
                if (!vector.contains(string3)) {
                    vector2.addElement(string3);
                }
                n = string2.indexOf("/", n + 1);
            }
        }
        return vector2;
    }

    static String generateFilePath(File file, String string) {
        if (file == null) {
            throw new NullPointerException("baseDirectory");
        }
        return JarMaker.generateFilePath(file.getAbsolutePath(), string);
    }

    static String generateFilePath(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("basePath");
        }
        if (string2 == null) {
            throw new NullPointerException("entryName");
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        if (stringBuffer.charAt(stringBuffer.length() - 1) != FILE_SEPARATOR) {
            stringBuffer.append(FILE_SEPARATOR);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string2.trim().replace('/', FILE_SEPARATOR));
        stringBuffer.append(stringBuffer2);
        String string3 = stringBuffer.toString();
        return string3;
    }

    private static Hashtable generateJarEntryMap(Hashtable hashtable) {
        Hashtable<File, String> hashtable2 = hashtable.size() != 0 ? new Hashtable(hashtable.size()) : new Hashtable<File, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            File file2 = (File)hashtable.get(file);
            String string = JarMaker.generateJarEntryName(file, file2);
            hashtable2.put(file, string);
        }
        return hashtable2;
    }

    private static String generateJarEntryName(File file, File file2) {
        String string;
        String string2 = file.getAbsolutePath();
        if (string2.startsWith(string = file2.getAbsolutePath())) {
            string2 = string2.substring(string.length());
        } else {
            System.err.println("Warning: File path does not begin with base path for additional files.");
            System.err.println("   File path: " + string2);
            System.err.println("   Base path: " + string);
        }
        String string3 = string2.replace(FILE_SEPARATOR, '/');
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public Vector getAdditionalFiles() {
        Vector<File> vector = new Vector<File>();
        Enumeration enumeration = this.additionalFiles_.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((File)enumeration.nextElement());
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] getBytes(File file) throws IOException {
        long l = file.length();
        byte[] byArray = new byte[(int)l];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            try {
                int n = ((InputStream)fileInputStream).read(byArray);
                if ((long)n < l) {
                    throw new IOException(file.getAbsolutePath() + ": Failed to read entire file.");
                }
                Object var7_6 = null;
                if (fileInputStream == null) return byArray;
            }
            catch (IOException iOException) {
                System.err.println("Error: IOException when reading file");
                System.err.println("       " + file.getAbsolutePath() + ":");
                System.err.println(iOException.toString());
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (fileInputStream == null) throw throwable;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    File getDestinationJar() {
        return this.destinationJarFile_;
    }

    private static Vector getEntryNamesForPackage(String string, JarMap jarMap) {
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        Enumeration enumeration = jarMap.elements();
        block3: while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            switch (n) {
                case 0: {
                    if (string2.indexOf(47) != -1) continue block3;
                    vector.addElement(string2);
                    continue block3;
                }
            }
            if (!string2.startsWith(string) || string2.lastIndexOf(47) != n) continue;
            vector.addElement(string2);
        }
        return vector;
    }

    File getExtractionDirectory() {
        return this.baseDirectoryForExtract_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getReferencedEntries(String string, JarMap jarMap) throws IOException {
        Vector vector;
        block4: {
            if (this.verbose_) {
                System.out.print(".");
            }
            ZipEntry zipEntry = jarMap.getEntry(string);
            String string2 = zipEntry.getName();
            String string3 = "";
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string3 = string2.substring(0, n).replace('/', '.');
            }
            InputStream inputStream = null;
            try {
                inputStream = jarMap.getInputStream(zipEntry);
                Vector vector2 = this.prescanForClassIndexes(inputStream, string3, jarMap);
                inputStream.close();
                inputStream = jarMap.getInputStream(zipEntry);
                Vector vector3 = this.processBytecodeStream(inputStream, string3, jarMap, vector2);
                inputStream.close();
                inputStream = null;
                vector = vector3;
                Object var12_11 = null;
                if (inputStream == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var12_12 = null;
                    if (inputStream == null) break block5;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return vector;
    }

    public Vector getRequiredFiles() {
        return this.filesRequired_;
    }

    public Vector getFilesRequired() {
        return this.filesRequired_;
    }

    public Vector getFilesExcluded() {
        return this.filesExcluded_;
    }

    public Vector getPackages() {
        return this.packages_;
    }

    public Vector getPackagesExcluded() {
        return this.packagesExcluded_;
    }

    File getSourceJar() {
        return this.sourceJarFile_;
    }

    int getSplitSize() {
        return this.splitSize_;
    }

    String[] getUnrecognizedArgs() {
        return this.arguments_.getUnrecognized();
    }

    private Vector identifyDependencies(JarMap jarMap) throws IOException {
        if (this.verbose_) {
            System.out.println("Analyzing source file");
        }
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = jarMap.entries();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(((ZipEntry)enumeration.nextElement()).getName());
        }
        vector2.removeElement(MANIFEST_ENTRY_NAME);
        Vector vector3 = new Vector();
        JarMaker.copyVector(this.filesRequired_, vector3, false);
        JarMaker.copyVector(this.filesExcluded_, this.dependenciesToExclude_, true);
        vector3 = this.adjustDependencies1(vector3, jarMap);
        if (vector3.size() == 0) {
            if (this.verbose_) {
                System.out.println("No required JAR or ZIP entries were specified");
            }
        } else {
            if (this.verbose_) {
                System.out.println("Analyzing " + vector3.size() + " required entries, starting with " + vector3.elementAt(0) + ".");
            }
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                if (!jarMap.contains(string)) {
                    System.err.println("Warning: The source file does not contain the specified required file: " + string);
                    vector3.removeElement(string);
                    continue;
                }
                if (!vector2.contains(string)) continue;
                vector2.removeElement(string);
                this.analyzeJarEntry(string, vector2, vector, jarMap);
                JarMaker.addElement(vector, string);
            }
            if (this.verbose_) {
                System.out.println();
            }
        }
        if (vector.size() == 0 && this.packages_.size() == 0) {
            JarMaker.copyVector(jarMap.getEntryNames(), vector, false);
        }
        vector = this.adjustDependencies2(vector, jarMap);
        JarMaker.removeElements(vector, this.filesExcluded_);
        vector = JarMaker.sortStrings(vector);
        vector = JarMaker.insertDirectoryEntries(vector);
        return vector;
    }

    private static Vector insertDirectoryEntries(Vector vector) {
        String string = "";
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
            if (!string3.equals(string)) {
                string = string3;
                int n = string3.indexOf("/");
                while (n != -1) {
                    String string4 = string3.substring(0, n + 1);
                    if (!vector2.contains(string4) && !string4.equals(string2)) {
                        vector2.addElement(string4);
                    }
                    n = string3.indexOf("/", n + 1);
                }
            }
            vector2.addElement(string2);
        }
        return vector2;
    }

    boolean isExtract() {
        return this.extract_;
    }

    boolean isOptionInfoSufficient() {
        return this.arguments_.isOptionInfoSufficient();
    }

    boolean isSplit() {
        return this.split_;
    }

    boolean isVerbose() {
        return this.verbose_;
    }

    static String listCommandOptions(CommandLineArguments commandLineArguments, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = bl ? commandLineArguments.getOptionNames() : commandLineArguments.getExtraOptions();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(" [" + string);
            String string2 = commandLineArguments.getOptionValue(string);
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append(" " + string2);
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString().trim();
    }

    public File makeJar(File file) throws FileNotFoundException, IOException, ZipException {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        File file2 = JarMaker.setupDefaultDestinationJarFile(file);
        this.makeJar(file, file2);
        return file2;
    }

    /*
     * Loose catch block
     */
    public void makeJar(File file, File file2) throws FileNotFoundException, IOException, ZipException {
        block54: {
            Throwable throwable2222;
            FilterOutputStream filterOutputStream;
            InputStream inputStream;
            ZipOutputStream zipOutputStream;
            ManifestMap manifestMap;
            JarMap jarMap;
            block50: {
                Object object;
                Object object2;
                Object object3;
                Enumeration enumeration;
                Object object4;
                Serializable serializable;
                Serializable serializable2;
                if (file == null) {
                    throw new NullPointerException("sourceJarFile");
                }
                if (file2 == null) {
                    throw new NullPointerException("destinationJarFile");
                }
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                if (file2.exists() && !file2.canWrite()) {
                    System.err.println("Error: Cannot write file");
                    System.err.println("       " + file2.getAbsolutePath());
                    throw new IOException(file2.getAbsolutePath());
                }
                if (this.verbose_) {
                    System.out.println("Source file is " + file.getAbsolutePath());
                    System.out.println("Destination file is " + file2.getAbsolutePath());
                }
                if (file2.getAbsolutePath().equals(file.getAbsolutePath())) {
                    System.err.println("Error: Destination file is same as source file.");
                    throw new IllegalArgumentException("destinationJarFile(" + file2.getAbsolutePath() + ")");
                }
                jarMap = null;
                manifestMap = null;
                zipOutputStream = null;
                inputStream = null;
                filterOutputStream = null;
                jarMap = new JarMap(file, this.verbose_);
                Vector vector = this.identifyDependencies(jarMap);
                Enumeration enumeration2 = this.additionalFiles_.keys();
                while (enumeration2.hasMoreElements()) {
                    serializable2 = (File)enumeration2.nextElement();
                    if (((File)serializable2).exists() && ((File)serializable2).isFile()) continue;
                    System.err.println("Error: A specified additional file was not found:");
                    System.err.println("       " + ((File)serializable2).getAbsolutePath());
                }
                serializable2 = JarMaker.generateJarEntryMap(this.additionalFiles_);
                if (this.verbose_) {
                    System.out.println();
                    System.out.println("Opening destination file " + file2.getAbsolutePath());
                }
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2), 2048);
                zipOutputStream = new ZipOutputStream(filterOutputStream);
                if (jarMap.hasManifest()) {
                    manifestMap = new ManifestMap(jarMap);
                    serializable = new StringBuffer();
                    object4 = manifestMap.getHeader();
                    if (((String)object4).length() != 0) {
                        ((StringBuffer)serializable).append((String)object4);
                    }
                    enumeration = manifestMap.elements();
                    while (enumeration.hasMoreElements()) {
                        object3 = (String)enumeration.nextElement();
                        if (!vector.contains(object3) || ((Hashtable)serializable2).contains(object3)) continue;
                        object2 = manifestMap.get((String)object3);
                        ((StringBuffer)serializable).append((String)object2);
                    }
                    if (this.additionalFiles_.size() != 0) {
                        if (this.verbose_) {
                            System.out.println("Creating manifest entries for additional files");
                        }
                        object3 = this.additionalFiles_.keys();
                        while (object3.hasMoreElements()) {
                            object2 = (File)object3.nextElement();
                            object = (String)((Hashtable)serializable2).get(object2);
                            JarMaker.constructManifestEntry((StringBuffer)serializable, (File)object2, (String)object);
                        }
                    }
                    object3 = ((StringBuffer)serializable).toString().getBytes();
                    object2 = new ZipEntry(MANIFEST_ENTRY_NAME);
                    ((ZipEntry)object2).setSize(((Enumeration<K>)object3).length);
                    zipOutputStream.putNextEntry((ZipEntry)object2);
                    zipOutputStream.write((byte[])object3);
                    zipOutputStream.flush();
                    ((BufferedOutputStream)filterOutputStream).flush();
                    zipOutputStream.closeEntry();
                    ((BufferedOutputStream)filterOutputStream).flush();
                }
                serializable = new Vector();
                object4 = vector.elements();
                while (object4.hasMoreElements()) {
                    enumeration = (String)object4.nextElement();
                    if (this.verbose_) {
                        System.out.print(".");
                    }
                    if (((Hashtable)serializable2).contains(enumeration)) continue;
                    if (((String)((Object)enumeration)).endsWith("/")) {
                        ((Vector)serializable).addElement(enumeration);
                    }
                    if ((object3 = jarMap.getEntry((String)((Object)enumeration))) == null) {
                        if (((String)((Object)enumeration)).endsWith("/")) continue;
                        throw new IOException(enumeration + ": No such entry in source file.");
                    }
                    inputStream = jarMap.getInputStream((ZipEntry)object3);
                    JarMaker.copyZipEntry(object3, inputStream, zipOutputStream);
                    zipOutputStream.flush();
                    ((BufferedOutputStream)filterOutputStream).flush();
                    zipOutputStream.closeEntry();
                    ((BufferedOutputStream)filterOutputStream).flush();
                    inputStream.close();
                    inputStream = null;
                }
                if (this.verbose_) {
                    System.out.println();
                }
                enumeration = this.additionalFiles_.keys();
                while (enumeration.hasMoreElements()) {
                    Object object5;
                    object3 = (File)enumeration.nextElement();
                    object2 = (String)((Hashtable)serializable2).get(object3);
                    object = JarMaker.generateDirEntries((String)object2, (Vector)serializable);
                    Enumeration enumeration3 = ((Vector)object).elements();
                    while (enumeration3.hasMoreElements()) {
                        object5 = (String)enumeration3.nextElement();
                        ZipEntry zipEntry = new ZipEntry((String)object5);
                        zipEntry.setSize(0L);
                        zipOutputStream.putNextEntry(zipEntry);
                        zipOutputStream.flush();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        zipOutputStream.closeEntry();
                        ((BufferedOutputStream)filterOutputStream).flush();
                        ((Vector)serializable).addElement(object5);
                    }
                    object5 = new ZipEntry((String)object2);
                    ((ZipEntry)object5).setSize(((File)object3).length());
                    ((ZipEntry)object5).setTime(((File)object3).lastModified());
                    inputStream = new BufferedInputStream(new FileInputStream((File)object3), 2048);
                    zipOutputStream.putNextEntry((ZipEntry)object5);
                    JarMaker.copyBytes(inputStream, zipOutputStream, ((ZipEntry)object5).getSize());
                    zipOutputStream.flush();
                    ((BufferedOutputStream)filterOutputStream).flush();
                    zipOutputStream.closeEntry();
                    ((BufferedOutputStream)filterOutputStream).flush();
                    inputStream.close();
                    inputStream = null;
                }
                Object var21_22 = null;
                if (manifestMap == null) break block50;
                try {
                    manifestMap.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (jarMap != null) {
                try {
                    jarMap.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2222) {}
            }
            break block54;
            {
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when writing file");
                    System.err.println("       " + file2.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when writing file");
                    System.err.println("       " + file2.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable42222;
                Object var21_23 = null;
                if (manifestMap != null) {
                    try {
                        manifestMap.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (jarMap != null) {
                    try {
                        jarMap.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                throw throwable3;
            }
        }
    }

    boolean parseArgs(String[] stringArray, boolean bl) {
        boolean bl2 = false;
        this.reset();
        if (this.arguments_.parse(stringArray, this, bl)) {
            bl2 = true;
        }
        return bl2;
    }

    private Vector prescanForClassIndexes(InputStream inputStream, String string, JarMap jarMap) throws IOException {
        Vector<Integer> vector = new Vector<Integer>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        JarMaker.skipBytes(dataInputStream, 4);
        JarMaker.skipBytes(dataInputStream, 2);
        JarMaker.skipBytes(dataInputStream, 2);
        int n = dataInputStream.readUnsignedShort();
        block9: for (int i = 1; i < n; ++i) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    int n2 = dataInputStream.readUnsignedShort();
                    JarMaker.skipBytes(dataInputStream, n2);
                    continue block9;
                }
                case 3: 
                case 4: {
                    JarMaker.skipBytes(dataInputStream, 4);
                    continue block9;
                }
                case 5: 
                case 6: {
                    JarMaker.skipBytes(dataInputStream, 8);
                    ++i;
                    continue block9;
                }
                case 7: {
                    int n3 = dataInputStream.readUnsignedShort();
                    vector.addElement(new Integer(n3));
                    continue block9;
                }
                case 8: {
                    JarMaker.skipBytes(dataInputStream, 2);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    JarMaker.skipBytes(dataInputStream, 2);
                    JarMaker.skipBytes(dataInputStream, 2);
                    continue block9;
                }
                case 12: {
                    JarMaker.skipBytes(dataInputStream, 2);
                    JarMaker.skipBytes(dataInputStream, 2);
                    continue block9;
                }
            }
        }
        return vector;
    }

    private Vector processBytecodeStream(InputStream inputStream, String string, JarMap jarMap, Vector vector) throws IOException {
        Vector<String> vector2 = new Vector<String>();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        JarMaker.skipBytes(dataInputStream, 4);
        JarMaker.skipBytes(dataInputStream, 2);
        JarMaker.skipBytes(dataInputStream, 2);
        int n = dataInputStream.readUnsignedShort();
        block9: for (int i = 1; i < n; ++i) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    int n2 = dataInputStream.readUnsignedShort();
                    if (n2 <= 0) continue block9;
                    byte[] byArray = new byte[n2];
                    dataInputStream.readFully(byArray);
                    String string2 = this.processUtf8(i, new String(byArray, "UTF8"), vector, string, jarMap);
                    if (string2 == null) continue block9;
                    vector2.addElement(string2);
                    continue block9;
                }
                case 3: 
                case 4: {
                    JarMaker.skipBytes(dataInputStream, 4);
                    continue block9;
                }
                case 5: 
                case 6: {
                    JarMaker.skipBytes(dataInputStream, 8);
                    ++i;
                    continue block9;
                }
                case 7: {
                    int n3 = dataInputStream.readUnsignedShort();
                    continue block9;
                }
                case 8: {
                    JarMaker.skipBytes(dataInputStream, 2);
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    JarMaker.skipBytes(dataInputStream, 2);
                    JarMaker.skipBytes(dataInputStream, 2);
                    continue block9;
                }
                case 12: {
                    JarMaker.skipBytes(dataInputStream, 2);
                    JarMaker.skipBytes(dataInputStream, 2);
                    continue block9;
                }
            }
        }
        return vector2;
    }

    private String processUtf8(int n, String string, Vector vector, String string2, JarMap jarMap) {
        String string3 = null;
        if (vector.contains(new Integer(n))) {
            String string4 = string + CLASS_SUFFIX;
            if (jarMap.contains(string4)) {
                string3 = string4;
            }
        } else if (string2.length() != 0 && string.startsWith(string2) || this.jarEntryDefaultPrefix_ != null && (string.startsWith(this.jarEntryDefaultPrefix_) || string.startsWith(this.jarEntryDefaultPrefixDotted_))) {
            String string5 = string.replace('.', '/') + ".properties";
            if (jarMap.contains(string5)) {
                string3 = string5;
            } else {
                String string6 = string.replace('.', '/') + CLASS_SUFFIX;
                if (jarMap.contains(string6)) {
                    string3 = string6;
                }
            }
        } else {
            String string7 = null;
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string7 = string.substring(n2).toLowerCase();
            }
            if (string7 != null && (string7.equals(".gif") || string7.equals(".jpg") || string7.equals(".html") || string7.equals(".pdml") || string7.equals(".pcml") || string7.equals(".ser"))) {
                String string8 = null;
                if (string2.length() != 0) {
                    string8 = string2.replace('.', '/') + "/" + string;
                    if (jarMap.contains(string8)) {
                        string3 = string8;
                    } else if (jarMap.contains(string)) {
                        string3 = string;
                    }
                } else if (jarMap.contains(string)) {
                    string3 = string;
                }
            }
        }
        return string3;
    }

    public synchronized void removeJarMakerListener(JarMakerListener jarMakerListener) {
        if (jarMakerListener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners_.removeElement(jarMakerListener);
    }

    public void reset() {
        this.sourceJarFile_ = null;
        this.destinationJarFile_ = null;
        this.filesRequired_.removeAllElements();
        this.filesExcluded_.removeAllElements();
        this.packages_.removeAllElements();
        this.packagesExcluded_.removeAllElements();
        this.additionalFiles_.clear();
        this.verbose_ = false;
        this.extract_ = false;
        this.baseDirectoryForExtract_ = new File(System.getProperty("user.dir"));
        this.split_ = false;
        this.splitSize_ = 2048;
        this.eventListeners_.removeAllElements();
        this.arguments_ = new Arguments();
    }

    public void setAdditionalFiles(Vector vector) {
        File file = new File(System.getProperty("user.dir"));
        this.setAdditionalFiles(vector, file);
    }

    public void setAdditionalFiles(Vector vector, File file) {
        if (vector == null) {
            throw new NullPointerException("fileList");
        }
        if (file == null) {
            throw new NullPointerException("baseDirectory");
        }
        vector = JarMaker.validateList(vector, "additionalFile", "java.io.File", this.verbose_);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            File file2 = (File)enumeration.nextElement();
            if (this.additionalFiles_.containsKey(file2)) continue;
            this.additionalFiles_.put(file2, file);
        }
    }

    void setDestinationJar(File file) {
        if (file == null) {
            throw new NullPointerException("destinationJarFile");
        }
        this.destinationJarFile_ = file;
    }

    void setExtract(boolean bl) {
        this.extract_ = bl;
    }

    void setExtractionDirectory(File file) {
        this.baseDirectoryForExtract_ = file;
    }

    public void setPackages(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("packages");
        }
        vector = JarMaker.validateList(vector, "packageName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.packages_, true);
    }

    public void setPackagesExcluded(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("packages");
        }
        vector = JarMaker.validateList(vector, "packageName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.packagesExcluded_, true);
    }

    public void setRequiredFiles(Vector vector) {
        this.setFilesRequired(vector);
    }

    public void setFilesRequired(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("entryList");
        }
        vector = JarMaker.validateList(vector, "entryName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.filesRequired_, true);
    }

    public void setFilesExcluded(Vector vector) {
        if (vector == null) {
            throw new NullPointerException("entryList");
        }
        vector = JarMaker.validateList(vector, "entryName", "java.lang.String", this.verbose_);
        JarMaker.copyVector(vector, this.filesExcluded_, true);
    }

    void setSourceJar(File file) {
        if (file == null) {
            throw new NullPointerException("sourceJarFile");
        }
        this.sourceJarFile_ = file;
    }

    void setSplit(boolean bl) {
        this.split_ = bl;
    }

    void setSplitSize(int n) {
        this.splitSize_ = n;
    }

    static File setupDefaultDestinationJarFile(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        String string2 = "Small";
        String string3 = n == -1 ? string + string2 : string.substring(0, n) + string2 + string.substring(n);
        return new File(CURRENT_DIR, string3);
    }

    private static File setupSplitJarFile(File file, int n) {
        String string = file.getName();
        int n2 = string.lastIndexOf(46);
        String string2 = n2 == -1 ? string + n : string.substring(0, n2) + Integer.toString(n) + string.substring(n2);
        return new File(CURRENT_DIR, string2);
    }

    public void setVerbose() {
        this.setVerbose(true);
    }

    public void setVerbose(boolean bl) {
        this.verbose_ = bl;
    }

    private static final void skipBytes(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.skipBytes(n);
        if (n2 != n) {
            throw new IOException("Fewer bytes skipped (" + n2 + ") than specified (" + n + ").");
        }
    }

    static Vector sortStrings(Vector vector) {
        Vector<String> vector2 = new Vector<String>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = false;
            int n = vector2.size();
            Enumeration enumeration2 = vector2.elements();
            int n2 = 0;
            while (!bl && enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (string.compareTo(string2) < 0) {
                    n = n2;
                    bl = true;
                }
                ++n2;
            }
            vector2.insertElementAt(string, n);
        }
        return vector2;
    }

    public Vector split(File file) throws FileNotFoundException, IOException, ZipException {
        return this.split(file, 2048);
    }

    /*
     * Loose catch block
     */
    public Vector split(File file, int n) throws FileNotFoundException, IOException, ZipException {
        Vector<File> vector;
        block38: {
            Throwable throwable322;
            ManifestMap manifestMap;
            JarMap jarMap;
            block37: {
                block36: {
                    int n2;
                    File file2;
                    long l;
                    block33: {
                        Throwable throwable2222;
                        Vector<File> vector2;
                        block34: {
                            if (file == null) {
                                throw new NullPointerException("sourceJarFile");
                            }
                            if (n < 1) {
                                throw new IllegalArgumentException("splitSizeKbytes (" + n + ")");
                            }
                            if (!file.exists()) {
                                throw new FileNotFoundException(file.getAbsolutePath());
                            }
                            if (this.verbose_) {
                                System.out.println("Source file is " + file.getAbsolutePath());
                                System.out.println("Split size is " + n + " kilobytes");
                            }
                            vector = new Vector<File>();
                            jarMap = null;
                            manifestMap = null;
                            Long l2 = new Long(n);
                            l = l2 * 1024L;
                            file2 = null;
                            n2 = 0;
                            file2 = JarMaker.setupSplitJarFile(file, n2++);
                            if (file.length() > l) break block33;
                            JarMaker.copyFile(file, file2);
                            vector.addElement(file2);
                            vector2 = vector;
                            Object var31_14 = null;
                            if (manifestMap == null) break block34;
                            try {
                                manifestMap.close();
                            }
                            catch (Throwable throwable2222) {
                                // empty catch block
                            }
                        }
                        if (jarMap != null) {
                            try {
                                jarMap.close();
                            }
                            catch (Throwable throwable2222) {
                                // empty catch block
                            }
                        }
                        return vector2;
                    }
                    jarMap = new JarMap(file, this.verbose_);
                    manifestMap = new ManifestMap(jarMap);
                    boolean bl = jarMap.hasManifest();
                    int n3 = jarMap.getSizeOfZipMetadataPerEntry();
                    int n4 = jarMap.getSizeOfZipMetadataPerZip();
                    if (bl) {
                        n4 += n3 + 2 * MANIFEST_ENTRY_NAME.length();
                    }
                    Vector<String> vector3 = new Vector<String>();
                    long l3 = n4;
                    Vector<String> vector4 = new Vector<String>();
                    Vector vector5 = null;
                    Enumeration enumeration = jarMap.elements();
                    while (enumeration.hasMoreElements()) {
                        int n5;
                        byte[] byArray;
                        String string = (String)enumeration.nextElement();
                        ZipEntry zipEntry = jarMap.getEntry(string);
                        if (zipEntry == null) {
                            throw new RuntimeException("Programming error: No JarMap entry for " + string);
                        }
                        if (zipEntry.isDirectory()) {
                            vector4.addElement(string);
                        }
                        long l4 = zipEntry.getSize();
                        long l5 = n3 + 2 * string.length();
                        String string2 = zipEntry.getComment();
                        if (string2 != null) {
                            l5 += (long)string2.length();
                        }
                        if ((byArray = zipEntry.getExtra()) != null) {
                            l5 += (long)(2 * byArray.length);
                        }
                        if (bl) {
                            l5 += (long)manifestMap.getEntrySize(string);
                        }
                        if (l4 + l5 + (long)n4 + (long)(n5 = JarMaker.determineDirMetadataSize(vector5 = JarMaker.generateDirEntries(string, vector4), n3)) >= l) {
                            Vector<String> vector6 = new Vector<String>();
                            vector6.addElement(string);
                            JarMaker.writeJarEntries(vector6, file2, jarMap, manifestMap, l, this.verbose_);
                            if (file2.length() > l) {
                                System.err.println("Warning: Oversize ZIP entry " + string);
                                System.err.println("         was written to file " + file2.getAbsolutePath() + ".");
                            }
                            vector.addElement(file2);
                            file2 = JarMaker.setupSplitJarFile(file, n2++);
                            continue;
                        }
                        if (l3 + l4 + l5 + (long)n5 > l) {
                            JarMaker.writeJarEntries(vector3, file2, jarMap, manifestMap, l, this.verbose_);
                            vector3.removeAllElements();
                            vector.addElement(file2);
                            file2 = JarMaker.setupSplitJarFile(file, n2++);
                            l3 = n4;
                            vector4.removeAllElements();
                            vector5 = JarMaker.generateDirEntries(string, vector4);
                            n5 = JarMaker.determineDirMetadataSize(vector5, n3);
                        }
                        vector3.addElement(string);
                        if (vector5 != null) {
                            JarMaker.copyVector(vector5, vector4, false);
                        }
                        l3 += l4 + l5 + (long)n5;
                    }
                    if (vector3.size() == 0) break block36;
                    JarMaker.writeJarEntries(vector3, file2, jarMap, manifestMap, l, this.verbose_);
                    vector3.removeAllElements();
                    vector.addElement(file2);
                }
                Object var31_15 = null;
                if (manifestMap == null) break block37;
                try {
                    manifestMap.close();
                }
                catch (Throwable throwable322) {
                    // empty catch block
                }
            }
            if (jarMap != null) {
                try {
                    jarMap.close();
                }
                catch (Throwable throwable322) {}
            }
            break block38;
            {
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when splitting file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when splitting file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            catch (Throwable throwable4) {
                Throwable throwable5222;
                Object var31_16 = null;
                if (manifestMap != null) {
                    try {
                        manifestMap.close();
                    }
                    catch (Throwable throwable5222) {
                        // empty catch block
                    }
                }
                if (jarMap != null) {
                    try {
                        jarMap.close();
                    }
                    catch (Throwable throwable5222) {
                        // empty catch block
                    }
                }
                throw throwable4;
            }
        }
        return vector;
    }

    static Vector validateList(Vector vector, String string, String string2, boolean bl) {
        if (vector == null) {
            throw new NullPointerException("list");
        }
        if (string == null) {
            throw new NullPointerException("parmName");
        }
        if (string2 == null) {
            throw new NullPointerException("className");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Programming error: Class not found: " + string2);
        }
        Vector vector2 = new Vector(vector.size());
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object == null) {
                throw new NullPointerException(string);
            }
            if (!clazz.isInstance(object)) {
                String string3 = object.getClass().getName();
                throw new IllegalArgumentException(string + " (object of class " + string3 + ")");
            }
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                if (n2 < 0) {
                    throw new IllegalArgumentException(string + " (" + n2 + ")");
                }
            } else if (object instanceof String) {
                String string4 = ((String)object).trim();
                if (string4.length() == 0) {
                    throw new IllegalArgumentException(string + "()");
                }
                object = string4;
            }
            if (!vector2.contains(object)) {
                vector2.addElement(object);
            }
            ++n;
        }
        return vector2;
    }

    /*
     * Loose catch block
     */
    private static void writeJarEntries(Vector vector, File file, JarMap jarMap, ManifestMap manifestMap, long l, boolean bl) throws FileNotFoundException, IOException, ZipException {
        block37: {
            Throwable throwable2222;
            InputStream inputStream;
            BufferedOutputStream bufferedOutputStream;
            ZipOutputStream zipOutputStream;
            block35: {
                block34: {
                    Object object;
                    String string;
                    Object object2;
                    Object object3;
                    if (vector == null) {
                        throw new NullPointerException("entryNames");
                    }
                    if (file == null) {
                        throw new NullPointerException("outFile");
                    }
                    if (jarMap == null) {
                        throw new NullPointerException("jarMap");
                    }
                    if (manifestMap == null) {
                        throw new NullPointerException("manifestMap");
                    }
                    if (bl) {
                        System.out.println("writeJarEntries( " + file.getName() + " )");
                    }
                    zipOutputStream = null;
                    bufferedOutputStream = null;
                    inputStream = null;
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);
                    zipOutputStream = new ZipOutputStream(bufferedOutputStream);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (jarMap.hasManifest()) {
                        object3 = manifestMap.getHeader();
                        if (((String)object3).length() != 0) {
                            stringBuffer.append((String)object3);
                        }
                        object2 = vector.elements();
                        while (object2.hasMoreElements()) {
                            string = (String)object2.nextElement();
                            object = manifestMap.get(string);
                            if (object == null) continue;
                            stringBuffer.append((String)object);
                        }
                    }
                    if (stringBuffer.length() != 0) {
                        object3 = stringBuffer.toString().getBytes();
                        object2 = new ZipEntry(MANIFEST_ENTRY_NAME);
                        ((ZipEntry)object2).setSize(((Vector<E>)object3).length);
                        try {
                            zipOutputStream.putNextEntry((ZipEntry)object2);
                            zipOutputStream.write((byte[])object3);
                            zipOutputStream.flush();
                            bufferedOutputStream.flush();
                            zipOutputStream.closeEntry();
                            bufferedOutputStream.flush();
                        }
                        catch (ZipException zipException) {
                            System.err.println("Error: ZipException for manifest entry");
                            System.err.println("       " + ((ZipEntry)object2).getName() + ":");
                            System.err.println(zipException.toString());
                            throw zipException;
                        }
                        catch (IOException iOException) {
                            System.err.println("Error: IOException for manifest entry");
                            System.err.println("       " + ((ZipEntry)object2).getName() + ":");
                            System.err.println(iOException.toString());
                            throw iOException;
                        }
                    }
                    object3 = new Vector<String>();
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        string = (String)object2.nextElement();
                        object = jarMap.getEntry(string);
                        if (object == null) {
                            System.err.println("Error: Entry not found in source file: " + string);
                            continue;
                        }
                        Vector vector2 = JarMaker.generateDirEntries(string, object3);
                        Enumeration enumeration = vector2.elements();
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            ZipEntry zipEntry = new ZipEntry(string2);
                            zipEntry.setSize(0L);
                            zipOutputStream.putNextEntry(zipEntry);
                            zipOutputStream.flush();
                            bufferedOutputStream.flush();
                            zipOutputStream.closeEntry();
                            bufferedOutputStream.flush();
                            ((Vector)object3).addElement(string2);
                        }
                        inputStream = jarMap.getInputStream((ZipEntry)object);
                        JarMaker.copyZipEntry((ZipEntry)object, inputStream, zipOutputStream);
                        zipOutputStream.flush();
                        bufferedOutputStream.flush();
                        zipOutputStream.closeEntry();
                        bufferedOutputStream.flush();
                        inputStream.close();
                        inputStream = null;
                        if (!((ZipEntry)object).isDirectory()) continue;
                        ((Vector)object3).addElement(string);
                    }
                    if (file.length() <= l) break block34;
                    System.err.println("Error: Generated file exceeds specified size:");
                    System.err.println("       " + file.getAbsolutePath());
                }
                Object var20_22 = null;
                if (inputStream == null) break block35;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (Throwable throwable2222) {}
            }
            break block37;
            {
                catch (ZipException zipException) {
                    System.err.println("Error: ZipException when writing to file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(zipException.toString());
                    throw zipException;
                }
                catch (IOException iOException) {
                    System.err.println("Error: IOException when writing to file");
                    System.err.println("       " + file.getAbsolutePath() + ":");
                    System.err.println(iOException.toString());
                    throw iOException;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable42222;
                Object var20_23 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                if (bufferedOutputStream != null) {
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (Throwable throwable42222) {
                        // empty catch block
                    }
                }
                throw throwable3;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            JarMaker jarMaker = new JarMaker();
            if (jarMaker.parseArgs(stringArray, false)) {
                if (jarMaker.isSplit()) {
                    File file = jarMaker.getSourceJar();
                    int n = jarMaker.getSplitSize();
                    jarMaker.split(file, n);
                } else if (jarMaker.isExtract()) {
                    File file = jarMaker.getSourceJar();
                    File file2 = jarMaker.getExtractionDirectory();
                    jarMaker.extract(file, file2);
                } else {
                    File file = jarMaker.getSourceJar();
                    File file3 = jarMaker.getDestinationJar();
                    jarMaker.makeJar(file, file3);
                }
            } else {
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            System.err.println(throwable.toString());
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    static class ManifestMap {
        private Vector entryList_ = new Vector();
        private Hashtable entryMap_ = new Hashtable();
        private JarMap jarMap_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ManifestMap(JarMap jarMap) throws IOException, ZipException {
            if (jarMap == null) {
                throw new NullPointerException("jarMap");
            }
            this.jarMap_ = jarMap;
            ZipEntry zipEntry = this.jarMap_.getEntry(JarMaker.MANIFEST_ENTRY_NAME);
            if (zipEntry == null) {
                System.err.println("Warning: Source file has no manifest.  No manifest will be created.");
                return;
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(jarMap.getInputStream(zipEntry)));
                boolean bl = false;
                boolean bl2 = false;
                while (bufferedReader.ready()) {
                    String string = bufferedReader.readLine();
                    if (string == null) continue;
                    if (string.startsWith(JarMaker.MANIFEST_NAME_KEYWORD)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        String string2 = string.substring(JarMaker.MANIFEST_NAME_KEYWORD.length()).trim();
                        stringBuffer.append(string);
                        stringBuffer.append('\n');
                        while (bufferedReader.ready() && string.length() != 0) {
                            string = bufferedReader.readLine();
                            if (string == null) continue;
                            stringBuffer.append(string);
                            stringBuffer.append('\n');
                        }
                        String string3 = stringBuffer.toString();
                        this.entryMap_.put(string2, string3);
                        this.entryList_.addElement(string2);
                        continue;
                    }
                    if (!bl && string.startsWith(JarMaker.MANIFEST_VERSION_KEYWORD)) {
                        bl = true;
                        this.entryMap_.put(JarMaker.MANIFEST_VERSION_KEYWORD, string + '\n');
                        continue;
                    }
                    if (bl2 || !string.startsWith(JarMaker.MANIFEST_REQVERS_KEYWORD)) continue;
                    bl2 = true;
                    this.entryMap_.put(JarMaker.MANIFEST_REQVERS_KEYWORD, string + '\n');
                }
                Object var11_10 = null;
                if (bufferedReader == null) return;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
        }

        void close() {
            this.entryList_.removeAllElements();
            this.entryMap_.clear();
            this.jarMap_ = null;
        }

        boolean contains(String string) {
            return this.entryList_.contains(string);
        }

        Enumeration elements() {
            return this.entryList_.elements();
        }

        String get(String string) {
            return (String)this.entryMap_.get(string);
        }

        int getEntrySize(String string) {
            int n = 0;
            String string2 = (String)this.entryMap_.get(string);
            if (string2 != null) {
                n = string2.length();
            }
            return n;
        }

        String getHeader() {
            String string = this.get(JarMaker.MANIFEST_VERSION_KEYWORD);
            String string2 = this.get(JarMaker.MANIFEST_REQVERS_KEYWORD);
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
    }

    static class JarMap {
        private ZipFile zipFile_;
        private ZipEntry manifest_;
        private Vector entryList_;
        private boolean verbose_;
        private int zipfileCommentLength_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        JarMap(File file, boolean bl) throws IOException, ZipException {
            Throwable throwable4;
            BufferedInputStream bufferedInputStream;
            block14: {
                this.entryList_ = new Vector();
                if (file == null) {
                    throw new NullPointerException("jarFile");
                }
                if (!file.isFile()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                this.zipFile_ = new ZipFile(file);
                this.verbose_ = bl;
                this.manifest_ = this.zipFile_.getEntry(JarMaker.MANIFEST_ENTRY_NAME);
                bufferedInputStream = null;
                ZipInputStream zipInputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 2048);
                    zipInputStream = new ZipInputStream(bufferedInputStream);
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        this.entryList_.addElement(zipEntry.getName());
                        zipEntry = zipInputStream.getNextEntry();
                    }
                    Object var7_6 = null;
                    if (zipInputStream == null) break block14;
                }
                catch (Throwable throwable2) {
                    Throwable throwable32;
                    Object var7_7 = null;
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                            bufferedInputStream = null;
                        }
                        catch (Throwable throwable32) {
                            // empty catch block
                        }
                    }
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (Throwable throwable32) {
                            // empty catch block
                        }
                    }
                    throw throwable2;
                }
                try {
                    zipInputStream.close();
                    bufferedInputStream = null;
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
            }
            if (bufferedInputStream != null) {
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (Throwable throwable4) {}
            }
            this.entryList_.removeElement(JarMaker.MANIFEST_ENTRY_NAME);
        }

        void close() {
            if (this.verbose_) {
                System.out.println("Closing source file");
            }
            this.entryList_.removeAllElements();
            this.manifest_ = null;
            if (this.zipFile_ != null) {
                try {
                    this.zipFile_.close();
                }
                catch (Exception exception) {
                    System.err.println("Error: While closing source file:");
                    System.err.println(exception.toString());
                }
                this.zipFile_ = null;
            }
        }

        boolean contains(String string) {
            return this.entryList_.contains(string);
        }

        Enumeration elements() {
            return this.entryList_.elements();
        }

        Enumeration entries() {
            return this.zipFile_.entries();
        }

        Vector getEntryNames() {
            return this.entryList_;
        }

        ZipEntry getEntry(String string) {
            return this.zipFile_.getEntry(string);
        }

        InputStream getInputStream(ZipEntry zipEntry) throws IOException, ZipException {
            return this.zipFile_.getInputStream(zipEntry);
        }

        ZipEntry getManifest() {
            return this.manifest_;
        }

        int getSizeOfZipMetadataPerZip() {
            int n = 0;
            n += 22;
            return n += this.zipfileCommentLength_;
        }

        int getSizeOfZipMetadataPerEntry() throws IOException, UnsupportedEncodingException {
            return 88;
        }

        boolean hasManifest() {
            return this.manifest_ != null;
        }
    }

    class Arguments {
        private Vector unrecognizedArgs_ = new Vector();
        private boolean optionsAreSufficient_;

        Arguments() {
        }

        String[] getUnrecognized() {
            Object[] objectArray = new String[this.unrecognizedArgs_.size()];
            this.unrecognizedArgs_.copyInto(objectArray);
            return objectArray;
        }

        boolean isOptionInfoSufficient() {
            return this.optionsAreSufficient_;
        }

        boolean parse(String[] stringArray, JarMaker jarMaker, boolean bl) {
            Object object;
            Object object2;
            if (stringArray.length == 0) {
                System.err.println("Error: No options were specified.");
                if (!bl) {
                    this.printUsage(System.err);
                }
                return false;
            }
            Vector<String> vector = new Vector<String>();
            vector.addElement("-source");
            vector.addElement("-destination");
            vector.addElement("-fileRequired");
            vector.addElement("-fileExcluded");
            vector.addElement("-additionalFile");
            vector.addElement("-additionalFilesDirectory");
            vector.addElement("-package");
            vector.addElement("-packageExcluded");
            vector.addElement("-extract");
            vector.addElement("-split");
            vector.addElement("-verbose");
            vector.addElement("-help");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("-s", "-source");
            hashtable.put("-src", "-source");
            hashtable.put("-so", "-source");
            hashtable.put("-d", "-destination");
            hashtable.put("-dest", "-destination");
            hashtable.put("-fr", "-fileRequired");
            hashtable.put("-file", "-fileRequired");
            hashtable.put("-rf", "-fileRequired");
            hashtable.put("-req", "-fileRequired");
            hashtable.put("-required", "-fileRequired");
            hashtable.put("-requiredfile", "-fileRequired");
            hashtable.put("-fx", "-fileExcluded");
            hashtable.put("-fileex", "-fileExcluded");
            hashtable.put("-filesex", "-fileExcluded");
            hashtable.put("-af", "-additionalFile");
            hashtable.put("-additional", "-additionalFile");
            hashtable.put("-afd", "-additionalFilesDirectory");
            hashtable.put("-additionalfilesdir", "-additionalFilesDirectory");
            hashtable.put("-p", "-package");
            hashtable.put("-px", "-packageExcluded");
            hashtable.put("-packageex", "-packageExcluded");
            hashtable.put("-packagesex", "-packageExcluded");
            hashtable.put("-x", "-extract");
            hashtable.put("-sp", "-split");
            hashtable.put("-v", "-verbose");
            hashtable.put("-h", "-help");
            CommandLineArguments commandLineArguments = new CommandLineArguments(stringArray, vector, hashtable);
            boolean bl2 = false;
            Vector<String> vector2 = null;
            Vector<String> vector3 = null;
            Vector<File> vector4 = null;
            File file = null;
            Vector<String> vector5 = null;
            Vector<String> vector6 = null;
            Object var14_14 = null;
            boolean bl3 = true;
            this.unrecognizedArgs_ = new Vector();
            if (commandLineArguments.isOptionSpecified("-verbose")) {
                jarMaker.setVerbose(true);
                System.out.print("Arguments parsed by JarMaker:");
                object2 = JarMaker.listCommandOptions(commandLineArguments, true);
                System.out.println((String)object2);
                object2 = JarMaker.listCommandOptions(commandLineArguments, false);
                if (((String)object2).length() != 0) {
                    System.out.print("Arguments unrecognized by JarMaker: ");
                    System.out.println((String)object2);
                }
            }
            JarMaker.this.requestedUsageInfo_ = commandLineArguments.isOptionSpecified("-help");
            String string = commandLineArguments.getOptionValue("");
            if (string != null && string.length() != 0) {
                object2 = new StringTokenizer(string = string.trim(), " ");
                if (((StringTokenizer)object2).countTokens() > 1) {
                    string = ((StringTokenizer)object2).nextToken();
                    object = new StringBuffer();
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        ((StringBuffer)object).append(((StringTokenizer)object2).nextToken() + " ");
                    }
                    System.err.println("Warning: Ignoring extra arguments: " + ((StringBuffer)object).toString());
                }
                JarMaker.this.setSourceJar(new File(string));
            }
            if ((string = commandLineArguments.getOptionValue("-source")) != null) {
                if (string.length() != 0) {
                    JarMaker.this.setSourceJar(new File(string));
                } else {
                    System.err.println("Warning: No file specified after -source.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-destination")) != null) {
                if (string.length() != 0) {
                    JarMaker.this.setDestinationJar(new File(string));
                    bl2 = true;
                } else {
                    System.err.println("Warning: No file specified after -destination.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-fileRequired")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector2 == null) {
                            vector2 = new Vector<String>(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            vector2.addElement(((StringTokenizer)object2).nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No file specified after -fileRequired.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-fileExcluded")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector3 == null) {
                            vector3 = new Vector<String>(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            vector3.addElement(((StringTokenizer)object2).nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No package specified after -fileExcluded.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-package")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector5 == null) {
                            vector5 = new Vector<String>(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            vector5.addElement(((StringTokenizer)object2).nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No package specified after -package.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-packageExcluded")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector6 == null) {
                            vector6 = new Vector<String>(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            vector6.addElement(((StringTokenizer)object2).nextToken());
                        }
                    }
                } else {
                    System.err.println("Warning: No package specified after -packageExcluded.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-additionalFile")) != null) {
                if (string.length() != 0) {
                    object2 = new StringTokenizer(string, ",");
                    if (((StringTokenizer)object2).countTokens() != 0) {
                        if (vector4 == null) {
                            vector4 = new Vector<File>(((StringTokenizer)object2).countTokens());
                        }
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            vector4.addElement(new File(((StringTokenizer)object2).nextToken()));
                        }
                    }
                } else {
                    System.err.println("Warning: No file specified after -additionalFile.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-additionalFilesDirectory")) != null) {
                if (string.length() != 0) {
                    file = new File(string);
                } else {
                    System.err.println("Warning: No directory specified after -additionalFilesDirectory.");
                }
            }
            if ((string = commandLineArguments.getOptionValue("-extract")) != null) {
                jarMaker.setExtract(true);
                if (string.length() != 0) {
                    jarMaker.setExtractionDirectory(new File(string));
                }
            }
            if ((string = commandLineArguments.getOptionValue("-split")) != null) {
                jarMaker.setSplit(true);
                if (string.length() != 0) {
                    int n = 0;
                    boolean bl4 = false;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Error: Non-integer split size: " + string);
                        bl3 = false;
                        bl4 = true;
                    }
                    if (n < 0) {
                        System.err.println("Error: Negative split size: " + string);
                        bl3 = false;
                        bl4 = true;
                    }
                    if (!bl4) {
                        jarMaker.setSplitSize(n);
                    }
                }
            }
            Enumeration enumeration = commandLineArguments.getExtraOptions();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string2 = commandLineArguments.getOptionValue((String)object);
                this.unrecognizedArgs_.addElement(object);
                if (string2 != null) {
                    this.unrecognizedArgs_.addElement(string2);
                }
                if (bl) continue;
                CharSequence charSequence = string2 == null ? object : (String)object + " " + string2;
                System.err.println("Error: Unrecognized option: " + (String)charSequence);
                bl3 = false;
            }
            if (JarMaker.this.requestedUsageInfo_) {
                if (bl) {
                    return bl3;
                }
                this.printUsage(System.out);
                return false;
            }
            if (jarMaker.getSourceJar() == null) {
                System.err.println("Error: Source JAR or ZIP file was not specified.");
                bl3 = false;
            } else if (jarMaker.isSplit()) {
                this.optionsAreSufficient_ = true;
                jarMaker.setExtract(false);
                if (bl2 || vector2 != null || vector3 != null || vector5 != null || vector6 != null || vector4 != null) {
                    System.err.println("Warning: When -split is specified, all other options are ignored, except -source, and -verbose.");
                }
            } else {
                if (vector2 == null && vector3 == null && vector4 == null && vector5 == null && vector6 == null && !jarMaker.isExtract()) {
                    if (this.unrecognizedArgs_.size() == 0 || !bl) {
                        System.err.println("Error: Need to specify more options.");
                        bl3 = false;
                    }
                } else {
                    this.optionsAreSufficient_ = true;
                }
                if (jarMaker.isExtract() && (bl2 || vector4 != null)) {
                    System.err.println("Warning: When -extract is specified, the following options are ignored: -destination, -additionalFile, and -additionalFilesDirectory.");
                }
                if (!bl2) {
                    object = JarMaker.setupDefaultDestinationJarFile(jarMaker.getSourceJar());
                    jarMaker.setDestinationJar((File)object);
                }
                if (file == null) {
                    file = new File(System.getProperty("user.dir"));
                }
                if (vector4 != null) {
                    JarMaker.this.setAdditionalFiles(vector4, file);
                }
                if (vector2 != null) {
                    JarMaker.this.setFilesRequired(vector2);
                }
                if (vector3 != null) {
                    JarMaker.this.setFilesExcluded(vector3);
                }
                if (vector5 != null) {
                    if (vector5.size() > 0) {
                        JarMaker.this.setPackages(vector5);
                    } else {
                        bl3 = false;
                    }
                }
                if (vector6 != null) {
                    if (vector6.size() > 0) {
                        JarMaker.this.setPackagesExcluded(vector6);
                    } else {
                        bl3 = false;
                    }
                }
            }
            if (!bl && !bl3) {
                this.printUsage(System.err);
            }
            return bl3;
        }

        private void printUsage(PrintStream printStream) {
            printStream.println("");
            printStream.println("Usage: ");
            printStream.println("");
            printStream.println("  JarMaker -source sourceJarFile");
            printStream.println("           [-destination jarFile]");
            printStream.println("           [-fileRequired entry1[,entry2[...]]]");
            printStream.println("           [-fileExcluded entry1[,entry2[...]]]");
            printStream.println("           [-additionalFile file1[,file2[...]]]");
            printStream.println("           [-additionalFilesDirectory directory");
            printStream.println("           [-package pkg1[,pkg2[...]]]");
            printStream.println("           [-packageExcluded pkg1[,pkg2[...]]]");
            printStream.println("           [-extract [directory]]");
            printStream.println("           [-split [kilobytes]]");
            printStream.println("           [-verbose]");
            printStream.println("           [-help]");
            printStream.println("");
            printStream.println("At least one of the following options must be specified: ");
            printStream.println("-fileRequired, -fileExcluded, -additionalFile, -package, -packageExcluded, -extract, -split");
        }
    }
}

