/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400JDBCCallableStatement;
import com.ibm.as400.access.AS400JDBCCallableStatementRedirect;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCConnectionImpl;
import com.ibm.as400.access.AS400JDBCDatabaseMetaData;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCPreparedStatementRedirect;
import com.ibm.as400.access.AS400JDBCResultSet;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400JDBCStatementRedirect;
import com.ibm.as400.access.AS400JDBCTransientException;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.SQLData;
import java.beans.PropertyVetoException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;

public class AS400JDBCConnectionRedirect
extends AS400JDBCConnection {
    public static final int SEAMLESS_RETRY_COUNT = 15;
    boolean enableSeamlessFailover_ = false;
    boolean doNotHandleErrors_ = false;
    AS400JDBCConnectionImpl currentConnection_ = new AS400JDBCConnectionImpl();
    JDDataSourceURL currentUrl_ = null;
    private AS400 originalAs400;
    private JDDataSourceURL originalDataSourceUrl_;
    private JDProperties originalProperties_;
    private Properties info_;
    private Properties originalInfo_;
    private JDDataSourceURL[] reconnectUrls_;
    private JDProperties[] reconnectProperties_;
    private AS400[] reconnectAS400s_;
    private int maxRetriesForClientReroute_ = -1;
    private int retryIntervalForClientReroute_ = -1;
    private Vector setCommands_ = null;
    private boolean throwException_;
    private boolean autoCommitSet_ = false;
    private boolean autoCommitSetting_ = false;
    private boolean transactionIsolationSet_ = false;
    private int transactionIsolationSetting_ = 0;
    private Hashtable clientInfoHashtable_ = null;
    private boolean holdabilitySet_ = false;
    private int holdability_ = 0;
    private boolean readOnlySet_ = false;
    private boolean readOnly_;
    private boolean networkTimeoutSet_ = false;
    private int networkTimeout_;
    private boolean lastConnectionCanSeamlessFailover_ = false;
    private boolean topLevelApi_ = false;
    String[] reconnectUrlStrings_ = null;

    AS400JDBCConnectionRedirect() {
    }

    private void setupRetryInformation() {
        this.enableSeamlessFailover_ = this.getEnableSeamlessFailover();
        this.maxRetriesForClientReroute_ = this.getMaxRetriesForClientReroute();
        this.retryIntervalForClientReroute_ = this.getRetryIntervalForClientReroute();
        if (this.retryIntervalForClientReroute_ > 0 && this.maxRetriesForClientReroute_ < 0) {
            this.maxRetriesForClientReroute_ = 3;
        }
        if (this.maxRetriesForClientReroute_ > 0 && this.retryIntervalForClientReroute_ < 0) {
            this.retryIntervalForClientReroute_ = 0;
        }
        Vector vector = this.getAlternateServerNames();
        Vector vector2 = this.getAlternatePortNumbers();
        this.setupAlternateServers(vector, vector2);
    }

    private void setupAlternateServers(String string) {
        Vector vector = this.getCommaSeparatedList(string);
        Vector vector2 = this.getAlternatePortNumbers();
        this.setupAlternateServers(vector, vector2);
    }

    private void setupAlternateServers(Vector vector, Vector vector2) {
        int n = vector.size();
        int n2 = vector2.size();
        this.reconnectUrls_ = new JDDataSourceURL[1 + n];
        this.reconnectProperties_ = new JDProperties[1 + n];
        this.reconnectAS400s_ = new AS400[1 + n];
        this.reconnectUrls_[0] = this.originalDataSourceUrl_;
        this.reconnectProperties_[0] = this.originalProperties_;
        this.reconnectAS400s_[0] = new AS400(this.originalAs400);
        boolean bl = this.originalProperties_.getBoolean(32);
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            String string2 = null;
            string2 = i < n2 ? (String)vector2.elementAt(i) : (bl ? "9471" : "8471");
            this.reconnectUrls_[i + 1] = this.fixupDataSourceUrl(string, string2);
            this.reconnectProperties_[i + 1] = this.fixupProperties(string, string2);
            this.reconnectAS400s_[i + 1] = this.fixupAS400(string, string2);
        }
    }

    private AS400 fixupAS400(String string, String string2) {
        AS400 aS400 = new AS400(this.originalAs400);
        try {
            aS400.setSystemName(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return aS400;
    }

    private JDProperties fixupProperties(String string, String string2) {
        JDProperties jDProperties = (JDProperties)this.originalProperties_.clone();
        if (string2 != null) {
            jDProperties.setString(92, string2);
        }
        return jDProperties;
    }

    private JDDataSourceURL fixupDataSourceUrl(String string, String string2) {
        JDDataSourceURL jDDataSourceURL = new JDDataSourceURL(this.originalDataSourceUrl_, string, string2);
        return jDDataSourceURL;
    }

    boolean getEnableSeamlessFailover() {
        int n = this.originalProperties_.getInt(98);
        return n == 1;
    }

    int getMaxRetriesForClientReroute() {
        int n = this.originalProperties_.getInt(96);
        if (n < 0) {
            n = -1;
        }
        return n;
    }

    int getRetryIntervalForClientReroute() {
        int n = this.originalProperties_.getInt(97);
        if (n < 0) {
            n = -1;
        }
        return n;
    }

    private Vector getAlternatePortNumbers() {
        return this.getPropertiesList(95);
    }

    private Vector getAlternateServerNames() {
        return this.getPropertiesList(94);
    }

    private Vector getPropertiesList(int n) {
        String string = this.originalProperties_.getString(n);
        return this.getCommaSeparatedList(string);
    }

    private Vector getCommaSeparatedList(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            int n = 0;
            int n2 = string.indexOf(44, n);
            while (n2 >= 0) {
                vector.add(string.substring(n, n2));
                n = n2 + 1;
                n2 = string.indexOf(44, n);
            }
            String string2 = string.substring(n);
            if (string2.length() > 0) {
                vector.add(string2);
            }
        }
        return vector;
    }

    boolean reconnect(SQLException sQLException) throws SQLException {
        return this.findNewConnection(sQLException);
    }

    private void replaySettings(AS400JDBCConnectionImpl aS400JDBCConnectionImpl) throws SQLException {
        String string;
        Object object;
        Object object2;
        if (this.setCommands_ != null) {
            object2 = aS400JDBCConnectionImpl.createStatement();
            object = this.setCommands_.elements();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                object2.executeUpdate(string);
            }
            object2.close();
        }
        if (this.autoCommitSet_) {
            aS400JDBCConnectionImpl.setAutoCommit(this.autoCommitSetting_);
        }
        if (this.transactionIsolationSet_) {
            aS400JDBCConnectionImpl.setTransactionIsolation(this.transactionIsolationSetting_);
        }
        if (this.holdabilitySet_) {
            aS400JDBCConnectionImpl.setHoldability(this.holdability_);
        }
        if (this.readOnlySet_) {
            aS400JDBCConnectionImpl.setReadOnly(this.readOnly_);
        }
        if (this.networkTimeoutSet_) {
            aS400JDBCConnectionImpl.setNetworkTimeout(this.networkTimeout_);
        }
        if (this.clientInfoHashtable_ != null) {
            object2 = this.clientInfoHashtable_.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string = (String)this.clientInfoHashtable_.get(object);
                aS400JDBCConnectionImpl.setClientInfo((String)object, string);
            }
        }
        aS400JDBCConnectionImpl.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupNewConnection(AS400JDBCConnectionImpl aS400JDBCConnectionImpl, JDDataSourceURL jDDataSourceURL, SQLException sQLException) throws SQLException {
        block11: {
            this.replaySettings(aS400JDBCConnectionImpl);
            if (this.enableSeamlessFailover_) {
                this.lastConnectionCanSeamlessFailover_ = this.currentConnection_.canSeamlessFailover();
            }
            this.doNotHandleErrors_ = true;
            try {
                try {
                    this.currentConnection_.closeAllResultSets();
                }
                catch (Exception exception) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(this, "Exception from closeAllResultSets", sQLException);
                    }
                    Object var6_5 = null;
                    this.doNotHandleErrors_ = false;
                    break block11;
                }
                catch (Throwable throwable) {
                    if (JDTrace.isTraceOn()) {
                        JDTrace.logException(this, "Throwable from closeAllResultSets", sQLException);
                    }
                    Object var6_6 = null;
                    this.doNotHandleErrors_ = false;
                }
                Object var6_4 = null;
                this.doNotHandleErrors_ = false;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.doNotHandleErrors_ = false;
                throw throwable;
            }
        }
        this.currentConnection_.resetStatements(aS400JDBCConnectionImpl.transactionManager_);
        this.currentConnection_.transferObjects(aS400JDBCConnectionImpl);
        try {
            this.currentConnection_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentConnection_ = aS400JDBCConnectionImpl;
        this.currentUrl_ = jDDataSourceURL;
        if (this.lastConnectionCanSeamlessFailover_ && this.topLevelApi_) {
            return true;
        }
        this.throwException_ = true;
        String[] stringArray = new String[]{this.currentConnection_.getHostName(), this.currentConnection_.getPort()};
        JDError.throwSQLException((Object)this, "08506", stringArray, sQLException);
        return false;
    }

    boolean findNewConnection(SQLException sQLException) throws SQLException {
        int n = 0;
        int n2 = sQLException.getErrorCode();
        if (n2 == -7061 && this.currentUrl_ != null) {
            for (int i = 0; i < this.reconnectUrls_.length; ++i) {
                if (this.reconnectUrls_[i] != this.currentUrl_) continue;
                n = i + 1;
                if (n == this.reconnectUrls_.length) {
                    n = 0;
                }
                i = this.reconnectUrls_.length;
            }
        }
        Exception[] exceptionArray = new Exception[this.reconnectUrls_.length];
        long l = System.currentTimeMillis();
        int n3 = this.maxRetriesForClientReroute_ >= 0 ? this.maxRetriesForClientReroute_ : Integer.MAX_VALUE;
        long l2 = this.retryIntervalForClientReroute_ >= 0 ? (long)(this.retryIntervalForClientReroute_ * 1000) : 30000L;
        while (n3 > 0) {
            long l3 = System.currentTimeMillis();
            for (int i = n; i < this.reconnectUrls_.length; ++i) {
                AS400JDBCConnectionImpl aS400JDBCConnectionImpl = new AS400JDBCConnectionImpl();
                AS400 aS400 = new AS400(this.reconnectAS400s_[i]);
                try {
                    aS400JDBCConnectionImpl.setProperties(this.reconnectUrls_[i], this.reconnectProperties_[i], aS400, this.originalInfo_);
                    return this.setupNewConnection(aS400JDBCConnectionImpl, this.reconnectUrls_[i], sQLException);
                }
                catch (SQLException sQLException2) {
                    if (this.throwException_) {
                        this.throwException_ = false;
                        throw sQLException2;
                    }
                    exceptionArray[i] = sQLException2;
                    if (!JDTrace.isTraceOn()) continue;
                    JDTrace.logException(this, "Unable to connect to system i=" + i + " as400=" + aS400, sQLException2);
                    continue;
                }
            }
            --n3;
            if (n > 0) {
                ++n3;
                n = 0;
                continue;
            }
            long l4 = 0L;
            long l5 = System.currentTimeMillis() - l3;
            if (this.maxRetriesForClientReroute_ < 0 && this.retryIntervalForClientReroute_ < 0) {
                l4 = l2 - l5;
                l2 += l2 / 2L;
                long l6 = 600000L + l - System.currentTimeMillis();
                if (l6 < 0L) {
                    n3 = 0;
                    l4 = 0L;
                } else if (l6 < l4 + l5 && (l4 = l6 - l5) < 0L) {
                    l4 = 0L;
                }
            } else {
                l4 = l2 - l5;
            }
            if (l4 <= 0L) continue;
            try {
                Thread.sleep(l4);
            }
            catch (InterruptedException interruptedException) {
                throw sQLException;
            }
        }
        throw sQLException;
    }

    boolean handleException(SQLException sQLException) throws SQLException {
        if (this.doNotHandleErrors_ || this.inFinalizer_) {
            throw sQLException;
        }
        int n = sQLException.getErrorCode();
        String string = sQLException.getSQLState();
        if (n == -99999 && ("08S01".equals(string) || "08001".equals(string)) || n == -7061 && this.should7061Reconnect(sQLException)) {
            if (this.reconnect(sQLException)) {
                return true;
            }
        } else {
            throw sQLException;
        }
        throw sQLException;
    }

    private boolean should7061Reconnect(SQLException sQLException) {
        String string = sQLException.getMessage();
        return string.indexOf(" 71.") > 0;
    }

    boolean handleSQLClientInfoException(SQLClientInfoException sQLClientInfoException) throws SQLClientInfoException {
        try {
            return this.handleException(sQLClientInfoException);
        }
        catch (SQLException sQLException) {
            if (sQLException instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)sQLException;
            }
            JDError.throwSQLClientInfoException(this, sQLException.getSQLState(), sQLException, sQLClientInfoException.getFailedProperties());
            throw sQLClientInfoException;
        }
    }

    public void cancel(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.cancel(n);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void checkAccess(JDSQLStatement jDSQLStatement) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.checkAccess(jDSQLStatement);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void checkCancel() {
        this.currentConnection_.checkCancel();
    }

    public boolean checkHoldabilityConstants(int n) {
        return this.currentConnection_.checkHoldabilityConstants(n);
    }

    public void checkOpen() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.checkOpen();
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.clearWarnings();
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        boolean bl = true;
        int n = 15;
        while (bl) {
            Object var5_4;
            try {
                try {
                    this.currentConnection_.close();
                    bl = false;
                }
                catch (SQLException sQLException) {
                    if (n > 0) {
                        this.topLevelApi_ = true;
                    }
                    bl = this.handleException(sQLException);
                    --n;
                    var5_4 = null;
                    this.topLevelApi_ = false;
                    continue;
                }
                var5_4 = null;
                this.topLevelApi_ = false;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.topLevelApi_ = false;
                throw throwable;
            }
        }
    }

    public void handleAbort() {
        this.currentConnection_.handleAbort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        boolean bl = true;
        int n = 15;
        while (bl) {
            Object var5_4;
            try {
                try {
                    this.currentConnection_.commit();
                    bl = false;
                }
                catch (SQLException sQLException) {
                    if (n > 0) {
                        this.topLevelApi_ = true;
                    }
                    bl = this.handleException(sQLException);
                    --n;
                    var5_4 = null;
                    this.topLevelApi_ = false;
                    continue;
                }
                var5_4 = null;
                this.topLevelApi_ = false;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.topLevelApi_ = false;
                throw throwable;
            }
        }
    }

    public void setCheckStatementHoldability(boolean bl) {
        this.currentConnection_.setCheckStatementHoldability(bl);
    }

    public int correctResultSetType(int n, int n2) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.correctResultSetType(n, n2);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() throws SQLException {
        boolean bl = true;
        int n = 15;
        while (bl) {
            Object var6_5;
            AS400JDBCStatement aS400JDBCStatement;
            block7: {
                aS400JDBCStatement = (AS400JDBCStatement)this.currentConnection_.createStatement(this);
                if (!this.enableSeamlessFailover_) break block7;
                AS400JDBCStatementRedirect aS400JDBCStatementRedirect = new AS400JDBCStatementRedirect(aS400JDBCStatement);
                var6_5 = null;
                this.topLevelApi_ = false;
                return aS400JDBCStatementRedirect;
            }
            try {
                AS400JDBCStatement aS400JDBCStatement2 = aS400JDBCStatement;
                var6_5 = null;
                this.topLevelApi_ = false;
                return aS400JDBCStatement2;
            }
            catch (SQLException sQLException) {
                try {
                    if (n > 0) {
                        this.topLevelApi_ = true;
                    }
                    bl = this.handleException(sQLException);
                    --n;
                    var6_5 = null;
                    this.topLevelApi_ = false;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    this.topLevelApi_ = false;
                    throw throwable;
                }
            }
        }
        return null;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                AS400JDBCStatement aS400JDBCStatement = (AS400JDBCStatement)this.currentConnection_.createStatement(this, n, n2);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCStatementRedirect(aS400JDBCStatement);
                }
                return aS400JDBCStatement;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                AS400JDBCStatement aS400JDBCStatement = (AS400JDBCStatement)this.currentConnection_.createStatement(this, n, n2, n3);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCStatementRedirect(aS400JDBCStatement);
                }
                return aS400JDBCStatement;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void debug(DBBaseRequestDS dBBaseRequestDS) {
        this.currentConnection_.debug(dBBaseRequestDS);
    }

    public void debug(DBReplyRequestedDS dBReplyRequestedDS) {
        this.currentConnection_.debug(dBReplyRequestedDS);
    }

    public AS400Impl getAS400() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getAS400();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getAutoCommit();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public String getCatalog() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getCatalog();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getConcurrentAccessResolution() {
        return this.currentConnection_.getConcurrentAccessResolution();
    }

    public ConvTable getConverter(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getConverter(n);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getDataCompression() {
        return this.currentConnection_.getDataCompression();
    }

    public String getDefaultSchema() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getDefaultSchema();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String getDefaultSchema(boolean bl) throws SQLException {
        boolean bl2 = true;
        while (bl2) {
            try {
                return this.currentConnection_.getDefaultSchema(bl);
            }
            catch (SQLException sQLException) {
                bl2 = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getHoldability() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getHoldability();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public int getID() {
        return this.currentConnection_.getID();
    }

    public int getInternalHoldability() {
        return this.currentConnection_.getInternalHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                AS400JDBCDatabaseMetaData aS400JDBCDatabaseMetaData = (AS400JDBCDatabaseMetaData)this.currentConnection_.getMetaData();
                aS400JDBCDatabaseMetaData.connection_ = this;
                return aS400JDBCDatabaseMetaData;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public JDProperties getProperties() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getProperties();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String getServerJobIdentifier() {
        return this.currentConnection_.getServerJobIdentifier();
    }

    public int getServerFunctionalLevel() {
        return this.currentConnection_.getServerFunctionalLevel();
    }

    public AS400 getSystem() {
        return this.currentConnection_.getSystem();
    }

    public int getTransactionIsolation() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getTransactionIsolation();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public JDTransactionManager getTransactionManager() {
        return this.currentConnection_.getTransactionManager();
    }

    public Map getTypeMap() throws SQLException {
        return this.currentConnection_.getTypeMap();
    }

    public int getUnusedId(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getUnusedId(n);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public boolean getMustSpecifyForUpdate() {
        return this.currentConnection_.getMustSpecifyForUpdate();
    }

    public String getURL() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getURL();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String getUserName() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getUserName();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public int getVRM() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getVRM();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getWarnings();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public boolean isCursorNameUsed(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.isCursorNameUsed(string);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public boolean isClosed() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.isClosed();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.isReadOnly();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public boolean isReadOnlyAccordingToProperties() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.isReadOnlyAccordingToProperties();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public void markCursorsClosed(boolean bl) throws SQLException {
        boolean bl2 = true;
        while (bl2) {
            try {
                this.currentConnection_.markCursorsClosed(bl);
                bl2 = false;
            }
            catch (SQLException sQLException) {
                bl2 = this.handleException(sQLException);
            }
        }
    }

    public void markStatementsClosed() {
        this.currentConnection_.markStatementsClosed();
    }

    public String makeGeneratedKeySelectStatement(String string, int[] nArray, String[] stringArray) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.makeGeneratedKeySelectStatement(string, nArray, stringArray);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String makeGeneratedKeySelectStatement(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.makeGeneratedKeySelectStatement(string);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public String nativeSQL(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.nativeSQL(this, string);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void notifyClose(AS400JDBCStatement aS400JDBCStatement, int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.notifyClose(aS400JDBCStatement, n);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void postWarning(SQLWarning sQLWarning) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.postWarning(sQLWarning);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                AS400JDBCCallableStatement aS400JDBCCallableStatement = (AS400JDBCCallableStatement)this.currentConnection_.prepareCall(this, string);
                aS400JDBCCallableStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCCallableStatementRedirect(aS400JDBCCallableStatement);
                }
                return aS400JDBCCallableStatement;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                AS400JDBCCallableStatement aS400JDBCCallableStatement = (AS400JDBCCallableStatement)this.currentConnection_.prepareCall(this, string, n, n2);
                aS400JDBCCallableStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCCallableStatementRedirect(aS400JDBCCallableStatement);
                }
                return aS400JDBCCallableStatement;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                AS400JDBCCallableStatement aS400JDBCCallableStatement = (AS400JDBCCallableStatement)this.currentConnection_.prepareCall(this, string, n, n2, n3);
                aS400JDBCCallableStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCCallableStatementRedirect(aS400JDBCCallableStatement);
                }
                return aS400JDBCCallableStatement;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        boolean bl = true;
        int n = 15;
        while (bl) {
            try {
                AS400JDBCPreparedStatement aS400JDBCPreparedStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement(this, string);
                aS400JDBCPreparedStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(aS400JDBCPreparedStatement);
                }
                return aS400JDBCPreparedStatement;
            }
            catch (SQLException sQLException) {
                try {
                    bl = this.handleException(sQLException);
                }
                catch (AS400JDBCTransientException aS400JDBCTransientException) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--n >= 0) {
                            bl = true;
                            continue;
                        }
                        throw aS400JDBCTransientException;
                    }
                    throw aS400JDBCTransientException;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        boolean bl = true;
        int n2 = 15;
        while (bl) {
            try {
                AS400JDBCPreparedStatement aS400JDBCPreparedStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement((AS400JDBCConnection)this, string, n);
                aS400JDBCPreparedStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(aS400JDBCPreparedStatement);
                }
                return aS400JDBCPreparedStatement;
            }
            catch (SQLException sQLException) {
                try {
                    bl = this.handleException(sQLException);
                }
                catch (AS400JDBCTransientException aS400JDBCTransientException) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--n2 >= 0) {
                            bl = true;
                            continue;
                        }
                        throw aS400JDBCTransientException;
                    }
                    throw aS400JDBCTransientException;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        boolean bl = true;
        int n3 = 15;
        while (bl) {
            try {
                AS400JDBCPreparedStatement aS400JDBCPreparedStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement(this, string, n, n2);
                aS400JDBCPreparedStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(aS400JDBCPreparedStatement);
                }
                return aS400JDBCPreparedStatement;
            }
            catch (SQLException sQLException) {
                try {
                    bl = this.handleException(sQLException);
                }
                catch (AS400JDBCTransientException aS400JDBCTransientException) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--n3 >= 0) {
                            bl = true;
                            continue;
                        }
                        throw aS400JDBCTransientException;
                    }
                    throw aS400JDBCTransientException;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        boolean bl = true;
        int n4 = 15;
        while (bl) {
            try {
                AS400JDBCPreparedStatement aS400JDBCPreparedStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement(this, string, n, n2, n3);
                aS400JDBCPreparedStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(aS400JDBCPreparedStatement);
                }
                return aS400JDBCPreparedStatement;
            }
            catch (SQLException sQLException) {
                try {
                    bl = this.handleException(sQLException);
                }
                catch (AS400JDBCTransientException aS400JDBCTransientException) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--n4 >= 0) {
                            bl = true;
                            continue;
                        }
                        throw aS400JDBCTransientException;
                    }
                    throw aS400JDBCTransientException;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        boolean bl = true;
        int n = 15;
        while (bl) {
            try {
                AS400JDBCPreparedStatement aS400JDBCPreparedStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement((AS400JDBCConnection)this, string, nArray);
                aS400JDBCPreparedStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(aS400JDBCPreparedStatement);
                }
                return aS400JDBCPreparedStatement;
            }
            catch (SQLException sQLException) {
                try {
                    bl = this.handleException(sQLException);
                }
                catch (AS400JDBCTransientException aS400JDBCTransientException) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--n >= 0) {
                            bl = true;
                            continue;
                        }
                        throw aS400JDBCTransientException;
                    }
                    throw aS400JDBCTransientException;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        boolean bl = true;
        int n = 15;
        while (bl) {
            try {
                AS400JDBCPreparedStatement aS400JDBCPreparedStatement = (AS400JDBCPreparedStatement)this.currentConnection_.prepareStatement((AS400JDBCConnection)this, string, stringArray);
                aS400JDBCPreparedStatement.setSaveParameterValues(true);
                if (this.enableSeamlessFailover_) {
                    return new AS400JDBCPreparedStatementRedirect(aS400JDBCPreparedStatement);
                }
                return aS400JDBCPreparedStatement;
            }
            catch (SQLException sQLException) {
                try {
                    bl = this.handleException(sQLException);
                }
                catch (AS400JDBCTransientException aS400JDBCTransientException) {
                    if (this.currentConnection_.canSeamlessFailover()) {
                        if (--n >= 0) {
                            bl = true;
                            continue;
                        }
                        throw aS400JDBCTransientException;
                    }
                    throw aS400JDBCTransientException;
                }
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void processSavepointRequest(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.processSavepointRequest(string);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void pseudoClose() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.pseudoClose();
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.releaseSavepoint(savepoint);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void rollback() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.rollback();
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.rollback(savepoint);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void send(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.send(dBBaseRequestDS);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void send(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.send(dBBaseRequestDS, n);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void send(DBBaseRequestDS dBBaseRequestDS, int n, boolean bl) throws SQLException {
        boolean bl2 = true;
        while (bl2) {
            try {
                this.currentConnection_.send(dBBaseRequestDS, n, bl);
                bl2 = false;
            }
            catch (SQLException sQLException) {
                bl2 = this.handleException(sQLException);
            }
        }
    }

    public void sendAndHold(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.sendAndHold(dBBaseRequestDS, n);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public DBReplyRequestedDS sendAndReceive(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.sendAndReceive(dBBaseRequestDS);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public DBReplyRequestedDS sendAndReceive(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.sendAndReceive(dBBaseRequestDS, n);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public DBReplyRequestedDS sendAndMultiReceive(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.sendAndMultiReceive(dBBaseRequestDS);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public DBReplyRequestedDS receiveMoreData() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.receiveMoreData();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        boolean bl2 = true;
        while (bl2) {
            try {
                this.currentConnection_.setAutoCommit(bl);
                bl2 = false;
            }
            catch (SQLException sQLException) {
                bl2 = this.handleException(sQLException);
            }
        }
        this.autoCommitSet_ = true;
        this.autoCommitSetting_ = bl;
    }

    public void setCatalog(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setCatalog(string);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setConcurrentAccessResolution(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setConcurrentAccessResolution(n);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setDB2eWLMCorrelator(byte[] byArray) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setDB2eWLMCorrelator(byArray);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setDRDA(boolean bl) throws SQLException {
        boolean bl2 = true;
        while (bl2) {
            try {
                this.currentConnection_.setDRDA(bl);
                bl2 = false;
            }
            catch (SQLException sQLException) {
                bl2 = this.handleException(sQLException);
            }
        }
    }

    public void setHoldability(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setHoldability(n);
                bl = false;
                this.holdability_ = n;
                this.holdabilitySet_ = true;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400 aS400, Properties properties) throws SQLException {
        block6: {
            try {
                this.originalDataSourceUrl_ = jDDataSourceURL;
                this.originalProperties_ = jDProperties;
                this.originalAs400 = aS400;
                this.originalInfo_ = properties;
                if (properties == null) {
                    this.originalInfo_ = new Properties();
                    this.originalInfo_.put("user", aS400.getUserId());
                }
                this.setupRetryInformation();
                this.currentConnection_.setProperties(jDDataSourceURL, jDProperties, aS400, properties);
                this.currentUrl_ = jDDataSourceURL;
                String string = this.currentConnection_.getAlternateServer();
                if (string != null) {
                    this.setupAlternateServers(string);
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.handleException(sQLException);
                }
                catch (SQLException sQLException2) {
                    if (sQLException2.getErrorCode() == -4498) break block6;
                    throw sQLException2;
                }
            }
        }
    }

    public void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400Impl aS400Impl) throws SQLException {
        this.originalDataSourceUrl_ = jDDataSourceURL;
        this.currentUrl_ = jDDataSourceURL;
        this.originalProperties_ = jDProperties;
        this.setupRetryInformation();
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setProperties(jDDataSourceURL, jDProperties, aS400Impl);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public boolean ignoreWarning(String string) {
        return this.currentConnection_.ignoreWarning(string);
    }

    public boolean ignoreWarning(SQLWarning sQLWarning) {
        return this.currentConnection_.ignoreWarning(sQLWarning);
    }

    public void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400Impl aS400Impl, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = true;
        while (bl3) {
            try {
                this.originalDataSourceUrl_ = jDDataSourceURL;
                this.originalProperties_ = jDProperties;
                this.currentConnection_.setProperties(jDDataSourceURL, jDProperties, aS400Impl, bl, bl2);
                bl3 = false;
            }
            catch (SQLException sQLException) {
                bl3 = this.handleException(sQLException);
            }
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        boolean bl2 = true;
        while (bl2) {
            try {
                this.currentConnection_.setReadOnly(bl);
                bl2 = false;
                this.readOnlySet_ = true;
                this.readOnly_ = bl;
            }
            catch (SQLException sQLException) {
                bl2 = this.handleException(sQLException);
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.setSavepoint();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.setSavepoint(string);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Savepoint setSavepoint(String string, int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.setSavepoint(string, n);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setServerAttributes() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setServerAttributes();
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setSystem(AS400 aS400) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.originalAs400 = aS400;
                this.currentConnection_.setSystem(aS400);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setTransactionIsolation(n);
                bl = false;
                this.transactionIsolationSet_ = true;
                this.transactionIsolationSetting_ = n;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setTypeMap(map);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public boolean useExtendedFormats() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.useExtendedFormats();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public String[] getValidWrappedList() {
        return this.currentConnection_.getValidWrappedList();
    }

    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setClientInfo(string, string2);
                if (this.clientInfoHashtable_ == null) {
                    this.clientInfoHashtable_ = new Hashtable();
                }
                if (string2 == null) {
                    string2 = "";
                }
                this.clientInfoHashtable_.put(string, string2);
                bl = false;
            }
            catch (SQLClientInfoException sQLClientInfoException) {
                bl = this.handleSQLClientInfoException(sQLClientInfoException);
            }
        }
    }

    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setClientInfo(properties);
                if (this.clientInfoHashtable_ == null) {
                    this.clientInfoHashtable_ = new Hashtable();
                }
                String[] stringArray = new String[]{"ApplicationName", "ClientUser", "ClientAccounting", "ClientHostname", "ClientProgramID"};
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = properties.getProperty(string);
                    if (string2 == null) {
                        string2 = "";
                    }
                    this.clientInfoHashtable_.put(string, string2);
                }
                bl = false;
            }
            catch (SQLClientInfoException sQLClientInfoException) {
                bl = this.handleSQLClientInfoException(sQLClientInfoException);
            }
        }
    }

    public String getClientInfo(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getClientInfo(string);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Properties getClientInfo() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getClientInfo();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Clob createClob() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.createClob();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Blob createBlob() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.createBlob();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.createArrayOf(string, objectArray);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.createStruct(string, objectArray);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setDBHostServerTrace(boolean bl) {
        this.currentConnection_.setDBHostServerTrace(bl);
    }

    public boolean doUpdateDeleteBlocking() {
        return this.currentConnection_.doUpdateDeleteBlocking();
    }

    public int getMaximumBlockedInputRows() {
        return this.currentConnection_.getMaximumBlockedInputRows();
    }

    public String getSchema() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getSchema();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void setNetworkTimeout(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setNetworkTimeout(n);
                bl = false;
                this.networkTimeoutSet_ = true;
                this.networkTimeout_ = n;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public int getNetworkTimeout() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.getNetworkTimeout();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return 0;
    }

    public void setSchema(String string) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setSchema(string);
                bl = false;
                if (this.setCommands_ == null) {
                    this.setCommands_ = new Vector();
                }
                this.setCommands_.add("SET SCHEMA " + string);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public boolean isQueryTimeoutMechanismCancel() {
        return this.currentConnection_.isQueryTimeoutMechanismCancel();
    }

    public void setupVariableFieldCompression() {
        this.currentConnection_.setupVariableFieldCompression();
    }

    public boolean useVariableFieldCompression() {
        return this.currentConnection_.useVariableFieldCompression();
    }

    public boolean useVariableFieldInsertCompression() {
        return this.currentConnection_.useVariableFieldInsertCompression();
    }

    public void setDisableCompression(boolean bl) {
        this.currentConnection_.setDisableCompression(bl);
    }

    public void dumpStatementCreationLocation() {
        this.currentConnection_.dumpStatementCreationLocation();
    }

    public boolean testDataTruncation(AS400JDBCStatement aS400JDBCStatement, AS400JDBCResultSet aS400JDBCResultSet, int n, boolean bl, SQLData sQLData, JDSQLStatement jDSQLStatement) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3) {
            try {
                bl2 = this.currentConnection_.testDataTruncation(aS400JDBCStatement, aS400JDBCResultSet, n, bl, sQLData, jDSQLStatement);
                bl3 = false;
            }
            catch (SQLException sQLException) {
                bl3 = this.handleException(sQLException);
            }
        }
        return bl2;
    }

    public ConvTable getConverter() {
        return this.currentConnection_.getConverter();
    }

    public void setLastServerSQLState(String string) {
        this.currentConnection_.setLastServerSQLState(string);
    }

    public String getLastServerSQLState() {
        return this.currentConnection_.getLastServerSQLState();
    }

    public ConvTable getPackageCCSID_Converter() {
        return this.currentConnection_.getPackageCCSID_Converter();
    }

    public void finalize() {
    }

    public boolean getReadOnly() {
        return this.currentConnection_.getReadOnly();
    }

    public boolean getCheckStatementHoldability() {
        return this.currentConnection_.getCheckStatementHoldability();
    }

    public String toString() {
        return this.currentConnection_.toString();
    }

    int getNewAutoCommitSupport() {
        return this.currentConnection_.getNewAutoCommitSupport();
    }

    void addSetCommand(String string) {
        if (this.setCommands_ == null) {
            this.setCommands_ = new Vector();
        }
        this.setCommands_.addElement(string);
    }

    boolean canSeamlessFailover() {
        return this.lastConnectionCanSeamlessFailover_;
    }

    public String[] getReconnectURLs() {
        if (this.reconnectUrlStrings_ == null) {
            this.reconnectUrlStrings_ = new String[this.reconnectUrls_.length];
            for (int i = 0; i < this.reconnectUrls_.length; ++i) {
                this.reconnectUrlStrings_[i] = this.reconnectUrls_[i].toString();
            }
        }
        return this.reconnectUrlStrings_;
    }

    public boolean isValid(int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.isValid(n);
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return false;
    }

    public NClob createNClob() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.createNClob();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public SQLXML createSQLXML() throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                return this.currentConnection_.createSQLXML();
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
        JDError.throwSQLException("HY000");
        return null;
    }

    public void abort(Executor executor) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.abort(executor);
                bl = false;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }

    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        boolean bl = true;
        while (bl) {
            try {
                this.currentConnection_.setNetworkTimeout(executor, n);
                bl = false;
                this.networkTimeoutSet_ = true;
                this.networkTimeout_ = n;
            }
            catch (SQLException sQLException) {
                bl = this.handleException(sQLException);
            }
        }
    }
}

