/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConvTableDoubleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private char[] toUnicode_ = null;
    private char[] fromUnicode_ = null;
    char[][] toUnicodeSurrogate_ = null;
    public static final int LEADING_SURROGATE_BASE = 55296;
    public static final int TRAILING_SURROGATE_BASE = 56320;
    public static final int FROM_UNICODE_SURROGATE_DIMENSION_LENGTH = 1024;
    char[][] fromUnicodeSurrogate_ = null;
    char[] combiningCharacters_;
    char[][] combiningCombinations_;

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2, char[][] cArray3) {
        this(n, cArray, cArray2);
        char c;
        int n2;
        this.toUnicodeSurrogate_ = new char[65535][];
        this.fromUnicodeSurrogate_ = new char[1024][];
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        Hashtable<Integer, char[]> hashtable = new Hashtable<Integer, char[]>();
        for (n2 = 0; n2 < cArray3.length; ++n2) {
            char[] cArray4;
            c = cArray3[n2][0];
            char c2 = cArray3[n2][1];
            char c3 = cArray3[n2][2];
            char[] cArray5 = new char[]{c2, c3};
            this.toUnicodeSurrogate_[0xFFFF & c] = cArray5;
            int n3 = c2 - 55296;
            int n4 = c3 - 56320;
            if (n3 >= 0 && n3 < 1024) {
                if (this.fromUnicodeSurrogate_[n3] == null) {
                    this.fromUnicodeSurrogate_[n3] = new char[1024];
                }
                cArray4 = this.fromUnicodeSurrogate_[n3];
                if (n4 < 0 || n4 >= 1024) continue;
                cArray4[n4] = c;
                continue;
            }
            cArray4 = new char[]{c2, c3, c};
            arrayList.add(cArray4);
            hashtable.put(new Integer(c3), cArray5);
        }
        n2 = hashtable.size();
        this.combiningCharacters_ = new char[n2];
        c = '\u0000';
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n5 = (Integer)enumeration.nextElement();
            this.combiningCharacters_[c] = (char)n5.intValue();
            ++c;
        }
        int n6 = arrayList.size();
        this.combiningCombinations_ = new char[n6][];
        for (c = '\u0000'; c < n6; ++c) {
            this.combiningCombinations_[c] = (char[])arrayList.get(c);
        }
    }

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.toUnicode_ = this.decompress(cArray);
        this.fromUnicode_ = this.decompress(cArray2);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded double-byte map for ccsid: " + this.ccsid_);
        }
    }

    ConvTableDoubleMap(ConvTableDoubleMap convTableDoubleMap) {
        super(convTableDoubleMap.ccsid_);
        this.toUnicode_ = convTableDoubleMap.toUnicode_;
        this.fromUnicode_ = convTableDoubleMap.fromUnicode_;
        this.toUnicodeSurrogate_ = convTableDoubleMap.toUnicodeSurrogate_;
        this.fromUnicodeSurrogate_ = convTableDoubleMap.fromUnicodeSurrogate_;
        this.combiningCharacters_ = convTableDoubleMap.combiningCharacters_;
        this.combiningCombinations_ = convTableDoubleMap.combiningCombinations_;
    }

    char[] decompress(char[] cArray) {
        return ConvTableDoubleMap.decompress(cArray, this.ccsid_);
    }

    static char[] decompress(char[] cArray, int n) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing double-byte conversion table for ccsid: " + n, cArray.length);
        }
        char[] cArray2 = new char[65536];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n3;
            int n4;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                long l = (0xFFFF & cArray[i + 1]) + (0xFFFF & n2);
                n4 = cArray[i + 2];
                while ((long)n2 < l) {
                    cArray2[n2++] = n4;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                int n5 = 0xFFFF & cArray[i + 2];
                n3 = 0xFFFF & cArray[i + 1];
                for (n4 = n5; n4 < n3 + n5; ++n4) {
                    cArray2[n2++] = (char)n4;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                int n6 = 0xFFFF & cArray[++i];
                n3 = cArray[++i];
                n4 = (char)(0xFF00 & n3);
                cArray2[n2++] = n3;
                ++i;
                for (int j = 0; j < n6; ++j) {
                    char c = cArray[i + j];
                    cArray2[n2++] = (char)(n4 + ((0xFF00 & c) >>> 8));
                    cArray2[n2++] = (char)(n4 + (0xFF & c));
                }
                i = i + n6 - 1;
                continue;
            }
            cArray2[n2++] = cArray[i];
        }
        return cArray2;
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            try {
                int n4 = ((0xFF & byArray[i * 2 + n]) << 8) + (0xFF & byArray[i * 2 + 1 + n]);
                int n5 = this.toUnicode(cArray, n3, n4);
                n3 += n5;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw arrayIndexOutOfBoundsException;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public int toUnicode(char[] cArray, int n, int n2) {
        int n3 = 0;
        cArray[n] = this.toUnicode_[n2];
        if (cArray[n] == '\ud800') {
            if (this.toUnicodeSurrogate_ != null) {
                char[] cArray2 = this.toUnicodeSurrogate_[n2];
                if (cArray2 != null) {
                    cArray[n] = cArray2[0];
                    ++n3;
                    cArray[++n] = cArray2[1];
                    ++n;
                    ++n3;
                } else {
                    cArray[n] = 65533;
                    ++n;
                    ++n3;
                }
            } else {
                cArray[n] = 65533;
                ++n;
                ++n3;
            }
        } else {
            ++n;
            ++n3;
        }
        return n3;
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int[] nArray = new int[1];
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = this.fromUnicode(cArray, n2, nArray);
            byArray[n * 2] = (byte)(c >>> 8);
            byArray[n * 2 + 1] = (byte)(0xFF & c);
            if (nArray[0] > 1) {
                ++n2;
            }
            ++n2;
            ++n;
        }
        if (n * 2 != byArray.length) {
            byte[] byArray2 = new byte[n * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n * 2);
            byArray = byArray2;
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }

    public char fromUnicode(char[] cArray, int n, int[] nArray) {
        int n2 = 1;
        int n3 = 0;
        char c = cArray[n];
        if (c < '\ud800' || c >= '\udc00') {
            int n4 = n + 1;
            boolean bl = false;
            if (this.combiningCharacters_ != null && n4 < cArray.length) {
                char c2 = cArray[n4];
                for (int i = 0; !bl && i < this.combiningCharacters_.length; ++i) {
                    if (c2 != this.combiningCharacters_[i]) continue;
                    for (int j = 0; !bl && j < this.combiningCombinations_.length; ++j) {
                        if (c != this.combiningCombinations_[j][0] || c2 != this.combiningCombinations_[j][1]) continue;
                        bl = true;
                        n3 = this.combiningCombinations_[j][2];
                        ++n;
                        ++n2;
                    }
                }
            }
            if (!bl) {
                n3 = this.fromUnicode_[cArray[n]];
            }
        } else {
            int n5;
            char[] cArray2;
            int n6 = cArray[n] - 55296;
            ++n2;
            n3 = this.fromUnicodeSurrogate_ != null ? ((cArray2 = this.fromUnicodeSurrogate_[n6]) != null ? ((n5 = cArray[++n] - 56320) >= 0 && n5 < 1024 && cArray2[n5] != '\u0000' ? cArray2[n5] : 65278) : 65278) : 65278;
        }
        nArray[0] = n2;
        return (char)n3;
    }

    public char[] getFromUnicode() {
        return this.fromUnicode_;
    }

    void setFromUnicode(char[] cArray) {
        this.fromUnicode_ = cArray;
    }

    public char[] getToUnicode() {
        return this.toUnicode_;
    }

    void setToUnicode(char[] cArray) {
        this.toUnicode_ = cArray;
    }
}

