/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.Trace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

class DDMDataStream
extends DataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    protected static final int HEADER_LENGTH = 6;
    protected static final int MAX_DATA_STREAM_LEN = Short.MAX_VALUE;
    protected static final int CONTINUATION_MASK = 128;
    protected static final byte CHAINED_MASK = 64;
    protected static final byte CONTINUE_ON_ERROR_MASK = 32;
    protected static final int OBJECT_DATA_STREAM = 17;
    protected static final int REPLY_DATA_STREAM = 16;
    protected static final int REQUEST_DATA_STREAM = 1;
    protected static final byte SAME_CORRELATOR_MASK = 16;
    protected static final byte TYPE_MASK = 3;

    static DDMDataStream construct(InputStream inputStream, Hashtable hashtable, AS400ImplRemote aS400ImplRemote, int n) throws IOException {
        DDMDataStream dDMDataStream = new DDMDataStream();
        if (DDMDataStream.readFromStream(inputStream, dDMDataStream.data_, 0, 6, n) < 6) {
            Trace.log(2, "Failed to read all of the DDM data stream header.");
            throw new ConnectionDroppedException(2);
        }
        DDMDataStream dDMDataStream2 = (DDMDataStream)hashtable.get(dDMDataStream);
        DDMDataStream dDMDataStream3 = null;
        if (dDMDataStream2 == null) {
            dDMDataStream3 = new DDMDataStream();
        } else {
            dDMDataStream3 = (DDMDataStream)dDMDataStream2.getNewDataStream();
            if (dDMDataStream3 == null) {
                dDMDataStream3 = new DDMDataStream();
            }
        }
        dDMDataStream3.setSystem(aS400ImplRemote);
        dDMDataStream3.setConnectionID(n);
        int n2 = dDMDataStream.getLength();
        if (n2 - 6 > 0) {
            if (dDMDataStream.isContinued()) {
                byte[] byArray = new byte[32765];
                byte[] byArray2 = new byte[2];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(dDMDataStream.data_, 0, 6);
                byte[] byArray3 = new byte[n2 - 6];
                if (DDMDataStream.readFromStream(inputStream, byArray3, 0, n2 - 6, n) < n2 - 6) {
                    Trace.log(2, "Failed to read all of the DDM data stream packet.");
                    throw new ConnectionDroppedException(2);
                }
                byteArrayOutputStream.write(byArray3);
                boolean bl = false;
                while (!bl) {
                    if (DDMDataStream.readFromStream(inputStream, byArray2, 0, 2, n) < 2) {
                        Trace.log(2, "Failed to read all of the DDM data stream packet length.");
                        throw new ConnectionDroppedException(2);
                    }
                    n2 = BinaryConverter.byteArrayToUnsignedShort(byArray2, 0);
                    if (n2 == 65535) {
                        byArray3 = byArray;
                        n2 = Short.MAX_VALUE;
                    } else {
                        byArray3 = new byte[n2 - 2];
                        bl = true;
                    }
                    if (DDMDataStream.readFromStream(inputStream, byArray3, 0, n2 - 2, n) < n2 - 2) {
                        Trace.log(2, "Failed to read all of the DDM data stream continuation packet.");
                        throw new ConnectionDroppedException(2);
                    }
                    byteArrayOutputStream.write(byArray3);
                }
                dDMDataStream3.data_ = byteArrayOutputStream.toByteArray();
            } else {
                dDMDataStream3.data_ = new byte[n2];
                System.arraycopy(dDMDataStream.data_, 0, dDMDataStream3.data_, 0, 6);
                if (dDMDataStream3.data_.length - 6 > 0) {
                    dDMDataStream3.readAfterHeader(inputStream);
                }
            }
        }
        return dDMDataStream3;
    }

    DDMDataStream() {
        super(6);
    }

    DDMDataStream(byte[] byArray) {
        super(6, byArray);
        this.setLength(this.data_.length);
    }

    DDMDataStream(int n) {
        super(6);
        this.data_ = new byte[n];
        this.setLength(this.data_.length);
    }

    boolean continueOnError() {
        return (this.data_[3] & 0x20) != 0;
    }

    int getCodePoint() {
        if (this.data_.length > 6) {
            return this.get16bit(8);
        }
        return 0;
    }

    int getCorrelation() {
        return this.get16bit(4);
    }

    byte getGDSId() {
        return this.data_[2];
    }

    int getLength() {
        int n;
        if (this.isContinued()) {
            byte[] byArray = new byte[2];
            System.arraycopy(this.data_, 0, byArray, 0, 2);
            byArray[0] = (byte)(byArray[0] & 0x7F);
            n = BinaryConverter.byteArrayToUnsignedShort(byArray, 0);
        } else {
            n = this.get16bit(0);
        }
        return n;
    }

    int getType() {
        return this.data_[3] & 3;
    }

    public int hashCode() {
        return this.getType();
    }

    boolean hasSameRequestCorrelation() {
        return (this.data_[3] & 0x10) != 0;
    }

    boolean isChained() {
        return (this.data_[3] & 0x40) != 0;
    }

    boolean isContinued() {
        return (this.data_[0] & 0x80) != 0;
    }

    void setContinueOnError(boolean bl) {
        this.data_[3] = bl ? (byte)(this.data_[3] | 0x20) : (byte)(this.data_[3] & 0xFFFFFFDF);
    }

    void setCorrelation(int n) {
        this.set16bit(n, 4);
    }

    void setGDSId(byte by) {
        this.data_[2] = by;
    }

    void setIsChained(boolean bl) {
        this.data_[3] = bl ? (byte)(this.data_[3] | 0x40) : (byte)(this.data_[3] & 0xFFFFFFBF);
    }

    void setLength(int n) {
        this.set16bit(n, 0);
    }

    void setHasSameRequestCorrelation(boolean bl) {
        this.data_[3] = bl ? (byte)(this.data_[3] | 0x10) : (byte)(this.data_[3] & 0xFFFFFFEF);
    }

    void setType(int n) {
        this.data_[3] = n == 1 ? (byte)(this.data_[3] | 1) : (n == 2 ? (byte)(this.data_[3] | 2) : (byte)(this.data_[3] | 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(OutputStream outputStream) throws IOException {
        int n = this.data_.length;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
            this.data_[0] = -1;
            this.data_[1] = -1;
        }
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            outputStream.write(this.data_, 0, n);
            outputStream.flush();
        }
        if (Trace.isTraceOn()) {
            Trace.log(0, "DDMDataStream.write() (connID=" + this.connectionID_ + "):", this.data_, 0, n);
        }
        if (this.data_.length > n) {
            outputStream2 = new DataOutputStream(outputStream);
            int n2 = 0;
            for (int i = n; i < this.data_.length; i += n2 - 2) {
                OutputStream outputStream3;
                n2 = this.data_.length - i + 2;
                if (n2 > Short.MAX_VALUE) {
                    n2 = Short.MAX_VALUE;
                    outputStream3 = outputStream;
                    synchronized (outputStream3) {
                        ((DataOutputStream)outputStream2).writeShort(-1);
                        ((DataOutputStream)outputStream2).flush();
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(0, "DDMDataStream.write() continuation (connID=" + this.connectionID_ + "):", new byte[]{-1, -1});
                    }
                } else {
                    outputStream3 = outputStream;
                    synchronized (outputStream3) {
                        ((DataOutputStream)outputStream2).writeShort(n2);
                        ((DataOutputStream)outputStream2).flush();
                    }
                    if (Trace.isTraceOn()) {
                        Trace.log(0, "DDMDataStream.write() packetLength (connID=" + this.connectionID_ + "):", new byte[]{(byte)(n2 >> 8), (byte)n2});
                    }
                }
                outputStream3 = outputStream;
                synchronized (outputStream3) {
                    ((DataOutputStream)outputStream2).write(this.data_, i, n2 - 2);
                    ((DataOutputStream)outputStream2).flush();
                }
                if (!Trace.isTraceOn()) continue;
                Trace.log(0, "DDMDataStream.write() (connID=" + this.connectionID_ + "):", this.data_, i, n2 - 2);
            }
        }
        outputStream2 = outputStream;
        synchronized (outputStream2) {
            outputStream.flush();
        }
    }
}

