/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.Copyright;
import com.ibm.as400.access.NLSTableDownload;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.Date;

public class GenerateConverterTable {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    static AS400 sys = null;
    static boolean compress_ = true;
    static boolean codePointPerLine_ = false;
    static boolean ascii_ = false;
    static boolean bidi_ = false;
    static boolean showOffsets_ = false;
    private static final char repSig = '\uffff';
    private static final char cic_ = '\uffff';
    private static final char rampSig = '\ufffe';
    private static final char ric_ = '\ufffe';
    private static final char hbSig = '\u0000';
    private static final char pad = '\u0000';
    static int numRepeats;
    static int numRamps;
    static int hbRepeats;
    static int charRepeats;

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: java com.ibm.as400.access.GenerateConverterTable system uid pwd [-nocompress] [-ascii] [-bidi] [-showOffsets] [-codePointPerLine] ccsid [ccsid2] [ccsid3] [ccsid4] ...");
            System.exit(0);
        }
        try {
            sys = new AS400(stringArray[0], stringArray[1], stringArray[2]);
            sys.connectService(6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        int n = 3;
        if (stringArray[n].equals("-nocompress")) {
            compress_ = false;
            ++n;
        }
        if (stringArray[n].equals("-ascii")) {
            ascii_ = true;
            ++n;
        }
        if (stringArray[n].equals("-bidi")) {
            bidi_ = true;
            ++n;
        }
        if (stringArray[n].equals("-showOffsets")) {
            showOffsets_ = true;
            ++n;
        }
        if (stringArray[n].equals("-codePointPerLine")) {
            codePointPerLine_ = true;
            ++n;
        }
        for (int i = n; i < stringArray.length; ++i) {
            GenerateConverterTable.go(new Integer(stringArray[i]));
        }
    }

    static String formattedChar(char c) {
        int n = 0xFFFF & c;
        String string = "\\u";
        if (n < 16) {
            string = string + "0";
        }
        if (n < 256) {
            string = string + "0";
        }
        if (n < 4096) {
            string = string + "0";
        }
        string = string + Integer.toHexString(n).toUpperCase();
        return string;
    }

    static void go(int n) {
        int n2;
        int n3;
        Object object;
        Object object2 = new char[]{};
        char[] cArray = new char[]{};
        Object object3 = null;
        boolean bl = false;
        int n4 = 2;
        int n5 = n;
        try {
            int n6;
            AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)sys.getImpl();
            object = new NLSTableDownload(aS400ImplRemote);
            ((NLSTableDownload)object).connect();
            if (n == 1089) {
                System.out.println("Special case for ccsid 1089.");
                System.out.println("Retrieving " + n + "->61952 table...");
                object2 = ((NLSTableDownload)object).download(n, 61952, 1);
            } else if (n == 61175) {
                System.out.println("Special case for ccsid 61175.");
                System.out.println("Retrieving 1026->13488 table and adjusting...");
                object2 = ((NLSTableDownload)object).download(1026, 13488, 1);
                object2[252] = object2[127];
                object2[127] = 34;
            } else if (n == 1376) {
                object2 = null;
            } else if (n == 1371) {
                object2 = null;
                n4 = 3;
            } else {
                System.out.println("Retrieving " + n + "->13488 table...");
                object2 = ((NLSTableDownload)object).download(n, 13488, 1);
            }
            if (object2 == null || ((char[])object2).length == 0) {
                String string = "";
                string = object2 == null ? "tableToUnicode is null" : "tableToUnicode.length is 0";
                if (n == 1175) {
                    System.out.println("Aborting since CCSD 1175 failed to download");
                    throw new Exception("Aborting since CCSD 1175 failed to download");
                }
                System.out.println(n + " must be double-byte because download failed (" + string + "). Performing secondary retrieve of " + n + "->1200 table...");
                bl = true;
                ((NLSTableDownload)object).disconnect();
                ((NLSTableDownload)object).connect();
                object2 = ((NLSTableDownload)object).download(n, 1200, n4);
            }
            System.out.println("  Size: " + ((char[])object2).length);
            if (((char[])object2).length > 65536) {
                System.out.println("Size is > 65536.  Fixing table");
                n3 = 0;
                char[] cArray2 = new char[65536];
                for (int i = 0; n3 < ((char[])object2).length && i < 65536; ++i) {
                    n2 = 0xFFFF & object2[n3];
                    if (i > 60586 && i <= 60624) {
                        System.out.println("Next=0x" + Integer.toHexString(i) + " to=" + Integer.toHexString(n2));
                    }
                    n6 = 0;
                    if (n3 + 1 < ((char[])object2).length) {
                        n6 = 0xFFFF & object2[n3 + 1];
                    }
                    if (n2 >= 55296 && n2 <= 57343 || n6 == 12442 && n2 != 12441 || n2 != 65533 && n6 == 768 || n2 != 4093 && n2 != 768 && n6 == 769 || n2 == 741 && n6 == 745 || n2 == 745 && n6 == 741) {
                        cArray2[i] = 55296;
                        if (object3 == null) {
                            object3 = new char[65536][];
                        }
                        char[] cArray3 = new char[2];
                        object3[i] = cArray3;
                        cArray3[0] = (char)(0xFFFF & object2[n3]);
                        cArray3[1] = (char)(0xFFFF & object2[n3 + 1]);
                        n3 += 2;
                        continue;
                    }
                    cArray2[i] = (char)n2;
                    ++n3;
                }
                object2 = cArray2;
            }
            ((NLSTableDownload)object).disconnect();
            ((NLSTableDownload)object).connect();
            if (n == 1089) {
                System.out.println("Special case for ccsid 1089.");
                System.out.println("Retrieving 61952->" + n + " table...");
                cArray = ((NLSTableDownload)object).download(61952, n, 2);
            } else {
                System.out.println("Retrieving 1200->" + n + " table...");
                cArray = ((NLSTableDownload)object).download(1200, n, 2);
            }
            System.out.println("  Size: " + cArray.length);
            if (n4 == 3) {
                int n7;
                char[] cArray4 = new char[65536];
                byte[] byArray = new byte[cArray.length * 2];
                for (n7 = 0; n7 < cArray.length; ++n7) {
                    byArray[2 * n7] = (byte)(0xFF & cArray[n7] >> 8);
                    byArray[2 * n7 + 1] = (byte)(cArray[n7] & 0xFF);
                }
                n7 = 1;
                n2 = 0;
                for (n6 = 0; n6 < byArray.length; ++n6) {
                    int n8 = 0xFF & byArray[n6];
                    while (n6 > 15 && n6 < byArray.length && (n8 == 14 || n8 == 15)) {
                        if (n8 == 14) {
                            n7 = 0;
                            ++n6;
                        } else {
                            n7 = 1;
                            ++n6;
                        }
                        if (n6 >= byArray.length) continue;
                        n8 = 0xFF & byArray[n6];
                    }
                    if (n6 >= byArray.length) continue;
                    if (n7 != 0) {
                        if (n2 >= cArray4.length) continue;
                        cArray4[n2] = (char)n8;
                        ++n2;
                        continue;
                    }
                    if (++n6 >= byArray.length) continue;
                    int n9 = 0xFF & byArray[n6];
                    if (n2 >= cArray4.length) continue;
                    if (n2 == 1073) {
                        cArray4[n2] = (char)((n8 << 8) + n9);
                        ++n2;
                        continue;
                    }
                    cArray4[n2] = (char)((n8 << 8) + n9);
                    ++n2;
                }
                while (n2 < cArray4.length) {
                    cArray4[n2] = 65278;
                    ++n2;
                }
                cArray = cArray4;
            }
            sys.disconnectAllServices();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        if (n == 290) {
            object2[225] = 8364;
            char c = cArray[4182];
            cArray[4182] = c = (char)(0xE100 | c & 0xFF);
        }
        GenerateConverterTable.verifyRoundTrip(object2, cArray, bl);
        System.out.println("****************************************");
        System.out.println("Verify round 2 ");
        System.out.println("****************************************");
        GenerateConverterTable.verifyRoundTrip(object2, cArray, bl);
        if (bl && compress_) {
            System.out.println("Compressing " + n + "->13488 conversion table...");
            char[] cArray5 = GenerateConverterTable.compress(object2);
            System.out.println("Old compression length: " + cArray5.length + " characters.");
            object = GenerateConverterTable.compressBetter(object2);
            System.out.println("New compression length: " + ((Object)object).length + " characters.");
            if (((Object)object).length > cArray5.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            cArray5 = GenerateConverterTable.decompressBetter((char[])object);
            if (cArray5.length != ((char[])object2).length) {
                int n10;
                System.out.println("Verification failed, lengths not equal: " + cArray5.length + " != " + ((char[])object2).length);
                for (n10 = 0; n10 < cArray5.length && cArray5[n10] == object2[n10]; ++n10) {
                }
                System.out.println("First mismatch at index " + n10 + ": " + cArray5[n10] + " != " + object2[n10]);
            } else {
                boolean bl2 = false;
                for (n3 = 0; n3 < cArray5.length; ++n3) {
                    if (cArray5[n3] == object2[n3]) continue;
                    bl2 = true;
                    System.out.println(n3 + ": " + Integer.toHexString(cArray5[n3]) + " != " + Integer.toHexString(object2[n3]));
                }
                if (bl2) {
                    System.out.println("Mismatches found in table.");
                } else {
                    object2 = object;
                    System.out.println("Table verified.");
                }
            }
        }
        int n11 = n;
        if (n4 == 3) {
            n11 = n + 1100000;
            System.out.println("Create file using " + n11 + " since MIXED CCSID ");
        }
        try {
            object = "ConvTable" + n11 + ".java";
            FileWriter fileWriter = new FileWriter((String)object);
            GenerateConverterTable.writeHeader(fileWriter, n11, sys.getSystemName());
            if (ascii_) {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableAsciiMap\n{\n");
            } else if (bidi_) {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableBidiMap\n{\n");
            } else if (bl) {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableDoubleMap\n{\n");
            } else {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableSingleMap\n{\n");
            }
            fileWriter.write("  private static char[] toUnicodeArray_;  \n");
            fileWriter.write("  private static final String copyright = \"Copyright (C) 1997-2016 International Business Machines Corporation and others.\";\n");
            fileWriter.write("  private static final String toUnicode_ = \n");
            System.out.print("Writing table for conversion from " + n + " to 13488... to " + (String)object + "\n");
            for (n3 = 0; n3 < ((char[])object2).length; n3 += 16) {
                if (showOffsets_) {
                    fileWriter.write("/* " + Integer.toHexString(n3) + " */ \"");
                } else {
                    fileWriter.write("    \"");
                }
                for (int i = 0; i < 16 && n3 + i < ((char[])object2).length; ++i) {
                    n2 = object2[n3 + i];
                    if (n2 == 8) {
                        fileWriter.write("\\b");
                    } else if (n2 == 9) {
                        fileWriter.write("\\t");
                    } else if (n2 == 10) {
                        fileWriter.write("\\n");
                    } else if (n2 == 12) {
                        fileWriter.write("\\f");
                    } else if (n2 == 13) {
                        fileWriter.write("\\r");
                    } else if (n2 == 34) {
                        fileWriter.write("\\\"");
                    } else if (n2 == 39) {
                        fileWriter.write("\\'");
                    } else if (n2 == 92) {
                        fileWriter.write("\\\\");
                    } else {
                        String string = "\\u";
                        if (n2 < 16) {
                            string = string + "0";
                        }
                        if (n2 < 256) {
                            string = string + "0";
                        }
                        if (n2 < 4096) {
                            string = string + "0";
                        }
                        string = string + Integer.toHexString(n2).toUpperCase();
                        fileWriter.write(string);
                    }
                    if (!codePointPerLine_ || i >= 15) continue;
                    if (showOffsets_) {
                        fileWriter.write("\" +\n/* " + Integer.toHexString(n3 + i + 1) + " */ \"");
                        continue;
                    }
                    fileWriter.write("\" +\n    \"");
                }
                if (n3 + 16 < ((char[])object2).length) {
                    fileWriter.write("\" +\n");
                    continue;
                }
                fileWriter.write("\";\n");
            }
            fileWriter.write("\n");
            fileWriter.write("\n");
            if (object3 != null) {
                fileWriter.write("\n");
                fileWriter.write("  private static final char[][] toUnicodeSurrogateMappings = { \n");
                System.out.print("Writing surrogate table for conversion from " + n + " to 13488... to " + (String)object + "\n");
                for (n3 = 0; n3 < ((char[][])object3).length; ++n3) {
                    char[] cArray6 = object3[n3];
                    if (cArray6 == null) continue;
                    fileWriter.write("{'" + GenerateConverterTable.formattedChar((char)n3) + "','" + GenerateConverterTable.formattedChar(cArray6[0]) + "','" + GenerateConverterTable.formattedChar(cArray6[1]) + "'},\n");
                }
                fileWriter.write("};\n");
                fileWriter.write("\n");
                fileWriter.write("\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (compress_) {
            System.out.println("Compressing 13488->" + n + " conversion table...");
            object = GenerateConverterTable.compress(cArray);
            System.out.println("Old compression length: " + ((Object)object).length + " characters.");
            char[] cArray7 = GenerateConverterTable.compressBetter(cArray);
            System.out.println("New compression length: " + cArray7.length + " characters.");
            if (cArray7.length > ((Object)object).length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            object = GenerateConverterTable.decompressBetter(cArray7);
            if (((Object)object).length != cArray.length) {
                System.out.println("Verification failed, lengths not equal: " + ((Object)object).length + " != " + cArray.length);
                for (n3 = 0; n3 < ((Object)object).length && object[n3] == cArray[n3]; ++n3) {
                }
                System.out.println("First mismatch at index " + n3 + ": " + (int)object[n3] + " != " + cArray[n3]);
                cArray = cArray7;
            } else {
                n3 = 0;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] == cArray[i]) continue;
                    n3 = 1;
                    System.out.println(i + ": " + Integer.toHexString((int)object[i]) + " != " + Integer.toHexString(cArray[i]));
                }
                if (n3 != 0) {
                    System.out.println("Mismatches found in table.");
                } else {
                    cArray = cArray7;
                    System.out.println("Table verified.");
                }
            }
        }
        try {
            object = "ConvTable" + n11 + ".java";
            FileWriter fileWriter = new FileWriter((String)object, true);
            fileWriter.write("  private static char[] fromUnicodeArray_; \n");
            fileWriter.write("  private static final String fromUnicode_ = \n");
            System.out.print("Writing table for conversion from 13488 to " + n + "... to " + (String)object + "\n");
            for (n3 = 0; n3 < cArray.length; n3 += 16) {
                if (showOffsets_) {
                    fileWriter.write("/* " + Integer.toHexString(n3) + " */ \"");
                } else {
                    fileWriter.write("    \"");
                }
                for (int i = 0; i < 16 && n3 + i < cArray.length; ++i) {
                    n2 = cArray[n3 + i];
                    if (n2 == 8) {
                        fileWriter.write("\\b");
                    } else if (n2 == 9) {
                        fileWriter.write("\\t");
                    } else if (n2 == 10) {
                        fileWriter.write("\\n");
                    } else if (n2 == 12) {
                        fileWriter.write("\\f");
                    } else if (n2 == 13) {
                        fileWriter.write("\\r");
                    } else if (n2 == 34) {
                        fileWriter.write("\\\"");
                    } else if (n2 == 39) {
                        fileWriter.write("\\'");
                    } else if (n2 == 92) {
                        fileWriter.write("\\\\");
                    } else {
                        String string = "\\u";
                        if (n2 < 16) {
                            string = string + "0";
                        }
                        if (n2 < 256) {
                            string = string + "0";
                        }
                        if (n2 < 4096) {
                            string = string + "0";
                        }
                        string = string + Integer.toHexString(n2).toUpperCase();
                        fileWriter.write(string);
                    }
                    if (!codePointPerLine_ || i >= 15) continue;
                    if (showOffsets_) {
                        fileWriter.write("\" +\n/* " + Integer.toHexString(n3 + i + 1) + " */ \"");
                        continue;
                    }
                    fileWriter.write("\" +\n    \"");
                }
                if (n3 + 16 < cArray.length) {
                    fileWriter.write("\" +\n");
                    continue;
                }
                fileWriter.write("\";\n");
            }
            fileWriter.write("\n");
            fileWriter.write("  static {\n");
            fileWriter.write("    toUnicodeArray_ = toUnicode_.toCharArray();\n");
            fileWriter.write("    fromUnicodeArray_ = fromUnicode_.toCharArray();\n");
            fileWriter.write("  }\n");
            fileWriter.write("\n  ConvTable" + n11 + "()\n  {\n");
            fileWriter.write("    super(" + n11 + ", ");
            fileWriter.write("toUnicodeArray_, ");
            if (object3 != null) {
                fileWriter.write("fromUnicodeArray_,");
                fileWriter.write("toUnicodeSurrogateMappings);\n");
            } else {
                fileWriter.write("fromUnicodeArray_);\n");
            }
            fileWriter.write("  }\n\n");
            fileWriter.write("\n  ConvTable" + n11 + "(int ccsid)\n  {\n");
            fileWriter.write("    super(ccsid, ");
            fileWriter.write("toUnicodeArray_, ");
            if (object3 != null) {
                fileWriter.write("fromUnicodeArray_,");
                fileWriter.write("toUnicodeSurrogateMappings);\n");
            } else {
                fileWriter.write("fromUnicodeArray_);\n");
            }
            fileWriter.write("  }\n}\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.print("Done.\n");
    }

    private static boolean verifyRoundTrip(char[] cArray, char[] cArray2, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string = "X";
        if (bl) {
            string = "GX";
        }
        if (!bl && (n5 = 0xFFFF & cArray2[13]) >> 8 != 63) {
            System.out.println("Fixing sub char in tableToEbcdic == sub was 0x" + Integer.toHexString(n5 >> 8));
            n5 = 0x3F00 | 0xFF & n5;
            cArray2[13] = (char)n5;
        }
        System.out.println("Checking round trip");
        n5 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (n4 = 0; n4 < cArray.length; ++n4) {
            n3 = 0xFFFF & cArray[n4];
            if (n3 == 65533 || n3 == 55296) continue;
            if (bl) {
                n2 = 0xFFFF & cArray2[n3];
            } else {
                n = 0xFFFF & cArray2[n3 / 2];
                n2 = n3 % 2 == 0 ? n >> 8 : n & 0xFF;
            }
            if (n4 == n2) continue;
            if (n3 != 26 && (n2 == 65278 || n2 == 63)) {
                stringBuffer.append("Fixing up EBCDIC RoundTrip Failure " + string + "'" + Integer.toHexString(n4) + "'" + " -> UX'" + Integer.toHexString(n3) + "'" + " -> " + string + "'" + Integer.toHexString(n2) + "'\n");
                if (bl) {
                    cArray2[n3] = (char)n4;
                } else {
                    n = 0xFFFF & cArray2[n3 / 2];
                    n = n3 % 2 == 0 ? n4 << 8 | n & 0xFF : n & 0xFF00 | n4;
                    cArray2[n3 / 2] = (char)n;
                }
                n5 = 0;
                continue;
            }
            n = 0;
            try {
                n = 0xFFFF & cArray[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("ERROR.. ArrayIndexOutOfBounds");
                System.out.println("ebcdicChar=0x" + Integer.toHexString(n2));
                System.out.println("i=" + n4);
                System.out.println("unicodeChar=0x" + Integer.toHexString(n3));
                throw arrayIndexOutOfBoundsException;
            }
            if (n == n3) {
                stringBuffer2.append("Secondary EBCDIC mapping " + string + "'" + Integer.toHexString(n4) + "'" + " -> UX'" + Integer.toHexString(n3) + "'" + " -> " + string + "'" + Integer.toHexString(n2) + "'" + " -> UX'" + Integer.toHexString(n) + "'\n");
                continue;
            }
            stringBuffer3.append("EBCDIC RoundTrip Failure2 " + string + "'" + Integer.toHexString(n4) + "'" + " -> UX'" + Integer.toHexString(n3) + "'" + " -> " + string + "'" + Integer.toHexString(n2) + "'" + " -> UX'" + Integer.toHexString(n) + "'\n");
            n5 = 0;
        }
        System.out.println(stringBuffer2);
        System.out.println(stringBuffer);
        System.out.println(stringBuffer3);
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        stringBuffer3.setLength(0);
        for (n4 = 0; n4 < cArray2.length; ++n4) {
            if (bl) {
                n3 = 0xFFFF & cArray2[n4];
            } else {
                n2 = 0xFFFF & cArray2[n4 / 2];
                n3 = n4 % 2 == 0 ? n2 >> 8 : n2 & 0xFF;
            }
            if (n3 == 65278 || n3 == 63 || n4 == (n2 = 0xFFFF & cArray[n3])) continue;
            if (n2 == 65533) {
                stringBuffer.append("Unicode RoundTrip Failure UX'" + Integer.toHexString(n4) + "'" + " -> " + string + "'" + Integer.toHexString(n3) + "'" + " -> UX'" + Integer.toHexString(n2) + "'\n");
                n5 = 0;
                continue;
            }
            if (bl) {
                n = 0xFFFF & cArray2[n2];
            } else {
                int n6 = 0xFFFF & cArray2[n2 / 2];
                n = n2 % 2 == 0 ? n6 >> 8 : n6 & 0xFF;
            }
            if (n == n3) {
                stringBuffer2.append("Secondary Unicode mapping UX'" + Integer.toHexString(n4) + "'" + " -> " + string + "'" + Integer.toHexString(n3) + "'" + " -> UX'" + Integer.toHexString(n2) + "'" + " -> " + string + "'" + Integer.toHexString(n) + "'\n");
                continue;
            }
            stringBuffer3.append("Unicode RoundTrip Failure2 UX'" + Integer.toHexString(n4) + "'" + " -> " + string + "'" + Integer.toHexString(n3) + "'" + " -> UX'" + Integer.toHexString(n2) + "'" + " -> " + string + "'" + Integer.toHexString(n) + "'\n");
            n5 = 0;
        }
        System.out.println(stringBuffer2);
        System.out.println(stringBuffer);
        System.out.println(stringBuffer3);
        return n5 != 0;
    }

    static int repeatCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] == cArray[n2 - 1]; ++n2) {
        }
        return n2 - n;
    }

    static final int rampCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] == cArray[n2 - 1] + '\u0001'; ++n2) {
        }
        return n2 - n;
    }

    static int hbCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length; ++n2) {
            if (GenerateConverterTable.repeatCheck(cArray, n2) > 6) {
                return n2 - n;
            }
            if (GenerateConverterTable.rampCheck(cArray, n2) > 6) {
                return n2 - n;
            }
            if ((cArray[n2] & 0xFF00) == (cArray[n2 - 1] & 0xFF00)) continue;
            return n2 - n;
        }
        return n2 - n;
    }

    static char[] compressBetter(char[] cArray) {
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n = GenerateConverterTable.repeatCheck(cArray, i);
            if (n > 3) {
                ++numRepeats;
                stringBuffer.append('\uffff');
                stringBuffer.append((char)n);
                stringBuffer.append(cArray[i]);
                i += n - 1;
                continue;
            }
            int n2 = GenerateConverterTable.rampCheck(cArray, i);
            if (n2 > 3) {
                ++numRamps;
                stringBuffer.append('\ufffe');
                stringBuffer.append((char)n2);
                stringBuffer.append(cArray[i]);
                i += n2 - 1;
                continue;
            }
            int n3 = GenerateConverterTable.hbCheck(cArray, i);
            if (--n3 >= 6) {
                ++hbRepeats;
                stringBuffer.append('\u0000');
                if (n3 % 2 == 1) {
                    --n3;
                }
                stringBuffer.append((char)(n3 / 2));
                stringBuffer.append(cArray[i++]);
                for (int j = 0; j < n3 / 2; ++j) {
                    char c = (char)((0xFF & cArray[i + j * 2]) * 256 + (0xFF & cArray[i + j * 2 + 1]));
                    stringBuffer.append(c);
                }
                i = i + n3 - 1;
                continue;
            }
            stringBuffer.append(cArray[i]);
            ++charRepeats;
            if (cArray[i] != '\uffff' && cArray[i] != '\ufffe' && cArray[i] != '\u0000') continue;
            stringBuffer.append('\u0000');
        }
        System.out.println("Compression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return stringBuffer.toString().toCharArray();
    }

    static char[] decompressBetter(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            char c;
            int n2;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\uffff');
                    ++i;
                    continue;
                }
                ++numRepeats;
                n2 = cArray[i + 1];
                c = cArray[i + 2];
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(c);
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\ufffe');
                    ++i;
                    continue;
                }
                ++numRamps;
                n2 = cArray[i + 1];
                c = cArray[i + 2];
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append((char)(n + c));
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\u0000');
                    ++i;
                    continue;
                }
                ++hbRepeats;
                n2 = 0xFFFF & cArray[++i];
                c = cArray[++i];
                n = (char)(0xFF00 & c);
                stringBuffer.append(c);
                ++i;
                for (int j = 0; j < n2; ++j) {
                    char c2 = cArray[i + j];
                    char c3 = (char)(n + ((0xFF00 & c2) >>> 8));
                    char c4 = (char)(n + (0xFF & c2));
                    stringBuffer.append(c3);
                    stringBuffer.append(c4);
                }
                i = i + n2 - 1;
                continue;
            }
            stringBuffer.append(cArray[i]);
            ++charRepeats;
        }
        System.out.println("Decompression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return stringBuffer.toString().toCharArray();
    }

    static char[] compress(char[] cArray) {
        int n;
        if (cArray.length < 3) {
            return cArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = cArray[0];
        char c2 = cArray[1];
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 2; n < cArray.length; ++n) {
            if (!bl && !bl2) {
                if (cArray[n] == c2 && cArray[n] == c) {
                    bl = true;
                    stringBuffer.append('\uffff');
                    stringBuffer.append(c);
                    n2 = 3;
                } else if (cArray[n] == c2 + '\u0001' && cArray[n] == c + 2) {
                    bl2 = true;
                    stringBuffer.append('\ufffe');
                    stringBuffer.append(c);
                } else if (c == '\uffff') {
                    stringBuffer.append('\uffff');
                } else if (c == '\ufffe') {
                    stringBuffer.append('\ufffe');
                } else {
                    stringBuffer.append(c);
                }
                c = c2;
                c2 = cArray[n];
                continue;
            }
            if (bl) {
                if (cArray[n] == c2 && cArray[n] == c) {
                    ++n2;
                    c = c2;
                    c2 = cArray[n];
                    continue;
                }
                bl = false;
                int n3 = n2;
                if (n2 == 8) {
                    n3 = 8;
                } else if (n2 == 9) {
                    n3 = 9;
                } else if (n2 == 10) {
                    n3 = 10;
                } else if (n2 == 12) {
                    n3 = 12;
                } else if (n2 == 13) {
                    n3 = 13;
                } else if (n2 == 34) {
                    n3 = 34;
                } else if (n2 == 39) {
                    n3 = 39;
                } else if (n2 == 92) {
                    n3 = 92;
                }
                stringBuffer.append((char)n3);
                c = cArray[n++];
                c2 = cArray[n];
                continue;
            }
            if (cArray[n] == c2 + '\u0001' && cArray[n] == c + 2) {
                c = c2;
                c2 = cArray[n];
                continue;
            }
            bl2 = false;
            stringBuffer.append(c2);
            c = cArray[n++];
            c2 = cArray[n];
        }
        if (bl) {
            n = (char)n2;
            if (n2 == 8) {
                n = 8;
            } else if (n2 == 9) {
                n = 9;
            } else if (n2 == 10) {
                n = 10;
            } else if (n2 == 12) {
                n = 12;
            } else if (n2 == 13) {
                n = 13;
            } else if (n2 == 34) {
                n = 34;
            } else if (n2 == 39) {
                n = 39;
            } else if (n2 == 92) {
                n = 92;
            }
            stringBuffer.append((char)n);
        }
        if (bl2) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString().toCharArray();
    }

    static void writeHeader(FileWriter fileWriter, int n, String string) throws Exception {
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        Date date = new Date();
        Class<Copyright> clazz = Copyright.class;
        Field field = clazz.getField("version");
        String string2 = (String)field.get(null);
        fileWriter.write("///////////////////////////////////////////////////////////////////////////////\n");
        fileWriter.write("//\n");
        fileWriter.write("// JTOpen (IBM Toolbox for Java - OSS version)\n");
        fileWriter.write("//\n");
        fileWriter.write("// Filename:  ConvTable" + n + ".java\n");
        fileWriter.write("//\n");
        fileWriter.write("// The source code contained herein is licensed under the IBM Public License\n");
        fileWriter.write("// Version 1.0, which has been approved by the Open Source Initiative.\n");
        fileWriter.write("// Copyright (C) 1997-2016 International Business Machines Corporation and\n");
        fileWriter.write("// others.  All rights reserved.\n");
        fileWriter.write("//\n");
        fileWriter.write("// Generated " + date + " from " + string + "\n");
        fileWriter.write("// Using " + string2 + "\n");
        fileWriter.write("///////////////////////////////////////////////////////////////////////////////\n\n");
        fileWriter.write("package com.ibm.as400.access;\n\n");
    }
}

