/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.DBBaseReplyDS;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplySQLCA;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;

class JDTransactionManager {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private static final int COMMIT_SERVER_MODE_CS_ = 1;
    private static final int COMMIT_SERVER_MODE_CHG_ = 2;
    static final int COMMIT_MODE_NOT_SET_ = -1;
    private static final int COMMIT_MODE_NONE_ = 0;
    private static final int COMMIT_MODE_CHG_ = 1;
    private static final int COMMIT_MODE_CS_ = 2;
    private static final int COMMIT_MODE_ALL_ = 3;
    private static final int COMMIT_MODE_RR_ = 4;
    private static final String[] COMMIT_MODE_ = new String[]{"NONE", "CHG", "CS", "ALL", "RR"};
    static final int CURSOR_HOLD_FALSE = 0;
    static final int CURSOR_HOLD_TRUE = 1;
    private boolean activeLocal_ = false;
    private boolean activeGlobal_ = false;
    private boolean autoCommit_;
    private AS400JDBCConnection connection_;
    private int holdIndicator_;
    private int currentCommitMode_;
    private int currentIsolationLevel_;
    private int id_;
    private int initialCommitMode_;
    private boolean localAutoCommit_ = true;
    private boolean localTransaction_ = true;
    private int serverCommitMode_;
    private int currentLocatorPersistence_ = -1;
    private int requestedLocatorPersistence_ = -1;
    private boolean serverAllowsLocatorPersistenceChange_ = true;

    JDTransactionManager(AS400JDBCConnection aS400JDBCConnection, int n, String string, boolean bl) throws SQLException {
        this.autoCommit_ = bl;
        this.connection_ = aS400JDBCConnection;
        this.holdIndicator_ = 1;
        this.id_ = n;
        this.currentIsolationLevel_ = JDTransactionManager.mapStringToLevel(string);
        this.initialCommitMode_ = this.currentCommitMode_ = JDTransactionManager.mapLevelToCommitMode(this.currentIsolationLevel_);
        this.serverCommitMode_ = this.connection_.getNewAutoCommitSupport() == 1 && bl ? 0 : this.currentCommitMode_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws SQLException {
        try {
            DBReplyRequestedDS dBReplyRequestedDS;
            block8: {
                DBSQLRequestDS dBSQLRequestDS = null;
                dBReplyRequestedDS = null;
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6151, this.id_, Integer.MIN_VALUE, 0);
                    dBSQLRequestDS.setHoldIndicator(this.getHoldIndicator());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    if (n != 0) {
                        int n2 = dBReplyRequestedDS.getReturnCode();
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                    }
                    Object var6_6 = null;
                    if (dBSQLRequestDS == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                    throw throwable;
                }
                dBSQLRequestDS.returnToPool();
                dBSQLRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        this.resetServer();
        this.activeLocal_ = false;
    }

    boolean getAutoCommit() {
        return this.autoCommit_;
    }

    int getCommitMode() {
        if (this.serverCommitMode_ == 1) {
            return 2;
        }
        if (this.serverCommitMode_ == 2) {
            return 1;
        }
        return this.serverCommitMode_;
    }

    int getHoldIndicator() {
        return this.holdIndicator_;
    }

    int getIsolation() {
        return this.currentIsolationLevel_;
    }

    boolean isGlobalActive() {
        return this.activeGlobal_;
    }

    boolean isLocalActive() {
        return this.activeLocal_;
    }

    boolean isLocalTransaction() {
        return this.localTransaction_;
    }

    private static int mapLevelToCommitMode(int n) throws SQLException {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                JDError.throwSQLException("HY024");
                n2 = -1;
            }
        }
        return n2;
    }

    static int mapStringToLevel(String string) throws SQLException {
        int n;
        if (string.equalsIgnoreCase("none")) {
            n = 0;
        } else if (string.equalsIgnoreCase("read committed")) {
            n = 2;
        } else if (string.equalsIgnoreCase("read uncommitted")) {
            n = 1;
        } else if (string.equalsIgnoreCase("repeatable read")) {
            n = 4;
        } else if (string.equalsIgnoreCase("serializable")) {
            n = 8;
        } else {
            JDError.throwSQLException("HY024");
            n = -1;
        }
        return n;
    }

    void markGlobalTransactionBoundary() {
        this.activeGlobal_ = false;
    }

    void processCommitOnReturn(DBBaseReplyDS dBBaseReplyDS) throws DBDataStreamException {
        DBReplySQLCA dBReplySQLCA = dBBaseReplyDS.getSQLCA();
        if (dBReplySQLCA.getEyecatcherBit54()) {
            this.activeLocal_ = false;
        }
    }

    private void resetServer() throws SQLException {
        if (this.connection_.getNewAutoCommitSupport() == 0) {
            this.serverCommitMode_ = this.initialCommitMode_;
            this.setCommitMode(this.currentCommitMode_);
        }
    }

    void resetXAServer() throws SQLException {
        this.resetServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws SQLException {
        try {
            DBReplyRequestedDS dBReplyRequestedDS;
            block8: {
                DBSQLRequestDS dBSQLRequestDS = null;
                dBReplyRequestedDS = null;
                try {
                    dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6152, this.id_, Integer.MIN_VALUE, 0);
                    dBSQLRequestDS.setHoldIndicator(this.getHoldIndicator());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    if (n != 0) {
                        int n2 = dBReplyRequestedDS.getReturnCode();
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                    }
                    Object var6_6 = null;
                    if (dBSQLRequestDS == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (dBSQLRequestDS != null) {
                        dBSQLRequestDS.returnToPool();
                        dBSQLRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                    throw throwable;
                }
                dBSQLRequestDS.returnToPool();
                dBSQLRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        catch (DBDataStreamException dBDataStreamException) {
            JDError.throwSQLException("HY000", dBDataStreamException);
        }
        this.resetServer();
        this.activeLocal_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setAutoCommit(boolean bl) throws SQLException {
        DBReplyRequestedDS dBReplyRequestedDS;
        block12: {
            if (!this.localTransaction_) {
                if (bl) {
                    JDError.throwSQLException("25000");
                    return;
                }
                this.localAutoCommit_ = false;
                return;
            }
            if (!this.autoCommit_ && bl && this.activeLocal_) {
                this.commit();
                this.connection_.postWarning(JDError.getSQLWarning("01H30"));
            }
            this.autoCommit_ = bl;
            if (this.connection_.getNewAutoCommitSupport() == 0) {
                this.setCommitMode(this.currentCommitMode_);
                return;
            }
            DBSQLAttributesDS dBSQLAttributesDS = null;
            dBReplyRequestedDS = null;
            try {
                try {
                    dBSQLAttributesDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    dBSQLAttributesDS.setAutoCommit(bl ? 232 : 213);
                    dBSQLAttributesDS.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                    this.serverCommitMode_ = this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1 ? 0 : this.currentCommitMode_;
                    boolean bl2 = this.setRequestLocatorPersistence(dBSQLAttributesDS, this.getIsolationLevel());
                    dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLAttributesDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    int n2 = dBReplyRequestedDS.getReturnCode();
                    if (n != 0 && bl2) {
                        this.serverAllowsLocatorPersistenceChange_ = false;
                        dBSQLAttributesDS.returnToPool();
                        dBSQLAttributesDS = null;
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                        dBSQLAttributesDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        dBSQLAttributesDS.setAutoCommit(bl ? 232 : 213);
                        dBSQLAttributesDS.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        this.serverCommitMode_ = this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1 ? 0 : this.currentCommitMode_;
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLAttributesDS);
                        n = dBReplyRequestedDS.getErrorClass();
                        n2 = dBReplyRequestedDS.getReturnCode();
                    }
                    if (n != 0) {
                        JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                    }
                    this.persistenceUpdated();
                }
                catch (DBDataStreamException dBDataStreamException) {
                    JDError.throwSQLException("HY000", dBDataStreamException);
                    Object var8_9 = null;
                    if (dBSQLAttributesDS != null) {
                        dBSQLAttributesDS.returnToPool();
                        dBSQLAttributesDS = null;
                    }
                    if (dBReplyRequestedDS == null) return;
                    dBReplyRequestedDS.returnToPool();
                    return;
                }
                Object var8_8 = null;
                if (dBSQLAttributesDS == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (dBSQLAttributesDS != null) {
                    dBSQLAttributesDS.returnToPool();
                    dBSQLAttributesDS = null;
                }
                if (dBReplyRequestedDS == null) throw throwable;
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
                throw throwable;
            }
            dBSQLAttributesDS.returnToPool();
            dBSQLAttributesDS = null;
        }
        if (dBReplyRequestedDS == null) return;
        dBReplyRequestedDS.returnToPool();
    }

    private boolean setRequestLocatorPersistence(DBSQLAttributesDS dBSQLAttributesDS, int n) throws DBDataStreamException {
        this.requestedLocatorPersistence_ = -1;
        if (this.serverAllowsLocatorPersistenceChange_) {
            if (n == 0) {
                if (this.currentLocatorPersistence_ != 0) {
                    dBSQLAttributesDS.setLocatorPersistence(0);
                    this.requestedLocatorPersistence_ = 0;
                    return true;
                }
            } else if (this.currentLocatorPersistence_ != 1) {
                dBSQLAttributesDS.setLocatorPersistence(1);
                this.requestedLocatorPersistence_ = 1;
                return true;
            }
        }
        return false;
    }

    private void persistenceUpdated() {
        if (this.serverAllowsLocatorPersistenceChange_ && this.requestedLocatorPersistence_ != -1) {
            this.currentLocatorPersistence_ = this.requestedLocatorPersistence_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCommitMode(int n) throws SQLException {
        if (this.autoCommit_) {
            n = 0;
        }
        if (n != this.serverCommitMode_) {
            JDSQLStatement jDSQLStatement = new JDSQLStatement("SET TRANSACTION ISOLATION LEVEL " + COMMIT_MODE_[n]);
            try {
                DBReplyRequestedDS dBReplyRequestedDS;
                block11: {
                    DBSQLRequestDS dBSQLRequestDS = null;
                    dBReplyRequestedDS = null;
                    try {
                        dBSQLRequestDS = DBDSPool.getDBSQLRequestDS(6150, this.id_, -2113929216, 0);
                        boolean bl = false;
                        if (this.connection_.getVRM() >= JDUtilities.vrm540) {
                            bl = true;
                        }
                        dBSQLRequestDS.setStatementText(jDSQLStatement.toString(), this.connection_.getPackageCCSID_Converter(), bl);
                        dBSQLRequestDS.setStatementType(jDSQLStatement.getNativeType());
                        dBSQLRequestDS.setCursorName("MURCH", this.connection_.getConverter());
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLRequestDS);
                        int n2 = dBReplyRequestedDS.getErrorClass();
                        int n3 = dBReplyRequestedDS.getReturnCode();
                        if (n2 != 0) {
                            JDError.throwSQLException(this, this.connection_, this.id_, n2, n3);
                        }
                        Object var9_9 = null;
                        if (dBSQLRequestDS == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (dBSQLRequestDS != null) {
                            dBSQLRequestDS.returnToPool();
                            dBSQLRequestDS = null;
                        }
                        if (dBReplyRequestedDS != null) {
                            dBReplyRequestedDS.returnToPool();
                            dBReplyRequestedDS = null;
                        }
                        throw throwable;
                    }
                    dBSQLRequestDS.returnToPool();
                    dBSQLRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
            catch (DBDataStreamException dBDataStreamException) {
                JDError.throwSQLException("HY000", dBDataStreamException);
            }
            this.serverCommitMode_ = n;
        }
    }

    void setHoldIndicator(String string) throws SQLException {
        if (string.equalsIgnoreCase("TRUE")) {
            this.holdIndicator_ = 1;
        } else if (string.equalsIgnoreCase("FALSE")) {
            this.holdIndicator_ = 0;
        } else {
            JDError.throwSQLException("HY024");
            this.holdIndicator_ = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setIsolation(int n) throws SQLException {
        int n2;
        block14: {
            DBReplyRequestedDS dBReplyRequestedDS;
            block15: {
                if (this.activeLocal_ && this.connection_.getNewAutoCommitSupport() == 0) {
                    JDError.throwSQLException("25000");
                }
                this.currentCommitMode_ = JDTransactionManager.mapLevelToCommitMode(n);
                this.currentIsolationLevel_ = n;
                if (this.connection_.getNewAutoCommitSupport() == 0) {
                    this.setCommitMode(this.currentCommitMode_);
                    return;
                }
                DBBaseRequestDS dBBaseRequestDS = null;
                dBReplyRequestedDS = null;
                n2 = this.currentCommitMode_;
                try {
                    block13: {
                        try {
                            if (this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1) {
                                n2 = 0;
                            }
                            if (this.serverCommitMode_ == n2) break block13;
                            dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                            ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                            boolean bl = this.setRequestLocatorPersistence((DBSQLAttributesDS)dBBaseRequestDS, this.getIsolationLevel());
                            dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                            int n3 = dBReplyRequestedDS.getErrorClass();
                            int n4 = dBReplyRequestedDS.getReturnCode();
                            if (n3 != 0 && bl) {
                                this.serverAllowsLocatorPersistenceChange_ = false;
                                dBBaseRequestDS.returnToPool();
                                dBBaseRequestDS = null;
                                dBReplyRequestedDS.returnToPool();
                                dBReplyRequestedDS = null;
                                dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                                ((DBSQLAttributesDS)dBBaseRequestDS).setCommitmentControlLevelParserOption(this.getIsolationLevel());
                                dBReplyRequestedDS = this.connection_.sendAndReceive(dBBaseRequestDS);
                                n3 = dBReplyRequestedDS.getErrorClass();
                                n4 = dBReplyRequestedDS.getReturnCode();
                            }
                            if (n3 != 0) {
                                JDError.throwSQLException(this, this.connection_, this.id_, n3, n4);
                            }
                            this.persistenceUpdated();
                        }
                        catch (DBDataStreamException dBDataStreamException) {
                            JDError.throwSQLException("HY000", dBDataStreamException);
                            Object var9_10 = null;
                            if (dBBaseRequestDS != null) {
                                dBBaseRequestDS.returnToPool();
                                dBBaseRequestDS = null;
                            }
                            if (dBReplyRequestedDS != null) {
                                dBReplyRequestedDS.returnToPool();
                                dBReplyRequestedDS = null;
                            }
                            break block14;
                        }
                    }
                    Object var9_9 = null;
                    if (dBBaseRequestDS == null) break block15;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS == null) throw throwable;
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                    throw throwable;
                }
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        this.serverCommitMode_ = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setLocalTransaction(boolean bl) throws SQLException {
        block26: {
            DBReplyRequestedDS dBReplyRequestedDS;
            block27: {
                this.localTransaction_ = bl;
                if (this.localTransaction_) {
                    DBReplyRequestedDS dBReplyRequestedDS2;
                    block25: {
                        this.autoCommit_ = this.localAutoCommit_;
                        if (this.connection_.getNewAutoCommitSupport() == 0) {
                            this.setCommitMode(this.currentCommitMode_);
                            return;
                        }
                        DBSQLAttributesDS dBSQLAttributesDS2 = null;
                        dBReplyRequestedDS2 = null;
                        try {
                            try {
                                dBSQLAttributesDS2 = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                                dBSQLAttributesDS2.setAutoCommit(this.autoCommit_ ? 232 : 213);
                                boolean bl2 = false;
                                if (this.connection_.getNewAutoCommitSupport() == 1 && this.autoCommit_) {
                                    dBSQLAttributesDS2.setCommitmentControlLevelParserOption(0);
                                    bl2 = this.setRequestLocatorPersistence(dBSQLAttributesDS2, 0);
                                    this.serverCommitMode_ = 0;
                                }
                                dBReplyRequestedDS2 = this.connection_.sendAndReceive(dBSQLAttributesDS2);
                                int n = dBReplyRequestedDS2.getErrorClass();
                                int n2 = dBReplyRequestedDS2.getReturnCode();
                                if (n != 0 && bl2) {
                                    this.serverAllowsLocatorPersistenceChange_ = false;
                                    dBSQLAttributesDS2.returnToPool();
                                    dBSQLAttributesDS2 = null;
                                    dBReplyRequestedDS2.returnToPool();
                                    dBReplyRequestedDS2 = null;
                                    dBSQLAttributesDS2 = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                                    dBSQLAttributesDS2.setAutoCommit(this.autoCommit_ ? 232 : 213);
                                    if (this.connection_.getNewAutoCommitSupport() == 1 && this.autoCommit_) {
                                        dBSQLAttributesDS2.setCommitmentControlLevelParserOption(0);
                                        this.serverCommitMode_ = 0;
                                    }
                                    dBReplyRequestedDS2 = this.connection_.sendAndReceive(dBSQLAttributesDS2);
                                    n = dBReplyRequestedDS2.getErrorClass();
                                    n2 = dBReplyRequestedDS2.getReturnCode();
                                }
                                if (n != 0) {
                                    JDError.throwSQLException(this, this.connection_, this.id_, n, n2);
                                }
                                this.persistenceUpdated();
                            }
                            catch (DBDataStreamException dBDataStreamException) {
                                JDError.throwSQLException("HY000", dBDataStreamException);
                                Object var8_15 = null;
                                if (dBSQLAttributesDS2 != null) {
                                    dBSQLAttributesDS2.returnToPool();
                                    dBSQLAttributesDS2 = null;
                                }
                                if (dBReplyRequestedDS2 == null) return;
                                dBReplyRequestedDS2.returnToPool();
                                return;
                            }
                            Object var8_14 = null;
                            if (dBSQLAttributesDS2 == null) break block25;
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            if (dBSQLAttributesDS2 != null) {
                                dBSQLAttributesDS2.returnToPool();
                                dBSQLAttributesDS2 = null;
                            }
                            if (dBReplyRequestedDS2 == null) throw throwable;
                            dBReplyRequestedDS2.returnToPool();
                            dBReplyRequestedDS2 = null;
                            throw throwable;
                        }
                        dBSQLAttributesDS2.returnToPool();
                        dBSQLAttributesDS2 = null;
                    }
                    if (dBReplyRequestedDS2 == null) return;
                    dBReplyRequestedDS2.returnToPool();
                    return;
                }
                this.localAutoCommit_ = this.autoCommit_;
                this.autoCommit_ = false;
                if (this.connection_.getNewAutoCommitSupport() == 0) {
                    this.setCommitMode(this.currentCommitMode_);
                    return;
                }
                DBSQLAttributesDS dBSQLAttributesDS = null;
                dBReplyRequestedDS = null;
                try {
                    try {
                        dBSQLAttributesDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        dBSQLAttributesDS.setAutoCommit(213);
                        if (this.serverCommitMode_ != this.currentCommitMode_) {
                            dBSQLAttributesDS.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                        }
                        boolean bl3 = this.setRequestLocatorPersistence(dBSQLAttributesDS, this.getIsolationLevel());
                        dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLAttributesDS);
                        int n = dBReplyRequestedDS.getErrorClass();
                        int n3 = dBReplyRequestedDS.getReturnCode();
                        if (n != 0 && bl3) {
                            this.serverAllowsLocatorPersistenceChange_ = false;
                            dBSQLAttributesDS.returnToPool();
                            dBSQLAttributesDS = null;
                            dBReplyRequestedDS.returnToPool();
                            dBReplyRequestedDS = null;
                            dBSQLAttributesDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                            dBSQLAttributesDS.setAutoCommit(213);
                            if (this.serverCommitMode_ != this.currentCommitMode_) {
                                dBSQLAttributesDS.setCommitmentControlLevelParserOption(this.getIsolationLevel());
                            }
                            dBReplyRequestedDS = this.connection_.sendAndReceive(dBSQLAttributesDS);
                            n = dBReplyRequestedDS.getErrorClass();
                            n3 = dBReplyRequestedDS.getReturnCode();
                        }
                        if (n != 0) {
                            JDError.throwSQLException(this, this.connection_, this.id_, n, n3);
                        }
                        this.persistenceUpdated();
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        JDError.throwSQLException("HY000", dBDataStreamException);
                        Object var10_19 = null;
                        if (dBSQLAttributesDS != null) {
                            dBSQLAttributesDS.returnToPool();
                            dBSQLAttributesDS = null;
                        }
                        if (dBReplyRequestedDS != null) {
                            dBReplyRequestedDS.returnToPool();
                            dBReplyRequestedDS = null;
                        }
                        break block26;
                    }
                    Object var10_18 = null;
                    if (dBSQLAttributesDS == null) break block27;
                }
                catch (Throwable throwable) {
                    Object var10_20 = null;
                    if (dBSQLAttributesDS != null) {
                        dBSQLAttributesDS.returnToPool();
                        dBSQLAttributesDS = null;
                    }
                    if (dBReplyRequestedDS == null) throw throwable;
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                    throw throwable;
                }
                dBSQLAttributesDS.returnToPool();
                dBSQLAttributesDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        this.serverCommitMode_ = this.currentCommitMode_;
    }

    void statementExecuted() {
        if (this.localTransaction_) {
            this.activeLocal_ = !this.autoCommit_;
        } else {
            this.activeGlobal_ = true;
        }
    }

    private int getIsolationLevel() {
        int n = this.currentCommitMode_;
        if (n == 1) {
            n = 2;
        } else if (n == 2) {
            n = 1;
        }
        if (this.autoCommit_ && this.connection_.getNewAutoCommitSupport() == 1) {
            n = 0;
        }
        return n;
    }
}

