/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ProgramParameter
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int PASS_BY_VALUE = 1;
    public static final int PASS_BY_REFERENCE = 2;
    static final int NULL = 255;
    static final int INPUT = 1;
    static final int OUTPUT = 2;
    static final int INOUT = 3;
    private int parameterType_ = 1;
    private boolean nullParameter_ = true;
    private byte[] inputData_ = null;
    private int outputDataLength_ = 0;
    private byte[] outputData_ = null;
    transient int length_ = 0;
    transient int maxLength_ = 0;
    transient int usage_ = 0;
    transient byte[] compressedInputData_ = null;
    private transient PropertyChangeSupport propertyChangeListeners_;
    private transient VetoableChangeSupport vetoableChangeListeners_;

    public ProgramParameter() {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Constructing ProgramParameter object.");
        }
    }

    public ProgramParameter(byte[] byArray) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, input data:", byArray);
        }
        this.nullParameter_ = false;
        this.inputData_ = byArray;
    }

    public ProgramParameter(int n) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, output data length:", n);
        }
        if (n < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + n + ")", 2);
        }
        this.nullParameter_ = false;
        this.outputDataLength_ = n;
    }

    public ProgramParameter(byte[] byArray, int n) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, output data length: " + n + " input data:", byArray);
        }
        if (n < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + n + ")", 2);
        }
        this.nullParameter_ = false;
        this.inputData_ = byArray;
        this.outputDataLength_ = n;
    }

    public ProgramParameter(int n, byte[] byArray) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, service program parameter type: " + n + " input data:", byArray);
        }
        if (n < 1 || n > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", n);
            throw new ExtendedIllegalArgumentException("parameterType (" + n + ")", 2);
        }
        this.parameterType_ = n;
        this.nullParameter_ = false;
        this.inputData_ = byArray;
    }

    public ProgramParameter(int n, int n2) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, service program parameter type: " + n + " output data length:", n2);
        }
        if (n < 1 || n > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", n);
            throw new ExtendedIllegalArgumentException("parameterType (" + n + ")", 2);
        }
        if (n2 < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + n2 + ")", 2);
        }
        this.parameterType_ = n;
        this.nullParameter_ = false;
        this.outputDataLength_ = n2;
    }

    public ProgramParameter(int n, byte[] byArray, int n2) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Constructing ProgramParameter object, service program parameter type: " + n + " output data length: " + n2 + " input data:", byArray);
        }
        if (n < 1 || n > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", n);
            throw new ExtendedIllegalArgumentException("parameterType (" + n + ")", 2);
        }
        if (n2 < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", n2);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + n2 + ")", 2);
        }
        this.parameterType_ = n;
        this.nullParameter_ = false;
        this.inputData_ = byArray;
        this.outputDataLength_ = n2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ == null) {
            this.propertyChangeListeners_ = new PropertyChangeSupport(this);
        }
        this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ == null) {
            this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
        }
        this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
    }

    int getMaxLength() {
        int n;
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Getting max length.");
        }
        int n2 = n = this.inputData_ == null ? this.outputDataLength_ : Math.max(this.inputData_.length, this.outputDataLength_);
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Max length:", n);
        }
        return n;
    }

    public byte[] getInputData() {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Getting input data:", this.inputData_);
        }
        return this.inputData_;
    }

    public byte[] getOutputData() {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Getting output data.");
        }
        return this.outputData_;
    }

    public int getOutputDataLength() {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Getting output data length:", this.outputDataLength_);
        }
        return this.outputDataLength_;
    }

    public int getParameterType() {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Getting parameter type:", this.parameterType_);
        }
        return this.parameterType_;
    }

    int getUsage() {
        int n;
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Getting parameter usage.");
        }
        int n2 = this.nullParameter_ ? 255 : (this.outputDataLength_ == 0 ? 1 : (n = this.inputData_ == null ? 2 : 3));
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Parameter usage:", n);
        }
        return n;
    }

    public boolean isNullParameter() {
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Checking if null parameter:", this.nullParameter_);
        }
        return this.nullParameter_;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "De-serializing ProgramParameter object.");
        }
        objectInputStream.defaultReadObject();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.isTraceOn()) {
            Trace.log(1, this, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, this, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setInputData(byte[] byArray) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting input data:", byArray);
        }
        byte[] byArray2 = this.inputData_;
        byte[] byArray3 = byArray;
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("inputData", byArray2, byArray3);
        }
        this.nullParameter_ = false;
        this.inputData_ = byArray;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("inputData", byArray2, byArray3);
        }
    }

    public void setNullParameter(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, (Object)this, "Setting null parameter:", bl);
        }
        this.nullParameter_ = bl;
        this.inputData_ = null;
        this.outputDataLength_ = 0;
    }

    void setOutputData(byte[] byArray) {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting output data:", byArray);
        }
        this.outputData_ = byArray;
    }

    public void setOutputDataLength(int n) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting output data length:", n);
        }
        if (n < 0) {
            Trace.log(2, (Object)this, "Value of parameter 'outputDataLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("outputDataLength (" + n + ")", 2);
        }
        Integer n2 = null;
        Integer n3 = null;
        if (this.vetoableChangeListeners_ != null || this.propertyChangeListeners_ != null) {
            n2 = new Integer(this.outputDataLength_);
            n3 = new Integer(n);
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("outputDataLength", n2, n3);
        }
        this.nullParameter_ = false;
        this.outputDataLength_ = n;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("outputDataLength", n2, n3);
        }
    }

    public void setParameterType(int n) throws PropertyVetoException {
        if (Trace.isTraceOn()) {
            Trace.log(1, (Object)this, "Setting parameter type:", n);
        }
        if (n < 1 || n > 2) {
            Trace.log(2, (Object)this, "Value of parameter 'parameterType' is not valid:", n);
            throw new ExtendedIllegalArgumentException("parameterType (" + n + ")", 2);
        }
        Integer n2 = null;
        Integer n3 = null;
        if (this.vetoableChangeListeners_ != null || this.propertyChangeListeners_ != null) {
            n2 = new Integer(this.parameterType_);
            n3 = new Integer(n);
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.fireVetoableChange("parameterType", n2, n3);
        }
        this.parameterType_ = n;
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.firePropertyChange("parameterType", n2, n3);
        }
    }
}

