/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable1208;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLClob
extends SQLDataBase {
    static final String copyright0 = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private int length_ = 0;
    private int maxLength_;
    private String value_;
    private Object savedObject_;

    SQLClob(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.maxLength_ = n;
        this.value_ = "";
    }

    public Object clone() {
        return new SQLClob(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToInt(byArray, n);
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.value_ = convTable.byteArrayToString(byArray, n + 4, this.length_, bidiConversionProperties);
        this.savedObject_ = null;
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
        int n2;
        if ((convTable instanceof ConvTableMixedMap || convTable instanceof ConvTable1208) && (n2 = convTable.validateData(byArray, n + 4, this.maxLength_)) < this.maxLength_) {
            BinaryConverter.intToByteArray(n2, byArray, n);
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        if (this.savedObject_ != null) {
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            this.doConversion();
        }
        try {
            int n2 = this.settings_.getBidiStringType();
            if (n2 == -1) {
                n2 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            byte[] byArray2 = convTable.stringToByteArray(this.value_, bidiConversionProperties);
            if (byArray2.length > this.maxLength_) {
                this.truncated_ = byArray2.length - this.maxLength_;
                System.arraycopy(byArray2, 0, byArray, n + 4, this.maxLength_);
                BinaryConverter.intToByteArray(this.maxLength_, byArray, n);
            } else {
                System.arraycopy(byArray2, 0, byArray, n + 4, byArray2.length);
                BinaryConverter.intToByteArray(byArray2.length, byArray, n);
            }
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Clob || object instanceof Reader || object instanceof InputStream || object instanceof SQLXML)) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.length_ = n != -1 ? n : -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        try {
            Object object;
            Object object2 = this.savedObject_;
            if (this.savedObject_ instanceof String) {
                this.value_ = (String)object2;
            } else if (object2 instanceof Reader) {
                this.value_ = SQLClob.getStringFromReader((Reader)object2, this.length_, this);
            } else if (object2 instanceof Clob) {
                object = (Clob)object2;
                this.value_ = object.getSubString(1L, (int)object.length());
            } else if (object2 instanceof SQLXML) {
                object = (SQLXML)object2;
                this.value_ = object.getString();
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
            int n = this.value_.length();
            if (n > this.maxLength_) {
                this.value_ = this.value_.substring(0, this.maxLength_);
                this.truncated_ = n - this.maxLength_;
                this.outOfBounds_ = false;
            } else {
                this.truncated_ = 0;
                this.outOfBounds_ = false;
            }
            this.length_ = this.value_.length();
            Object var4_4 = null;
            this.savedObject_ = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.savedObject_ = null;
            throw throwable;
        }
    }

    public int getSQLType() {
        return 7;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCClob";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "CLOB";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 408;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "CLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.value_));
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.value_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(this.value_);
    }

    public Clob getClob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClob(this.value_, this.maxLength_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCClob(this.value_, this.maxLength_);
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(this.value_);
    }

    public NClob getNClob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCNClob(this.value_, this.maxLength_);
    }

    public String getNString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.value_;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.value_);
    }

    public void saveValue() throws SQLException {
        if (this.savedObject_ != null && (this.value_ == null || this.value_.length() == 0)) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }
}

