/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCNClob;
import com.ibm.as400.access.AS400JDBCNClobLocator;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLNClobLocator
implements SQLLocator {
    private AS400JDBCConnection connection_;
    private SQLConversionSettings settings_;
    private ConvTable converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private String value_;
    private String savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;

    SQLNClobLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3) {
        this.connection_ = aS400JDBCConnection;
        this.id_ = n;
        this.locator_ = new JDLobLocator(aS400JDBCConnection, n, n2, true);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
    }

    public Object clone() {
        return new SQLNClobLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            this.truncated_ = n2 > this.maxLength_ ? n2 - this.maxLength_ : 0;
            this.outOfBounds_ = false;
        } else if (!(object instanceof Reader || object instanceof InputStream || object instanceof Clob || object instanceof NClob || object instanceof SQLXML)) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObject_ = object;
        this.savedObjectWrittenToServer_ = false;
        if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        Object object;
        int n = this.scale_;
        if (n == -1) {
            try {
                n = (int)this.locator_.getLength();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object2 = this.savedObject_;
        if (this.savedObject_ instanceof String) {
            this.value_ = (String)object2;
        } else if (object2 instanceof Reader) {
            this.value_ = SQLDataBase.getStringFromReader((Reader)object2, n, this);
            this.savedObject_ = this.value_;
        } else if (object2 instanceof Clob) {
            if (object2 instanceof AS400JDBCClobLocator) {
                Object object3 = object = (AS400JDBCClobLocator)object2;
                synchronized (object3) {
                    if (((AS400JDBCClobLocator)object).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)object).savedObject_;
                        this.savedObjectWrittenToServer_ = false;
                        this.scale_ = ((AS400JDBCClobLocator)object).savedScale_;
                        ((AS400JDBCClobLocator)object).savedObject_ = null;
                        if (!(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                            this.doConversion();
                            return;
                        }
                    }
                }
            }
            object = (Clob)object2;
            this.value_ = object.getSubString(1L, (int)object.length());
        } else if (object2 instanceof SQLXML) {
            object = (SQLXML)object2;
            this.value_ = object.getString();
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n2 = this.value_.length();
        if (n2 > this.maxLength_) {
            this.value_ = this.value_.substring(0, this.maxLength_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeToServer() throws SQLException {
        block52: {
            try {
                var1_1 = this.savedObject_;
                if (var1_1 instanceof String) {
                    var2_2 = (String)var1_1;
                    var3_7 = this.converter_.stringToByteArray(var2_2);
                    this.locator_.writeData(0L, var3_7, true);
                    break block52;
                }
                if (var1_1 instanceof Reader) {
                    var2_3 = this.scale_ * 2;
                    if (var2_3 == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block52;
                    }
                    if (var2_3 > 0) {
                        try {
                            var3_8 = var2_3 < 1000000 ? var2_3 : 1000000;
                            var4_16 = this.settings_.getBidiStringType();
                            if (var4_16 == -1) {
                                var4_16 = this.converter_.bidiStringType_;
                            }
                            var5_23 = new BidiConversionProperties(var4_16);
                            var5_23.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            var5_23.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            var6_28 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_23, var3_8);
                            try {
                                var7_35 = new byte[var3_8];
                                var8_40 = 0;
                                var9_44 = var6_28.read(var7_35, 0, var3_8);
                                while (var9_44 > -1 && var8_40 < var2_3) {
                                    this.locator_.writeData(var8_40 / 2, var7_35, 0, var9_44, true);
                                    var10_46 = var2_3 - (var8_40 += var9_44);
                                    if (var10_46 < var3_8) {
                                        var3_8 = var10_46;
                                        if (var6_28.available() == 0 && var3_8 != 0) {
                                            var6_28.close();
                                            var6_28 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_23, var3_8);
                                        }
                                    }
                                    var9_44 = var6_28.read(var7_35, 0, var3_8);
                                }
                                if (var8_40 < var2_3) {
                                    JDError.throwSQLException((Object)this, "07006");
                                }
                                var12_47 = null;
                            }
                            catch (Throwable var11_51) {
                                var12_48 = null;
                                try {
                                    var6_28.close();
                                }
                                catch (Exception var13_50) {
                                    JDTrace.logException(this, "writeToServer stream.close()", var13_50);
                                }
                                throw var11_51;
                            }
                            try {
                                var6_28.close();
                            }
                            catch (Exception var13_49) {
                                JDTrace.logException(this, "writeToServer stream.close()", var13_49);
                            }
                            break block52;
                        }
                        catch (IOException var3_9) {
                            JDError.throwSQLException((Object)this, "HY000", var3_9);
                        }
                        break block52;
                    }
                    if (var2_3 == -2) {
                        try {
                            var3_10 = 1000000;
                            var4_17 = this.settings_.getBidiStringType();
                            if (var4_17 == -1) {
                                var4_17 = this.converter_.bidiStringType_;
                            }
                            var5_24 = new BidiConversionProperties(var4_17);
                            var5_24.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
                            var5_24.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
                            var6_29 = new ReaderInputStream((Reader)this.savedObject_, this.converter_.getCcsid(), var5_24, var3_10);
                            try {
                                var7_36 = new byte[var3_10];
                                var8_41 = 0;
                                var9_45 = var6_29.read(var7_36, 0, var3_10);
                                while (var9_45 > -1) {
                                    this.locator_.writeData(var8_41 / 2, var7_36, 0, var9_45, true);
                                    var8_41 += var9_45;
                                    var9_45 = var6_29.read(var7_36, 0, var3_10);
                                }
                                var15_52 = null;
                            }
                            catch (Throwable var14_56) {
                                var15_53 = null;
                                try {
                                    var6_29.close();
                                }
                                catch (Exception var16_55) {
                                    JDTrace.logException(this, "writeToServer stream2.close()", var16_55);
                                }
                                throw var14_56;
                            }
                            try {
                                var6_29.close();
                            }
                            catch (Exception var16_54) {
                                JDTrace.logException(this, "writeToServer stream2.close()", var16_54);
                            }
                            break block52;
                        }
                        catch (IOException var3_11) {
                            JDError.throwSQLException((Object)this, "HY000", var3_11);
                        }
                        break block52;
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block52;
                }
                if (var1_1 instanceof InputStream) {
                    var2_4 = this.scale_ * 2;
                    if (var2_4 == 0) {
                        this.locator_.writeData(0L, new byte[0], 0, 0, true);
                        break block52;
                    }
                    if (var2_4 > 0) {
                        var3_12 = (InputStream)this.savedObject_;
                        var4_18 = var2_4 < 1000000 ? var2_4 : 1000000;
                        var5_25 = new byte[var4_18];
                        try {
                            var6_30 = 0;
                            var7_37 = var3_12.read(var5_25, 0, var4_18);
                            while (var7_37 > -1 && var6_30 < var2_4) {
                                this.locator_.writeData((long)var6_30 / 2L, var5_25, 0, var7_37, true);
                                var8_42 = var2_4 - (var6_30 += var7_37);
                                if (var8_42 < var4_18) {
                                    var4_18 = var8_42;
                                }
                                var7_37 = var3_12.read(var5_25, 0, var4_18);
                            }
                            if (var6_30 < var2_4) {
                                JDError.throwSQLException((Object)this, "07006");
                            }
                            break block52;
                        }
                        catch (IOException var6_31) {
                            JDError.throwSQLException((Object)this, "HY000", var6_31);
                        }
                        break block52;
                    }
                    if (var2_4 == -2) {
                        var3_13 = (InputStream)this.savedObject_;
                        var4_19 = 1000000;
                        var5_26 = new byte[var4_19];
                        try {
                            var6_32 = 0;
                            var7_38 = var3_13.read(var5_26, 0, var4_19);
                            while (var7_38 > -1) {
                                this.locator_.writeData((long)var6_32 / 2L, var5_26, 0, var7_38, true);
                                var6_32 += var7_38;
                                var7_38 = var3_13.read(var5_26, 0, var4_19);
                            }
                            break block52;
                        }
                        catch (IOException var6_33) {
                            JDError.throwSQLException((Object)this, "HY000", var6_33);
                            break block52;
                        }
                    }
                    JDError.throwSQLException((Object)this, "07006");
                    break block52;
                }
                if (var1_1 instanceof Clob) {
                    var2_5 = false;
                    if (var1_1 instanceof AS400JDBCClobLocator) {
                        var3_14 = (AS400JDBCClobLocator)var1_1;
                        var4_20 = var3_14;
                        synchronized (var4_20) {
                            if (var3_14.savedObject_ == null) ** break block53
                            this.savedObject_ = var3_14.savedObject_;
                            this.savedObjectWrittenToServer_ = false;
                            this.scale_ = var3_14.savedScale_;
                            var3_14.savedObject_ = null;
                            this.writeToServer();
                            this.savedObjectWrittenToServer_ = false;
                        }
                        var19_57 = null;
                        this.savedObjectWrittenToServer_ = true;
                        return;
                        {
                        }
                    }
                    if (!var2_5) {
                        var3_14 = (Clob)var1_1;
                        var4_21 = (int)var3_14.length();
                        if (var4_21 < (var5_27 = 1000000)) {
                            var5_27 = var4_21;
                        }
                        var6_34 = 1;
                        var7_39 = new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
                        while (var6_34 <= var4_21) {
                            var8_43 = var3_14.getSubString(var6_34, var5_27);
                            var7_39.setString(var6_34, var8_43);
                            if (var4_21 - (var6_34 += var5_27) >= var5_27) continue;
                            var5_27 = var4_21 - var6_34 + 1;
                        }
                        var2_5 = true;
                    } else {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    break block52;
                }
                if (var1_1 instanceof SQLXML) {
                    var2_6 = (SQLXML)var1_1;
                    var3_15 = var2_6.getString();
                    var4_22 = this.converter_.stringToByteArray(var3_15);
                    this.locator_.writeData(0L, var4_22, 0, var4_22.length, true);
                } else {
                    JDError.throwSQLException((Object)this, "07006");
                }
            }
            catch (Throwable var18_61) {
                var19_59 = null;
                this.savedObjectWrittenToServer_ = true;
                throw var18_61;
            }
        }
        var19_58 = null;
        this.savedObjectWrittenToServer_ = true;
        this.scale_ = (int)this.locator_.getLength();
    }

    public int getSQLType() {
        return 34;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_ / 2;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCNClobLocator";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "NCLOB";
    }

    public int getMaximumPrecision() {
        return 0x3FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 968;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2011;
    }

    public String getTypeName() {
        return "NCLOB";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.value_));
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new HexReaderInputStream(new StringReader(this.value_));
            }
            return new HexReaderInputStream(new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.value_), this.maxLength_);
            }
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.value_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return 0;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.value_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid()), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.value_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public NClob getNClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCNClob(this.value_, this.maxLength_);
        }
        return new AS400JDBCNClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_);
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.value_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        return string;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCSQLXML(this.value_, this.maxLength_);
        }
        return new AS400JDBCSQLXML(this.getString());
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    public void saveValue() throws SQLException {
        if (this.value_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.value_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

