/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLVarbinary
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private int length_ = 0;
    private int maxLength_;
    private byte[] value_;

    SQLVarbinary(int n, SQLConversionSettings sQLConversionSettings) {
        super(sQLConversionSettings);
        this.maxLength_ = n;
        this.value_ = default_;
    }

    public Object clone() {
        return new SQLVarbinary(this.maxLength_, this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        AS400ByteArray aS400ByteArray = new AS400ByteArray(this.length_);
        this.value_ = (byte[])aS400ByteArray.toObject(byArray, n + 2);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        AS400ByteArray aS400ByteArray = new AS400ByteArray(this.length_);
        BinaryConverter.unsignedShortToByteArray(this.length_, byArray, n);
        aS400ByteArray.toBytes(this.value_, byArray, n + 2);
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            this.value_ = SQLVarbinary.getBytesFromInputStream((InputStream)object, n, this);
        } else if (object instanceof Reader) {
            this.value_ = SQLVarbinary.getBytesFromReader((Reader)object, n, this);
        } else if (object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        int n2 = this.value_.length;
        if (n2 > this.maxLength_) {
            byte[] byArray = new byte[this.maxLength_];
            System.arraycopy(this.value_, 0, byArray, 0, this.maxLength_);
            this.value_ = byArray;
            this.truncated_ = n2 - this.maxLength_;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length;
    }

    public int getSQLType() {
        return 29;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "[B";
    }

    public String getLiteralPrefix() {
        return "VARBINARY(X'";
    }

    public String getLiteralSuffix() {
        return "')";
    }

    public String getLocalName() {
        return "VARBINARY";
    }

    public int getMaximumPrecision() {
        return 32739;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 908;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -3;
    }

    public String getTypeName() {
        return "VARBINARY";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new ByteArrayInputStream(this.getBytes());
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        byte[] byArray = this.getBytes();
        return new AS400JDBCBlob(byArray, byArray.length);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length > n && n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value_, 0, byArray, 0, n);
            return byArray;
        }
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new StringReader(BinaryConverter.bytesToHexString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        String string = BinaryConverter.bytesToHexString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getBytes();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return BinaryConverter.bytesToHexString(this.getBytes());
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

