/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable1208;
import com.ibm.as400.access.ConvTableMixedMap;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import com.ibm.as400.access.SQLVariableCompressible;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

abstract class SQLVarcharBase
extends SQLDataBase
implements SQLVariableCompressible {
    static final String copyright = "Copyright (C) 1997-2013 International Business Machines Corporation and others.";
    protected int length_;
    protected int maxLength_;
    protected String value_;
    protected String untruncatedValue_;
    protected int bytesPerCharacter_;
    protected int sizeAfterTruncation_ = 0;

    SQLVarcharBase(SQLConversionSettings sQLConversionSettings, int n, int n2, String string) {
        super(sQLConversionSettings);
        this.length_ = n;
        this.maxLength_ = n2;
        this.value_ = string;
        this.untruncatedValue_ = string;
        this.bytesPerCharacter_ = 1;
    }

    SQLVarcharBase(SQLConversionSettings sQLConversionSettings, int n, int n2, String string, int n3) {
        super(sQLConversionSettings);
        this.length_ = n;
        this.maxLength_ = n2;
        this.value_ = string;
        this.untruncatedValue_ = string;
        this.bytesPerCharacter_ = n3;
    }

    public void trim() {
        this.value_ = this.value_.trim();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        int n2 = this.settings_.getBidiStringType();
        if (n2 == -1) {
            n2 = convTable.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            this.sizeAfterTruncation_ = this.length_ * this.bytesPerCharacter_;
            this.untruncatedValue_ = this.value_ = convTable.byteArrayToString(byArray, n + 2, this.length_ * this.bytesPerCharacter_, bidiConversionProperties);
        }
        catch (Exception exception) {
            JDError.throwSQLException("22524", exception);
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        try {
            int n2 = this.settings_.getBidiStringType();
            if (n2 == -1) {
                n2 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n2);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            String string = this.value_;
            if (convTable.getCcsid() == 1208) {
                string = this.untruncatedValue_;
            }
            byte[] byArray2 = convTable.stringToByteArray(string, bidiConversionProperties);
            BinaryConverter.unsignedShortToByteArray(byArray2.length / this.bytesPerCharacter_, byArray, n);
            this.sizeAfterTruncation_ = byArray2.length;
            if (byArray2.length > this.maxLength_) {
                BinaryConverter.unsignedShortToByteArray(this.maxLength_ / this.bytesPerCharacter_, byArray, n);
                this.sizeAfterTruncation_ = this.maxLength_;
                this.truncated_ = byArray2.length - this.maxLength_;
                System.arraycopy(byArray2, 0, byArray, n + 2, this.maxLength_);
            } else {
                System.arraycopy(byArray2, 0, byArray, n + 2, byArray2.length);
            }
            if (this.maxLength_ - byArray2.length > 16) {
                int n3 = n + 2 + this.maxLength_;
                for (int i = n + 2 + byArray2.length; i < n3; ++i) {
                    byArray[i] = 0;
                }
            }
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
        int n2;
        if ((convTable instanceof ConvTableMixedMap || convTable instanceof ConvTable1208) && (n2 = convTable.validateData(byArray, n + 2, this.maxLength_)) < this.maxLength_) {
            BinaryConverter.unsignedShortToByteArray(n2, byArray, n);
            this.sizeAfterTruncation_ = n2;
        }
    }

    public int convertToCompressedBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        int n2 = 0;
        try {
            int n3 = this.settings_.getBidiStringType();
            if (n3 == -1) {
                n3 = convTable.bidiStringType_;
            }
            BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(n3);
            bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
            bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
            String string = this.value_;
            if (convTable.getCcsid() == 1208) {
                string = this.untruncatedValue_;
            }
            byte[] byArray2 = convTable.stringToByteArray(string, bidiConversionProperties);
            BinaryConverter.unsignedShortToByteArray(byArray2.length / this.bytesPerCharacter_, byArray, n);
            n2 += 2;
            if (byArray2.length > this.maxLength_) {
                this.truncated_ = byArray2.length - this.maxLength_;
                System.arraycopy(byArray2, 0, byArray, n + 2, this.maxLength_);
                n2 += this.maxLength_;
            } else if (byArray2.length > 0) {
                System.arraycopy(byArray2, 0, byArray, n + 2, byArray2.length);
                n2 += byArray2.length;
            }
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
        return n2;
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        int n2;
        Object object2;
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Number) {
            string = object.toString();
        } else if (object instanceof Boolean) {
            string = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            string = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            string = SQLTimestamp.timestampToStringTrimTrailingZeros((Timestamp)object, calendar, this.settings_);
        } else if (object instanceof Date) {
            string = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            string = object.toString();
        } else if (object instanceof Clob) {
            object2 = (Clob)object;
            string = object2.getSubString(1L, (int)object2.length());
        } else if (object instanceof Reader) {
            string = SQLVarcharBase.getStringFromReader((Reader)object, -2, this);
        } else if (object instanceof SQLXML) {
            object2 = (SQLXML)object;
            string = object2.getString();
        }
        if (string == null) {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.untruncatedValue_ = this.value_ = string;
        int n3 = this.value_.length();
        if (n3 > (n2 = this.maxLength_ / this.bytesPerCharacter_)) {
            this.value_ = this.value_.substring(0, n2);
            this.truncated_ = n3 - n2;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
        this.length_ = this.value_.length();
    }

    public int getSQLType() {
        return 30;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "java.lang.String";
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public String getLocalName() {
        return "VARCHAR";
    }

    public int getMaximumPrecision() {
        return 32739;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 448;
    }

    public int getPrecision() {
        return this.maxLength_ / this.bytesPerCharacter_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 12;
    }

    public String getTypeName() {
        return "VARCHAR";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        if (this.sizeAfterTruncation_ != 0) {
            return this.sizeAfterTruncation_;
        }
        return this.value_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            byte[] byArray = BinaryConverter.stringToBytes(this.getString());
            return new AS400JDBCBlob(byArray, byArray.length);
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException numberFormatException) {
            JDError.throwSQLException((Object)this, "07006", numberFormatException);
            return null;
        }
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getString();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }

    public String getNString() throws SQLException {
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length() > n && n > 0) {
            return this.value_.substring(0, n);
        }
        return this.value_;
    }

    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.getString());
    }

    public void saveValue() {
        this.savedValue_ = this.untruncatedValue_;
    }
}

