/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.jdbcClient;

import com.ibm.as400.access.AS400JDBCSQLSyntaxErrorException;
import com.ibm.as400.access.JVMInfo;
import com.ibm.as400.access.jdbcClient.ClientBlob;
import com.ibm.as400.access.jdbcClient.ClientClob;
import com.ibm.as400.access.jdbcClient.ReflectionUtil;
import com.ibm.as400.access.jdbcClient.StringFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.transaction.xa.XAException;

public class Main
implements Runnable {
    public static String[] knownDrivers = new String[]{"com.ibm.as400.access.AS400JDBCDriver", "com.ibm.db2.jdbc.app.DB2Driver", "com.ibm.jtopenlite.database.jdbc.JDBCDriver"};
    public static String promptString = ">";
    private static PrintStream defaultOutput = System.out;
    public static String usage = "Usage:  java -cp jt400.jar  com.ibm.as400.access.jdbcClient.Main <jdbcUrl> <userid> <password>\n        java -jar jt400.jar <jdbcUrl> <userid> <password>";
    public static String[] commandHelp = new String[]{"com.ibm.as400.access.jdbcClient.Main executes SQL commands using a JDBC connection.  ", "  This program is provided AS IS and formal support will NOT be provided.", "  This program should not be used in a production environment.", "", "Parameters are passed to a CALL procedure by using the following ", "CALL ... -- INPARM [p1]....    Calls the stored procedure with the specified parameters", "", "Using CL:  [as400 command] will use QSYS.QCMDEXEC to execute the as400 command ", "", "Besides SQL COMMANDS, the following COMMANDS and SUBCOMMANDS are available", "", "!USAGE                          Displays this information", "!HELP                           Displays this information", "!PREPARE [sql statement]        prepares an sql statement", "!EXECUTEQUERY                   Invokes executeQuery on the prepared statement", "!EXECUTEUPDATE                  Invokes executeUpdate on the prepared statement", "!SETPARM [index],[value]        Sets the parameter for the sql statement", "!SETPARMFROMVAR [index],[var]   Sets the parameter using a variable", "!SETRESULTSETTYPE [..]          Sets the results set type for prepare", "!SETRESULTSETCONCURRENCY [..]   ..", "!SETRESULTSETHOLDABILITY [..]   ..", "!REUSE STATEMENT [true|false]   Controls whethe the stmt object is reused", "!PROMPT [string]                Set the string to use for the prompt", "!ECHO [string]                  Echos the string", "!ECHOCOMMAND [true|false]       Should the input command be echod.", "!ECHOCOMMENTS [true|false]      Should the comments be echod.", "!PRINTSTACKTRACE [true|false]   Should the stack trace be printed for SQLExceptions.", "-- [string]                     Specifies a comment", "!SETQUERYTIMEOUT [number]       Sets the query timeout for subsequent statements", "!RESET CONNECTION PROPERTIES    Resets connection properties", "!ADD CONNECTION PROPERTY        Set properties to be used on subsequent connects", "!REUSE CONNECTION [true|false]  Should the connection be reused by connect to ", "!CONNECT TO URL [URL] [USERID=..] [PASSWORD=...]  Connect using the URL", "!CONNECT TO SCHEMA [schema]            Reconnect using the current URL to the specified schema", "!CONNECT RESET                  Closes the current connection", "!EXISTFILE                      Indicates if the specified file exists (on the client)", "!GC                             Force the Java garbage collector to run", "!OUTPUT FORMAT [xml | html]     Set the output format to include XML or HTML", "!SHOWMIXEDUX [true | false]     Set if mixed UX strings will be displayed", "!SET AUTOCOMMIT [true|false]    Sets the autocommit value", "!SET TRANSACTIONISOLATION [VALUE] Sets the autocommit value", "                                 Supported values are ", "                               TRANSACTION_READ_UNCOMMITTED", "                               TRANSACTION_READ_COMMITTED", "                               TRANSACTION_REPEATABLE_READ", "                               TRANSACTION_SERIALIZABLE", "!GETSERVERJOBNAME               Returns connection.getServerJobName", "!CLOSESTATEMENTRS [on|off]      Close statement and result set after execution of query default off", "!MEASUREEXECUTE [on|off]        Measure time to do execute", "!CHARACTERDETAILS [on|off]      Turn on to see entire character details -- default of off", "!MANUALFETCH [on|off]           Set if manual fetch operations should be used", "!RS.NEXT,!RS.FIRST, !RS.LAST, !RS.PREVIOUS, !RS.ABSOLUTE pos, !RS.RELATIVE pos, !RS.BEFOREFIRST, !RS.AFTERLAST", "                               Call rs.next,... for manually fetching", "!DMD.GETCOLUMNS catalog, schemaPattern, tableNamePattern, columnNamePattern ", "!DMD.GETTABLES catalog, schemaPattern, tableNamePattern, type1 | type2", "!DMD.GETINDEXINFO catalog, schema, table, booleanUnique, booleanApproximate ", "!DMD.GETSCHEMAS", "!HISTORY.CLEAR                    Clears the stored history", "!HISTORY.SHOW                     Shows the history of commands", "!SETCLITRACE [true|false]         Sets CLI tracing for native JDBC driver -- valid V5R5 and later", "!SETDB2TRACE [0|1|2|3|4]          Sets jdbc tracing for native JDBC driver  -- valid V5R5 and later", "!SYSTEMDEBUGGER                   Starts the system debugger (requires tes.jar on classpath)", "", "Parameters for prepared statements and callable statements may be specified in the following formats", "UX'....'                       Unicode string (in hexadecimal)", "X'....'                        Byte array (in hexademical)", "FILEBLOB=<filename>            A Blob retrieved from the named file", "FILECLOB=<filename>            A clob retrieved from the named file", "SAVEDPARM=<number>             A parameter from a previous CALL statement", "GEN_BYTE_ARRAY+<count>         A generated byte array of count bytes", "GEN_HEX_STRING+<count>         A generated hex string", "GEN_CHAR_ARRAY+<count>C<ccsid> A generated character string", "SQLARRAY[TYPE:e1:e2:...]       A JAVA.SQL.ARRAY type", "                               Types are String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:long:float:double:byteArray", "SQLARRAY[Time:e1 e2 ...]       A JAVA.SQL.ARRAY with time blank sep", "SQLARRAY[Timestamp:e1|e2 ...]  A JAVA.SQL.ARRAY with timestamp | sep", "", "The following prefixes are available", "!INVISIBLE:     The command and its results are not echoed", "!SILENT:        The exceptions and warnings from the command are not echoed", "!SILENTRS:      The result sets from the command are not echoed", "", "", "The following 'reflection' based commands are available", "!SETVAR [VARNAME] = [METHODCALL]  Sets a variable use a method.. i.e. ", "                                 SETVAR BLOB = RS.getBlob(1)", "!SETVAR [VARNAME] [PARAMETER SPECIFICATION] Sets a variable using a parameter specification", "!SETNEWVAR [VARNAME] = [CONSTRUCTORCALL]  Sets a variable by calling the contructor", "                                 SETNEWVAR DS = com.ibm.db2.jdbc.app.UDBDataSource()", "!SHOWVARMETHODS [VARNAME]         Shows the methods for a variable", "!CALLMETHOD [METHODCALL]          Calls a method on a variable", "  Hint:  To see a result set use !CALLMETHOD com.ibm.as400.access.jdbcClient.Main.dispResultSet(RS)", "  Hint:  To access an array use  !SETVAR LIST=java.util.Arrays.asList(ARRAYVARIABLE)", "", "!THREAD [COMMAND]                      Runs a command in its own thread.", "!THREADPERSIST [THREADNAME]            Create a thread that persist.", "!THREADEXEC [THREADNAME] [COMMAND]     Execute a command in a persistent thread.", "!REPEAT [NUMBER] [COMMAND]             Repeat a command a number of times.", "!EXIT_REPEAT_ON_EXCEPTION [false|true] Exit the repeat if an exception occurs. ", ""};
    String url_;
    String userid_;
    String password_;
    boolean prompt_ = true;
    boolean echoCommand_ = false;
    boolean printStackTrace_ = false;
    boolean exitRepeatOnException_ = false;
    boolean exceptionOccurred_ = false;
    int queryTimeout_ = 0;
    boolean measureExecute_ = false;
    boolean manualFetch_ = false;
    int resultSetType_ = 1003;
    int resultSetConcurrency_ = 1007;
    int resultSetHoldability_ = 1;
    boolean jdk16_ = false;
    private boolean hideWarnings_ = false;
    private boolean toolboxDriver_ = false;
    Connection connection_;
    Statement stmt_;
    private int manualResultSetNumCols_;
    private ResultSet manualResultSet_;
    private String[] manualResultSetColumnLabel_;
    private int showLobThreshold_ = 4096;
    private boolean characterDetails_ = false;
    private int stringSampleSize_ = 256;
    private boolean showMixedUX_;
    private int[] manualResultSetColType_;
    private boolean closeStatementRS_;
    private PreparedStatement pstmt_;
    private String[] savedStringParm_ = new String[256];
    private boolean echoComments_ = false;
    private String urlArgs_ = "";
    private boolean debug_ = false;
    private String conLabel_;
    private CallableStatement cstmt_;
    private String cstmtSql_;
    private Vector threads_ = new Vector();
    boolean html_ = false;
    boolean xml_ = false;
    private boolean silent_;
    private boolean silentrs_;
    private boolean useConnectionPool_ = false;
    private boolean reuseStatement_ = false;
    private Connection poolConnection = null;
    private String poolUserId = null;
    private String poolPassword = null;
    private String poolUrl = null;
    private Hashtable connectionPool = new Hashtable();
    private Hashtable variables = new Hashtable();
    private int conCount;
    private String conName = "CON";
    private Vector history = new Vector();
    String command_;
    PrintStream out_;
    private long startTime_;
    private long finishTime_;

    void initializeDefaults() {
        try {
            String string = System.getProperty("com.ibm.as400.access.jdbcClient.debug");
            if (string != null && (string = string.toUpperCase()).equals("TRUE")) {
                this.debug_ = true;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        for (int i = 0; i < knownDrivers.length; ++i) {
            try {
                Class.forName(knownDrivers[i]);
                continue;
            }
            catch (Exception exception) {
                if (!(this.debug_ | this.printStackTrace_)) continue;
                exception.printStackTrace();
            }
        }
        this.jdk16_ = JVMInfo.isJDK16();
        this.addVariable("MAIN", this);
        String string = null;
        try {
            string = System.getProperty("com.ibm.as400.access.jdbcClient.drivers");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        while (string != null) {
            String string2 = null;
            int n = string.indexOf(":");
            if (n > 0) {
                string2 = string.substring(0, n);
                if ((string = string.substring(n + 1).trim()).length() == 0) {
                    string = null;
                }
            } else {
                string2 = string;
                string = null;
            }
            try {
                Class.forName(string2);
            }
            catch (Exception exception) {
                System.out.println("Exception " + exception);
                if (!this.debug_ && !this.printStackTrace_) continue;
                exception.printStackTrace();
            }
        }
    }

    public Main(String string, String string2, String string3) throws SQLException {
        this.initializeDefaults();
        this.setUrl(string);
        this.userid_ = string2;
        this.password_ = string3;
        try {
            this.connection_ = DriverManager.getConnection(this.url_, this.userid_, this.password_);
            this.addVariable("CON", this.connection_);
        }
        catch (SQLException sQLException) {
            System.out.println("Warning:  Unable to connect to " + this.url_ + " using " + this.userid_);
            if (this.printStackTrace_) {
                sQLException.printStackTrace(System.out);
            }
            System.out.println("CON is not defined");
            this.connection_ = null;
        }
    }

    Main() {
        this.initializeDefaults();
    }

    public static String readLine(BufferedReader bufferedReader) throws Exception {
        String string = null;
        string = bufferedReader.readLine();
        if (string != null && string.indexOf("\\u") >= 0) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            int n3 = string.indexOf("\\u", n2);
            while (n3 >= 0) {
                stringBuffer.append(string.substring(n2, n3));
                if (n3 + 6 <= n) {
                    try {
                        stringBuffer.append(Main.getUnicodeCharacter(string, n3 + 2));
                    }
                    catch (SQLException sQLException) {
                        throw new SQLException("Escape sequence '" + string.substring(n3, n3 + 6) + "' invalid in " + string);
                    }
                } else {
                    throw new SQLException("Escape sequence '" + string.substring(n3) + "' invalid in " + string);
                }
                n2 = n3 + 6;
                n3 = string.indexOf("\\u", n2);
            }
            stringBuffer.append(string.substring(n2));
            string = stringBuffer.toString();
        }
        return string;
    }

    private static char getUnicodeCharacter(String string, int n) throws SQLException {
        int n2 = 0;
        for (int i = 0; i < 4; ++i) {
            char c = string.charAt(n + i);
            n2 = n2 * 16 + Main.hexValue(c);
        }
        return (char)n2;
    }

    private static int hexValue(char c) throws SQLException {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return 10 + c - 97;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return 10 + c - 65;
            }
        }
        throw new SQLException("invalid escape digit '" + c + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int go(InputStream inputStream, PrintStream printStream) {
        int n;
        block20: {
            n = 0;
            boolean bl = true;
            PrintStream printStream2 = defaultOutput;
            defaultOutput = printStream;
            try {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    if (this.prompt_) {
                        printStream.print(promptString);
                    }
                    try {
                        string = Main.readLine(bufferedReader);
                        if (string == null) {
                            bl = false;
                        }
                    }
                    catch (SQLException sQLException) {
                        printStream.println("Exception reading: " + sQLException.toString());
                        if (this.printStackTrace_) {
                            sQLException.printStackTrace(printStream);
                        }
                        string = null;
                    }
                    while (bl) {
                        if (string != null) {
                            bl = this.executeTopLevelCommand(string, printStream);
                        }
                        if (!bl) continue;
                        if (this.prompt_) {
                            printStream.print(promptString);
                        }
                        try {
                            string = Main.readLine(bufferedReader);
                            if (string != null) {
                                string = string.trim();
                                continue;
                            }
                            bl = false;
                        }
                        catch (SQLException sQLException) {
                            printStream.println("Exception reading: " + sQLException.toString());
                            if (this.printStackTrace_) {
                                sQLException.printStackTrace(printStream);
                            }
                            string = null;
                        }
                    }
                    if (this.connection_ != null) {
                        this.connection_.close();
                        this.cstmt_ = null;
                        this.cstmtSql_ = "";
                        this.variables.remove("CSTMT");
                    }
                    this.connection_ = null;
                    this.variables.remove("CON");
                }
                catch (Exception exception) {
                    printStream.println("Outermost Exception " + exception);
                    if (this.printStackTrace_) {
                        exception.printStackTrace(printStream);
                    }
                    Object var10_14 = null;
                    defaultOutput = printStream2;
                    break block20;
                }
                catch (UnknownError unknownError) {
                    printStream.println("Outermost UnknownError " + unknownError);
                    if (this.printStackTrace_) {
                        unknownError.printStackTrace(printStream);
                    }
                    Object var10_15 = null;
                    defaultOutput = printStream2;
                }
                Object var10_13 = null;
                defaultOutput = printStream2;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                defaultOutput = printStream2;
                throw throwable;
            }
        }
        return n;
    }

    public Main(Main main, String string, PrintStream printStream) {
        this.inheritVariables(main);
        this.command_ = string;
        this.out_ = printStream;
    }

    private void inheritVariables(Main main) {
        this.variables = main.variables;
        this.url_ = main.url_;
        this.userid_ = main.userid_;
        this.password_ = main.password_;
        this.prompt_ = main.prompt_;
        this.echoCommand_ = main.echoCommand_;
        this.exitRepeatOnException_ = main.exitRepeatOnException_;
        this.printStackTrace_ = main.printStackTrace_;
        this.queryTimeout_ = main.queryTimeout_;
        this.measureExecute_ = main.measureExecute_;
        this.manualFetch_ = main.manualFetch_;
        this.resultSetType_ = main.resultSetType_;
        this.resultSetConcurrency_ = main.resultSetConcurrency_;
        this.resultSetHoldability_ = main.resultSetHoldability_;
        this.jdk16_ = main.jdk16_;
        this.hideWarnings_ = main.hideWarnings_;
        this.toolboxDriver_ = main.toolboxDriver_;
        this.connection_ = main.connection_;
        this.stmt_ = main.stmt_;
        this.manualResultSetNumCols_ = main.manualResultSetNumCols_;
        this.manualResultSet_ = main.manualResultSet_;
        this.manualResultSetColumnLabel_ = main.manualResultSetColumnLabel_;
        this.showLobThreshold_ = main.showLobThreshold_;
        this.characterDetails_ = main.characterDetails_;
        this.stringSampleSize_ = main.stringSampleSize_;
        this.showMixedUX_ = main.showMixedUX_;
        this.manualResultSetColType_ = main.manualResultSetColType_;
        this.closeStatementRS_ = main.closeStatementRS_;
        this.pstmt_ = main.pstmt_;
        this.savedStringParm_ = main.savedStringParm_;
        this.echoComments_ = main.echoComments_;
        this.urlArgs_ = main.urlArgs_;
        this.debug_ = main.debug_;
        this.conLabel_ = main.conLabel_;
        this.cstmt_ = main.cstmt_;
        this.cstmtSql_ = main.cstmtSql_;
        this.threads_ = main.threads_;
        this.html_ = main.html_;
        this.xml_ = main.xml_;
        this.useConnectionPool_ = main.useConnectionPool_;
        this.reuseStatement_ = main.reuseStatement_;
        this.poolConnection = main.poolConnection;
        this.poolUserId = main.poolUserId;
        this.poolPassword = main.poolPassword;
        this.poolUrl = main.poolUrl;
        this.connectionPool = main.connectionPool;
        this.conCount = main.conCount;
        this.conName = main.conName;
        this.silent_ = main.silent_;
        this.silentrs_ = main.silentrs_;
        this.history = main.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        this.out_.println("Thread " + thread + " running " + this.command_);
        String string = this.command_.toUpperCase();
        if (string.startsWith("PERSIST")) {
            this.command_ = null;
            while (this.command_ == null) {
                Main main = this;
                synchronized (main) {
                    while (this.command_ == null) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.out_.println("Interrupted Exception : " + interruptedException);
                            if (!this.printStackTrace_) continue;
                            interruptedException.printStackTrace(this.out_);
                        }
                    }
                }
                string = this.command_.toUpperCase().trim();
                if (string.equals("QUIT") || string.equals("EXIT")) continue;
                this.out_.println("Thread " + thread + " running " + this.command_);
                this.executeTopLevelCommand(this.command_, this.out_);
                this.command_ = null;
            }
        } else {
            this.out_.println("Thread " + thread + " running " + this.command_);
            this.executeTopLevelCommand(this.command_, this.out_);
            this.out_.println("Thread " + thread + " ending");
        }
        this.out_.println("Thread " + thread + " ending");
    }

    public synchronized void setCommand(String string) {
        this.command_ = string;
        this.notify();
    }

    public void useConnectionPool(boolean bl) {
        this.useConnectionPool_ = bl;
    }

    public void setUrl(String string) {
        this.url_ = string;
        if (this.url_.indexOf(":as400:") > 0) {
            this.toolboxDriver_ = true;
        }
    }

    public void setUserId(String string) {
        if (this.debug_) {
            this.out_.println("User ID set to " + string);
        }
        this.userid_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public String removeProperty(String string, String string2) {
        int n = string2.indexOf("=");
        while (n > 0) {
            int n2;
            String string3 = string2.substring(0, n).trim();
            int n3 = string.indexOf(string3);
            while (n3 > 0) {
                n2 = string.indexOf(";", n3);
                string = n2 > 0 ? string.substring(0, n3).trim() + string.substring(n2 + 1).trim() : string.substring(0, n3).trim();
                n3 = string.indexOf(string3);
            }
            n2 = string2.indexOf(";", n);
            string2 = n2 > 0 ? string2.substring(n2 + 1) : "";
            n = string2.indexOf("=");
        }
        return string;
    }

    public void setManualResultSetColType(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.manualResultSetColType_ = new int[this.manualResultSetNumCols_ + 1];
        for (int i = 1; i <= this.manualResultSetNumCols_; ++i) {
            this.manualResultSetColType_[i] = resultSetMetaData.getColumnType(i);
        }
    }

    public Connection getPooledConnection(String string, String string2, String string3, PrintStream printStream) throws SQLException {
        if (this.poolConnection != null && string.equals(this.poolUserId) && string2.equals(this.poolPassword) && string3.equals(this.poolUrl)) {
            this.connection_ = this.poolConnection;
            this.addVariable("CON", this.connection_);
        } else {
            String string4;
            if (this.poolConnection != null) {
                string4 = this.poolUserId + "." + this.poolPassword + "." + this.poolUrl;
                this.connectionPool.put(string4, this.poolConnection);
                if (this.debug_) {
                    printStream.println("Added connection to pool for " + string4);
                }
            }
            string4 = string + "." + string2 + "." + string3;
            this.connection_ = (Connection)this.connectionPool.get(string4);
            if (this.connection_ != null) {
                this.addVariable("CON", this.connection_);
                if (this.debug_) {
                    printStream.println("Retrieved connection from pool for " + string4);
                }
                this.connectionPool.remove(string4);
            } else {
                if (this.debug_) {
                    printStream.println("Didn't retrieve connection from pool for " + string4);
                }
                this.connection_ = string.equals("null") && string2.equals("null") ? DriverManager.getConnection(string3) : DriverManager.getConnection(string3, string, string2);
                this.addVariable("CON", this.connection_);
            }
            this.poolConnection = this.connection_;
            this.poolUserId = string;
            this.poolPassword = string2;
            this.poolUrl = string3;
        }
        return this.connection_;
    }

    void executeSqlQuery(String string, PrintStream printStream) throws Exception {
        this.history.addElement(string);
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                try {
                    this.stmt_.close();
                    this.stmt_ = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
            this.addVariable("STMT", this.stmt_);
        }
        if (this.queryTimeout_ != 0) {
            this.stmt_.setQueryTimeout(this.queryTimeout_);
        }
        if (this.stmt_ != null) {
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            ResultSet resultSet = this.stmt_.executeQuery(string);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("EXECUTE TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            SQLWarning sQLWarning = this.stmt_.getWarnings();
            if (this.manualFetch_) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                this.setManualResultSetColType(resultSetMetaData);
                this.manualResultSet_ = resultSet;
                this.addVariable("RS", this.manualResultSet_);
                this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
            } else {
                this.dispResultSet(printStream, resultSet, false);
                if (sQLWarning != null && !this.silent_) {
                    Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                }
                if (this.closeStatementRS_) {
                    resultSet.close();
                }
            }
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("WITH FETCH TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
        } else {
            printStream.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    public void executeCLCommand(String string, PrintStream printStream) throws Exception {
        this.history.addElement("CL: " + string);
        int n = string.length();
        String string2 = n < 10 ? "000000000" + n + ".00000" : (n < 100 ? "00000000" + n + ".00000" : (n < 1000 ? "0000000" + n + ".00000" : (n < 10000 ? "000000" + n + ".00000" : "00000" + n + ".00000")));
        String string3 = "CALL QSYS.QCMDEXC('" + string + "    ', " + string2 + ")";
        if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
            if (this.stmt_ != null) {
                this.stmt_.close();
                this.stmt_ = null;
            }
            this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
            this.addVariable("STMT", this.stmt_);
        }
        if (this.stmt_ != null) {
            SQLWarning sQLWarning;
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(string3);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent_) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        } else {
            printStream.println("UNABLE to EXECUTE SELECT because not connected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeCallCommand(String string, PrintStream printStream) throws Exception {
        this.history.addElement(string);
        if (this.connection_ != null) {
            block30: {
                ResultSet resultSet;
                int n;
                int n2;
                int n3 = string.indexOf("-- INPARM");
                String string2 = null;
                if (n3 > 0) {
                    string2 = string.substring(n3 + 9).trim();
                    string = string.substring(0, n3);
                }
                if (!string.equals(this.cstmtSql_)) {
                    this.cstmt_ = this.connection_.prepareCall(string, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                    this.cstmtSql_ = string;
                    this.addVariable("CSTMT", this.cstmt_);
                }
                ParameterMetaData parameterMetaData = this.cstmt_.getParameterMetaData();
                int n4 = parameterMetaData.getParameterCount();
                for (n2 = 1; n2 <= n4; ++n2) {
                    int n5 = parameterMetaData.getParameterMode(n2);
                    if (n5 == 4 || n5 == 2) {
                        n = parameterMetaData.getParameterType(n2);
                        switch (n) {
                            case -8: 
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2003: 
                            case 2004: {
                                this.cstmt_.registerOutParameter(n2, n);
                                break;
                            }
                            default: {
                                this.cstmt_.registerOutParameter(n2, 12);
                            }
                        }
                    }
                    if (n5 != 1 && n5 != 2) continue;
                    String string3 = string2;
                    if (string2 != null && (n3 = string2.indexOf(",")) >= 0) {
                        string3 = string2.substring(0, n3).trim();
                        string2 = string2.substring(n3 + 1).trim();
                    }
                    if (string3 != null) {
                        this.setParameter(this.cstmt_, string3, n2, printStream);
                        continue;
                    }
                    printStream.println("Warning:  thisParm is null");
                    printStream.println("--INPARM not found but num param > 0 ");
                }
                n2 = this.cstmt_.execute() ? 1 : 0;
                SQLWarning sQLWarning = this.cstmt_.getWarnings();
                if (sQLWarning != null) {
                    if (!this.silent_) {
                        Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
                    }
                    if (this.html_) {
                        printStream.println("Statement was " + string);
                    }
                }
                block10: for (n = 1; n <= n4; ++n) {
                    int n6 = parameterMetaData.getParameterMode(n);
                    if (n6 != 4 && n6 != 2) continue;
                    int n7 = parameterMetaData.getParameterType(n);
                    switch (n7) {
                        case -8: 
                        case -4: 
                        case -3: 
                        case -2: 
                        case 2004: {
                            printStream.print("Parameter " + n + " returned ");
                            byte[] byArray = this.cstmt_.getBytes(n);
                            if (byArray == null) {
                                printStream.println("null");
                                continue block10;
                            }
                            if (byArray.length < this.showLobThreshold_) {
                                printStream.print("X'");
                                for (int i = 0; i < byArray.length; ++i) {
                                    int n8 = 0xFF & byArray[i];
                                    if (n8 < 16) {
                                        printStream.print("0" + Integer.toHexString(n8));
                                        continue;
                                    }
                                    printStream.print(Integer.toHexString(n8));
                                }
                                printStream.println("'");
                                continue block10;
                            }
                            CRC32 cRC32 = new CRC32();
                            cRC32.update(byArray);
                            printStream.println("ARRAY[size=" + byArray.length + ",CRC32=" + cRC32.getValue() + "]");
                            continue block10;
                        }
                        case 2003: {
                            printStream.print("Parameter " + n + " returned ARRAY ");
                            this.printArray(printStream, this.cstmt_.getArray(n));
                            printStream.println();
                            continue block10;
                        }
                        default: {
                            printStream.print("Parameter " + n + " returned ");
                            this.savedStringParm_[n] = this.cstmt_.getString(n);
                            this.printUnicodeString(printStream, this.savedStringParm_[n]);
                            printStream.println();
                        }
                    }
                }
                if (n2 != 0 && (resultSet = this.cstmt_.getResultSet()) != null) {
                    if (this.manualFetch_) {
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        this.manualResultSetNumCols_ = resultSetMetaData.getColumnCount();
                        this.setManualResultSetColType(resultSetMetaData);
                        this.manualResultSet_ = resultSet;
                        this.addVariable("RS", this.manualResultSet_);
                        this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
                    } else {
                        this.dispResultSet(printStream, resultSet, false);
                        if (this.closeStatementRS_) {
                            resultSet.close();
                            resultSet = null;
                        }
                    }
                    if (!this.manualFetch_) {
                        try {
                            while (this.cstmt_.getMoreResults()) {
                                printStream.println("<<<< NEXT RESULT SET >>>>>>>");
                                resultSet = this.cstmt_.getResultSet();
                                this.dispResultSet(printStream, resultSet, false);
                                if (!this.closeStatementRS_) continue;
                                resultSet.close();
                                resultSet = null;
                            }
                        }
                        catch (Exception exception) {
                            String string4 = exception.toString();
                            if (string4.indexOf("implemented") >= 0) break block30;
                            throw exception;
                        }
                    }
                }
            }
            if (!this.manualFetch_ && !this.closeStatementRS_) return;
        }
        printStream.println("UNABLE to EXECUTE CALL because not connected");
    }

    public void executeSqlCommand(String string, PrintStream printStream) throws Exception {
        if (this.connection_ != null) {
            SQLWarning sQLWarning;
            if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                if (this.stmt_ != null) {
                    try {
                        this.stmt_.close();
                        this.stmt_ = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                this.addVariable("STMT", this.stmt_);
            }
            if (this.queryTimeout_ != 0) {
                this.stmt_.setQueryTimeout(this.queryTimeout_);
            }
            if (this.measureExecute_) {
                this.startTime_ = System.currentTimeMillis();
            }
            this.stmt_.executeUpdate(string);
            this.history.addElement(string);
            if (this.measureExecute_) {
                this.finishTime_ = System.currentTimeMillis();
                printStream.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
            }
            if ((sQLWarning = this.stmt_.getWarnings()) != null && !this.silent_) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        } else {
            printStream.println("UNABLE to EXECUTE because not connected");
        }
    }

    public void processException(SQLException sQLException, String string, PrintStream printStream) {
        if (!this.silent_) {
            printStream.println("\n*** SQLException caught ***");
            printStream.println("Statement was " + string);
            Throwable throwable = sQLException;
            while (throwable != null) {
                if (throwable instanceof SQLException) {
                    int n;
                    sQLException = throwable;
                    printStream.println("SQLState: " + sQLException.getSQLState());
                    String string2 = sQLException.getMessage();
                    string2 = Main.cleanupMessage(string2);
                    printStream.println("Message:  " + string2);
                    if (throwable instanceof AS400JDBCSQLSyntaxErrorException) {
                        AS400JDBCSQLSyntaxErrorException aS400JDBCSQLSyntaxErrorException = (AS400JDBCSQLSyntaxErrorException)throwable;
                        int n2 = aS400JDBCSQLSyntaxErrorException.getLocationOfSyntaxError();
                        String string3 = aS400JDBCSQLSyntaxErrorException.getSqlStatementText();
                        printStream.println("... Syntax error at " + n2 + " in " + string3);
                        if (n2 > 0 && string3 != null) {
                            try {
                                printStream.println("... " + string3.substring(0, n2 - 1) + "=====>" + string3.substring(n2 - 1));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    printStream.println("Vendor:   " + sQLException.getErrorCode());
                    if (this.debug_ || this.printStackTrace_) {
                        sQLException.printStackTrace(printStream);
                    }
                    if ((n = sQLException.getErrorCode()) == -104) {
                        printStream.println("\nToken not valid found.  Use !HELP to see what you can do");
                    }
                    if ((throwable = sQLException.getNextException()) == null) {
                        try {
                            throwable = sQLException.getCause();
                        }
                        catch (Throwable throwable2) {}
                    }
                } else if (throwable != null) {
                    printStream.println("Throwable: " + throwable);
                    if (this.printStackTrace_) {
                        throwable.printStackTrace(printStream);
                    }
                    try {
                        throwable = throwable.getCause();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                if (throwable != null) {
                    printStream.println("Next exception:");
                    continue;
                }
                printStream.println("");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean executeTopLevelCommand(String string, PrintStream printStream) {
        boolean bl;
        block42: {
            block41: {
                bl = true;
                this.silent_ = false;
                this.silentrs_ = false;
                if ((string = string.trim()).toUpperCase().startsWith("!INVISIBLE:")) {
                    this.silent_ = true;
                    string = string.substring(11).trim();
                } else if (this.echoCommand_) {
                    printStream.println(string);
                    if (this.html_) {
                        printStream.println("<BR>");
                    }
                }
                if (string.toUpperCase().startsWith("!SILENT:")) {
                    this.silent_ = true;
                    string = string.substring(8).trim();
                }
                if (string.toUpperCase().startsWith("!SILENTRS:")) {
                    this.silentrs_ = true;
                    string = string.substring(10).trim();
                }
                String string2 = string.toUpperCase();
                if (string2.startsWith("SELECT") || string2.startsWith("VALUES") || string2.startsWith("WITH ")) {
                    this.executeSqlQuery(string, printStream);
                    break block41;
                }
                if (string2.startsWith("CL:")) {
                    String string3 = string.substring(3).trim();
                    this.executeCLCommand(string3, printStream);
                    break block41;
                }
                if (string2.startsWith("!PROMPT")) {
                    if (string.length() > 7) {
                        this.prompt_ = true;
                        promptString = string.substring(7).trim();
                    } else {
                        this.prompt_ = false;
                    }
                    break block41;
                }
                if (string2.startsWith("!ECHO") && !string2.startsWith("!ECHOCOMMAND") && !string2.startsWith("!ECHOCOMMENTS") || string2.startsWith("--") || string2.startsWith("//") || string2.startsWith("/*")) {
                    this.history.addElement(string);
                    if (this.echoComments_) {
                        printStream.println(string);
                        if (this.html_) {
                            printStream.println("<BR>");
                        }
                    }
                    break block41;
                }
                if (string2.equals("!QUIT") || string2.equals("!EXIT") || string2.equals("QUIT") || string2.equals("EXIT")) {
                    bl = false;
                    break block41;
                }
                if (string.length() > 0 && string.startsWith("!")) {
                    string = string.substring(1);
                    this.executeCommand(string, printStream);
                    break block41;
                }
                if (string2.startsWith("CALL ")) {
                    this.executeCallCommand(string, printStream);
                    break block41;
                }
                if (string2.length() == 0) break block41;
                this.executeSqlCommand(string, printStream);
            }
            Object var7_9 = null;
            if (this.stmt_ == null) break block42;
            try {
                if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                    this.stmt_.close();
                    this.stmt_ = null;
                    this.variables.remove("STMT");
                }
                break block42;
            }
            catch (Exception exception) {
                printStream.println("Exception :" + exception);
                if (this.printStackTrace_) {
                    exception.printStackTrace(printStream);
                }
                break block42;
            }
            {
                catch (SQLException sQLException) {
                    this.exceptionOccurred_ = true;
                    this.processException(sQLException, string, printStream);
                    Object var7_10 = null;
                    if (this.stmt_ == null) break block42;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block42;
                    }
                    catch (Exception exception) {
                        printStream.println("Exception :" + exception);
                        if (this.printStackTrace_) {
                            exception.printStackTrace(printStream);
                        }
                        break block42;
                    }
                }
                catch (Exception exception) {
                    this.exceptionOccurred_ = true;
                    printStream.println("\n*** exception caught *** " + exception);
                    printStream.println("Statement was " + string);
                    if (this.printStackTrace_) {
                        exception.printStackTrace(printStream);
                    }
                    Object var7_11 = null;
                    if (this.stmt_ == null) break block42;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block42;
                    }
                    catch (Exception exception2) {
                        printStream.println("Exception :" + exception2);
                        if (this.printStackTrace_) {
                            exception2.printStackTrace(printStream);
                        }
                        break block42;
                    }
                }
                catch (UnknownError unknownError) {
                    this.exceptionOccurred_ = true;
                    printStream.println("\n*** java.lang.UnknownError caught ***" + unknownError);
                    printStream.println("Statement was " + string);
                    if (this.printStackTrace_) {
                        unknownError.printStackTrace(printStream);
                    }
                    Object var7_12 = null;
                    if (this.stmt_ == null) break block42;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block42;
                    }
                    catch (Exception exception) {
                        printStream.println("Exception :" + exception);
                        if (this.printStackTrace_) {
                            exception.printStackTrace(printStream);
                        }
                        break block42;
                    }
                }
            }
            catch (Throwable throwable) {
                block43: {
                    Object var7_13 = null;
                    if (this.stmt_ != null) {
                        try {
                            if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                                this.stmt_.close();
                                this.stmt_ = null;
                                this.variables.remove("STMT");
                            }
                        }
                        catch (Exception exception) {
                            printStream.println("Exception :" + exception);
                            if (!this.printStackTrace_) break block43;
                            exception.printStackTrace(printStream);
                        }
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean executeCommand(String var1_1, PrintStream var2_2) {
        block375: {
            block374: {
                var3_3 = true;
                this.silentrs_ = false;
                var1_1 = var1_1.trim();
                var4_4 = var1_1.toUpperCase();
                if (var4_4.startsWith("PREPARE")) {
                    this.history.addElement("!" + var1_1);
                    var1_1 = var1_1.substring(7).trim();
                    if (this.pstmt_ != null && this.closeStatementRS_) {
                        this.pstmt_.close();
                    }
                    this.pstmt_ = this.connection_.prepareStatement(var1_1, this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                    this.addVariable("PSTMT", this.pstmt_);
                    break block374;
                }
                if (var4_4.startsWith("SETRESULTSETTYPE")) {
                    this.history.addElement("!" + var1_1);
                    var1_1 = var1_1.substring(16).trim();
                    if (var1_1.indexOf("FORWARD_ONLY") >= 0) {
                        this.resultSetType_ = 1003;
                    } else if (var1_1.indexOf("SCROLL_INSENSITIVE") >= 0) {
                        this.resultSetType_ = 1004;
                    } else if (var1_1.indexOf("SCROLL_SENSITIVE") >= 0) {
                        this.resultSetType_ = 1005;
                    } else {
                        var2_2.println("Value of '" + var1_1 + " not valid use");
                        var2_2.println("     FORWARD_ONLY, SCROLL_INSENSITIVE, or SCROLL_SENSITIVE");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETRESULTSETCONCURRENCY")) {
                    this.history.addElement("!" + var1_1);
                    var1_1 = var1_1.substring(15).trim();
                    if (var1_1.indexOf("READ_ONLY") >= 0) {
                        this.resultSetConcurrency_ = 1007;
                    } else if (var1_1.indexOf("UPDATABLE") >= 0) {
                        this.resultSetConcurrency_ = 1008;
                    } else {
                        var2_2.println("Value of '" + var1_1 + " not valid. Use");
                        var2_2.println(" READ_ONLY or UPDATABLE ");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETRESULTSETHOLDABILITY")) {
                    this.history.addElement("!" + var1_1);
                    var1_1 = var1_1.substring(15).trim();
                    if (var1_1.indexOf("HOLD") >= 0) {
                        this.resultSetHoldability_ = 1;
                    } else if (var1_1.indexOf("CLOSE") >= 0) {
                        this.resultSetHoldability_ = 2;
                    } else {
                        var2_2.println("Value of '" + var1_1 + " not valid. Use");
                        var2_2.println(" HOLD_CURSORS_OVER_COMMIT or CLOSE_CURSORS_AT_COMMIT");
                    }
                    break block374;
                }
                if (var4_4.startsWith("EXECUTEQUERY")) {
                    this.history.addElement("!" + var1_1);
                    if (this.pstmt_ != null) {
                        if (this.measureExecute_) {
                            this.startTime_ = System.currentTimeMillis();
                        }
                        var5_8 = this.pstmt_.executeQuery();
                        if (this.measureExecute_) {
                            this.finishTime_ = System.currentTimeMillis();
                            var2_2.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                        }
                        if (this.manualFetch_) {
                            var6_64 = var5_8.getMetaData();
                            this.manualResultSetNumCols_ = var6_64.getColumnCount();
                            this.setManualResultSetColType(var6_64);
                            this.manualResultSet_ = var5_8;
                            this.addVariable("RS", this.manualResultSet_);
                            this.manualResultSetColumnLabel_ = Main.dispColumnHeadings(var2_2, var5_8, var6_64, false, this.manualResultSetNumCols_, this.html_, this.xml_, this.showMixedUX_, this.silentrs_);
                        } else {
                            this.dispResultSet(var2_2, var5_8, false);
                            var6_65 = this.pstmt_.getWarnings();
                            if (var6_65 != null && !this.silent_) {
                                Main.dispWarning(var2_2, var6_65, this.hideWarnings_, this.html_);
                            }
                            if (this.closeStatementRS_) {
                                var5_8.close();
                            }
                        }
                    } else {
                        var2_2.println("UNABLE to EXECUTE QUERY because prepared statement does not exist");
                    }
                    break block374;
                }
                if (var4_4.startsWith("EXECUTEUPDATE")) {
                    this.history.addElement("!" + var1_1);
                    if (this.pstmt_ != null) {
                        if (this.measureExecute_) {
                            this.startTime_ = System.currentTimeMillis();
                        }
                        this.pstmt_.executeUpdate();
                        if (this.measureExecute_) {
                            this.finishTime_ = System.currentTimeMillis();
                            var2_2.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                        }
                        if ((var5_9 = this.pstmt_.getWarnings()) != null && !this.silent_) {
                            Main.dispWarning(var2_2, var5_9, this.hideWarnings_, this.html_);
                        }
                    } else {
                        var2_2.println("UNABLE to EXECUTE UPDATE because prepared statement does not exist");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETPARMFROMVAR")) {
                    this.history.addElement("!" + var1_1);
                    if (this.pstmt_ != null) {
                        var5_10 = (var1_1 = var1_1.substring(14).trim()).indexOf(",");
                        if (var5_10 > 0) {
                            var6_66 = var1_1.substring(0, var5_10).trim();
                            var7_90 = Integer.parseInt(var6_66);
                            var8_114 = var1_1.substring(var5_10 + 1).trim();
                            var9_132 = this.variables.get(var8_114);
                            if (var9_132 != null) {
                                this.pstmt_.setObject(var7_90, var9_132);
                                var10_145 = this.pstmt_.getWarnings();
                                if (var10_145 != null && !this.silent_) {
                                    Main.dispWarning(var2_2, var10_145, this.hideWarnings_, this.html_);
                                }
                            } else {
                                var2_2.println("Unable to find object for variable " + var8_114);
                                this.showValidVariables(var2_2);
                            }
                        } else {
                            var2_2.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                        }
                    } else {
                        var2_2.println("UNABLE to SETPARM because prepared statement does not exist");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETPARM")) {
                    this.history.addElement("!" + var1_1);
                    if (this.pstmt_ != null) {
                        var5_11 = (var1_1 = var1_1.substring(7).trim()).indexOf(",");
                        if (var5_11 > 0) {
                            var6_67 = var1_1.substring(0, var5_11).trim();
                            var7_91 = Integer.parseInt(var6_67);
                            var8_115 = var1_1.substring(var5_11 + 1).trim();
                            this.setParameter(this.pstmt_, var8_115, var7_91, var2_2);
                        } else {
                            var2_2.println("UNABLE to find comma for SETPARM  --> SETPARM [index],[value]");
                        }
                    } else {
                        var2_2.println("UNABLE to SETPARM because prepared statement does not exist");
                    }
                    break block374;
                }
                if (var4_4.startsWith("ECHO") && !var4_4.startsWith("ECHOCOMMAND") && !var4_4.startsWith("ECHOCOMMENTS") || var4_4.startsWith("--") || var4_4.startsWith("//") || var4_4.startsWith("/*")) {
                    this.history.addElement("!" + var1_1);
                    if (this.echoComments_) {
                        var2_2.println(var1_1);
                        if (this.html_) {
                            var2_2.println("<BR>");
                        }
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETQUERYTIMEOUT")) {
                    this.history.addElement("!" + var1_1);
                    var5_12 = var1_1.substring(16).trim();
                    try {
                        this.queryTimeout_ = Integer.parseInt(var5_12);
                        var2_2.println("-->Query timeout set to " + this.queryTimeout_);
                    }
                    catch (Exception var6_68) {
                        var2_2.println("Unable to parse (" + var5_12 + ")");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RESET CONNECTION PROPERTIES")) {
                    this.history.addElement("!" + var1_1);
                    this.urlArgs_ = "";
                    break block374;
                }
                if (var4_4.startsWith("ADD CONNECTION PROPERTY")) {
                    this.history.addElement("!" + var1_1);
                    var5_13 = var1_1.substring(23).trim();
                    this.urlArgs_ = this.removeProperty(this.urlArgs_, var5_13);
                    this.urlArgs_ = this.urlArgs_ + "; " + var5_13;
                    break block374;
                }
                if (var4_4.startsWith("CONNECT TO URL")) {
                    this.history.addElement("!" + var1_1);
                    if (this.connection_ != null && this.connection_ != this.poolConnection) {
                        this.connection_.close();
                        this.cstmt_ = null;
                        this.cstmtSql_ = "";
                        this.variables.remove("CSTMT");
                    }
                    var5_14 = var1_1.substring(14).trim();
                    var6_69 = null;
                    var7_92 = null;
                    var8_116 = var5_14.indexOf("USERID=");
                    if (var8_116 > 0) {
                        var6_69 = var5_14.substring(var8_116 + 7).trim();
                        var5_14 = var5_14.substring(0, var8_116).trim();
                        var9_133 = var6_69.indexOf(" ");
                        if (var9_133 >= 0) {
                            var6_69 = var6_69.substring(0, var9_133);
                        }
                        if ((var10_146 = var1_1.indexOf("PASSWORD=")) > 0) {
                            var7_92 = var1_1.substring(var10_146 + 9).trim();
                            var9_133 = var7_92.indexOf(" ");
                            if (var9_133 > 0) {
                                var7_92 = var7_92.substring(0, var9_133);
                            }
                            if (this.debug_) {
                                var2_2.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + var5_14);
                            }
                            var11_155 = null;
                            try {
                                if (var5_14.indexOf("jdbc:db2://") >= 0) {
                                    if (this.debug_) {
                                        var2_2.println("Loading jcc driver");
                                    }
                                    Class.forName("com.ibm.db2.jcc.DB2Driver").newInstance();
                                    var12_161 = DriverManager.getDriver(this.url_);
                                    if (var12_161.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2Driver")) {
                                        if (this.debug_) {
                                            var2_2.println("removing native driver");
                                        }
                                        var11_155 = var12_161;
                                        DriverManager.deregisterDriver(var11_155);
                                    }
                                }
                                if (this.useConnectionPool_) {
                                    this.connection_ = this.getPooledConnection(var6_69, var7_92, var5_14, var2_2);
                                } else {
                                    if (this.measureExecute_) {
                                        this.startTime_ = System.currentTimeMillis();
                                    }
                                    this.connection_ = DriverManager.getConnection(var5_14, var6_69, var7_92);
                                    if (this.measureExecute_) {
                                        this.finishTime_ = System.currentTimeMillis();
                                        var2_2.println("CONNECT TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                                    }
                                    this.addVariable("CON", this.connection_);
                                    var12_161 = this.connection_.getWarnings();
                                    if (var12_161 != null && !this.silent_) {
                                        Main.dispWarning(var2_2, (SQLWarning)var12_161, this.hideWarnings_, this.html_);
                                    }
                                }
                            }
                            catch (Exception var12_162) {
                                var2_2.println("Exception " + var12_162);
                                if (this.printStackTrace_) {
                                    var12_162.printStackTrace(var2_2);
                                }
                                var7_92 = null;
                            }
                            if (var11_155 != null) {
                                DriverManager.registerDriver(var11_155);
                            }
                            this.conLabel_ = this.conName;
                            if (this.conCount > 0) {
                                this.conLabel_ = this.conLabel_ + this.conCount;
                            }
                            ++this.conCount;
                        }
                    }
                    if (var7_92 == null) {
                        var2_2.println("Usage:  CONNECT TO URL [URL] [USERID=XXXX] [PASSWORD=YYYY]");
                        var2_2.println("  i.e.  CONNECT TO URL jdbc:db2:localhost USERID=MYUSER PASSWORD=XXXXX");
                        var2_2.println("        CONNECT TO URL jdbc:db2://localhost/*LOCAL USERID=MYUSER PASSWORD=XXXXX");
                        var2_2.println("        CONNECT TO URL jdbc:db2:SAMPLE\\;transaction isolation=serializable USERID=MYUSER PASSWORD=XXXXXXX");
                    }
                    break block374;
                }
                if (var4_4.startsWith("CONNECT TO SCHEMA")) {
                    this.history.addElement("!" + var1_1);
                    if (this.connection_ != null) {
                        if (this.connection_ != this.poolConnection) {
                            this.connection_.close();
                            this.cstmt_ = null;
                            this.cstmtSql_ = "";
                            this.variables.remove("CSTMT");
                        }
                        this.connection_ = null;
                    }
                    if ((var6_70 = var1_1.substring(17).trim()).length() > 0) {
                        var7_93 = var6_70.indexOf(47);
                        if (var7_93 >= 0) {
                            var8_117 = this.url_.indexOf(":");
                            var8_117 = this.url_.indexOf(":", var8_117 + 1);
                            var9_134 = this.url_.substring(0, var8_117 + 1);
                            var5_15 = (String)var9_134 + var6_70 + this.urlArgs_;
                        } else {
                            var8_117 = this.url_.indexOf(";");
                            var5_15 = var8_117 < 0 ? this.url_ + "/" + var6_70 + this.urlArgs_ : this.url_.substring(0, var8_117) + "/" + var6_70 + this.url_.substring(var8_117) + this.urlArgs_;
                        }
                    } else {
                        var5_15 = this.url_ + this.urlArgs_;
                    }
                    var7_93 = var5_15.indexOf(" ;");
                    while (var7_93 > 0) {
                        var5_15 = var5_15.substring(0, var7_93) + var5_15.substring(var7_93 + 1);
                        var7_93 = var5_15.indexOf(" ;");
                    }
                    if (this.userid_ != null) {
                        if (this.debug_) {
                            var2_2.println("Connecting using " + this.userid_ + ", " + this.password_ + " to " + var5_15);
                        }
                        if (this.useConnectionPool_) {
                            this.connection_ = this.getPooledConnection(this.userid_, this.password_, var5_15, var2_2);
                        } else {
                            if (this.measureExecute_) {
                                this.startTime_ = System.currentTimeMillis();
                            }
                            this.connection_ = DriverManager.getConnection(var5_15, this.userid_, this.password_);
                            if (this.measureExecute_) {
                                this.finishTime_ = System.currentTimeMillis();
                                var2_2.println("CONNECT TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                            }
                            if ((var7_94 = this.connection_.getWarnings()) != null && !this.silent_) {
                                Main.dispWarning(var2_2, var7_94, this.hideWarnings_, this.html_);
                            }
                        }
                        this.addVariable("CON", this.connection_);
                    } else {
                        if (this.debug_) {
                            var2_2.println("Connecting using default id and password to " + var5_15);
                        }
                        if (this.useConnectionPool_) {
                            this.connection_ = this.getPooledConnection("null", "null", var5_15, var2_2);
                        } else {
                            this.connection_ = DriverManager.getConnection(var5_15);
                            var7_95 = this.connection_.getWarnings();
                            if (var7_95 != null && !this.silent_) {
                                Main.dispWarning(var2_2, var7_95, this.hideWarnings_, this.html_);
                            }
                        }
                        this.addVariable("CON", this.connection_);
                    }
                    this.conLabel_ = this.conName;
                    if (this.conCount > 0) {
                        this.conLabel_ = this.conLabel_ + this.conCount;
                    }
                    ++this.conCount;
                    var7_96 = var6_70.indexOf(59);
                    if (var7_96 > 0) {
                        var6_70 = var6_70.substring(0, var7_96).trim();
                    }
                    if (var6_70.length() > 0) {
                        var8_117 = var6_70.lastIndexOf("/");
                        if (var8_117 >= 0) {
                            var6_70 = var6_70.substring(var8_117 + 1);
                        }
                        var9_134 = this.connection_.prepareStatement("SET CURRENT PATH " + var6_70 + ", SYSTEM PATH");
                        var9_134.execute();
                        var9_134.close();
                    }
                    break block374;
                }
                if (var4_4.startsWith("CONNECT RESET")) {
                    this.history.addElement("!" + var1_1);
                    if (this.connection_ != null) {
                        if (this.connection_ != this.poolConnection) {
                            this.connection_.close();
                            this.cstmt_ = null;
                            this.cstmtSql_ = "";
                            this.variables.remove("CSTMT");
                        }
                        this.connection_ = null;
                        this.variables.remove("CON");
                    }
                    break block374;
                }
                if (var4_4.startsWith("CHARACTERDETAILS")) {
                    this.history.addElement("!" + var1_1);
                    var5_16 = var1_1.substring(16).trim().toUpperCase();
                    if (var5_16.equals("TRUE")) {
                        this.characterDetails_ = true;
                    } else if (var5_16.equals("ON")) {
                        this.characterDetails_ = true;
                    } else if (var5_16.equals("FALSE")) {
                        this.characterDetails_ = false;
                    } else if (var5_16.equals("OFF")) {
                        this.characterDetails_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_16 + "' for CHARACTERDETAILS");
                    }
                    break block374;
                }
                if (var4_4.startsWith("ECHOCOMMAND")) {
                    this.history.addElement("!" + var1_1);
                    var5_17 = var1_1.substring(11).trim().toUpperCase();
                    if (var5_17.equals("TRUE")) {
                        this.echoCommand_ = true;
                    } else if (var5_17.equals("ON")) {
                        this.echoCommand_ = true;
                    } else if (var5_17.equals("FALSE")) {
                        this.echoCommand_ = false;
                    } else if (var5_17.equals("OFF")) {
                        this.echoCommand_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_17 + "' for ECHOCOMMAND");
                    }
                    break block374;
                }
                if (var4_4.startsWith("ECHOCOMMENTS")) {
                    this.history.addElement("!" + var1_1);
                    var5_18 = var1_1.substring(12).trim().toUpperCase();
                    if (var5_18.equals("TRUE")) {
                        this.echoComments_ = true;
                    } else if (var5_18.equals("ON")) {
                        this.echoComments_ = true;
                    } else if (var5_18.equals("FALSE")) {
                        this.echoComments_ = false;
                    } else if (var5_18.equals("OFF")) {
                        this.echoComments_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_18 + "' for ECHOCOMMENTS");
                    }
                    break block374;
                }
                if (var4_4.startsWith("EXIT_REPEAT_ON_EXCEPTION") || var4_4.startsWith("EXIT REPEAT ON EXCEPTION")) {
                    this.history.addElement("!" + var1_1);
                    var5_19 = var1_1.substring(24).trim().toUpperCase();
                    if (var5_19.equals("TRUE")) {
                        this.exitRepeatOnException_ = true;
                    } else if (var5_19.equals("ON")) {
                        this.exitRepeatOnException_ = true;
                    } else if (var5_19.equals("FALSE")) {
                        this.exitRepeatOnException_ = false;
                    } else if (var5_19.equals("OFF")) {
                        this.exitRepeatOnException_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_19 + "' for EXIT REPEAT ON EXCEPTION");
                    }
                    break block374;
                }
                if (var4_4.startsWith("PRINTSTACKTRACE")) {
                    this.history.addElement("!" + var1_1);
                    var5_20 = var1_1.substring(15).trim().toUpperCase();
                    if (var5_20.equals("TRUE")) {
                        this.printStackTrace_ = true;
                    } else if (var5_20.equals("ON")) {
                        this.printStackTrace_ = true;
                    } else if (var5_20.equals("FALSE")) {
                        this.printStackTrace_ = false;
                    } else if (var5_20.equals("OFF")) {
                        this.printStackTrace_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_20 + "' for PRINTSTACKTRACE");
                    }
                    break block374;
                }
                if (var4_4.startsWith("CLOSESTATEMENTRS")) {
                    this.history.addElement("!" + var1_1);
                    var5_21 = var1_1.substring(16).trim().toUpperCase();
                    if (var5_21.equals("TRUE")) {
                        this.closeStatementRS_ = true;
                    } else if (var5_21.equals("ON")) {
                        this.closeStatementRS_ = true;
                    } else if (var5_21.equals("FALSE")) {
                        this.closeStatementRS_ = false;
                    } else if (var5_21.equals("OFF")) {
                        this.closeStatementRS_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_21 + "' for closeStatementRS");
                    }
                    break block374;
                }
                if (var4_4.startsWith("MEASUREEXECUTE")) {
                    this.history.addElement("!" + var1_1);
                    var5_22 = var1_1.substring(14).trim().toUpperCase();
                    if (var5_22.equals("TRUE")) {
                        this.measureExecute_ = true;
                    } else if (var5_22.equals("ON")) {
                        this.measureExecute_ = true;
                    } else if (var5_22.equals("FALSE")) {
                        this.measureExecute_ = false;
                    } else if (var5_22.equals("OFF")) {
                        this.measureExecute_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_22 + "' for measureExecute");
                    }
                    break block374;
                }
                if (var4_4.startsWith("EXISTFILE")) {
                    this.history.addElement("!" + var1_1);
                    var5_23 = var1_1.substring(9).trim();
                    try {
                        var6_71 = new File(var5_23);
                        if (var6_71.exists()) {
                            var2_2.println("EXISTFILE " + var5_23 + ": YES");
                            break block374;
                        }
                        var2_2.println("EXISTFILE " + var5_23 + ": NO");
                    }
                    catch (Exception var6_72) {
                        var2_2.println("Exception " + var6_72);
                        if (this.printStackTrace_) {
                            var6_72.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("GC")) {
                    this.history.addElement("!" + var1_1);
                    this.startTime_ = System.currentTimeMillis();
                    System.gc();
                    this.finishTime_ = System.currentTimeMillis();
                    var2_2.println("GC ran in " + (this.finishTime_ - this.startTime_) + " milliseconds");
                    break block374;
                }
                if (var4_4.startsWith("OUTPUT FORMAT ")) {
                    this.history.addElement("!" + var1_1);
                    var5_24 = var1_1.substring(14).trim().toUpperCase();
                    if (var5_24.equals("XML")) {
                        this.xml_ = true;
                        this.html_ = false;
                    } else if (var5_24.equals("HTML")) {
                        this.html_ = true;
                        this.xml_ = false;
                    } else {
                        var2_2.println("Error.  Did not recognize output format '" + var5_24 + "'");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SHOWMIXEDUX ")) {
                    this.history.addElement("!" + var1_1);
                    var5_25 = var1_1.substring(11).trim().toUpperCase();
                    if (var5_25.equals("TRUE")) {
                        this.showMixedUX_ = true;
                    } else if (var5_25.equals("FALSE")) {
                        this.showMixedUX_ = false;
                    } else {
                        var2_2.println("Error.  Did not recognize SHOWMIXEDUX value  '" + var5_25 + "'");
                    }
                    break block374;
                }
                if (var4_4.startsWith("QUIT") || var4_4.startsWith("EXIT")) {
                    var3_3 = false;
                    break block374;
                }
                if (var4_4.startsWith("SET AUTOCOMMIT")) {
                    this.history.addElement("!" + var1_1);
                    var5_26 = var1_1.substring(14).trim();
                    if (var5_26.startsWith("true")) {
                        this.connection_.setAutoCommit(true);
                    } else if (var5_26.startsWith("false")) {
                        this.connection_.setAutoCommit(false);
                    } else {
                        var2_2.println("SET AUTOCOMMIT:  Didn't understand \"" + var5_26 + "\"");
                        var2_2.println("  Usage:  SET AUTOCOMMIT true");
                        var2_2.println("          SET AUTOCOMMIT false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("REUSE CONNECTION")) {
                    this.history.addElement("!" + var1_1);
                    var5_27 = var1_1.substring(16).trim();
                    if (var5_27.startsWith("true")) {
                        this.useConnectionPool_ = true;
                    } else if (var5_27.startsWith("false")) {
                        this.useConnectionPool_ = false;
                    } else {
                        var2_2.println("REUSE CONNECTION:  Didn't understand \"" + var5_27 + "\"");
                        var2_2.println("  Usage:  REUSE CONNECTION true");
                        var2_2.println("          REUSE CONNECTION false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("REUSE STATEMENT")) {
                    this.history.addElement("!" + var1_1);
                    var5_28 = var1_1.substring(16).trim();
                    if (var5_28.startsWith("true")) {
                        this.reuseStatement_ = true;
                    } else if (var5_28.startsWith("false")) {
                        this.reuseStatement_ = false;
                    } else {
                        var2_2.println("REUSE STATEMENT:  Didn't understand \"" + var5_28 + "\"");
                        var2_2.println("  Usage:  REUSE STATEMENT true");
                        var2_2.println("          REUSE STATEMENT false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETCLITRACE")) {
                    this.history.addElement("!" + var1_1);
                    var5_29 = false;
                    var6_73 = false;
                    var7_97 = var1_1.substring(11).trim();
                    if (var7_97.startsWith("true")) {
                        var5_29 = true;
                        var6_73 = true;
                    } else if (var7_97.startsWith("false")) {
                        var5_29 = false;
                        var6_73 = true;
                    }
                    if (var6_73) {
                        try {
                            var8_118 = Class.forName("com.ibm.db2.jdbc.app.T");
                            var9_135 = new Class[]{Boolean.TYPE};
                            var10_147 = var8_118.getMethod("setCliTrace", var9_135);
                            var11_156 = new Object[]{new Boolean(var5_29)};
                            var10_147.invoke(null, var11_156);
                        }
                        catch (Exception var8_119) {
                            var2_2.println("Exception while setting cli trace");
                            var2_2.println("Exception " + var8_119);
                            if (this.printStackTrace_) {
                                var8_119.printStackTrace(var2_2);
                            }
                            ** GOTO lbl1031
                        }
                    } else {
                        var2_2.println("SETCLITRACE:  Didn't understand \"" + var7_97 + "\"");
                        var2_2.println("  Usage:  SETCLITRACE true");
                        var2_2.println("          SETCLITRACE false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETDB2TRACE")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_30 = var1_1.substring(11).trim();
                        var6_74 = Class.forName("com.ibm.db2.jdbc.app.T");
                        var7_98 = new Class[]{Integer.TYPE};
                        var8_120 = var6_74.getMethod("setDb2Trace", var7_98);
                        var9_136 = new Object[]{var5_30.startsWith("true") != false ? new Integer(3) : (var5_30.startsWith("false") != false ? new Integer(0) : new Integer(Integer.parseInt(var5_30)))};
                        var8_120.invoke(null, var9_136);
                    }
                    catch (Exception var5_31) {
                        var2_2.println("Exception while setting cli trace");
                        var2_2.println("Exception " + var5_31);
                        if (this.printStackTrace_) {
                            var5_31.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("SYSTEMDEBUGGER")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_32 = Class.forName("com.ibm.iseries.debug.util.Util");
                        var6_75 = new Class[]{};
                        var7_99 = var5_32.getMethod("registerApp", var6_75);
                        var8_121 = new Object[]{};
                        var7_99.invoke(null, var8_121);
                        var9_137 = Class.forName("utilities.Debug");
                        var10_148 = new Class[1];
                        var8_121 = new Object[1];
                        var11_157 = new String[]{"-u", this.getUser(), "-s", this.getSystem(), "-j", this.getServerJobName()};
                        var8_121[0] = var11_157;
                        var10_148[0] = var11_157.getClass();
                        var12_163 = var9_137.getMethod("main", var10_148);
                        var12_163.invoke(null, var8_121);
                    }
                    catch (Exception var5_33) {
                        var2_2.println("Exception starting  SYSTEMDEBUGGER");
                        var2_2.println("Exception " + var5_33);
                        if (this.printStackTrace_) {
                            var5_33.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("SET TRANSACTIONISOLATION")) {
                    this.history.addElement("!" + var1_1);
                    var5_34 = var1_1.substring(24).trim();
                    if (var5_34.startsWith("TRANSACTION_READ_UNCOMMITTED")) {
                        this.connection_.setTransactionIsolation(1);
                    } else if (var5_34.startsWith("TRANSACTION_READ_COMMITTED")) {
                        this.connection_.setTransactionIsolation(2);
                    } else if (var5_34.startsWith("TRANSACTION_REPEATABLE_READ")) {
                        this.connection_.setTransactionIsolation(4);
                    } else if (var5_34.startsWith("TRANSACTION_SERIALIZABLE")) {
                        this.connection_.setTransactionIsolation(8);
                    } else {
                        var2_2.println("SET TRANSACTIONISOLATION:  Didn't understand \"" + var5_34 + "\"");
                        var2_2.println("  Usage:  SET TRANSACTIONISOLATION TRANSACTION_READ_UNCOMMITTED");
                        var2_2.println("          SET TRANSACTIONISOLATION TRANSACTION_READ_COMMITTED");
                        var2_2.println("          SET TRANSACTIONISOLATION TRANSACTION_REPEATABLE_READ");
                        var2_2.println("          SET TRANSACTIONISOLATION TRANSACTION_SERIALIZABLE");
                    }
                    break block374;
                }
                if (var4_4.startsWith("USAGE") || var4_4.startsWith("HELP")) {
                    for (var5_35 = 0; var5_35 < Main.commandHelp.length; ++var5_35) {
                        var2_2.println(Main.commandHelp[var5_35]);
                    }
                    break block374;
                }
                if (var4_4.startsWith("GETSERVERJOBNAME")) {
                    this.history.addElement("!" + var1_1);
                    var5_36 = this.getServerJobName();
                    var2_2.println("getServerJobName returned " + var5_36);
                    break block374;
                }
                if (var4_4.startsWith("DMD.GETCOLUMNS")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_37 = null;
                        var6_76 = null;
                        var7_100 = null;
                        var8_122 = null;
                        var9_138 = this.connection_.getMetaData();
                        var10_149 = var1_1.substring(14).trim();
                        var11_158 = var10_149.indexOf(",");
                        if (var11_158 > 0) {
                            var5_37 = var10_149.substring(0, var11_158).trim();
                            if (var5_37.equals("null")) {
                                var5_37 = null;
                            }
                            if ((var11_158 = (var10_149 = var10_149.substring(var11_158 + 1)).indexOf(",")) > 0) {
                                var6_76 = var10_149.substring(0, var11_158).trim();
                                if (var6_76.equals("null")) {
                                    var6_76 = null;
                                }
                                if ((var11_158 = (var10_149 = var10_149.substring(var11_158 + 1)).indexOf(",")) > 0) {
                                    var7_100 = var10_149.substring(0, var11_158).trim();
                                    if (var7_100.equals("null")) {
                                        var7_100 = null;
                                    }
                                    if ((var8_122 = var10_149.substring(var11_158 + 1).trim()).equals("null")) {
                                        var8_122 = null;
                                    }
                                }
                            }
                        }
                        var2_2.println("Calling dmd.getColumns(" + var5_37 + ", " + var6_76 + ", " + var7_100 + ", " + var8_122 + ")");
                        var12_164 = var9_138.getColumns(var5_37, var6_76, var7_100, var8_122);
                        if (var12_164 != null) {
                            this.dispResultSet(var2_2, var12_164, false);
                            var12_164.close();
                        }
                        break block374;
                    }
                    catch (Exception var5_38) {
                        var2_2.println("databaseMetaData.getColumns failed with exception " + var5_38);
                        if (this.printStackTrace_) {
                            var5_38.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("DMD.GETTABLES")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_39 = null;
                        var6_77 = null;
                        var7_101 = null;
                        var8_123 = null;
                        var9_139 = null;
                        var10_150 = this.connection_.getMetaData();
                        var11_159 = var1_1.substring(14).trim();
                        var12_165 = var11_159.indexOf(",");
                        if (var12_165 > 0) {
                            var5_39 = var11_159.substring(0, var12_165).trim();
                            if (var5_39.equals("null")) {
                                var5_39 = null;
                            }
                            if ((var12_165 = (var11_159 = var11_159.substring(var12_165 + 1)).indexOf(",")) > 0) {
                                var6_77 = var11_159.substring(0, var12_165).trim();
                                if (var6_77.equals("null")) {
                                    var6_77 = null;
                                }
                                if ((var12_165 = (var11_159 = var11_159.substring(var12_165 + 1)).indexOf(",")) > 0) {
                                    var7_101 = var11_159.substring(0, var12_165).trim();
                                    if (var7_101.equals("null")) {
                                        var7_101 = null;
                                    }
                                    if ((var8_123 = var11_159.substring(var12_165 + 1).trim()).equals("null")) {
                                        var8_123 = null;
                                    } else {
                                        var13_167 = new Vector<E>();
                                        var14_169 = var8_123.indexOf(124);
                                        while (var14_169 > 0) {
                                            var15_171 = var8_123.substring(0, var14_169);
                                            var13_167.add(var15_171);
                                            var8_123 = var8_123.substring(1 + var14_169);
                                            var14_169 = var8_123.indexOf(124);
                                        }
                                        var13_167.add(var8_123);
                                        var15_172 = var13_167.size();
                                        var9_139 = new String[var15_172];
                                        for (var16_173 = 0; var16_173 < var15_172; ++var16_173) {
                                            var9_139[var16_173] = (String)var13_167.elementAt(var16_173);
                                        }
                                    }
                                }
                            }
                        }
                        var2_2.println("Calling dmd.getTables(" + var5_39 + ", " + var6_77 + ", " + var7_101 + ", " + var8_123 + "=" + StringFormatUtil.stringArrayContents(var9_139) + ")");
                        var13_167 = var10_150.getTables(var5_39, var6_77, var7_101, var9_139);
                        if (var13_167 != null) {
                            this.dispResultSet(var2_2, (ResultSet)var13_167, false);
                            var13_167.close();
                        }
                        break block374;
                    }
                    catch (Exception var5_40) {
                        var2_2.println("databaseMetaData.getTables failed with exception " + var5_40);
                        if (this.printStackTrace_) {
                            var5_40.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("DMD.GETINDEXINFO")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_41 = null;
                        var6_78 = null;
                        var7_102 = null;
                        var8_124 = false;
                        var9_140 = false;
                        var10_151 = this.connection_.getMetaData();
                        var11_160 = var1_1.substring(16).trim();
                        var12_166 = var11_160.indexOf(",");
                        if (var12_166 > 0) {
                            var5_41 = var11_160.substring(0, var12_166).trim();
                            if (var5_41.equals("null")) {
                                var5_41 = null;
                            }
                            if ((var12_166 = (var11_160 = var11_160.substring(var12_166 + 1)).indexOf(",")) > 0) {
                                var6_78 = var11_160.substring(0, var12_166).trim();
                                if (var6_78.equals("null")) {
                                    var6_78 = null;
                                }
                                if ((var12_166 = (var11_160 = var11_160.substring(var12_166 + 1)).indexOf(",")) > 0) {
                                    var7_102 = var11_160.substring(0, var12_166).trim();
                                    if (var7_102.equals("null")) {
                                        var7_102 = null;
                                    }
                                    if ((var12_166 = (var11_160 = var11_160.substring(var12_166 + 1)).indexOf(",")) > 0) {
                                        var13_168 = var11_160.substring(0, var12_166).trim();
                                        var8_124 = var13_168.equalsIgnoreCase("true");
                                        var14_170 = var11_160 = var11_160.substring(var12_166 + 1);
                                        var9_140 = var14_170.equalsIgnoreCase("true");
                                    }
                                }
                            }
                        }
                        var2_2.println("Calling dmd.getIndexInfo(" + var5_41 + ", " + var6_78 + ", " + var7_102 + ", " + var8_124 + "," + var9_140 + ")");
                        var13_168 = var10_151.getIndexInfo(var5_41, var6_78, var7_102, var8_124, var9_140);
                        if (var13_168 != null) {
                            this.dispResultSet(var2_2, (ResultSet)var13_168, false);
                            var13_168.close();
                        }
                        break block374;
                    }
                    catch (Exception var5_42) {
                        var2_2.println("databaseMetaData.getIndexInfo failed with exception " + var5_42);
                        if (this.printStackTrace_) {
                            var5_42.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("DMD.GETSCHEMAS")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_43 = this.connection_.getMetaData();
                        var2_2.println("Calling dmd.getSchemas()");
                        var6_79 = var5_43.getSchemas();
                        if (var6_79 != null) {
                            this.dispResultSet(var2_2, var6_79, false);
                            var6_79.close();
                        }
                        break block374;
                    }
                    catch (Exception var5_44) {
                        var2_2.println("databaseMetaData.getSchemas failed with exception " + var5_44);
                        if (this.printStackTrace_) {
                            var5_44.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("HISTORY.CLEAR")) {
                    this.history.clear();
                    break block374;
                }
                if (var4_4.startsWith("HISTORY.SHOW")) {
                    var5_45 = this.history.elements();
                    while (var5_45.hasMoreElements()) {
                        var6_80 = (String)var5_45.nextElement();
                        var2_2.println(var6_80);
                    }
                    break block374;
                }
                if (var4_4.startsWith("MANUALFETCH")) {
                    this.history.addElement("!" + var1_1);
                    var5_46 = var1_1.substring(11).trim().toUpperCase();
                    if (var5_46.equals("TRUE")) {
                        this.manualFetch_ = true;
                    } else if (var5_46.equals("ON")) {
                        this.manualFetch_ = true;
                    } else if (var5_46.equals("FALSE")) {
                        this.manualFetch_ = false;
                    } else if (var5_46.equals("OFF")) {
                        this.manualFetch_ = false;
                    } else {
                        var2_2.println("Invalid arg '" + var5_46 + "' for MANUALFETCH");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RS.NEXT")) {
                    this.history.addElement("!" + var1_1);
                    var5_47 = this.manualResultSet_.next();
                    if (var5_47) {
                        Main.dispRow(var2_2, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    } else {
                        var2_2.println("rs.next returned false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RS.FIRST")) {
                    this.history.addElement("!" + var1_1);
                    var5_48 = this.manualResultSet_.first();
                    if (var5_48) {
                        Main.dispRow(var2_2, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    } else {
                        var2_2.println("rs.first returned false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RS.BEFOREFIRST")) {
                    this.history.addElement("!" + var1_1);
                    this.manualResultSet_.beforeFirst();
                    var2_2.println("rs.beforeFirst called");
                    break block374;
                }
                if (var4_4.startsWith("RS.AFTERLAST")) {
                    this.history.addElement("!" + var1_1);
                    this.manualResultSet_.afterLast();
                    var2_2.println("rs.afterLast called");
                    break block374;
                }
                if (var4_4.startsWith("RS.LAST")) {
                    this.history.addElement("!" + var1_1);
                    var5_49 = this.manualResultSet_.last();
                    if (var5_49) {
                        Main.dispRow(var2_2, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    } else {
                        var2_2.println("rs.last returned false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RS.PREVIOUS")) {
                    this.history.addElement("!" + var1_1);
                    var5_50 = this.manualResultSet_.previous();
                    if (var5_50) {
                        Main.dispRow(var2_2, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    } else {
                        var2_2.println("rs.previous returned false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RS.ABSOLUTE")) {
                    this.history.addElement("!" + var1_1);
                    var5_51 = var1_1.substring(11).trim().toUpperCase();
                    var6_81 = Integer.parseInt(var5_51);
                    var7_103 = this.manualResultSet_.absolute(var6_81);
                    if (var7_103) {
                        Main.dispRow(var2_2, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    } else {
                        var2_2.println("rs.absolute returned false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("RS.RELATIVE")) {
                    this.history.addElement("!" + var1_1);
                    var5_52 = var1_1.substring(11).trim().toUpperCase();
                    var6_82 = Integer.parseInt(var5_52);
                    var7_104 = this.manualResultSet_.relative(var6_82);
                    if (var7_104) {
                        Main.dispRow(var2_2, this.manualResultSet_, false, this.manualResultSetNumCols_, this.manualResultSetColType_, this.manualResultSetColumnLabel_, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.silentrs_);
                    } else {
                        var2_2.println("rs.relative returned false");
                    }
                    break block374;
                }
                if (var4_4.startsWith("SETVAR")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_53 = var1_1.substring(6).trim();
                        var6_83 = var5_53.indexOf("=");
                        if (var6_83 > 0) {
                            var7_105 = var5_53.substring(0, var6_83).trim();
                            var8_125 = this.callMethod(var5_53 = var5_53.substring(var6_83 + 1), var2_2);
                            if (var8_125 != null) {
                                this.addVariable(var7_105, var8_125);
                                var2_2.println(var7_105 + "=" + var8_125.toString());
                            } else {
                                var2_2.println("ERROR:  Method not found or output is null");
                            }
                            break block374;
                        }
                        var7_106 = var5_53.indexOf(" ");
                        if (var7_106 > 0) {
                            var8_126 = var5_53.substring(0, var7_106).trim();
                            var9_141 = this.getParameterObject(var5_53 = var5_53.substring(var7_106 + 1), var2_2);
                            if (var9_141 != null) {
                                this.addVariable(var8_126, var9_141);
                                var2_2.println(var8_126 + "=" + var9_141.toString());
                            } else {
                                var2_2.println("ERROR:  Unable to get parameter ");
                            }
                            break block374;
                        }
                        var2_2.println("ERROR:  '=' or ' ' not found after SETVAR [VAR]");
                    }
                    catch (Exception var5_54) {
                        var2_2.println("Exception " + var5_54);
                        if (this.printStackTrace_) {
                            var5_54.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("SETNEWVAR")) {
                    this.history.addElement("!" + var1_1);
                    try {
                        var5_55 = var1_1.substring(9).trim();
                        var6_84 = var5_55.indexOf("=");
                        if (var6_84 > 0) {
                            var7_107 = var5_55.substring(0, var6_84).trim();
                            var8_127 = this.callNewMethod(var5_55 = var5_55.substring(var6_84 + 1), var2_2);
                            if (var8_127 != null) {
                                this.addVariable(var7_107, var8_127);
                                var2_2.println(var7_107 + "=" + var8_127.toString());
                            } else {
                                var2_2.println("ERROR:  Method not found or output is null");
                            }
                            break block374;
                        }
                        var2_2.println("line missing =");
                    }
                    catch (Exception var5_56) {
                        var2_2.println("Exception " + var5_56);
                        if (this.printStackTrace_) {
                            var5_56.printStackTrace(var2_2);
                        }
                        break block374;
                    }
                }
                if (var4_4.startsWith("SHOWVARMETHODS")) {
                    this.history.addElement("!" + var1_1);
                    var5_57 = var1_1.substring(14).trim();
                    this.showMethods(var5_57, var2_2);
                    break block374;
                }
                if (var4_4.startsWith("THREAD ")) {
                    this.history.addElement("!" + var1_1);
                    var5_58 = var1_1.substring(7).trim();
                    var2_2.println("Starting thread for " + var5_58);
                    var6_85 = new Main(this, var5_58, var2_2);
                    var7_108 = new Thread(var6_85);
                    var7_108.start();
                    this.threads_.add(var7_108);
                    break block374;
                }
                if (var4_4.startsWith("THREADPERSIST ")) {
                    this.history.addElement("!" + var1_1);
                    var5_59 = var1_1.substring(14).trim();
                    var2_2.println("Starting runnable " + var5_59);
                    var6_86 = "PERSIST";
                    var7_109 = new Main(this, var6_86, var2_2);
                    this.variables.put(var5_59, var7_109);
                    var8_128 = new Thread(var7_109);
                    var8_128.setName(var5_59);
                    var8_128.setDaemon(true);
                    var8_128.start();
                    var2_2.println("Started thread " + var5_59 + "-T");
                    this.variables.put(var5_59 + "-T", var8_128);
                    break block374;
                }
                if (var4_4.startsWith("THREADEXEC ")) {
                    this.history.addElement("!" + var1_1);
                    var5_60 = var1_1.substring(11).trim();
                    var6_87 = var5_60.indexOf(32);
                    if (var6_87 > 0) {
                        var7_110 = var5_60.substring(0, var6_87);
                        var8_129 = var5_60.substring(var6_87 + 1);
                        var9_142 = (Main)this.variables.get(var7_110);
                        if (var9_142 != null) {
                            var9_142.setCommand(var8_129);
                        } else {
                            var2_2.println("ERROR: Unable to find thread " + var7_110);
                        }
                    } else {
                        var2_2.println("ERROR:  THREADEXEC: no space after thread name");
                    }
                    break block374;
                }
                if (var4_4.startsWith("REPEAT ")) {
                    this.history.addElement("!" + var1_1);
                    var5_61 = var1_1.substring(7).trim();
                    var6_88 = var5_61.indexOf(" ");
                    if (var6_88 > 0) {
                        var7_111 = Integer.parseInt(var5_61.substring(0, var6_88));
                        if (var7_111 > 0) {
                            var8_130 = var5_61.substring(var6_88).trim();
                            var9_143 = var7_111;
                            var10_152 = 1;
                            while (var7_111 > 0) {
                                var2_2.println("Iteration " + var10_152 + " of " + var9_143);
                                ++var10_152;
                                this.exceptionOccurred_ = false;
                                this.executeTopLevelCommand(var8_130, var2_2);
                                --var7_111;
                                if (!this.exitRepeatOnException_ || !this.exceptionOccurred_) continue;
                                var7_111 = 0;
                            }
                        } else {
                            var2_2.println("Error.. invalid repeat count " + var5_61.substring(0, var6_88));
                        }
                    } else {
                        var2_2.println("Error.  No count for repeat");
                    }
                    break block374;
                }
                if (var4_4.startsWith("CALLMETHOD")) {
                    this.history.addElement("!" + var1_1);
                    var5_62 = var1_1.substring(10).trim();
                    var6_89 = this.callMethod(var5_62, var2_2);
                    var2_2.println("Call returned " + var6_89);
                    if (var6_89 != null && var6_89 instanceof InputStream) {
                        var2_2.println("InputStream[ ");
                        var7_112 = (InputStream)var6_89;
                        var8_131 = var7_112.read();
                        while (var8_131 > 0) {
                            var2_2.print(" " + Integer.toHexString(var8_131));
                            var8_131 = var7_112.read();
                        }
                        var2_2.println("]");
                    }
                    if (var6_89 != null && var6_89.getClass().isArray()) {
                        var7_113 = Array.getLength(var6_89);
                        var2_2.println("  .. Array of size " + var7_113);
                        for (var8_131 = 0; var8_131 < var7_113; ++var8_131) {
                            var9_144 = Array.get(var6_89, var8_131);
                            if (var9_144 instanceof DriverPropertyInfo) {
                                var10_153 = (DriverPropertyInfo)var9_144;
                                var2_2.println("[" + var8_131 + "]=" + var10_153.name + " " + var10_153.value + " " + var10_153.description);
                                continue;
                            }
                            if (var9_144 instanceof Byte) {
                                var10_154 = 255 & ((Byte)var9_144).intValue();
                                var2_2.println("[" + var8_131 + "]=0x" + Integer.toHexString(var10_154) + " a[" + StringFormatUtil.asciiChar(var10_154) + "]" + " e[" + StringFormatUtil.ebcdicChar(var10_154) + "]");
                                continue;
                            }
                            var2_2.println("[" + var8_131 + "][" + var9_144.getClass().getName() + "]=" + var9_144);
                        }
                    }
                    break block374;
                }
                if (var4_4.length() == 0) break block374;
                if (this.connection_ != null) {
                    if (!(this.connection_ == null || this.stmt_ != null && this.reuseStatement_)) {
                        if (this.stmt_ != null) {
                            this.stmt_.close();
                            this.stmt_ = null;
                        }
                        this.stmt_ = this.connection_.createStatement(this.resultSetType_, this.resultSetConcurrency_, this.resultSetHoldability_);
                        this.addVariable("STMT", this.stmt_);
                    }
                    if (this.queryTimeout_ != 0) {
                        this.stmt_.setQueryTimeout(this.queryTimeout_);
                    }
                    if (this.measureExecute_) {
                        this.startTime_ = System.currentTimeMillis();
                    }
                    this.stmt_.executeUpdate(var1_1);
                    this.history.addElement(var1_1);
                    if (this.measureExecute_) {
                        this.finishTime_ = System.currentTimeMillis();
                        var2_2.println("TIME: " + (this.finishTime_ - this.startTime_) + " ms");
                    }
                    if ((var5_63 = this.stmt_.getWarnings()) != null && !this.silent_) {
                        Main.dispWarning(var2_2, var5_63, this.hideWarnings_, this.html_);
                    }
                    break block374;
                }
                var2_2.println("UNABLE to EXECUTE because not connected");
            }
            var18_174 = null;
            if (this.stmt_ == null) break block375;
            try {
                if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                    this.stmt_.close();
                    this.stmt_ = null;
                    this.variables.remove("STMT");
                }
                break block375;
            }
            catch (Exception var19_179) {
                var2_2.println("Exception " + var19_179);
                if (this.printStackTrace_) {
                    var19_179.printStackTrace(var2_2);
                }
                break block375;
            }
            {
                catch (SQLException var4_5) {
                    this.exceptionOccurred_ = true;
                    if (!this.silent_) {
                        this.processException(var4_5, var1_1, var2_2);
                    }
                    var18_175 = null;
                    if (this.stmt_ == null) break block375;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block375;
                    }
                    catch (Exception var19_180) {
                        var2_2.println("Exception " + var19_180);
                        if (this.printStackTrace_) {
                            var19_180.printStackTrace(var2_2);
                        }
                        break block375;
                    }
                }
                catch (Exception var4_6) {
                    this.exceptionOccurred_ = true;
                    var2_2.println("\n*** exception caught *** " + var4_6);
                    var2_2.println("Statement was " + var1_1);
                    if (this.printStackTrace_) {
                        var4_6.printStackTrace(var2_2);
                    }
                    var18_176 = null;
                    if (this.stmt_ == null) break block375;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block375;
                    }
                    catch (Exception var19_181) {
                        var2_2.println("Exception " + var19_181);
                        if (this.printStackTrace_) {
                            var19_181.printStackTrace(var2_2);
                        }
                        break block375;
                    }
                }
                catch (UnknownError var4_7) {
                    this.exceptionOccurred_ = true;
                    var2_2.println("\n*** java.lang.UnknownError caught ***" + var4_7);
                    var2_2.println("Statement was " + var1_1);
                    if (this.printStackTrace_) {
                        var4_7.printStackTrace(var2_2);
                    }
                    var18_177 = null;
                    if (this.stmt_ == null) break block375;
                    try {
                        if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                            this.stmt_.close();
                            this.stmt_ = null;
                            this.variables.remove("STMT");
                        }
                        break block375;
                    }
                    catch (Exception var19_182) {
                        var2_2.println("Exception " + var19_182);
                        if (this.printStackTrace_) {
                            var19_182.printStackTrace(var2_2);
                        }
                        break block375;
                    }
                }
            }
            catch (Throwable var17_184) {
                block376: {
                    var18_178 = null;
                    if (this.stmt_ != null) {
                        try {
                            if (!this.reuseStatement_ && !this.manualFetch_ && this.closeStatementRS_) {
                                this.stmt_.close();
                                this.stmt_ = null;
                                this.variables.remove("STMT");
                            }
                        }
                        catch (Exception var19_183) {
                            var2_2.println("Exception " + var19_183);
                            if (!this.printStackTrace_) break block376;
                            var19_183.printStackTrace(var2_2);
                        }
                    }
                }
                throw var17_184;
            }
        }
        return var3_3;
    }

    private String getSystem() throws SQLException {
        String string = "";
        String string2 = this.connection_.getMetaData().getURL();
        if (string2.startsWith("jdbc:as400:")) {
            string = string2.substring(11);
            int n = string.indexOf(59);
            if (n > 0) {
                string = string.substring(0, n).replace('/', ' ').trim();
            }
        } else if (string2.startsWith("jdbc:db2:")) {
            string = "localhost";
        }
        return string;
    }

    private String getUser() throws Exception {
        return this.connection_.getMetaData().getUserName();
    }

    private String getServerJobName() {
        String string;
        try {
            string = ReflectionUtil.callMethod_S(this.connection_, "getServerJobName");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                DatabaseMetaData databaseMetaData = this.connection_.getMetaData();
                String string2 = databaseMetaData.getDriverName();
                if (string2.indexOf("Toolbox") >= 0 || string2.indexOf("jtopenlite") >= 0) {
                    try {
                        string = ReflectionUtil.callMethod_S(this.connection_, "getServerJobIdentifier");
                        if (string.length() >= 26) {
                            string = string.substring(20).trim() + "/" + string.substring(10, 20).trim() + "/" + string.substring(0, 10).trim();
                        }
                    }
                    catch (Exception exception) {
                        return "server jobname is not available";
                    }
                }
                return "getServerJobName:3 failed with exception " + noSuchMethodException + " for driver " + string2;
            }
            catch (Exception exception) {
                return "getServerJobName:2 failed with 2 exceptions " + noSuchMethodException + ":" + exception;
            }
        }
        catch (Exception exception) {
            return "getServerJobName:1 failed with exception " + exception;
        }
        return string;
    }

    private Object callMethod(String string, PrintStream printStream) {
        try {
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            Object object = null;
            int n = string.indexOf("(");
            if (n > 0) {
                int n2 = string.lastIndexOf(".", n);
                if (n2 > 0) {
                    String string2 = string.substring(0, n2).trim();
                    Object v = this.variables.get(string2);
                    Class<?> clazz = null;
                    string = string.substring(n2 + 1).trim();
                    n = string.indexOf("(");
                    String string3 = string.substring(0, n).trim();
                    string = string.substring(n + 1);
                    if (v == null) {
                        try {
                            clazz = Class.forName(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (v != null || clazz != null) {
                        if (n > 0) {
                            Method[] methodArray = v != null ? v.getClass().getMethods() : (clazz != null ? clazz.getMethods() : new Method[]{});
                            boolean bl2 = false;
                            for (int i = 0; !bl && i < methodArray.length && object == null; ++i) {
                                int n3 = 0;
                                int n4 = 0;
                                if (!methodArray[i].getName().equals(string3)) continue;
                                Class<?>[] classArray = methodArray[i].getParameterTypes();
                                String string4 = string;
                                Object[] objectArray = new Object[classArray.length];
                                bl = true;
                                bl2 = true;
                                n4 = classArray.length;
                                String string5 = "";
                                for (n3 = 0; n3 < classArray.length; ++n3) {
                                    int n5;
                                    int n6;
                                    Object[] objectArray2;
                                    int n7;
                                    int n8;
                                    String string6;
                                    int n9 = 0;
                                    int n10 = 0;
                                    int n11 = 0;
                                    if (string4.length() > 1 && (string4.charAt(0) == '\"' || string4.charAt(0) == '\'')) {
                                        n9 = 1;
                                        n10 = string4.indexOf(string4.charAt(0), 1);
                                        if (n10 > 0) {
                                            if (string4.charAt(n10 + 1) == ',' || string4.charAt(n10 + 1) == ')') {
                                                n11 = n10 + 2;
                                            } else {
                                                stringBuffer.append("[,)] does not follow #" + string4.charAt(0) + "#\n");
                                                n10 = -1;
                                            }
                                        }
                                    } else {
                                        n10 = string4.indexOf(",");
                                        if (n10 < 0) {
                                            n10 = string4.indexOf(")");
                                        }
                                        if (n10 >= 0) {
                                            n11 = n10 + 1;
                                        }
                                    }
                                    if (n10 < 0) {
                                        bl = false;
                                        stringBuffer.append("Unable to find arg with remaining args " + string4 + "\n");
                                        stringBuffer.append("Number of parameters is " + classArray.length + "\n");
                                        bl = false;
                                        continue;
                                    }
                                    if (n9 > n10) continue;
                                    String string7 = string4.substring(n9, n10).trim();
                                    string4 = string4.substring(n11);
                                    Object v2 = this.variables.get(string7);
                                    if (v2 != null) {
                                        objectArray[n3] = v2;
                                        continue;
                                    }
                                    String string8 = classArray[n3].getName();
                                    string5 = string5 + string8 + " ";
                                    if (string7.equals("null")) {
                                        objectArray[n3] = null;
                                        continue;
                                    }
                                    if (string8.equals("java.lang.String") || string8.equals("java.lang.Object")) {
                                        objectArray[n3] = string7;
                                        continue;
                                    }
                                    if (string8.equals("boolean")) {
                                        try {
                                            objectArray[n3] = new Boolean(string7);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string7 + " as integer\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("short")) {
                                        try {
                                            objectArray[n3] = new Short(string7);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string7 + " as short\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("int")) {
                                        try {
                                            objectArray[n3] = new Integer(string7);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string7 + " as integer\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("long")) {
                                        try {
                                            objectArray[n3] = new Long(string7);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string7 + " as long\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("float")) {
                                        try {
                                            objectArray[n3] = new Float(string7);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string7 + " as float\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("double")) {
                                        try {
                                            objectArray[n3] = new Double(string7);
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Could not parse " + string7 + " as double\n");
                                            bl = false;
                                        }
                                        continue;
                                    }
                                    if (string8.equals("[Ljava.lang.String;")) {
                                        if (string7.charAt(0) == '[') {
                                            string6 = string7.substring(1);
                                            n8 = string6.length();
                                            n7 = 1;
                                            for (int j = 0; j < n8; ++j) {
                                                if (string6.charAt(j) != '+') continue;
                                                ++n7;
                                            }
                                            objectArray[n3] = objectArray2 = new String[n7];
                                            int n12 = 0;
                                            n6 = 0;
                                            n5 = string6.indexOf(43, n6);
                                            if (n5 < 0) {
                                                n5 = string6.indexOf(93, n6);
                                            }
                                            while (n5 > 0) {
                                                if (n12 < n7) {
                                                    objectArray2[n12] = string6.substring(n6, n5);
                                                    ++n12;
                                                }
                                                if ((n6 = n5 + 1) >= n8) {
                                                    n5 = -1;
                                                    continue;
                                                }
                                                n5 = string6.indexOf(43, n6);
                                                if (n5 >= 0) continue;
                                                n5 = string6.indexOf(93, n6);
                                            }
                                            continue;
                                        }
                                        stringBuffer.append("Could not parse " + string7 + " as String array .. try [A+B+C]\n");
                                        bl = false;
                                        continue;
                                    }
                                    if (string8.equals("[I")) {
                                        if (string7.charAt(0) == '[') {
                                            string6 = string7.substring(1);
                                            n8 = string6.length();
                                            n7 = 1;
                                            for (int j = 0; j < n8; ++j) {
                                                if (string6.charAt(j) != '+') continue;
                                                ++n7;
                                            }
                                            objectArray[n3] = objectArray2 = (Object[])new int[n7];
                                            String string9 = "";
                                            try {
                                                n6 = 0;
                                                n5 = 0;
                                                int n13 = string6.indexOf(43, n5);
                                                if (n13 < 0) {
                                                    n13 = string6.indexOf(93, n5);
                                                }
                                                while (n13 > 0) {
                                                    if (n6 < n7) {
                                                        objectArray2[n6] = (String)Integer.parseInt(string6.substring(n5, n13));
                                                        ++n6;
                                                    }
                                                    if ((n5 = n13 + 1) >= n8) {
                                                        n13 = -1;
                                                        continue;
                                                    }
                                                    n13 = string6.indexOf(43, n5);
                                                    if (n13 >= 0) continue;
                                                    n13 = string6.indexOf(93, n5);
                                                }
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                stringBuffer.append("Exception " + exception + " piece = " + string9 + "\n");
                                                stringBuffer.append("Could not parse " + string7 + " as Integer.. try [1+2+3]\n");
                                                bl = false;
                                                continue;
                                            }
                                        }
                                        stringBuffer.append("Could not parse " + string7 + " as Integer.. try [1+2+3]\n");
                                        bl = false;
                                        continue;
                                    }
                                    stringBuffer.append("Did not handle parameter with class " + string8 + "\n");
                                    bl = false;
                                }
                                if (bl) {
                                    if (n3 == n4) {
                                        if (string4.trim().equals(")") || string4.trim().length() == 0) {
                                            try {
                                                methodArray[i].setAccessible(true);
                                                object = methodArray[i].invoke(v, objectArray);
                                            }
                                            catch (Exception exception) {
                                                Exception exception2;
                                                Throwable throwable;
                                                if (exception instanceof InvocationTargetException && (throwable = exception.getCause()) != null && throwable instanceof Exception) {
                                                    exception2 = (Exception)throwable;
                                                }
                                                if (exception2 instanceof XAException) {
                                                    stringBuffer.append("XAException:" + exception2.toString() + " code=" + this.getXACodeInfo((XAException)exception2) + "\n");
                                                }
                                                stringBuffer.append("Exception " + exception2 + "\n");
                                                if (this.printStackTrace_) {
                                                    Main.printStackTraceToStringBuffer(exception2, stringBuffer);
                                                }
                                                stringBuffer.append("Calling method " + string3 + " with " + string5 + " failed\n");
                                                bl = false;
                                            }
                                            continue;
                                        }
                                        stringBuffer.append("Not calling method " + string3 + " with " + string5 + " because argsLeft = " + string4 + "\n");
                                        bl = false;
                                        continue;
                                    }
                                    stringBuffer.append("Not calling method " + string3 + " with " + string5 + " because parsed parameter count = " + n3 + "\n");
                                    continue;
                                }
                                stringBuffer.append("Method not found " + string3 + "\n");
                            }
                            if (!bl2) {
                                stringBuffer.append("ERROR:  Method not found " + string3 + "\n");
                            }
                        } else {
                            stringBuffer.append("ERROR:  could find ( in " + string + "\n");
                        }
                    } else {
                        printStream.println("ERROR:  could not find variable or class " + string2);
                        this.showValidVariables(printStream);
                    }
                } else {
                    stringBuffer.append("ERROR:  could find . in " + string);
                }
            } else {
                stringBuffer.append("ERROR:  could find ( in " + string);
            }
            if (!bl) {
                printStream.println("No matching method found, possible errors are the following:\n" + stringBuffer.toString());
            }
            return object;
        }
        catch (Exception exception) {
            this.exceptionOccurred_ = true;
            printStream.println("Unexpected exception");
            printStream.println("Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.exceptionOccurred_ = true;
            printStream.println("NoClassDefFoundError " + noClassDefFoundError);
            if (this.printStackTrace_) {
                noClassDefFoundError.printStackTrace(printStream);
            }
            return null;
        }
    }

    private String getXACodeInfo(XAException xAException) {
        int n = xAException.errorCode;
        switch (n) {
            case 7: {
                return "XA_HEURCOM : The transaction branch has been heuristically committed.";
            }
            case 8: {
                return "XA_HEURHAZ : The transaction branch may have been heuristically completed.";
            }
            case 5: {
                return "XA_HEURMIX : The transaction branch has been heuristically committed and rolled back.";
            }
            case 6: {
                return "XA_HEURRB : The transaction branch has been heuristically rolled back.";
            }
            case 9: {
                return "XA_NOMIGRATE : Resumption must occur where the suspension occurred.";
            }
            case 101: {
                return "XA_RBCOMMFAIL : Indicates that the rollback was caused by a communication failure.";
            }
            case 102: {
                return "XA_RBDEADLOCK : A deadlock was detected.";
            }
            case 103: {
                return "XA_RBINTEGRITY : A condition that violates the integrity of the resource was detected.";
            }
            case 104: {
                return "XA_RBOTHER : The resource manager rolled back the transaction branch for a reason not on this list.";
            }
            case 105: {
                return "XA_RBPROTO : A protocol error occurred in the resource manager.";
            }
            case 100: {
                return "XA_RBROLLBACK : Indicates that the rollback was caused by an unspecified reason.";
            }
            case 106: {
                return "XA_RBTIMEOUT : A transaction branch took too long.";
            }
            case 107: {
                return "XA_RBTRANSIENT : May retry the transaction branch.";
            }
            case 3: {
                return "XA_RDONLY : The transaction branch was read-only and has been committed.";
            }
            case 4: {
                return "XA_RETRY : Routine returned with no effect and may be reissued.";
            }
            case -2: {
                return "XAER_ASYNC : There is an asynchronous operation already outstanding.";
            }
            case -8: {
                return "XAER_DUPID : The XID already exists.";
            }
            case -5: {
                return "XAER_INVAL : Invalid arguments were given.";
            }
            case -4: {
                return "XAER_NOTA : The XID is not valid.";
            }
            case -9: {
                return "XAER_OUTSIDE : The resource manager is doing work outside a global transaction.";
            }
            case -6: {
                return "XAER_PROTO : Routine was invoked in an improper context.";
            }
            case -3: {
                return "XAER_RMERR : A resource manager error has occurred in the transaction branch.";
            }
            case -7: {
                return "XAER_RMFAIL : Resource manager is unavailable.";
            }
        }
        return "" + n;
    }

    public static void printStackTraceToStringBuffer(Throwable throwable, StringBuffer stringBuffer) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string = stringWriter.toString();
        stringBuffer.append(string);
    }

    private Object callNewMethod(String string, PrintStream printStream) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            Object var5_7 = null;
            int n = string.indexOf("(");
            if (n > 0) {
                String string2 = string.substring(0, n).trim();
                Class<?> clazz = null;
                string = string.substring(n + 1);
                try {
                    clazz = Class.forName(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clazz != null) {
                    if (n > 0) {
                        Constructor<?>[] constructorArray = clazz.getConstructors();
                        for (int i = 0; !bl && i < constructorArray.length && var5_7 == null; ++i) {
                            Class<?>[] classArray = constructorArray[i].getParameterTypes();
                            String string3 = string;
                            Object[] objectArray = new Object[classArray.length];
                            bl = true;
                            String string4 = "(";
                            for (int j = 0; j < classArray.length; ++j) {
                                int n2;
                                int n3;
                                Object[] objectArray2;
                                int n4;
                                int n5;
                                String string5;
                                int n6 = 0;
                                int n7 = 0;
                                int n8 = 0;
                                if (string3.length() > 1 && string3.charAt(0) == '\"') {
                                    n6 = 1;
                                    n7 = string3.indexOf(34, 1);
                                    if (n7 > 0) {
                                        if (string3.charAt(n7 + 1) == ',' || string3.charAt(n7 + 1) == ')') {
                                            n8 = n7 + 2;
                                        } else {
                                            stringBuffer.append("[,)] does not follow \n");
                                            n7 = -1;
                                        }
                                    }
                                } else {
                                    n7 = string3.indexOf(",");
                                    if (n7 < 0) {
                                        n7 = string3.indexOf(")");
                                    }
                                    if (n7 >= 0) {
                                        n8 = n7 + 1;
                                    }
                                }
                                if (n7 < 0) {
                                    bl = false;
                                    stringBuffer.append("Unable to find arg in " + string3 + "\n");
                                    continue;
                                }
                                String string6 = string3.substring(n6, n7).trim();
                                string3 = string3.substring(n8);
                                String string7 = classArray[j].getName();
                                if (j > 0) {
                                    string4 = string4 + ",";
                                }
                                string4 = string4 + string7;
                                Object v = this.variables.get(string6);
                                if (v != null) {
                                    objectArray[j] = v;
                                    continue;
                                }
                                if (string6.equals("null")) {
                                    objectArray[j] = null;
                                    continue;
                                }
                                if (string7.equals("java.lang.String")) {
                                    objectArray[j] = string6;
                                    continue;
                                }
                                if (string7.equals("int")) {
                                    try {
                                        objectArray[j] = new Integer(string6);
                                    }
                                    catch (Exception exception) {
                                        stringBuffer.append("Could not parse " + string6 + " as integer\n");
                                        bl = false;
                                    }
                                    continue;
                                }
                                if (string7.equals("boolean")) {
                                    try {
                                        objectArray[j] = new Boolean(string6);
                                    }
                                    catch (Exception exception) {
                                        stringBuffer.append("Could not parse " + string6 + " as integer\n");
                                        bl = false;
                                    }
                                    continue;
                                }
                                if (string7.equals("long")) {
                                    try {
                                        objectArray[j] = new Long(string6);
                                    }
                                    catch (Exception exception) {
                                        stringBuffer.append("Could not parse " + string6 + " as long\n");
                                        bl = false;
                                    }
                                    continue;
                                }
                                if (string7.equals("[Ljava.lang.String;")) {
                                    if (string6.charAt(0) == '[') {
                                        string5 = string6.substring(1);
                                        n5 = string5.length();
                                        n4 = 1;
                                        for (int k = 0; k < n5; ++k) {
                                            if (string5.charAt(k) != '+') continue;
                                            ++n4;
                                        }
                                        objectArray[j] = objectArray2 = new String[n4];
                                        int n9 = 0;
                                        n3 = 0;
                                        n2 = string5.indexOf(43, n3);
                                        if (n2 < 0) {
                                            n2 = string5.indexOf(93, n3);
                                        }
                                        while (n2 > 0) {
                                            if (n9 < n4) {
                                                objectArray2[n9] = string5.substring(n3, n2);
                                                ++n9;
                                            }
                                            if ((n3 = n2 + 1) >= n5) {
                                                n2 = -1;
                                                continue;
                                            }
                                            n2 = string5.indexOf(43, n3);
                                            if (n2 >= 0) continue;
                                            n2 = string5.indexOf(93, n3);
                                        }
                                        continue;
                                    }
                                    stringBuffer.append("Could not parse " + string6 + " as String array .. try [A+B+C]\n");
                                    bl = false;
                                    continue;
                                }
                                if (string7.equals("[I")) {
                                    if (string6.charAt(0) == '[') {
                                        string5 = string6.substring(1);
                                        n5 = string5.length();
                                        n4 = 1;
                                        for (int k = 0; k < n5; ++k) {
                                            if (string5.charAt(k) != '+') continue;
                                            ++n4;
                                        }
                                        objectArray[j] = objectArray2 = (Object[])new int[n4];
                                        String string8 = "";
                                        try {
                                            n3 = 0;
                                            n2 = 0;
                                            int n10 = string5.indexOf(43, n2);
                                            if (n10 < 0) {
                                                n10 = string5.indexOf(93, n2);
                                            }
                                            while (n10 > 0) {
                                                if (n3 < n4) {
                                                    objectArray2[n3] = (String)Integer.parseInt(string5.substring(n2, n10));
                                                    ++n3;
                                                }
                                                if ((n2 = n10 + 1) >= n5) {
                                                    n10 = -1;
                                                    continue;
                                                }
                                                n10 = string5.indexOf(43, n2);
                                                if (n10 >= 0) continue;
                                                n10 = string5.indexOf(93, n2);
                                            }
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            stringBuffer.append("Exception " + exception + " piece = " + string8 + "\n");
                                            stringBuffer.append("Could not parse " + string6 + " as Integer.. try [1+2+3]\n");
                                            bl = false;
                                            continue;
                                        }
                                    }
                                    stringBuffer.append("Could not parse " + string6 + " as Integer.. try [1+2+3\n]");
                                    bl = false;
                                    continue;
                                }
                                stringBuffer.append("Did not handle parameter with class " + string7);
                                bl = false;
                            }
                            string4 = string4 + ")";
                            if (!bl) continue;
                            if (string3.trim().equals(")") || string3.trim().length() == 0) {
                                try {
                                    var5_7 = constructorArray[i].newInstance(objectArray);
                                    bl = true;
                                }
                                catch (Exception exception) {
                                    stringBuffer.append("Exception " + exception + "\n");
                                    if (this.printStackTrace_) {
                                        Main.printStackTraceToStringBuffer(exception, stringBuffer);
                                    }
                                    for (Throwable throwable = exception.getCause(); throwable != null; throwable = throwable.getCause()) {
                                        stringBuffer.append("..Caused by " + throwable + "\n");
                                        if (!this.printStackTrace_) continue;
                                        Main.printStackTraceToStringBuffer(throwable, stringBuffer);
                                    }
                                    stringBuffer.append("Creating object  with " + string4 + " failed\n");
                                    bl = false;
                                }
                                continue;
                            }
                            stringBuffer.append("Not calling constructor  with " + string4 + " because argsLeft = " + string3 + "\n");
                            bl = false;
                        }
                    } else {
                        stringBuffer.append("ERROR:  could find ( in " + string + "\n");
                    }
                } else {
                    stringBuffer.append("ERROR:  could not find variable or class " + string2 + "\n");
                }
            } else {
                stringBuffer.append("ERROR:  could find ( in " + string + "\n");
            }
            if (!bl) {
                printStream.println("Unable to call method: Possible errors are the following\n" + stringBuffer.toString());
            }
            return var5_7;
        }
        catch (Exception exception) {
            printStream.println("Unexpected exception");
            printStream.println("Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            printStream.println("NoClassDefFoundError " + noClassDefFoundError);
            if (this.printStackTrace_) {
                noClassDefFoundError.printStackTrace(printStream);
            }
            return null;
        }
    }

    private void showValidVariables(PrintStream printStream) {
        printStream.println("Valid variables are the following");
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            printStream.println(enumeration.nextElement());
        }
    }

    private void showMethods(String string, PrintStream printStream) {
        String string2 = string.trim();
        Object v = this.variables.get(string2);
        Class<?> clazz = null;
        if (v == null) {
            try {
                clazz = Class.forName(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v != null || clazz != null) {
            String string3;
            Method[] methodArray = v != null ? v.getClass().getMethods() : (clazz != null ? clazz.getMethods() : new Method[]{});
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?> clazz2 = methodArray[i].getReturnType();
                string3 = methodArray[i].getName();
                String string4 = clazz2 != null ? " @RETURNS " + clazz2.getName() : " @RETURNS void";
                Class<?>[] classArray = methodArray[i].getParameterTypes();
                string3 = string3 + "(";
                for (int j = 0; j < classArray.length; ++j) {
                    String string5 = classArray[j].getName();
                    if (j > 0) {
                        string3 = string3 + ",";
                    }
                    string3 = string3 + string5;
                }
                string3 = string3 + ")" + string4;
                vector.addElement(string3);
            }
            Collections.sort(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                int n = string3.indexOf(" @RETURNS ");
                if (n > 0) {
                    printStream.println(string3.substring(n + 10) + " " + string3.substring(0, n));
                    continue;
                }
                printStream.println(string3);
            }
        } else {
            printStream.println("Could not find variable " + string2);
            this.showValidVariables(printStream);
        }
    }

    private static String[] dispColumnHeadings(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("<table border>\n");
        }
        String[] stringArray = new String[n + 1];
        for (int i = 1; i <= n; ++i) {
            stringArray[i] = resultSetMetaData.getColumnLabel(i);
            if (bl2) {
                stringBuffer.append("<th>" + stringArray[i].replace('_', ' '));
                continue;
            }
            if (bl3) continue;
            if (i > 1) {
                stringBuffer.append(",");
            }
            Main.appendUnicodeString(stringBuffer, stringArray[i], 65535, 65535, true, bl4);
        }
        if (bl2) {
            stringBuffer.append("<tr>\n");
        }
        if (bl3) {
            stringBuffer.append("<table>");
            if (!bl5) {
                printStream.println(stringBuffer.toString());
            }
        } else {
            stringBuffer.append("");
            if (!bl5) {
                printStream.println(stringBuffer.toString());
            }
        }
        return stringArray;
    }

    private static void dispRow(PrintStream printStream, ResultSet resultSet, boolean bl, int n, int[] nArray, String[] stringArray, String[] stringArray2, boolean bl2, boolean bl3, int n2, int n3, boolean bl4, boolean bl5, boolean bl6) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append("<row>\n");
        }
        for (int i = 1; i <= n; ++i) {
            if (bl3) {
                stringBuffer.append("<td>");
            } else if (bl2) {
                stringBuffer.append("   <" + stringArray[i] + ">");
            } else if (i > 1) {
                stringBuffer.append(",");
            }
            switch (nArray[i]) {
                case 2004: {
                    int n4;
                    Object object = resultSet.getBlob(i);
                    if (object != null && object.getClass().getName().equals("com.ibm.db2.jdbc.app.DB2BlobLocator")) {
                        try {
                            n4 = ReflectionUtil.callMethod_I(object, "getLocator");
                            stringBuffer.append("L#" + n4 + ":");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                case -8: 
                case -4: 
                case -3: 
                case -2: {
                    int n4;
                    Object object = resultSet.getBytes(i);
                    if (object == null) {
                        stringBuffer.append(resultSet.getString(i));
                        break;
                    }
                    if (((Object)object).length < n2) {
                        for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                            int n5 = object[n4] & 0xFF;
                            if (n5 >= 16) {
                                stringBuffer.append(Integer.toHexString(n5));
                                continue;
                            }
                            stringBuffer.append("0" + Integer.toHexString(n5));
                        }
                        break;
                    }
                    CRC32 cRC32 = new CRC32();
                    cRC32.update((byte[])object);
                    stringBuffer.append("ARRAY[size=" + ((Object)object).length + ",CRC32=" + cRC32.getValue() + "]");
                    break;
                }
                default: {
                    String string = resultSet.getString(i);
                    if (bl && string != null) {
                        string = string.trim();
                    }
                    if (stringArray2 != null && i - 1 < stringArray2.length && stringArray2[i - 1] != null) {
                        string = Main.formatString(string, stringArray2[i - 1]);
                    }
                    Main.appendUnicodeString(stringBuffer, string, n2, n3, bl4, bl5);
                }
            }
            if (!bl2) continue;
            stringBuffer.append("</" + stringArray[i] + ">\n");
        }
        if (bl3) {
            if (!bl6) {
                printStream.println(stringBuffer.toString() + "<tr>");
            }
        } else if (bl2) {
            if (!bl6) {
                printStream.println(stringBuffer.toString() + "</row>");
            }
        } else if (!bl6) {
            printStream.println(stringBuffer.toString());
        }
    }

    private static String stripTS(String string) {
        string = string.replace(' ', '-');
        int n = (string = string.replace(':', '.')).indexOf(".000000");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private static String formatString(String string, String string2) {
        if (string2 != null) {
            int n = string2.indexOf("{STUFF}");
            if (n > 0) {
                return Main.formatString(string, string2.substring(0, n)) + string + Main.formatString(string, string2.substring(n + 7));
            }
            if (n == 0) {
                return string + Main.formatString(string, string2.substring(n + 7));
            }
            n = string2.indexOf("{STRIPPEDTS}");
            if (n > 0) {
                return Main.formatString(string, string2.substring(0, n)) + Main.stripTS(string) + Main.formatString(string, string2.substring(n + 12));
            }
            if (n == 0) {
                return Main.stripTS(string) + Main.formatString(string, string2.substring(n + 12));
            }
            n = string2.indexOf("{PART");
            if (n >= 0) {
                int n2 = string2.indexOf("}", n);
                int n3 = n2 - n + 1;
                int n4 = string2.charAt(n + 5) - 48;
                String string3 = string2.substring(n + 9, n2);
                String string4 = Main.getNthItem(string, string3, n4);
                if (n > 0) {
                    return Main.formatString(string, string2.substring(0, n)) + string4 + Main.formatString(string, string2.substring(n + n3));
                }
                return string4 + Main.formatString(string, string2.substring(n + n3));
            }
            return string2;
        }
        return string;
    }

    private static String getNthItem(String string, String string2, int n) {
        String string3 = string;
        int n2 = string2.length();
        int n3 = string3.indexOf(string2);
        int n4 = 1;
        while (n3 > 0) {
            if (n4 == n) {
                return string3.substring(0, n3);
            }
            string3 = string3.substring(n3 + n2);
            n3 = string3.indexOf(string2);
            ++n4;
        }
        return string3;
    }

    public static void dispResultSet(ResultSet resultSet) throws SQLException {
        Main.dispResultSet(defaultOutput, resultSet, false, null, false, false, 16384, 16384, true, true, false, false);
    }

    void dispResultSet(PrintStream printStream, ResultSet resultSet, boolean bl) throws SQLException {
        Main.dispResultSet(printStream, resultSet, bl, null, this.xml_, this.html_, this.showLobThreshold_, this.stringSampleSize_, this.characterDetails_, this.showMixedUX_, this.hideWarnings_, this.silentrs_);
    }

    static void dispResultSet(PrintStream printStream, ResultSet resultSet, boolean bl, String[] stringArray, boolean bl2, boolean bl3, int n, int n2, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        String[] stringArray2 = Main.dispColumnHeadings(printStream, resultSet, resultSetMetaData, bl, n3, bl2, bl3, bl5, bl7);
        int[] nArray = new int[n3 + 1];
        for (int i = 1; i <= n3; ++i) {
            nArray[i] = resultSetMetaData.getColumnType(i);
        }
        boolean bl8 = resultSet.next();
        while (bl8) {
            Main.dispRow(printStream, resultSet, bl, n3, nArray, stringArray2, stringArray, bl2, bl3, n, n2, bl4, bl5, bl7);
            SQLWarning sQLWarning = resultSet.getWarnings();
            if (!bl7 && sQLWarning != null) {
                Main.dispWarning(printStream, sQLWarning, bl6, bl3);
            }
            bl8 = resultSet.next();
        }
        if (!bl7) {
            if (bl3) {
                printStream.println("</table>");
            }
            if (bl2) {
                printStream.println("</table>");
            }
        }
    }

    private static void dispWarning(PrintStream printStream, SQLWarning sQLWarning, boolean bl, boolean bl2) {
        if (bl) {
            return;
        }
        if (sQLWarning != null) {
            printStream.println("\n *** Warning ***\n");
            if (bl2) {
                printStream.println("<br>");
            }
            while (sQLWarning != null) {
                printStream.println("SQLState: " + sQLWarning.getSQLState());
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("Message:  " + Main.cleanupMessage(sQLWarning.getMessage()));
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("Vendor:   " + sQLWarning.getErrorCode());
                if (bl2) {
                    printStream.println("<br>");
                }
                printStream.println("");
                if (bl2) {
                    printStream.println("<br>");
                }
                sQLWarning = sQLWarning.getNextWarning();
            }
        }
    }

    private static String cleanupMessage(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            bl = true;
            cArray[i] = 42;
        }
        if (!bl) {
            return string;
        }
        return new String(cArray);
    }

    private void printArray(PrintStream printStream, java.sql.Array array) throws SQLException {
        if (array == null) {
            printStream.print("nullArray");
        } else {
            Object[] objectArray = (Object[])array.getArray();
            if (objectArray == null) {
                printStream.print("XXXX_null_returned_from_outArray.getArray");
            } else {
                String string = objectArray.getClass().getComponentType().getName();
                printStream.print(string + "[" + objectArray.length + "]=[");
                for (int i = 0; i < objectArray.length; ++i) {
                    long l;
                    Object object;
                    if (i > 0) {
                        printStream.print(",");
                    }
                    if (objectArray[i] == null) {
                        printStream.print("null");
                        continue;
                    }
                    if (string.equals("[B")) {
                        printStream.print(StringFormatUtil.dumpBytes((byte[])objectArray[i]));
                        continue;
                    }
                    if (objectArray[i] instanceof Blob) {
                        object = (Blob)objectArray[i];
                        l = object.length();
                        printStream.print(StringFormatUtil.dumpBytes(object.getBytes(1L, (int)l)));
                        continue;
                    }
                    if (objectArray[i] instanceof Clob) {
                        object = (Clob)objectArray[i];
                        l = object.length();
                        printStream.print(object.getSubString(1L, (int)l));
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        this.printUnicodeString(printStream, (String)objectArray[i]);
                        continue;
                    }
                    printStream.print(objectArray[i].toString());
                }
                printStream.print("]");
            }
        }
    }

    private void printUnicodeString(PrintStream printStream, String string) {
        int n;
        if (string != null && (n = string.length()) > this.showLobThreshold_) {
            printStream.print("CHARARRAY[size=" + n + ",CRC32=" + Main.getCRC32(string) + "]->");
            if (!this.characterDetails_) {
                string = string.substring(0, this.stringSampleSize_);
            }
        }
        if (string != null) {
            int n2;
            char[] cArray = string.toCharArray();
            boolean bl = false;
            for (n2 = 0; !bl && n2 < cArray.length; ++n2) {
                if (cArray[n2] == '\r' || cArray[n2] == '\n' || cArray[n2] == '\t' || cArray[n2] < '\u007f' && cArray[n2] >= ' ') continue;
                bl = true;
            }
            if (!bl) {
                printStream.print(string);
            } else if (this.showMixedUX_) {
                this.showMixedUXOutput(printStream, cArray);
            } else {
                printStream.print("U'");
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    int n3 = cArray[n2] & 0xFFFF;
                    if (n3 > 65280 && n3 < 65375 || n3 == 12288) {
                        if (n3 == 12288) {
                            printStream.print("| ");
                            continue;
                        }
                        printStream.print('|');
                        printStream.print((char)(n3 - 65248));
                        continue;
                    }
                    String string2 = Integer.toHexString(n3);
                    if (n3 >= 4096) {
                        printStream.print(string2);
                        continue;
                    }
                    if (n3 >= 256) {
                        printStream.print("0" + string2);
                        continue;
                    }
                    if (n3 >= 16) {
                        printStream.print("00" + string2);
                        continue;
                    }
                    printStream.print("000" + string2);
                }
                printStream.print("'");
            }
        } else {
            printStream.print(string);
        }
    }

    private static void appendUnicodeString(StringBuffer stringBuffer, String string, int n, int n2, boolean bl, boolean bl2) {
        int n3;
        if (string != null && (n3 = string.length()) > n) {
            stringBuffer.append("CHARARRAY[size=" + n3 + ",CRC32=" + Main.getCRC32(string) + "]->");
            if (!bl) {
                string = string.substring(0, n2);
            }
        }
        if (string != null) {
            int n4;
            char[] cArray = string.toCharArray();
            boolean bl3 = false;
            for (n4 = 0; !bl3 && n4 < cArray.length; ++n4) {
                if (cArray[n4] == '\r' || cArray[n4] == '\n' || cArray[n4] == '\t' || cArray[n4] < '\u007f' && cArray[n4] >= ' ') continue;
                bl3 = true;
            }
            if (!bl3) {
                stringBuffer.append(string);
            } else if (bl2) {
                Main.appendMixedUXOutput(stringBuffer, cArray);
            } else {
                stringBuffer.append("U'");
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    int n5 = cArray[n4] & 0xFFFF;
                    if (n5 > 65280 && n5 < 65375 || n5 == 12288) {
                        if (n5 == 12288) {
                            stringBuffer.append("| ");
                            continue;
                        }
                        stringBuffer.append('|');
                        stringBuffer.append((char)(n5 - 65248));
                        continue;
                    }
                    String string2 = Integer.toHexString(n5);
                    if (n5 >= 4096) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    if (n5 >= 256) {
                        stringBuffer.append("0" + string2);
                        continue;
                    }
                    if (n5 >= 16) {
                        stringBuffer.append("00" + string2);
                        continue;
                    }
                    stringBuffer.append("000" + string2);
                }
                stringBuffer.append("'");
            }
        } else {
            stringBuffer.append(string);
        }
    }

    public void showMixedUXOutput(PrintStream printStream, char[] cArray) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i] & 0xFFFF;
            if (n == 10 || n >= 32 && n < 127) {
                if (bl) {
                    printStream.print("''");
                    bl = false;
                }
                printStream.print(cArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                printStream.print("UX''");
            }
            String string = Integer.toHexString(n);
            if (n >= 4096) {
                printStream.print(string);
                continue;
            }
            if (n >= 256) {
                printStream.print("0" + string);
                continue;
            }
            if (n >= 16) {
                printStream.print("00" + string);
                continue;
            }
            printStream.print("000" + string);
        }
        if (bl) {
            printStream.print("''");
        }
    }

    public static void appendMixedUXOutput(StringBuffer stringBuffer, char[] cArray) {
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray[i] & 0xFFFF;
            if (n == 10 || n >= 32 && n < 127) {
                if (bl) {
                    stringBuffer.append("''");
                    bl = false;
                }
                stringBuffer.append(cArray[i]);
                continue;
            }
            if (!bl) {
                bl = true;
                stringBuffer.append("UX''");
            }
            String string = Integer.toHexString(n);
            if (n >= 4096) {
                stringBuffer.append(string);
                continue;
            }
            if (n >= 256) {
                stringBuffer.append("0" + string);
                continue;
            }
            if (n >= 16) {
                stringBuffer.append("00" + string);
                continue;
            }
            stringBuffer.append("000" + string);
        }
        if (bl) {
            stringBuffer.append("''");
        }
    }

    public Object getParameterObject(String string, PrintStream printStream) {
        if (string.indexOf("UX'") == 0) {
            String string2;
            block24: {
                int n = string.length();
                if ((string = string.substring(3, n - 1)).indexOf("null") >= 0) {
                    return null;
                }
                string2 = null;
                try {
                    char[] cArray = new char[(n -= 4) / 4];
                    for (int i = 0; i < cArray.length; ++i) {
                        String string3 = string.substring(i * 4, i * 4 + 4);
                        cArray[i] = (char)Integer.parseInt(string3, 16);
                    }
                    string2 = new String(cArray);
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block24;
                    exception.printStackTrace(printStream);
                }
            }
            return string2;
        }
        if (string.indexOf("X'") == 0) {
            byte[] byArray;
            block25: {
                int n = string.length();
                if ((string = string.substring(2, n - 1)).indexOf("null") >= 0) {
                    return null;
                }
                byArray = null;
                try {
                    byArray = new byte[(n -= 3) / 2];
                    for (int i = 0; i < byArray.length; ++i) {
                        String string4 = string.substring(i * 2, i * 2 + 2);
                        byArray[i] = (byte)Integer.parseInt(string4, 16);
                    }
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block25;
                    exception.printStackTrace(printStream);
                }
            }
            return byArray;
        }
        if (string.indexOf("FILEBLOB=") == 0) {
            ClientBlob clientBlob;
            block26: {
                clientBlob = null;
                try {
                    String string5 = string.substring(9).trim();
                    byte[] byArray = null;
                    File file = new File(string5);
                    int n = (int)file.length();
                    byArray = new byte[n];
                    FileInputStream fileInputStream = new FileInputStream(string5);
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    clientBlob = new ClientBlob(byArray);
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed because of " + exception);
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block26;
                    exception.printStackTrace(printStream);
                }
            }
            return clientBlob;
        }
        if (string.indexOf("FILECLOB=") == 0) {
            ClientClob clientClob;
            block27: {
                clientClob = null;
                try {
                    String string6 = string.substring(9).trim();
                    char[] cArray = null;
                    File file = new File(string6);
                    int n = (int)file.length();
                    cArray = new char[n];
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));
                    bufferedReader.read(cArray, 0, n);
                    clientClob = new ClientClob(new String(cArray));
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed because of " + exception);
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block27;
                    exception.printStackTrace(printStream);
                }
            }
            return clientClob;
        }
        if (string.indexOf("SAVEDPARM=") == 0) {
            printStream.println("ERROR:  SAVEDPARM not supported yet");
        } else if (string.indexOf("SQLARRAY[") == 0) {
            printStream.println("ERROR:  SQLARRAY not supported yet");
        } else {
            if (string.indexOf("GEN_BYTE_ARRAY+") == 0) {
                return this.getGenByteArrayParm(string, printStream);
            }
            if (string.indexOf("GEN_HEX_STRING+") == 0) {
                printStream.println("ERROR:  GEN_HEX_STRING+ not supported yet");
            } else if (string.indexOf("GEN_CHAR_ARRAY+") == 0) {
                printStream.println("ERROR:  GEN_CHAR_ARRAY+ not supported yet");
            }
        }
        return string;
    }

    public void setParameter(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        if (string.indexOf("UX'") == 0) {
            this.handleUnicodeStringParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("X'") == 0) {
            this.handleByteArrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("FILEBLOB=") == 0) {
            this.handleFileBlobParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("FILECLOB=") == 0) {
            this.handleFileClobParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("SAVEDPARM=") == 0) {
            this.handleSavedParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("SQLARRAY[") == 0) {
            this.handleSqlarrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_BYTE_ARRAY+") == 0) {
            this.handleGenByteArrayParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_HEX_STRING+") == 0) {
            this.handleGenHexStringParm(preparedStatement, string, n, printStream);
        } else if (string.indexOf("GEN_CHAR_ARRAY+") == 0) {
            Object object;
            int n2;
            String string2;
            block31: {
                string2 = null;
                n2 = -1;
                try {
                    object = null;
                    String string3 = null;
                    int n3 = -1;
                    int n4 = -1;
                    String string4 = string.substring(15).trim();
                    n4 = string4.indexOf("C");
                    object = string4.substring(0, n4);
                    string3 = string4.substring(n4 + 1).trim();
                    n2 = Integer.parseInt((String)object);
                    n3 = Integer.parseInt(string3);
                    char[] cArray = new char[]{'a', 'b', 'c', 'd'};
                    char[] cArray2 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                    char[] cArray3 = new char[]{'\u3055', '\u31ff', '\u3066'};
                    char[] cArray4 = new char[]{'\u00c0', '\u35c0', '\ub5a0', '\u3055', '\u31ff', '\u3066'};
                    char[] cArray5 = new char[]{'\u5e03', '\u5f17', '\u672b', '\u5378', '\u59cb', '\u8679', '\u500c', '\u89f4', '\u9853', '\u8271', '\u8f44', '\u977e', '\u52f1'};
                    char[] cArray6 = new char[n2];
                    char[] cArray7 = new char[n2];
                    switch (n3) {
                        case 37: {
                            cArray6 = cArray;
                            break;
                        }
                        case 835: {
                            cArray6 = cArray5;
                            break;
                        }
                        case 1200: {
                            cArray6 = cArray4;
                            break;
                        }
                        case 1208: {
                            cArray6 = cArray2;
                            break;
                        }
                        case 13488: {
                            cArray6 = cArray3;
                        }
                    }
                    for (int i = 0; i < n2; ++i) {
                        cArray7[i] = cArray6[i % cArray6.length];
                    }
                    string2 = new String(cArray7);
                }
                catch (Exception exception) {
                    printStream.println("Processing of " + string + " failed");
                    printStream.println("Exception " + exception);
                    if (!this.printStackTrace_) break block31;
                    exception.printStackTrace(printStream);
                }
            }
            preparedStatement.setString(n, string2);
            printStream.println("CHARARRAY[size=" + n2 + ",CRC32=" + Main.getCRC32(string2) + ",CRC32xor1=" + this.getCRC32xor1(string2) + "]");
            object = preparedStatement.getWarnings();
            if (object != null && !this.silent_) {
                Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
            }
        } else {
            if (string.indexOf("'") == 0) {
                int n5 = string.indexOf("'", 1);
                string = n5 > 0 ? string.substring(1, n5) : string.substring(1);
            }
            preparedStatement.setString(n, string);
            SQLWarning sQLWarning = preparedStatement.getWarnings();
            if (sQLWarning != null && !this.silent_) {
                Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
            }
        }
    }

    static String getCRC32(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byArray[2 * i + 1] = (byte)(c & 0xFF);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return "" + cRC32.getValue();
    }

    String getCRC32xor1(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[2 * n];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[2 * i] = (byte)((c & 0xFF00) >> 16);
            byArray[2 * i + 1] = byArray[2 * i] == -40 ? (byte)(c & 0xFF) : (byte)((c ^ '\u0001') & 0xFF);
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return "" + cRC32.getValue();
    }

    void handleUnicodeStringParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        String string2 = (String)this.getParameterObject(string, printStream);
        preparedStatement.setString(n, string2);
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent_) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    void handleByteArrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        byte[] byArray = (byte[])this.getParameterObject(string, printStream);
        preparedStatement.setBytes(n, byArray);
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent_) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    byte[] getGenByteArrayParm(String string, PrintStream printStream) {
        byte[] byArray;
        block3: {
            byArray = null;
            try {
                String string2 = string.substring(15);
                int n = Integer.parseInt(string2);
                byArray = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)(i & 0xFF);
                }
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                printStream.println("Exception " + exception);
                if (!this.printStackTrace_) break block3;
                exception.printStackTrace(printStream);
            }
        }
        return byArray;
    }

    void handleGenByteArrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        byte[] byArray = this.getGenByteArrayParm(string, printStream);
        preparedStatement.setBytes(n, byArray);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        printStream.println("GEN_BYTE_ARRAY generated array of size = " + byArray.length + " with checksum of " + cRC32.getValue());
    }

    void handleSavedParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Object object;
        int n2;
        block3: {
            n2 = 0;
            try {
                object = string.substring(10);
                n2 = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                printStream.println("Processing of " + string + " failed");
                printStream.println("Exception " + exception);
                if (!this.printStackTrace_) break block3;
                exception.printStackTrace(printStream);
            }
        }
        preparedStatement.setString(n, this.savedStringParm_[n2]);
        printStream.println("SAVEDPARM set(" + n + "," + this.savedStringParm_[n2] + " from saved " + n2);
        object = preparedStatement.getWarnings();
        if (object != null && !this.silent_) {
            Main.dispWarning(printStream, (SQLWarning)object, this.hideWarnings_, this.html_);
        }
    }

    static void appendDigit(StringBuffer stringBuffer, int n) {
        switch (n) {
            case 0: {
                stringBuffer.append('0');
                break;
            }
            case 1: {
                stringBuffer.append('1');
                break;
            }
            case 2: {
                stringBuffer.append('2');
                break;
            }
            case 3: {
                stringBuffer.append('3');
                break;
            }
            case 4: {
                stringBuffer.append('4');
                break;
            }
            case 5: {
                stringBuffer.append('5');
                break;
            }
            case 6: {
                stringBuffer.append('6');
                break;
            }
            case 7: {
                stringBuffer.append('7');
                break;
            }
            case 8: {
                stringBuffer.append('8');
                break;
            }
            case 9: {
                stringBuffer.append('9');
                break;
            }
            case 10: {
                stringBuffer.append('a');
                break;
            }
            case 11: {
                stringBuffer.append('b');
                break;
            }
            case 12: {
                stringBuffer.append('c');
                break;
            }
            case 13: {
                stringBuffer.append('d');
                break;
            }
            case 14: {
                stringBuffer.append('e');
                break;
            }
            case 15: {
                stringBuffer.append('f');
            }
        }
    }

    void handleGenHexStringParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Object object;
        StringBuffer stringBuffer = null;
        byte[] byArray = null;
        try {
            object = string.substring(15);
            int n2 = Integer.parseInt((String)object);
            stringBuffer = new StringBuffer(2 * n2);
            byArray = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray[i] = (byte)(i & 0xFF);
                Main.appendDigit(stringBuffer, (i & 0xF0) >> 4);
                Main.appendDigit(stringBuffer, i & 0xF);
            }
        }
        catch (Exception exception) {
            printStream.println("Processing of " + string + " failed");
            printStream.println("Exception " + exception);
            if (this.printStackTrace_) {
                exception.printStackTrace(printStream);
            }
            throw new SQLException("Unable to set HexString parameter");
        }
        preparedStatement.setString(n, stringBuffer.toString());
        object = new CRC32();
        object.update(byArray);
        printStream.println("GEN_BYTE_ARRAY generated array of size = " + byArray.length + " with checksum of " + ((CRC32)object).getValue());
        SQLWarning sQLWarning = preparedStatement.getWarnings();
        if (sQLWarning != null && !this.silent_) {
            Main.dispWarning(printStream, sQLWarning, this.hideWarnings_, this.html_);
        }
    }

    void handleFileBlobParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Blob blob = (Blob)this.getParameterObject(string, printStream);
        preparedStatement.setBlob(n, blob);
    }

    void handleFileClobParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        Clob clob = (Clob)this.getParameterObject(string, printStream);
        preparedStatement.setClob(n, clob);
    }

    public java.sql.Array makeArray(Object object, String string) throws Exception {
        Object[] objectArray = new Object[]{};
        Class[] classArray = new Class[]{"".getClass(), objectArray.getClass()};
        java.sql.Array array = (java.sql.Array)ReflectionUtil.callMethod_O(this.connection_, "createArrayOf", classArray, string, object);
        return array;
    }

    void handleSqlarrayParm(PreparedStatement preparedStatement, String string, int n, PrintStream printStream) throws SQLException {
        block95: {
            try {
                String string2 = string.substring(9).trim();
                int n2 = string2.indexOf(":");
                boolean bl = false;
                if (n2 == -1 && (n2 = string2.indexOf("]")) > 0) {
                    bl = true;
                }
                if (n2 > 0) {
                    String string3 = string2.substring(0, n2);
                    string2 = bl ? string2.substring(n2) : string2.substring(n2 + 1);
                    Vector<String> vector = new Vector<String>();
                    String string4 = ":";
                    if (string3.equals("Time")) {
                        string4 = " ";
                    }
                    if (string3.equals("Timestamp")) {
                        string4 = "|";
                    }
                    n2 = string2.indexOf(string4);
                    while (n2 >= 0) {
                        String string5 = string2.substring(0, n2);
                        vector.addElement(string5);
                        string2 = string2.substring(n2 + 1);
                        n2 = string2.indexOf(string4);
                    }
                    int n3 = string2.indexOf("]");
                    if (n3 >= 0) {
                        if (!bl) {
                            vector.addElement(string2.substring(0, n3));
                        }
                        int n4 = vector.size();
                        String string6 = "String:BigDecimal:Date:Time:Timestamp:Blob:Clob:int:short:long:float:double:byteArray";
                        if (string3.equals("String")) {
                            String[] stringArray = new String[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string7 = (String)vector.get(i);
                                if ("null".equals(string7)) {
                                    stringArray[i] = null;
                                    continue;
                                }
                                if (string7.indexOf("UX'") == 0) {
                                    int n5 = string7.length();
                                    char[] cArray = new char[(n5 -= 4) / 4];
                                    for (int j = 0; j < cArray.length; ++j) {
                                        String string8 = string7.substring(3 + j * 4, 3 + j * 4 + 4);
                                        cArray[j] = (char)Integer.parseInt(string8, 16);
                                    }
                                    stringArray[i] = new String(cArray);
                                    continue;
                                }
                                stringArray[i] = string7;
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(stringArray, "VARCHAR"));
                            } else {
                                preparedStatement.setObject(n, stringArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Clob")) {
                            Clob[] clobArray = new Clob[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string9 = (String)vector.get(i);
                                clobArray[i] = "null".equals(string9) ? null : new ClientClob(string9);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(clobArray, "CLOB"));
                            } else {
                                preparedStatement.setObject(n, clobArray);
                            }
                            break block95;
                        }
                        if (string3.equals("BigDecimal")) {
                            BigDecimal[] bigDecimalArray = new BigDecimal[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string10 = (String)vector.get(i);
                                bigDecimalArray[i] = "null".equals(string10) ? null : new BigDecimal(string10);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(bigDecimalArray, "DECIMAL"));
                            } else {
                                preparedStatement.setObject(n, bigDecimalArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Date")) {
                            Date[] dateArray = new Date[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string11 = (String)vector.get(i);
                                dateArray[i] = "null".equals(string11) ? null : Date.valueOf(string11);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(dateArray, "DATE"));
                            } else {
                                preparedStatement.setObject(n, dateArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Time")) {
                            Time[] timeArray = new Time[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string12 = (String)vector.get(i);
                                timeArray[i] = "null".equals(string12) ? null : Time.valueOf(string12);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(timeArray, "TIME"));
                            } else {
                                preparedStatement.setObject(n, timeArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Timestamp")) {
                            Timestamp[] timestampArray = new Timestamp[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string13 = (String)vector.get(i);
                                timestampArray[i] = "null".equals(string13) ? null : Timestamp.valueOf(string13);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(timestampArray, "TIMESTAMP"));
                            } else {
                                preparedStatement.setObject(n, timestampArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Integer")) {
                            Integer[] integerArray = new Integer[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string14 = (String)vector.get(i);
                                integerArray[i] = "null".equals(string14) ? null : new Integer(Integer.parseInt(string14));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(integerArray, "INTEGER"));
                            } else {
                                preparedStatement.setObject(n, integerArray);
                            }
                            break block95;
                        }
                        if (string3.equals("int")) {
                            int[] nArray = new int[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string15 = (String)vector.get(i);
                                nArray[i] = "null".equals(string15) ? 0 : Integer.parseInt(string15);
                            }
                            if (this.toolboxDriver_) {
                                Integer[] integerArray = new Integer[n4];
                                for (int i = 0; i < n4; ++i) {
                                    integerArray[i] = new Integer(nArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(integerArray, "INTEGER"));
                            } else {
                                preparedStatement.setObject(n, nArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Short")) {
                            Short[] shortArray = new Short[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string16 = (String)vector.get(i);
                                shortArray[i] = "null".equals(string16) ? null : new Short((short)Integer.parseInt(string16));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(shortArray, "SMALLINT"));
                            } else {
                                preparedStatement.setObject(n, shortArray);
                            }
                            break block95;
                        }
                        if (string3.equals("short")) {
                            short[] sArray = new short[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string17 = (String)vector.get(i);
                                sArray[i] = "null".equals(string17) ? (short)0 : (short)Integer.parseInt(string17);
                            }
                            if (this.toolboxDriver_) {
                                Short[] shortArray = new Short[n4];
                                for (int i = 0; i < n4; ++i) {
                                    shortArray[i] = new Short(sArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(shortArray, "SMALLINT"));
                            } else {
                                preparedStatement.setObject(n, sArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Long")) {
                            Long[] longArray = new Long[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string18 = (String)vector.get(i);
                                longArray[i] = "null".equals(string18) ? null : new Long(Long.parseLong(string18));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(longArray, "BIGINT"));
                            } else {
                                preparedStatement.setObject(n, longArray);
                            }
                            break block95;
                        }
                        if (string3.equals("long")) {
                            long[] lArray = new long[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string19 = (String)vector.get(i);
                                lArray[i] = "null".equals(string19) ? 0L : Long.parseLong(string19);
                            }
                            if (this.toolboxDriver_) {
                                Long[] longArray = new Long[n4];
                                for (int i = 0; i < n4; ++i) {
                                    longArray[i] = new Long(lArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(longArray, "BIGINT"));
                            } else {
                                preparedStatement.setObject(n, lArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Float")) {
                            Float[] floatArray = new Float[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string20 = (String)vector.get(i);
                                floatArray[i] = "null".equals(string20) ? null : new Float((float)Double.parseDouble(string20));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(floatArray, "REAL"));
                            } else {
                                preparedStatement.setObject(n, floatArray);
                            }
                            break block95;
                        }
                        if (string3.equals("float")) {
                            float[] fArray = new float[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string21 = (String)vector.get(i);
                                fArray[i] = "null".equals(string21) ? 0.0f : (float)Double.parseDouble(string21);
                            }
                            if (this.toolboxDriver_) {
                                Float[] floatArray = new Float[n4];
                                for (int i = 0; i < n4; ++i) {
                                    floatArray[i] = new Float(fArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(floatArray, "REAL"));
                            } else {
                                preparedStatement.setObject(n, fArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Double")) {
                            Double[] doubleArray = new Double[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string22 = (String)vector.get(i);
                                doubleArray[i] = "null".equals(string22) ? null : new Double(Double.parseDouble(string22));
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(doubleArray, "DOUBLE"));
                            } else {
                                preparedStatement.setObject(n, doubleArray);
                            }
                            break block95;
                        }
                        if (string3.equals("double")) {
                            double[] dArray = new double[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string23 = (String)vector.get(i);
                                dArray[i] = "null".equals(string23) ? 0.0 : Double.parseDouble(string23);
                            }
                            if (this.toolboxDriver_) {
                                Double[] doubleArray = new Double[n4];
                                for (int i = 0; i < n4; ++i) {
                                    doubleArray[i] = new Double(dArray[i]);
                                }
                                preparedStatement.setArray(n, this.makeArray(doubleArray, "DOUBLE"));
                            } else {
                                preparedStatement.setObject(n, dArray);
                            }
                            break block95;
                        }
                        if (string3.equals("byteArray")) {
                            byte[][] byArrayArray = new byte[n4][];
                            for (int i = 0; i < n4; ++i) {
                                String string24 = (String)vector.get(i);
                                if ("null".equals(string24)) {
                                    byArrayArray[i] = null;
                                    continue;
                                }
                                byte[] byArray = new byte[string24.length() / 2];
                                for (int j = 0; j < byArray.length; ++j) {
                                    String string25 = string24.substring(j * 2, j * 2 + 2);
                                    byArray[j] = (byte)Integer.parseInt(string25, 16);
                                }
                                byArrayArray[i] = byArray;
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(byArrayArray, "BINARY"));
                            } else {
                                preparedStatement.setObject(n, byArrayArray);
                            }
                            break block95;
                        }
                        if (string3.equals("Blob")) {
                            Blob[] blobArray = new Blob[n4];
                            for (int i = 0; i < n4; ++i) {
                                String string26 = (String)vector.get(i);
                                if ("null".equals(string26)) {
                                    blobArray[i] = null;
                                    continue;
                                }
                                byte[] byArray = new byte[string26.length() / 2];
                                for (int j = 0; j < byArray.length; ++j) {
                                    String string27 = string26.substring(j * 2, j * 2 + 2);
                                    byArray[j] = (byte)Integer.parseInt(string27, 16);
                                }
                                blobArray[i] = new ClientBlob(byArray);
                            }
                            if (this.toolboxDriver_) {
                                preparedStatement.setArray(n, this.makeArray(blobArray, "BLOB"));
                            } else {
                                preparedStatement.setObject(n, blobArray);
                            }
                            break block95;
                        }
                        if (string3.equalsIgnoreCase("null")) {
                            preparedStatement.setObject(n, null);
                            break block95;
                        }
                        throw new Exception("Type [" + string3 + "] not valid: valid types=" + string6);
                    }
                    throw new Exception("Unable to find ending brace for SQLARRAY[TYPE:e1:e2:...]");
                }
                throw new Exception("TYPE not found for SQLARRAY[TYPE:e1:e2:...]");
            }
            catch (Exception exception) {
                printStream.println("Processing of ARRAYPARAMETER '" + string + "' failed because of " + exception);
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                printStream.println("Exception " + exception);
                if (!this.printStackTrace_) break block95;
                exception.printStackTrace(printStream);
            }
        }
    }

    void addVariable(String string, Object object) {
        this.variables.put(string, object);
        if (string.equals("CON")) {
            this.connection_ = (Connection)object;
        } else if (string.equals("STMT")) {
            this.stmt_ = (Statement)object;
        } else if (string.equals("PSTMT")) {
            this.pstmt_ = (PreparedStatement)object;
        } else if (string.equals("CSTMT")) {
            this.cstmt_ = (CallableStatement)object;
        } else if (string.equals("RS")) {
            this.manualResultSet_ = (ResultSet)object;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(usage);
            System.exit(1);
        } else {
            try {
                Main main = stringArray.length == 1 ? new Main(stringArray[0], null, null) : (stringArray.length == 2 ? new Main(stringArray[0], stringArray[1], null) : new Main(stringArray[0], stringArray[1], stringArray[2]));
                int n = main.go(System.in, System.out);
                System.exit(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

