/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VMessage;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VMessageList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static String description_ = ResourceLoader.getText("MESSAGE_LIST_DESCRIPTION");
    private static Icon icon16_ = ResourceLoader.getIcon("VMessageList16.gif", description_);
    private static Icon icon32_ = ResourceLoader.getIcon("VMessageList32.gif", description_);
    private static String nameColumnHeader_ = ResourceLoader.getText("MESSAGE_ID");
    private static String textColumnHeader_ = ResourceLoader.getText("MESSAGE_TEXT");
    private static String typeColumnHeader_ = ResourceLoader.getText("MESSAGE_TYPE");
    private static String severityColumnHeader_ = ResourceLoader.getText("MESSAGE_SEVERITY");
    private AS400Message[] messageList_ = new AS400Message[0];
    private VNode parent_ = null;
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VObject[] detailsChildren_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VMessageList() {
        this.initializeTransient();
    }

    public VMessageList(AS400Message[] aS400MessageArray) {
        if (aS400MessageArray == null) {
            throw new NullPointerException("messageList");
        }
        this.messageList_ = aS400MessageArray;
        this.initializeTransient();
    }

    public VMessageList(VNode vNode, AS400Message[] aS400MessageArray) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400MessageArray == null) {
            throw new NullPointerException("messageList");
        }
        this.parent_ = vNode;
        this.messageList_ = aS400MessageArray;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public TreeNode getChildAt(int n) {
        return null;
    }

    public int getChildCount() {
        return 0;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public synchronized VObject getDetailsChildAt(int n) {
        if (n < 0 || n >= this.detailsChildren_.length) {
            return null;
        }
        return this.detailsChildren_[n];
    }

    public synchronized int getDetailsChildCount() {
        return this.detailsChildren_.length;
    }

    public synchronized int getDetailsIndex(VObject vObject) {
        for (int i = 0; i < this.detailsChildren_.length; ++i) {
            if (this.detailsChildren_[i] != vObject) continue;
            return i;
        }
        return -1;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            return icon32_;
        }
        return icon16_;
    }

    public synchronized int getIndex(TreeNode treeNode) {
        return -1;
    }

    public AS400Message[] getMessageList() {
        return this.messageList_;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return null;
    }

    public Object getPropertyValue(Object object) {
        if (object == NAME_PROPERTY) {
            return this;
        }
        if (object == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public String getText() {
        return description_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.detailsChildren_ = new VObject[0];
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isSortable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.workingEventSupport_.fireStartWorking();
        VMessageList vMessageList = this;
        synchronized (vMessageList) {
            int n;
            for (n = 0; n < this.detailsChildren_.length; ++n) {
                this.detailsChildren_[n].removeErrorListener(this.errorEventSupport_);
                this.detailsChildren_[n].removeVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[n].removeWorkingListener(this.workingEventSupport_);
            }
            this.detailsChildren_ = new VObject[this.messageList_.length];
            for (n = 0; n < this.messageList_.length; ++n) {
                this.detailsChildren_[n] = new VMessage(this.messageList_[n]);
                this.detailsChildren_[n].addErrorListener(this.errorEventSupport_);
                this.detailsChildren_[n].addVObjectListener(this.objectEventSupport_);
                this.detailsChildren_[n].addWorkingListener(this.workingEventSupport_);
            }
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setMessageList(AS400Message[] aS400MessageArray) throws PropertyVetoException {
        if (aS400MessageArray == null) {
            throw new NullPointerException("messageList");
        }
        AS400Message[] aS400MessageArray2 = this.messageList_;
        AS400Message[] aS400MessageArray3 = aS400MessageArray;
        this.vetoableChangeSupport_.fireVetoableChange("messageList", aS400MessageArray2, aS400MessageArray3);
        if (aS400MessageArray2 != aS400MessageArray3) {
            this.messageList_ = aS400MessageArray;
        }
        this.propertyChangeSupport_.firePropertyChange("messageList", aS400MessageArray2, aS400MessageArray3);
    }

    public synchronized void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (blArray == null) {
            throw new NullPointerException("orders");
        }
        VUtilities.sort(this.detailsChildren_, objectArray, blArray);
    }

    public String toString() {
        return description_;
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VMessage.NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VMessage.TEXT_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(textColumnHeader_);
        vTableColumn2.setPreferredCharWidth(80);
        detailsColumnModel_.addColumn(vTableColumn2);
        VTableColumn vTableColumn3 = new VTableColumn(n++, VMessage.SEVERITY_PROPERTY);
        vTableColumn3.setCellRenderer(new VObjectCellRenderer(4));
        vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer(4));
        vTableColumn3.setHeaderValue(severityColumnHeader_);
        vTableColumn3.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTableColumn3);
        VTableColumn vTableColumn4 = new VTableColumn(n++, VMessage.TYPE_PROPERTY);
        vTableColumn4.setCellRenderer(new VObjectCellRenderer());
        vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn4.setHeaderValue(typeColumnHeader_);
        vTableColumn4.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn4);
    }
}

