/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemValueGroup;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VSystemValueList
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SystemValueList systemValueList_;
    private VNode parent_;
    private transient VNode[] children_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private static String description_;
    private static Icon icon16_;
    private static Icon icon32_;
    private static TableColumnModel detailsColumnModel_;
    private static String nameColumnHeader_;
    private static String descriptionColumnHeader_;
    private static final String groupName_;
    private static final String groupDescription_;
    private static final int groupCount_;

    public VSystemValueList() {
        this.systemValueList_ = new SystemValueList();
        this.initializeTransient();
    }

    public VSystemValueList(AS400 aS400) {
        this.systemValueList_ = new SystemValueList(aS400);
        this.initializeTransient();
    }

    public VSystemValueList(VNode vNode, AS400 aS400) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        this.systemValueList_ = new SystemValueList(aS400);
        this.parent_ = vNode;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return this.children_[n];
    }

    public int getChildCount() {
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return this.children_[n];
    }

    public int getDetailsChildCount() {
        return this.children_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject vObject) {
        for (int i = 0; i < groupCount_; ++i) {
            if (this.children_[i] != vObject) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n != 32) {
            return icon16_;
        }
        return icon32_;
    }

    public int getIndex(TreeNode treeNode) {
        for (int i = 0; i < groupCount_; ++i) {
            if (this.children_[i] != treeNode) continue;
            return i;
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return null;
    }

    public Object getPropertyValue(Object object) {
        if (object == NAME_PROPERTY) {
            return this;
        }
        if (object == DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.systemValueList_.getSystem();
    }

    public SystemValueList getSystemValueList() {
        return this.systemValueList_;
    }

    public String getText() {
        return description_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.children_ = new VSystemValueGroup[groupCount_];
        for (int i = 0; i < groupCount_; ++i) {
            this.children_[i] = new VSystemValueGroup(this, i);
            this.children_[i].addErrorListener(this.errorEventSupport_);
            this.children_[i].addVObjectListener(this.objectEventSupport_);
            this.children_[i].addWorkingListener(this.workingEventSupport_);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isSortable() {
        return false;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.systemValueList_.getSystem().connectService(2);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        if (vObjectListener == null) {
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        if (workingListener == null) {
            throw new NullPointerException("listener");
        }
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        AS400 aS4002 = this.systemValueList_.getSystem();
        AS400 aS4003 = aS400;
        this.vetoableChangeSupport_.fireVetoableChange("system", aS4002, aS4003);
        if (aS4002 != aS4003) {
            this.systemValueList_.setSystem(aS4003);
        }
        this.propertyChangeSupport_.firePropertyChange("system", aS4002, aS4003);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return description_;
    }

    static {
        groupCount_ = SystemValueList.getGroupCount();
        description_ = ResourceLoader.getText("SYSTEM_VALUE_LIST_DESCRIPTION");
        groupName_ = ResourceLoader.getText("COLUMN_GROUP");
        groupDescription_ = ResourceLoader.getText("COLUMN_DESCRIPTION");
        icon16_ = ResourceLoader.getIcon("VSystemValueList16.gif", description_);
        icon32_ = ResourceLoader.getIcon("VSystemValueList32.gif", description_);
        nameColumnHeader_ = groupName_;
        descriptionColumnHeader_ = groupDescription_;
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, DESCRIPTION_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(descriptionColumnHeader_);
        vTableColumn2.setPreferredCharWidth(40);
        detailsColumnModel_.addColumn(vTableColumn2);
    }
}

